/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomXMLDocumentContainer;
import com.cognos.cm.request.customFunctions.QueryFunctionStep;
import com.cognos.cm.request.customFunctions.ReportQueryDelegate;
import com.cognos.cm.request.customFunctions.XMLDocPool;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.StaxUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;

class ReportFunctionStep
extends QueryFunctionStep {
    private static final String METADATA_MODEL = "metadataModel";
    private static final String ROOT_END = "</root>";
    private static final byte[] ROOT_END_BA = CMStringUtils.getUTF8BytesFromString("</root>");
    private static final String ROOT_START = "<root xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
    private static final byte[] ROOT_START_BA = CMStringUtils.getUTF8BytesFromString("<root xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
    private static XMLDocPool xmlDocPool;
    private String packageSearchPath;
    private String searchPath;
    private String validator;

    public ReportFunctionStep(String _name, String _id, CustomFunctionPlugin _plugin, XMLElement stepSpecification) throws CMException {
        super(_name, _id, _plugin);
        this.searchPath = this.getSearchPath(stepSpecification);
        this.validator = this.getValidator(stepSpecification);
    }

    public String getMetadataModelPackageSearchPath() {
        return this.packageSearchPath;
    }

    @Override
    public void runFunctionStep(OutputStream os) throws SAXException, CMException {
        if (xmlDocPool == null) {
            throw new RuntimeException("XML Doc Pool has not been initialized");
        }
        CustomXMLDocumentContainer doc = xmlDocPool.getDocFromPool();
        this.replaceVariablesInXMLDoc(this.searchPath, this.validator, doc);
        this.runRequest(os, doc);
        xmlDocPool.returnDocToPool(doc);
    }

    private void runRequest(OutputStream os, CustomXMLDocumentContainer doc) throws SAXException, CMException {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        try {
            response.write(ROOT_START_BA);
            this.runStaticRequest(doc.getXMLDoc(), response);
            response.write(ROOT_END_BA);
        }
        catch (IOException e) {
            throw new CMRuntimeException(e);
        }
        this.extractValuesFromResponse(os, response);
    }

    private void extractValuesFromResponse(OutputStream os, ByteArrayOutputStream response) {
        OutputStreamWriter writer;
        XMLStreamReader staxXmlReader = this.getStreamReader(response);
        try {
            writer = new OutputStreamWriter(os, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CMRuntimeException(e);
        }
        ReportQueryDelegate delegate = new ReportQueryDelegate(staxXmlReader);
        this.parseAndWriteResponse(writer, delegate);
        this.packageSearchPath = delegate.getSearchPath();
        String modelSearchPath = delegate.getModelSearchPath();
        if (modelSearchPath != null) {
            this.addResponseHint(METADATA_MODEL, modelSearchPath);
        }
    }

    private void parseAndWriteResponse(OutputStreamWriter writer, ReportQueryDelegate delegate) {
        try {
            XMLStreamWriter xmlStreamWriterToClient = XMLStreamFactory.createXMLStreamWriter((Writer)writer);
            StaxUtils.copyCurrentElement((XMLStreamReader)delegate, (XMLStreamWriter)xmlStreamWriterToClient);
        }
        catch (XMLStreamException e) {
            throw new CMRuntimeException(e);
        }
    }

    private XMLStreamReader getStreamReader(ByteArrayOutputStream response) {
        try {
            XMLStreamReader staxXmlReader = XMLStreamFactory.createXMLStreamReader((Reader)this.getReader(response));
            return staxXmlReader;
        }
        catch (XMLStreamException e) {
            throw new CMRuntimeException(e);
        }
    }

    private Reader getReader(ByteArrayOutputStream baos) {
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        try {
            return new InputStreamReader((InputStream)is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CMRuntimeException(e);
        }
    }

    private void replaceVariablesInXMLDoc(String searchPath, String validator, CustomXMLDocumentContainer doc) {
        this.replaceHeaderInDoc(doc);
        doc.replaceVariable("REPORT_SEARCHPATH1", searchPath);
        doc.replaceVariable("REPORT_SEARCHPATH2", searchPath + "/reportCache[@name='promptCache']");
        doc.replaceVariable("REPORT_SEARCHPATH3", "expandReferences(" + searchPath + ", @base)/reportCache[@name='promptCache']");
        doc.replaceVariable("REPORT_SEARCHPATH4", searchPath + "/reportMetadata[@name='parameterCache']");
        doc.replaceVariable("REPORT_SEARCHPATH5", "expandReferences(" + searchPath + ", @base)/reportMetadata[@name='parameterCache']");
        doc.replaceVariable("REPORT_VALIDATOR", validator);
    }

    public static void initialize(InputStream request) throws CMException, SAXException, IOException {
        xmlDocPool = new XMLDocPool(request);
    }
}

