/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.contentTasks.cleanupTask.RepositoryRulesTempCache;
import com.cognos.cm.dbstore.properties.CMDbStoreRepositoryRule;
import com.cognos.cm.dbstore.properties.CMDbStoreRepositoryRuleArray;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMRepositoryRuleArray;
import com.cognos.cm.properties.ICMObjectClasses;
import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomXMLDocumentContainer;
import com.cognos.cm.request.customFunctions.QueryFunctionStep;
import com.cognos.cm.request.customFunctions.XMLDocPool;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMStringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class RepositoryRulesQueryFunctionStep
extends QueryFunctionStep {
    private static final String SORTBY_VARIABLE = "SORTBY";
    private static final String OPTIONS_VARIABLE = "OPTIONS";
    private static final String PROPERTIES_VARIABLE = "PROPERTIES";
    private static final String QUERY_VALIDATOR_VARIABLE = "QUERY_VALIDATOR";
    private static final String SEARCHPATH_VARIABLE = "SEARCHPATH";
    private static final String ROOT_END = "</root>";
    private static final byte[] ROOT_END_BA = CMStringUtils.getUTF8BytesFromString("</root>");
    private static final String ROOT_START = "<root xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
    private static final byte[] ROOT_START_BA = CMStringUtils.getUTF8BytesFromString("<root xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
    private static XMLDocPool xmlDocPool;
    private String searchPath;
    private String validator;
    private XMLElement properties;
    private XMLElement options;
    private XMLElement sortBy;
    private RepositoryRulesTempCache repositoryRulesCache;

    public RepositoryRulesQueryFunctionStep(String _name, String _id, CustomFunctionPlugin _plugin, XMLElement stepSpecification, RepositoryRulesTempCache repositoryRulesCache) throws CMException {
        super(_name, _id, _plugin);
        this.searchPath = this.getSearchPath(stepSpecification);
        this.properties = stepSpecification.getOptionalChildWithName("properties");
        this.options = stepSpecification.getOptionalChildWithName("options");
        this.sortBy = stepSpecification.getOptionalChildWithName("sortBy");
        this.validator = this.getValidator(stepSpecification);
        this.validateRequiredParameters();
        this.repositoryRulesCache = repositoryRulesCache;
    }

    private void validateRequiredParameters() throws CMException {
        if (this.searchPath == null) {
            throw new CMException("cmNoSelection");
        }
        if (this.properties == null || this.properties.children_ == null) {
            throw new IllegalStateException("RepositoryRulesQueryFunctionStep is missing required query property: repositoryRules!");
        }
        boolean repositoryRulesSpecified = false;
        for (XMLElement propertyItem : this.properties.children_) {
            if (!propertyItem.value_.equalsIgnoreCase(this.getRepositoryRulesPropertyName())) continue;
            repositoryRulesSpecified = true;
        }
        if (!repositoryRulesSpecified) {
            throw new IllegalStateException("RepositoryRulesQueryFunctionStep is missing required query property: repositoryRules!");
        }
    }

    protected String getRepositoryRulesPropertyName() {
        return CMProperty.REPOSITORYRULES.getName();
    }

    public static void initialize(InputStream request) throws CMException, SAXException, IOException {
        xmlDocPool = new XMLDocPool(request);
    }

    @Override
    public void runFunctionStep(OutputStream os) throws SAXException, CMException {
        ByteArrayOutputStream outputStreamBuffer = new ByteArrayOutputStream();
        if (xmlDocPool == null) {
            throw new RuntimeException("The doc pool has not been initialized");
        }
        CustomXMLDocumentContainer doc = xmlDocPool.getDocFromPool();
        this.replaceVariablesInXMLDoc(this.searchPath, this.validator, doc);
        this.runStaticRequest(doc.getXMLDoc(), outputStreamBuffer);
        this.cacheRepositoryRules(this.searchPath, outputStreamBuffer);
        try {
            os.write(outputStreamBuffer.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        xmlDocPool.returnDocToPool(doc);
    }

    private void cacheRepositoryRules(String searchPath, ByteArrayOutputStream responseStream) throws CMException {
        Document reposnseDocument = this.getResponseDocument(responseStream);
        if (reposnseDocument == null) {
            return;
        }
        Element rootElement = reposnseDocument.getRootElement();
        Node repositoryRulesNode = this.getRepositoryRulesNode(rootElement);
        List<Node> repositoryRuleNodes = this.getRepositoryRuleNodes(repositoryRulesNode);
        CMRepositoryRuleArray repositoryRuleArray = this.getCMRepositoryRuleArray(repositoryRuleNodes);
        this.repositoryRulesCache.addEntry(searchPath, repositoryRuleArray);
    }

    private CMRepositoryRuleArray getCMRepositoryRuleArray(List<Node> repositoryRuleNodes) throws CMStoreNotAvailable, CMStoreUnexpected {
        CMDbStoreRepositoryRuleArray repositoryRuleArray = new CMDbStoreRepositoryRuleArray();
        if (repositoryRuleNodes == null) {
            return repositoryRuleArray;
        }
        for (Node repositoryRuleNode : repositoryRuleNodes) {
            Node objectClassNode = repositoryRuleNode.selectSingleNode("./objectClass");
            CMObjectClass objectClass = this.getObjectClasses().getClassByName(objectClassNode.getText());
            String dataSourceName = repositoryRuleNode.selectSingleNode("./dataSourceName").getText();
            CMDbStoreRepositoryRule repositoryRule = new CMDbStoreRepositoryRule(objectClass, dataSourceName);
            repositoryRuleArray.add(repositoryRule);
        }
        return repositoryRuleArray;
    }

    private ICMObjectClasses getObjectClasses() throws CMStoreNotAvailable, CMStoreUnexpected {
        return this.getCMExecutionContext().getStore().getObjectClasses();
    }

    private List<Node> getRepositoryRuleNodes(Node repositoryRulesNode) {
        if (repositoryRulesNode == null) {
            return null;
        }
        List repositoryRuleNodes = repositoryRulesNode.selectNodes("./value/item");
        return repositoryRuleNodes;
    }

    private Node getRepositoryRulesNode(Element rootElement) throws CMException {
        List repositoryRulesNodes = rootElement.selectNodes(".//" + this.getRepositoryRulesPropertyName());
        if (repositoryRulesNodes.size() == 0) {
            return null;
        }
        if (repositoryRulesNodes.size() > 1) {
            throw new CMException("cmMultipleParents");
        }
        return (Node)repositoryRulesNodes.get(0);
    }

    private Document getResponseDocument(ByteArrayOutputStream responseStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(ROOT_START_BA);
            outputStream.write(responseStream.toByteArray());
            outputStream.write(ROOT_END_BA);
            SAXReader reader = new SAXReader();
            return reader.read((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void replaceVariablesInXMLDoc(String reportSearchPath, String validator, CustomXMLDocumentContainer doc) throws CMException {
        this.replaceHeaderInDoc(doc);
        doc.replaceVariable(SEARCHPATH_VARIABLE, this.getQuerySearchPath(reportSearchPath));
        doc.replaceVariable(QUERY_VALIDATOR_VARIABLE, validator);
        doc.replaceVariable(PROPERTIES_VARIABLE, "");
        this.addProperties(doc);
        doc.replaceVariable(OPTIONS_VARIABLE, "");
        this.addOptions(doc);
        doc.replaceVariable(SORTBY_VARIABLE, "");
        this.addSortBy(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQuerySearchPath(String reportSearchPath) throws CMException {
        String querySearchPath = null;
        ICMStorePath objectStorePath = this.createStorePath(reportSearchPath);
        CMStore store = this.getCMExecutionContext().getStore();
        ICMLockManager lockManager = store.getLockManager();
        try {
            lockManager.requestLocks(objectStorePath);
            store.beginTransaction();
            querySearchPath = this.repositoryRulesCache.getSearchPathOfObjectWithRepositoryRule(objectStorePath, store);
            store.commitTransaction();
        }
        finally {
            if (store.inTransaction()) {
                store.rollbackTransaction();
            }
            lockManager.releaseLocks();
        }
        if (querySearchPath == null) {
            throw new CMException("cmFailNoParent");
        }
        return querySearchPath;
    }

    protected CMExecutionContext getCMExecutionContext() {
        return CMExecutionContext.get();
    }

    protected ICMStorePath createStorePath(String searchPath) throws CMStoreParseException {
        return new CMStoreXPath(searchPath);
    }

    private void addProperties(CustomXMLDocumentContainer doc) {
        this.updateChildren(doc.getVariableElement(PROPERTIES_VARIABLE), this.properties.getChildren());
    }

    private void addOptions(CustomXMLDocumentContainer doc) {
        if (this.options == null) {
            this.updateChildren(doc.getVariableElement(OPTIONS_VARIABLE), null);
        } else {
            this.updateChildren(doc.getVariableElement(OPTIONS_VARIABLE), this.options.getChildren());
        }
    }

    private void addSortBy(CustomXMLDocumentContainer doc) {
        if (this.sortBy == null) {
            this.updateChildren(doc.getVariableElement(SORTBY_VARIABLE), null);
        } else {
            this.updateChildren(doc.getVariableElement(SORTBY_VARIABLE), this.sortBy.getChildren());
        }
    }

    private void updateChildren(XMLElement element, ArrayList<XMLElement> children) {
        if (element != null) {
            element.children_ = children;
        }
    }
}

