/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.IRepositoryRules;
import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomXMLDocumentContainer;
import com.cognos.cm.request.customFunctions.QueryFunctionStep;
import com.cognos.cm.request.customFunctions.XMLDocPool;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class RepositoryRulesSignonFunctionStep
extends QueryFunctionStep {
    private static final String REPOSITORYRULE_OBJECTCLASS_ELEM = "repositoryRuleObjectClass";
    private static final String SORTBY_VARIABLE = "SORTBY";
    private static final String OPTIONS_VARIABLE = "OPTIONS";
    private static final String PROPERTIES_VARIABLE = "PROPERTIES";
    private static final String DATASOURCE_VALIDATOR_VARIABLE = "DATASOURCE_VALIDATOR";
    private static final String DATASOURCE_SEARCHPATH_VARIABLE = "DATASOURCE_SEARCHPATH";
    private static final String FUNCTIONSTEP_ELEM = "functionStep";
    private static XMLDocPool xmlDocPool;
    private CMStore store = CMExecutionContext.get().getStore();
    private CMObjectClass repositoryRuleObjectClass;
    private String searchPath;
    private String validator;
    private XMLElement properties;
    private XMLElement options;
    private XMLElement sortBy;
    private IRepositoryRules repositoryRules;

    public RepositoryRulesSignonFunctionStep(String _name, String _id, CustomFunctionPlugin _plugin, XMLElement stepSpecification, IRepositoryRules mockRepositoryRules) throws CMException {
        super(_name, _id, _plugin);
        this.searchPath = this.getSearchPath(stepSpecification);
        String objectClassString = this.getValueFromElement(stepSpecification, REPOSITORYRULE_OBJECTCLASS_ELEM);
        this.repositoryRuleObjectClass = this.store.getObjectClasses().getClassByName(objectClassString);
        this.validateRequiredParametersNotNull(objectClassString);
        this.properties = stepSpecification.getOptionalChildWithName("properties");
        this.options = stepSpecification.getOptionalChildWithName("options");
        this.sortBy = stepSpecification.getOptionalChildWithName("sortBy");
        this.validator = this.getValidator(stepSpecification);
        this.repositoryRules = mockRepositoryRules;
    }

    private void validateRequiredParametersNotNull(String objectClassString) throws CMException {
        if (objectClassString == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", REPOSITORYRULE_OBJECTCLASS_ELEM), new CMException.Parm("Parent", FUNCTIONSTEP_ELEM));
        }
        if (this.repositoryRuleObjectClass == null) {
            throw new CMException("cmInvalidObjectClass", new CMException.Parm("Class", objectClassString));
        }
        if (this.searchPath == null) {
            throw new CMException("cmNoSelection");
        }
    }

    @Override
    public void runFunctionStep(OutputStream os) throws SAXException, CMException {
        if (xmlDocPool == null) {
            throw new RuntimeException("The doc pool has not been initialized");
        }
        CustomXMLDocumentContainer doc = xmlDocPool.getDocFromPool();
        this.replaceVariablesInXMLDoc(this.searchPath, this.validator, doc);
        this.runStaticRequest(doc.getXMLDoc(), os);
        xmlDocPool.returnDocToPool(doc);
    }

    protected void replaceVariablesInXMLDoc(String reportSearchPath, String validator, CustomXMLDocumentContainer doc) throws CMException {
        this.replaceHeaderInDoc(doc);
        doc.replaceVariable(DATASOURCE_SEARCHPATH_VARIABLE, this.getDataSourceSearchPath(reportSearchPath));
        doc.replaceVariable(DATASOURCE_VALIDATOR_VARIABLE, validator);
        doc.replaceVariable(PROPERTIES_VARIABLE, "");
        this.addProperties(doc);
        doc.replaceVariable(OPTIONS_VARIABLE, "");
        this.addOptions(doc);
        doc.replaceVariable(SORTBY_VARIABLE, "");
        this.addSortBy(doc);
    }

    private void addProperties(CustomXMLDocumentContainer doc) {
        if (this.properties == null) {
            this.updateChildren(doc.getVariableElement(PROPERTIES_VARIABLE), null);
        } else {
            this.updateChildren(doc.getVariableElement(PROPERTIES_VARIABLE), this.properties.getChildren());
        }
    }

    private void addOptions(CustomXMLDocumentContainer doc) {
        if (this.options == null) {
            this.updateChildren(doc.getVariableElement(OPTIONS_VARIABLE), null);
        } else {
            this.updateChildren(doc.getVariableElement(OPTIONS_VARIABLE), this.options.getChildren());
        }
    }

    private void addSortBy(CustomXMLDocumentContainer doc) {
        if (this.sortBy == null) {
            this.updateChildren(doc.getVariableElement(SORTBY_VARIABLE), null);
        } else {
            this.updateChildren(doc.getVariableElement(SORTBY_VARIABLE), this.sortBy.getChildren());
        }
    }

    private void updateChildren(XMLElement element, ArrayList<XMLElement> children) {
        if (element != null) {
            element.children_ = children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataSourceSearchPath(String objectSearchPath) throws CMException {
        String dataSourceName = null;
        ICMStorePath objectStorePath = this.createStorePath(objectSearchPath);
        ICMLockManager lockManager = this.store.getLockManager();
        try {
            lockManager.requestLocks(objectStorePath);
            this.store.beginTransaction();
            dataSourceName = this.repositoryRules.getRepositoryDataSourceName(objectStorePath, this.repositoryRuleObjectClass);
            this.store.commitTransaction();
        }
        finally {
            lockManager.releaseLocks();
            if (this.store.inTransaction()) {
                this.store.rollbackTransaction();
            }
        }
        if (dataSourceName == null) {
            dataSourceName = "";
        }
        return CMConstants.FUNC_DATASRCSIGNON_DEF.getName() + "(" + SearchPathEncoder.quoteString((String)dataSourceName) + ")";
    }

    protected ICMStorePath createStorePath(String searchPath) throws CMStoreParseException {
        return new CMStoreXPath(searchPath);
    }

    public static void initialize(InputStream request) throws CMException, SAXException, IOException {
        xmlDocPool = new XMLDocPool(request);
    }
}

