/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.request.customFunctions.CustomDocumentParser;
import com.cognos.cm.request.customFunctions.CustomXMLDocumentContainer;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.util.CMXMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLDocPool {
    private Stack<CustomXMLDocumentContainer> docPool = new Stack();
    private InputStream requestStream;
    private int poolMaxSize;

    public XMLDocPool(InputStream request) throws CMException, SAXException, IOException {
        this(request, 20);
    }

    public XMLDocPool(InputStream request, int poolSize) throws CMException, SAXException, IOException {
        this(request, poolSize, poolSize * 5);
    }

    public XMLDocPool(InputStream request, int initialPoolSize, int maxSize) throws CMException, SAXException, IOException {
        this.poolMaxSize = maxSize;
        this.requestStream = request;
        this.buildDocs(initialPoolSize);
    }

    private void buildDocs(int number) throws CMException, SAXException, IOException {
        for (int i = 0; i < number; ++i) {
            CustomXMLDocumentContainer doc = this.buildDoc();
            this.returnDocToPool(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomXMLDocumentContainer buildDoc() throws CMException, SAXException, IOException {
        InputStream inputStream = this.requestStream;
        synchronized (inputStream) {
            this.requestStream.reset();
            CustomDocumentParser docParser = new CustomDocumentParser();
            XMLReader saxParser = null;
            try {
                saxParser = CMXMLUtils.getSAXParserFromPool();
                saxParser.setContentHandler(docParser);
                saxParser.setErrorHandler(docParser);
                saxParser.setDTDHandler(docParser);
                saxParser.setEntityResolver(docParser);
                InputSource inputSource = new InputSource(this.requestStream);
                saxParser.parse(inputSource);
            }
            finally {
                CMXMLUtils.returnSAXParserToPool(saxParser);
            }
            CustomXMLDocumentContainer doc = docParser.getXMLDoc();
            return doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnDocToPool(CustomXMLDocumentContainer doc) {
        Stack<CustomXMLDocumentContainer> stack = this.docPool;
        synchronized (stack) {
            if (this.docPool.size() < this.poolMaxSize) {
                this.docPool.push(doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomXMLDocumentContainer getDocFromPool() {
        Stack<CustomXMLDocumentContainer> stack = this.docPool;
        synchronized (stack) {
            if (this.docPool.size() > 0) {
                return this.docPool.pop();
            }
        }
        try {
            return this.buildDoc();
        }
        catch (Exception e) {
            throw new CMRuntimeException(e);
        }
    }
}

