/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.customFunctions;

import com.cognos.cm.request.customFunctions.AccountFunctionStep;
import com.cognos.cm.request.customFunctions.AccountFunctionStepCAM;
import com.cognos.cm.request.customFunctions.ConstantOutputStep;
import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.request.customFunctions.CustomReportQueryCookie;
import com.cognos.cm.request.customFunctions.DataSourceFunctionStep;
import com.cognos.cm.request.customFunctions.ICustomFunctionStep;
import com.cognos.cm.request.customFunctions.NoActionFunctionStep;
import com.cognos.cm.request.customFunctions.PackageFunctionStep;
import com.cognos.cm.request.customFunctions.ReportFunctionStep;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.Header;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.iRequestHandler;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class customReportQuery
extends CustomFunctionPlugin {
    private static Object lock_ = new Object();
    private static boolean initialized = false;
    private static final String SUPPORTED_OBJECTS_QUERY = "supportedObjectsQuery";
    private static final String DATA_SOURCE_SIGNON_QUERY = "dataSourceSignonQuery";
    private static final String PACKAGE_QUERY = "packageQuery";
    private static final String ACCOUNT_QUERY_CAM = "accountQueryCAM";
    private static final String ACCOUNT_QUERY = "accountQuery";
    private static final String REPORT_QUERY = "reportQuery";
    private iRequestHandler requestHandler;

    public customReportQuery(iRequestHandler rh) {
        this.requestHandler = rh;
    }

    public customReportQuery(CMResourceLoader loader, iRequestHandler rh) {
        super(loader);
        this.requestHandler = rh;
    }

    @Override
    public void run(List<XMLElement> functionSteps, OutputStream os) throws CMException, SAXException {
        List<ICustomFunctionStep> steps = this.buildFunctionSteps(functionSteps);
        try {
            this.runSteps(steps, os);
        }
        catch (IOException e) {
            throw new CMRuntimeException(e);
        }
        this.setCookie();
    }

    private void setCookie() {
        Header header = this.requestHandler.getHeader();
        CustomReportQueryCookie cookie = this.getCookie(header);
        String passportID = CMExecutionContext.get().getAccManPassportID();
        cookie.create(passportID);
    }

    protected CustomReportQueryCookie getCookie(Header header) {
        return new CustomReportQueryCookie(header);
    }

    @Override
    protected ICustomFunctionStep getCustomFunctionStep(String name, String id, XMLElement stepSpecification) throws CMException {
        if (name.equals(REPORT_QUERY)) {
            return new ReportFunctionStep(name, id, this, stepSpecification);
        }
        if (name.equals(ACCOUNT_QUERY)) {
            return new AccountFunctionStep(name, id, this, stepSpecification);
        }
        if (name.equals(ACCOUNT_QUERY_CAM)) {
            return new AccountFunctionStepCAM(name, id, this, stepSpecification);
        }
        if (name.equals(PACKAGE_QUERY)) {
            return new PackageFunctionStep(name, id, this, stepSpecification);
        }
        if (name.equals(DATA_SOURCE_SIGNON_QUERY)) {
            return new DataSourceFunctionStep(name, id, this, stepSpecification);
        }
        if (name.equals(SUPPORTED_OBJECTS_QUERY)) {
            return new ConstantOutputStep(name, id, this);
        }
        return new NoActionFunctionStep(name, id, this);
    }

    @Override
    protected void initializeStep(String requestName, Element requestContent) {
        try {
            InputStream is = this.getInputStreamFromRequest(requestContent);
            if (requestName.equals(REPORT_QUERY)) {
                ReportFunctionStep.initialize(is);
            } else if (requestName.equals(ACCOUNT_QUERY)) {
                AccountFunctionStep.initialize(is);
            } else if (requestName.equals(ACCOUNT_QUERY_CAM)) {
                AccountFunctionStepCAM.initialize(is);
            } else if (requestName.equals(PACKAGE_QUERY)) {
                PackageFunctionStep.initialize(is);
            } else if (requestName.equals(DATA_SOURCE_SIGNON_QUERY)) {
                DataSourceFunctionStep.initialize(is);
            } else if (requestName.equals(SUPPORTED_OBJECTS_QUERY)) {
                ConstantOutputStep.initialize(requestName, is);
            }
        }
        catch (CMException e) {
            throw new CMRuntimeException(e);
        }
        catch (SAXException e) {
            throw new CMRuntimeException(e);
        }
        catch (IOException e) {
            throw new CMRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        Object object = lock_;
        synchronized (object) {
            if (!initialized) {
                this.loadRequests();
                initialized = true;
            }
        }
    }

    public static void reset() {
        initialized = false;
    }
}

