/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AuditContext;
import com.cognos.cm.server.CMConfiguration;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.RequestParms;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.trustedServices.trustedService;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class delete
extends RequestHandler {
    protected static String className_ = null;
    protected String perfReqName_ = "delete";
    private boolean success = false;

    public delete(CMStore store) {
        super(store);
        delete.setClassName();
    }

    public static void setClassName() {
        className_ = "com.cognos.cm.request.delete";
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        RequestInfo requestInfo = (RequestInfo)this.requestsInfo_.get(0);
        CMStoreXPath objectContext = null;
        if (requestInfo != null && requestInfo.objectsContexts_ != null && requestInfo.objectsContexts_.size() > 0 && (objectContext = requestInfo.objectsContexts_.get(0)) != null && objectContext.isUnion()) {
            throw new CMException("cmBadCompoundPathOp", new CMException.Parm("Path", objectContext.getOriginalPath()));
        }
    }

    protected String getResultTypeString() {
        return "integer";
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        XMLElement optionsXmlElm;
        if (this.didGetParmUsingXMLEl_ == requestElement && this.requestsInfo_.size() > 0) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        if (this.lockedPaths_ == null) {
            this.lockedPaths_ = new ArrayList();
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.requestElement_ = requestElement;
        this.requestsInfo_.add(requestInfo);
        requestInfo.objectsContexts_ = new ArrayList();
        requestInfo.objectsVersions_ = null;
        requestInfo.force_ = false;
        requestInfo.recursive_ = false;
        XMLElement xmlElm = requestElement.getOptionalChildWithName("search");
        if (xmlElm != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
            CMStoreXPath objectContext = this.parsePath(xmlElm.value_);
            CMObjectClass theClass = this.getObjectClassForIPF(objectContext);
            this.validatePathForNonQueryCommand(objectContext, "delete");
            this.checkReadOnlyClass(theClass);
            objectContext.setLockManagerUsageFlag(15);
            this.addObjectContextToLockPaths(objectContext);
            requestInfo.objectsContexts_.add(objectContext);
        }
        if ((optionsXmlElm = requestElement.getOptionalChildWithName("options")) != null) {
            xmlElm = optionsXmlElm.getOptionalChildWithName("force");
            if (xmlElm != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
                requestInfo.force_ = CMXMLUtils.parseBooleanAttribute(xmlElm.value_);
            }
            if ((xmlElm = optionsXmlElm.getOptionalChildWithName("recursive")) != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
                requestInfo.recursive_ = CMXMLUtils.parseBooleanAttribute(xmlElm.value_);
            }
            if ((xmlElm = optionsXmlElm.getOptionalChildWithName("faultIfObjectReferenced")) != null && xmlElm.value_ != null && xmlElm.value_.length() > 0 && xmlElm.value_.equalsIgnoreCase("true")) {
                requestInfo.clearInvalidReferences_ = false;
            }
        }
        if ((xmlElm = requestElement.getOptionalChildWithName("objects")) != null && xmlElm.children_ != null) {
            requestInfo.objectsVersions_ = new ArrayList();
            ArrayList<XMLElement> aClassList = xmlElm.getChildren();
            ListIterator iterClass = aClassList.listIterator();
            while (iterClass.hasNext()) {
                XMLElement xmlElClass = (XMLElement)iterClass.next();
                if (xmlElClass == null) continue;
                String localName = xmlElClass.xsiType_;
                this.checkReadOnlyClass(localName);
                ArrayList<XMLElement> aPropList = xmlElClass.getChildren();
                if (aPropList == null) continue;
                CMStoreXPath objectContext = null;
                Integer objectVersion = null;
                ListIterator iterProp = aPropList.listIterator();
                while (iterProp.hasNext()) {
                    XMLElement xmlElProp = (XMLElement)iterProp.next();
                    if (xmlElProp.isNil_) continue;
                    localName = xmlElProp.name_;
                    if (localName.equalsIgnoreCase("searchPath")) {
                        XMLElement xmlElValue = xmlElProp.getOptionalChildWithName("value");
                        if (xmlElValue == null || xmlElValue.isNil_) continue;
                        objectContext = (CMStoreXPath)CMStoreXPath.parse(xmlElValue.value_);
                        this.validatePathForNonQueryCommand(objectContext, "delete");
                        objectContext.setLockManagerUsageFlag(15);
                        this.addObjectContextToLockPaths(objectContext);
                        requestInfo.objectsContexts_.add(objectContext);
                        continue;
                    }
                    if (!localName.equalsIgnoreCase("version")) continue;
                    objectVersion = new Integer(xmlElProp.getChildIntValueWithName("value"));
                }
                if (objectContext == null) continue;
                requestInfo.objectsVersions_.add(objectVersion);
            }
        }
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = this.runCommands("deleteResponse", "deleteReply");
        return rc;
    }

    @Override
    protected void prepareLocks() {
    }

    @Override
    public boolean doCommand(Object requestInfoObj, String tabPrefix) throws CMException {
        RequestInfo requestInfo = (RequestInfo)requestInfoObj;
        int objectCount = 0;
        for (int i = 0; i < requestInfo.objectsContexts_.size(); ++i) {
            CMStorePath objectContext = requestInfo.objectsContexts_.get(i);
            Integer objectVersion = null;
            if (requestInfo.objectsVersions_ != null) {
                objectVersion = requestInfo.objectsVersions_.get(i);
            }
            int count = delete.deleteObjects(objectContext, objectVersion, requestInfo.recursive_, requestInfo.force_, this.requestParms_, requestInfo.clearInvalidReferences_);
            objectCount += count;
        }
        this.emit(tabPrefix);
        this.emitElement("count", "xsd", this.getResultTypeString(), Integer.toString(objectCount));
        return this.success;
    }

    public static int deleteObjects(CMStorePath objectContext, boolean recursive, boolean force, RequestParms parms, boolean clearInvalidReferences) throws CMException {
        return delete.deleteObjects(objectContext, null, recursive, force, parms, clearInvalidReferences);
    }

    public static int deleteObjects(CMStorePath objectContext, Integer objectVersion, boolean recursive, boolean force, RequestParms parms, boolean clearInvalidReferences) throws CMException {
        int objectCount = 0;
        if (objectContext == null) {
            return 0;
        }
        CMStore store = CMExecutionContext.get().getStore();
        if (objectContext.size() == 0) {
            throw new CMException("cmBadDeleteSelectionRoot", new CMException.Parm("Path", CMQueryUtils.getPath(store, objectContext)));
        }
        int permissions = 18;
        if (CMExecutionContext.get().getCurrentUserIsAdministrator()) {
            permissions = 512;
        } else if (force) {
            permissions |= 8;
        }
        DeadlockContext context = new DeadlockContext();
        context.committed = false;
        context.objectCount = objectCount;
        context.objectContext = objectContext;
        context.recursive = recursive;
        context.objectVersion = objectVersion;
        context.force = force;
        context.parms = parms;
        context.clearInvalidReferences = clearInvalidReferences;
        context.permissions = permissions;
        context.deleteValidator = new DeleteValidator();
        try {
            CMWhileDeadlockExecutor.execute(null, context, Class.forName(className_).getDeclaredMethod("executeInDeadlockLoop", DeadlockContext.class, Integer.class));
        }
        catch (CMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CMException(t, "cmUnexpectedError");
        }
        objectCount = context.objectCount;
        if (context.committed && parms != null) {
            parms.postSuccessfulOperation();
        }
        return objectCount;
    }

    public static int deleteDescendants(CMStore store, CMStorePath path, int permissions, boolean clearInvalidReferences) throws CMException {
        int count = 0;
        for (CMStorePath spath : delete.getSelectionRoots(store, path)) {
            count += delete.deleteDescendantsInternal(store, spath, permissions, clearInvalidReferences);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteDescendantsInternal(CMStore store, CMStorePath path, int permissions, boolean clearInvalidReferences) throws CMException {
        int numOfObjectsDeleted = 0;
        CMStoreXPath descendantQuery = new CMStoreXPath(path, "descendant-or-self::*", false);
        int numDescendants = 0;
        int operation = 2;
        if ((permissions & 8) != 0) {
            operation = 8;
        }
        CMStoreQueryResults descendantResults = store.executeQuery(descendantQuery, null, null, operation, permissions |= 0x80, null);
        try {
            while (descendantResults.next()) {
                CMStoreXPath searchPath = delete.createPath(descendantResults.getSearchPath());
                if (searchPath.size() == 1 && CMCAMIDHelper.isSpecialCAMID(searchPath.getCAMIDFromFirstStep())) {
                    throw new CMException("cmBadDeleteSelectionSpecial", new CMException.Parm("Path", descendantResults.getPath()));
                }
                if (!CMExecutionContext.get().canSeeObjectsWithTenantId(descendantResults.getTenantID())) {
                    throw new CMException("cmNoWrite", new CMException.Parm("object", store.getDisplayPathFromSearchPath(path)));
                }
                ++numDescendants;
            }
            if (numDescendants > 0) {
                numOfObjectsDeleted = store.delete(descendantResults, clearInvalidReferences);
            }
        }
        finally {
            descendantResults.release();
        }
        return numOfObjectsDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<CMStorePath> getSelectionRoots(CMStore store, CMStorePath path) throws CMException {
        if (!CMConfiguration.getConfig().namesHaveTenantScope() || delete.isStoreIDBasedPath(path) || delete.isCurrentSessionOrUserPath(path)) {
            return Collections.singletonList(path);
        }
        ArrayList<CMStorePath> result = new ArrayList<CMStorePath>();
        CMStoreQueryResults qresults = store.executeQuery(path, null, null, 0, 0, null);
        try {
            while (qresults.next()) {
                int id = qresults.getObjectID();
                CMStoreXPath xpath = CMStoreXPath.fromStoreID(store.getObjectStoreID(id));
                result.add(xpath);
            }
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
        }
        return result;
    }

    private static boolean isStoreIDBasedPath(CMStorePath path) {
        if (!path.isUnion() && path.size() == 1) {
            CMStorePathStep step = path.stepAt(0);
            CMConstants.FunctionDef func = step.getNodeSetFunction();
            return func == CMConstants.FUNC_STOREID_DEF || func == CMConstants.FUNC_CAMID_DEF;
        }
        return false;
    }

    private static boolean isCurrentSessionOrUserPath(CMStorePath path) {
        if (!path.isUnion() && path.size() > 0) {
            CMStorePathStep step = path.stepAt(0);
            return step.bCurrentSession_ || step.bCurrentUser_;
        }
        return false;
    }

    public static int deleteDescendants(CMStore store, String path, int permissions, boolean clearInvalidReferences) throws CMException {
        return delete.deleteDescendants(store, delete.createPath(path), permissions, clearInvalidReferences);
    }

    private static CMStoreXPath createPath(String path) throws CMStoreParseException {
        return delete.getCMStorePathFactory().createCMStoreXPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInDeadlockLoop(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        context.objectCount = 0;
        CMStore store = CMExecutionContext.get().getStore();
        CMExecutionContext ctx = CMExecutionContext.get();
        AuditContext auditContext = ctx.getAuditContext();
        CMStoreQueryResults results = null;
        CMProperty[] props = null;
        props = context.objectVersion == null ? new CMProperty[]{CMProperty.HASCHILDREN, CMProperty.ID} : new CMProperty[]{CMProperty.HASCHILDREN, CMProperty.ID, CMProperty.VERSION};
        List<CMStorePath> selection = delete.getSelectionRoots(store, context.objectContext);
        try {
            store.beginTransaction();
            context.committed = false;
            for (CMStorePath spath : selection) {
                results = store.executeQuery(spath, props, null, 2, context.permissions, null);
                if (results == null) {
                    throw new CMException("cmObjectNotFound", new CMException.Parm("Path", context.objectContext.getOriginalPath()));
                }
                context.deleteValidator.validateDeleteRules(results, context, store);
                results.reset();
                while (results.next()) {
                    String path = results.getSearchPath();
                    CMObjectClass objClass = results.getObjectClass();
                    if (context.parms != null) {
                        context.parms.configurationModified(path, objClass);
                        context.parms.accountsDeleted(path, objClass);
                    }
                    String storeID = store.getObjectStoreID(results.getObjectID());
                    CMStoreXPath storeIDPath = CMStoreXPath.fromStoreID(storeID);
                    auditContext.add(results.getObjectID(), objClass);
                    if (context.recursive) {
                        int permissions = context.permissions;
                        trustedService ts = ctx.getTrustedService();
                        if (ts != null && ts.canDeleteDescendants(objClass)) {
                            permissions = 512;
                        }
                        context.objectCount += delete.deleteDescendantsInternal(store, storeIDPath, permissions & 0xFFFFFFEF, context.clearInvalidReferences);
                        CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                        continue;
                    }
                    ++context.objectCount;
                }
                if (!context.recursive && context.objectCount > 0) {
                    store.delete(results, context.clearInvalidReferences);
                    CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                }
                results.release();
                results = null;
            }
            store.commitTransaction();
            context.committed = true;
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    protected static class DeadlockContext {
        public boolean committed = false;
        public int objectCount = 0;
        public CMStorePath objectContext;
        public boolean recursive;
        public Integer objectVersion;
        public boolean force;
        public RequestParms parms;
        public boolean clearInvalidReferences;
        public int permissions;
        public DeleteValidator deleteValidator;

        protected DeadlockContext() {
        }
    }

    protected static class DeleteValidator {
        protected DeleteValidator() {
        }

        public void validateDeleteRules(CMStoreQueryResults results, DeadlockContext context, CMStore store) throws CMException {
            if (results == null) {
                return;
            }
            while (results.next()) {
                Integer version;
                String strHasChildren;
                if (!CMExecutionContext.get().canSeeObjectsWithTenantId(results.getTenantID())) {
                    results.exclude();
                    continue;
                }
                CMObjectClass objectClass = results.getObjectClass();
                delete.modifyingClass(objectClass);
                CMStoreXPath objectPath = null;
                String sObjectPath = results.getSearchPath();
                objectPath = new CMStoreXPath(null, sObjectPath, false);
                int obj_id = results.getObjectID();
                if (!context.recursive && (strHasChildren = results.getValue(0).toString()) != null && strHasChildren.equals("true")) {
                    throw new CMException("cmNoDelChild", new CMException.Parm("Path", results.getPath()));
                }
                if (objectPath.size() < 1) {
                    throw new CMException("cmBadDeleteSelectionRoot", new CMException.Parm("Path", results.getPath()));
                }
                if (objectPath.size() == 1) {
                    CMStoreXPathStep firstStep = (CMStoreXPathStep)objectPath.stepAt(0);
                    String camid = firstStep.getCAMIDLiteral();
                    if (camid == null) {
                        throw new CMException("cmBadDeleteSelectionRoot", new CMException.Parm("Path", results.getPath()));
                    }
                    if (CMCAMIDHelper.isSpecialCAMID(camid)) {
                        throw new CMException("cmBadDeleteSelectionSpecial", new CMException.Parm("Path", results.getPath()));
                    }
                }
                if (objectClass == CMObjectClass.TENANTS) {
                    throw new CMException("cmBadDeleteSelectionSpecial", new CMException.Parm("Path", results.getPath()));
                }
                if (objectClass == CMObjectClass.TENANT) {
                    throw new CMException("cmCantDeleteTenantObject");
                }
                if (objectClass.isExternal()) {
                    if (objectClass == CMObjectClass.ACCOUNT) {
                        if (CMExecutionContext.sessionCacheContainsAccount(obj_id)) {
                            throw new CMException("cmBadDeleteAccountInUse", new CMException.Parm("Path", results.getPath()));
                        }
                        if (results.getParentSearchPath().equals("/configuration") && results.getTenantID() == 0) {
                            throw new CMException("cmBadDeleteExist", new CMException.Parm("Path", results.getPath()));
                        }
                        membershipCacheClear = true;
                    } else if (objectClass == CMObjectClass.NAMESPACE) {
                        Object oid = results.getValue(1);
                        if (CMServlet.namespaceManager.isActiveNamespace(oid.toString())) {
                            throw new CMException("cmBadDeleteSelectionExternal", new CMException.Parm("Path", results.getPath()));
                        }
                    } else if (!(results.getState() != 2 && store.objectInCognosNamespace(obj_id) || this.isOpenIdGroup(objectClass, objectPath))) {
                        try {
                            if (AccMan.normalizeExternalSearch(sObjectPath) != null) {
                                throw new CMException("cmBadDeleteExternalObjectExists", new CMException.Parm("Path", results.getPath()));
                            }
                        }
                        catch (Exception e) {
                            throw new CMException(e, "cmBadDeleteSelectionExternal", new CMException.Parm("Path", results.getPath()));
                        }
                    }
                }
                if (objectClass == CMObjectClass.SESSION && CMExecutionContext.sessionCacheContainsSession(obj_id)) {
                    throw new CMException("cmBadDeleteAccountInUse", new CMException.Parm("Path", results.getPath()));
                }
                if (context.objectVersion == null || (version = new Integer(results.getValue(2).toString())).equals(context.objectVersion)) continue;
                throw new CMException("cmVersionMismatch", new CMException.Parm("Path", results.getPath()));
            }
        }

        private boolean isOpenIdGroup(CMObjectClass objectClass, ICMStorePath objectPath) {
            if (objectClass != CMObjectClass.GROUP) {
                return false;
            }
            String camid = objectPath.getCAMIDFromFirstStep();
            return CMCAMIDHelper.isOpenIDNamespaceObject(camid);
        }
    }

    public class RequestInfo {
        public boolean force_;
        public boolean recursive_;
        public ArrayList<CMStoreXPath> objectsContexts_;
        public ArrayList<Integer> objectsVersions_;
        public XMLElement requestElement_;
        public boolean clearInvalidReferences_ = true;
    }
}

