/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import java.io.File;

public class deleteArchive
extends Deployment {
    private String archiveName_;

    public deleteArchive(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        this.setDeploymentIPF(false);
        CMExecutionContext.get().addLevel3Parm(new CMException.Parm("Options", this.archiveName_));
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.archiveName_ != null) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        this.archiveName_ = requestElement.getChildNonNullValueWithName("archive");
    }

    @Override
    public boolean doAction(XMLElement requestElement, String tabPrefix) throws CMException {
        int count = 0;
        this.getParams(requestElement);
        try {
            File deploymentFolder = deleteArchive.getDeploymentFolder();
            if (this.archiveName_.equals("*")) {
                File[] files = deploymentFolder.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().endsWith(".zip") || !files[i].delete()) continue;
                    ++count;
                }
            } else {
                File exportfile = new File(deploymentFolder, this.archiveName_ + ".zip");
                if (!exportfile.exists()) {
                    throw new CMException("cmArchiveNotExist", new CMException.Parm("Archive", this.archiveName_));
                }
                if (exportfile.delete()) {
                    ++count;
                }
            }
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmArchiveDeleteFailed", new CMException.Parm("Archive", this.archiveName_));
        }
        this.emit(tabPrefix);
        this.emitElement("count", "xsd", "integer", Integer.toString(count));
        return true;
    }

    @Override
    protected void setNamespace() {
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\">\r\n");
    }

    @Override
    protected void setResponseHeader() {
        this.out.print("\t<");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("deleteArchiveResponse");
    }

    @Override
    protected void setResponseTrailer() {
        this.out.print("\t</");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("deleteArchiveResponse");
        this.out.print(">");
    }

    public void lockArchive(String archive) throws CMException {
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

