/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.diagnostics.Aggregator;
import com.cognos.cm.diagnostics.CSVReportGenerator;
import com.cognos.cm.diagnostics.CappedDatedFileStrategy;
import com.cognos.cm.diagnostics.ContextFilter;
import com.cognos.cm.diagnostics.CounterDescriptor;
import com.cognos.cm.diagnostics.DiagnosticsContext;
import com.cognos.cm.diagnostics.DiagnosticsManager;
import com.cognos.cm.diagnostics.LogKitTarget;
import com.cognos.cm.diagnostics.ReadyToGraphCSVReportGenerator;
import com.cognos.cm.diagnostics.ReportGenerator;
import com.cognos.cm.diagnostics.ReportTarget;
import com.cognos.cm.diagnostics.ResponseStreamTarget;
import com.cognos.cm.diagnostics.XMLReportGenerator;
import com.cognos.cm.diagnostics.XMLReportTarget;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;
import com.cognos.cm.diagnostics.serialization.CounterSerializerFactory;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class diagnostics
extends RequestHandler {
    protected PrintStream responseStream;
    protected DiagnosticsManager diagnosticsManager;

    public diagnostics(CMStore store) {
        super(store);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        this.diagnosticsManager = ContentManager.diagnosticsManager;
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!ctx.getCurrentUserIsAdministrator() && AdvancedSettings.CMPERFREQAUTH) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "diagnostics"));
        }
        try {
            this.responseStream = new PrintStream(this.oStream, false, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        XMLElement root = this.xmlElement_;
        this.writeResponseHeader();
        this.doDiagnostics(root);
        this.writeResponseFooter();
        this.responseStream.flush();
        return true;
    }

    protected void doDiagnostics(XMLElement xmlElRoot) throws CMException {
        String command = null;
        XMLElement elCommand = xmlElRoot.getChild(0);
        if (elCommand != null) {
            command = elCommand.name_;
        }
        if ("measure".equals(command)) {
            this.processMeasure(elCommand);
        } else if ("delete".equals(command)) {
            this.processDelete(elCommand);
        } else if ("report".equals(command)) {
            this.processReport(elCommand);
        } else if ("list".equals(command)) {
            this.processList(elCommand);
        } else if ("describe".equals(command)) {
            this.processDescribe(elCommand);
        } else {
            throw new IllegalArgumentException("Invalid sub-command: " + command);
        }
    }

    protected void processList(XMLElement list) {
        String what = "";
        if (list.value_ != null) {
            what = list.value_.trim();
        }
        if ("counters".equals(what)) {
            this.responseStream.print("<counters>\r\n");
            for (CounterDescriptor d : this.diagnosticsManager.listCounters()) {
                this.writeItem(d.getName());
            }
            this.responseStream.print("</counters>\r\n");
        } else if ("measures".equals(what)) {
            this.responseStream.print("<measures>\r\n");
            for (Aggregator a : this.diagnosticsManager.listAggregators()) {
                this.writeItem(a.getName());
            }
            this.responseStream.print("</measures>\r\n");
        } else if (!"channels".equals(what) && !"traces".equals(what)) {
            throw new IllegalArgumentException("Invalid list parameter:" + what);
        }
    }

    protected void processDescribe(XMLElement el) {
        XMLElement child = el.getChild(0);
        int i = 1;
        while (child != null) {
            String name = child.value_;
            if (child.nameIs("measure")) {
                this.describeMeasure(name);
            } else if (child.nameIs("counter")) {
                this.describeCounter(name);
            } else {
                throw new IllegalArgumentException("Invalid describe parameter: " + child.name_);
            }
            child = el.getChild(i);
            ++i;
        }
    }

    private void describeCounter(String name) {
        CounterDescriptor d = this.diagnosticsManager.getCounterDescriptor(name);
        if (d == null) {
            throw new IllegalArgumentException("Counter \"" + name + "\" not found");
        }
        this.responseStream.println("<counter>");
        this.writeElement("name", d.getName());
        this.writeElement("type", d.getTypeName());
        this.writeElement("description", d.getDescription());
        this.responseStream.println("</counter>");
    }

    private void describeMeasure(String name) {
        Aggregator agg = this.diagnosticsManager.getAggregator(name);
        if (agg == null) {
            throw new IllegalArgumentException("Aggregator \"" + name + "\" not found");
        }
        this.responseStream.println("<measure>");
        this.writeElement("name", agg.getName());
        this.writeMeasureCounters(agg);
        this.writeMeasureFilters(agg);
        this.writeMeasureGroups(agg);
        this.writeMeasureHistory(agg);
        this.writeMeasureLog(agg);
        this.responseStream.println("</measure>");
    }

    private void writeMeasureLog(Aggregator agg) {
        ReportGenerator rg = agg.getReportGenerator();
        if (rg != null) {
            this.responseStream.println("<log>");
            ReportTarget rt = rg.getReportTarget();
            if (rt != null) {
                LogKitTarget logKitTarget;
                this.writeElement("name", rt.getName());
                if (rt instanceof LogKitTarget && ((logKitTarget = (LogKitTarget)rt).getMaxFiles() > 0 || logKitTarget.getDaysPerFile() > 0)) {
                    this.responseStream.println("<rotate>");
                    int maxFiles = logKitTarget.getMaxFiles();
                    if (maxFiles > 0) {
                        this.writeElement("maxFiles", Integer.toString(logKitTarget.getMaxFiles()));
                    }
                    this.writeElement("daysPerFile", Integer.toString(logKitTarget.getDaysPerFile()));
                    this.responseStream.println("</rotate>");
                }
            }
            String format = null;
            if (rg instanceof XMLReportGenerator) {
                format = "xml";
            } else if (rg instanceof ReadyToGraphCSVReportGenerator) {
                format = "readyToGraph";
            } else if (rg instanceof CSVReportGenerator) {
                format = "csv";
            }
            if (format != null) {
                this.writeElement("format", format);
            }
            this.responseStream.println("</log>");
        }
    }

    private void writeMeasureHistory(Aggregator agg) {
        this.responseStream.println("<history>");
        this.writeElement("intervalLength", String.valueOf(agg.getInntervalDuration()));
        this.writeElement("numberOfIntervals", String.valueOf(agg.getNumberOfInntervals()));
        this.responseStream.println("</history>");
    }

    private void writeMeasureGroups(Aggregator agg) {
        DiagnosticsContext.Param[] groups = agg.getGroups();
        if (groups != null) {
            this.responseStream.println("<groupBy>");
            for (int i = 0; i < groups.length; ++i) {
                this.writeItem(groups[i].toString());
            }
            this.responseStream.println("</groupBy>");
        }
    }

    private void writeMeasureFilters(Aggregator agg) {
        ContextFilter filter = agg.getFilter();
        if (filter != null) {
            this.responseStream.println("<filterBy>");
            DiagnosticsContext.Param[] keys = filter.getFilterParameters();
            for (int i = 0; i < keys.length; ++i) {
                this.responseStream.print('<');
                this.responseStream.print(keys[i].toString());
                this.responseStream.print('>');
                String[] values = filter.getFilterValues(keys[i]);
                for (int v = 0; v < values.length; ++v) {
                    this.writeItem(values[v]);
                }
                this.responseStream.print("</");
                this.responseStream.print(keys[i].toString());
                this.responseStream.print('>');
            }
            this.responseStream.println("</filterBy>");
        }
    }

    private void writeMeasureCounters(Aggregator agg) {
        this.responseStream.println("<counters>");
        CounterDescriptor[] counters = agg.getCounters();
        for (int i = 0; i < counters.length; ++i) {
            this.writeItem(counters[i].getName());
        }
        this.responseStream.println("</counters>");
    }

    private void writeItem(String value) {
        this.writeElement("item", value);
    }

    protected void processMeasure(XMLElement measure) throws CMException {
        DiagnosticsContext.Param[] groups;
        String measureName = measure.getChildNonNullValueWithName("name");
        Aggregator newAggregator = new Aggregator(measureName, this.getCounters(measure));
        ContextFilter filter = this.createContextFilter(measure);
        if (filter != null) {
            newAggregator.setFilter(filter);
        }
        if ((groups = this.getGroups(measure)) != null) {
            newAggregator.setGroups(groups);
        }
        this.setHistory(newAggregator, measure);
        this.setLog(newAggregator, measure);
        this.registerAggregator(newAggregator);
    }

    private void setLog(Aggregator newAggregator, XMLElement measure) throws CMException {
        XMLElement log = measure.getOptionalChildWithName("log");
        if (log != null) {
            String fileName = log.getChildValueWithName("name");
            this.validateLogFileName(fileName);
            String format = log.getOptionalChildValueWithName("format");
            if (format == null) {
                format = "csv";
            }
            if (!(format.equalsIgnoreCase("csv") || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("readyToGraph"))) {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
            File logDir = CMEnvironment.getCRNLogsDir();
            XMLElement rotate = log.getOptionalChildWithName("rotate");
            ReportGenerator generator = this.createGenerator(newAggregator, fileName, format, logDir, rotate);
            newAggregator.setReportGenerator(generator);
        }
    }

    private void validateLogFileName(String fileName) {
        char[] illegalChars;
        for (char illegal : illegalChars = new char[]{'\\', '/', '?', '*'}) {
            if (fileName.indexOf(illegal) == -1) continue;
            throw new IllegalArgumentException("Invalid file name '" + fileName + "', fileNames may not contain the characters /\\*?");
        }
    }

    private ReportGenerator createGenerator(Aggregator newAggregator, String fileName, String format, File logDir, XMLElement rotate) {
        String extension = ".log";
        int daysPerFile = -1;
        int maxFiles = -1;
        if (CappedDatedFileStrategy.getExistingFileNames(logDir, fileName, extension).length != 0) {
            throw new IllegalArgumentException("Log file already exists");
        }
        if (rotate != null) {
            String sMaxFiles;
            daysPerFile = 1;
            String sDaysPerFile = rotate.getOptionalChildValueWithName("daysPerFile");
            if (sDaysPerFile != null) {
                try {
                    daysPerFile = Integer.parseInt(sDaysPerFile);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid daysPerFile parameter: '" + sDaysPerFile + "'");
                }
            }
            if ((sMaxFiles = rotate.getOptionalChildValueWithName("maxFiles")) != null) {
                try {
                    maxFiles = Integer.parseInt(sMaxFiles);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid maxFiles parameter: '" + sMaxFiles + "'");
                }
            }
        }
        try {
            ReportGenerator rg = null;
            CounterSerializer serializer = CounterSerializerFactory.getSerializerForType(newAggregator.getCounterType());
            if (format.equalsIgnoreCase("csv")) {
                String header = CSVReportGenerator.generateHeaderFor(newAggregator);
                String footer = null;
                LogKitTarget target = new LogKitTarget(newAggregator.getName(), logDir, fileName, extension, maxFiles, daysPerFile, header, footer);
                rg = new CSVReportGenerator(target, serializer, newAggregator.hasGroups());
            } else if (format.equalsIgnoreCase("readyToGraph")) {
                String header = ReadyToGraphCSVReportGenerator.generateHeaderFor(newAggregator);
                String footer = null;
                LogKitTarget target = new LogKitTarget(newAggregator.getName(), logDir, fileName, extension, maxFiles, daysPerFile, header, footer);
                rg = new ReadyToGraphCSVReportGenerator(target, serializer, newAggregator.getCounters(), newAggregator.hasGroups());
            } else {
                String header = "<report>\n";
                String footer = "</report>\n";
                LogKitTarget target = new LogKitTarget(newAggregator.getName(), logDir, fileName, extension, maxFiles, daysPerFile, header, footer);
                rg = new XMLReportGenerator(target, serializer, newAggregator.hasGroups());
            }
            return rg;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processDelete(XMLElement delete3) {
        for (String value : this.getChildrenValues(delete3)) {
            this.diagnosticsManager.deleteAggregator(value);
            this.writeDeleteResponse(value);
        }
    }

    protected void processReport(XMLElement report) throws CMException {
        ReportGenerator generator;
        String measure = report.getChildNonNullValueWithName("measure");
        Aggregator aggregator = this.diagnosticsManager.getAggregator(measure);
        if (aggregator == null) {
            throw new IllegalArgumentException("Measure " + measure + "is unknown");
        }
        String format = report.getOptionalChildValueWithName("format");
        if (format == null) {
            format = "csv";
        }
        ResponseStreamTarget target = new ResponseStreamTarget(this.responseStream);
        CounterSerializer serializer = CounterSerializerFactory.getSerializerForType(aggregator.getCounterType());
        if (format.equalsIgnoreCase("csv")) {
            generator = new CSVReportGenerator(new XMLReportTarget(target), serializer, aggregator.hasGroups());
        } else if (format.equalsIgnoreCase("xml")) {
            generator = new XMLReportGenerator(target, serializer, aggregator.hasGroups());
        } else if (format.equalsIgnoreCase("readyToGraph")) {
            generator = new ReadyToGraphCSVReportGenerator(new XMLReportTarget(target), serializer, aggregator.getCounters(), aggregator.hasGroups());
        } else {
            throw new IllegalArgumentException("Invalid report format: " + format);
        }
        aggregator.generateReport(generator);
    }

    protected CounterDescriptor[] getCounters(XMLElement measure) throws CMException {
        XMLElement countersElement = measure.getChildWithName("counters");
        ArrayList<String> values = this.getChildrenValues(countersElement);
        if (values.size() == 0) {
            throw new IllegalArgumentException("You must specify at least one counter");
        }
        CounterDescriptor[] counters = new CounterDescriptor[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            String counterName = values.get(i);
            CounterDescriptor counter = this.diagnosticsManager.getCounterDescriptor(counterName);
            if (counter == null) {
                throw new IllegalStateException("The counter you specified is not registered: " + counterName);
            }
            counters[i] = counter;
        }
        return counters;
    }

    protected ContextFilter createContextFilter(XMLElement measure) {
        XMLElement filterBy = measure.getOptionalChildWithName("filterBy");
        if (filterBy != null) {
            ContextFilter contextFilter = new ContextFilter();
            ArrayList<XMLElement> filters = filterBy.getChildren();
            if (filters != null) {
                for (int i = 0; i < filters.size(); ++i) {
                    XMLElement filter = (XMLElement)filters.get(i);
                    ArrayList<String> values = this.getChildrenValues(filter);
                    if (filter.name_ == null || values.size() <= 0) continue;
                    contextFilter.set(DiagnosticsContext.getParam(filter.name_), values.toArray(new String[0]));
                }
                return contextFilter;
            }
        }
        return null;
    }

    protected DiagnosticsContext.Param[] getGroups(XMLElement measure) {
        XMLElement groupBy = measure.getOptionalChildWithName("groupBy");
        ArrayList<String> values = this.getChildrenValues(groupBy);
        if (values.size() == 0) {
            return null;
        }
        DiagnosticsContext.Param[] result = new DiagnosticsContext.Param[values.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = DiagnosticsContext.getParam(values.get(i));
            if (result[i] != null) continue;
            throw new IllegalArgumentException("Invalid group: " + values.get(i));
        }
        return result;
    }

    protected void setHistory(Aggregator newAggregator, XMLElement measure) {
        XMLElement history = measure.getOptionalChildWithName("history");
        if (history != null) {
            String intervalLength = history.getOptionalChildValueWithName("intervalLength");
            String numberOfIntervals = history.getOptionalChildValueWithName("numberOfIntervals");
            if (intervalLength != null && numberOfIntervals != null) {
                try {
                    newAggregator.setHistory(new Long(intervalLength), new Integer(numberOfIntervals));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        }
    }

    protected void registerAggregator(Aggregator aggregator) {
        this.diagnosticsManager.registerAggregator(aggregator);
        this.writeMeasureResponse(aggregator);
    }

    private ArrayList<String> getChildrenValues(XMLElement parent) {
        ArrayList<XMLElement> children;
        ArrayList<String> values = new ArrayList<String>();
        if (parent != null && (children = parent.getChildren()) != null) {
            for (int i = 0; i < children.size(); ++i) {
                XMLElement child = (XMLElement)children.get(i);
                if (child == null || child.value_ == null) continue;
                values.add(child.value_);
            }
        }
        return values;
    }

    private void writeResponseHeader() {
        this.responseStream.print("<");
        this.responseStream.print(this.getCMPrefixString());
        this.responseStream.print(":diagnosticsResponse");
        this.responseStream.print(" xmlns:");
        this.responseStream.print("cm");
        this.responseStream.print("=\"");
        this.responseStream.print(this.getBiBusNamespace());
        this.responseStream.print("\">\r\n");
    }

    private void writeResponseFooter() {
        this.responseStream.print("</");
        this.responseStream.print(this.getCMPrefixString());
        this.responseStream.print(":");
        this.responseStream.print("diagnosticsResponse>\r\n");
    }

    private void writeMeasureResponse(Aggregator aggregator) {
        this.writeElement("measure", aggregator.getName());
    }

    private void writeDeleteResponse(String aggregatorName) {
        this.writeElement("deleted", aggregatorName);
    }

    private void writeElement(String name, String value) {
        this.responseStream.print('<');
        this.responseStream.print(name);
        this.responseStream.print('>');
        this.responseStream.print(value);
        this.responseStream.print("</");
        this.responseStream.print(name);
        this.responseStream.println('>');
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

