/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.delete2;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cmutils.hash.HashUtil;
import java.util.ArrayList;
import java.util.ListIterator;

public class endSession
extends RequestHandler {
    private String id_;
    private String searchPath_;

    public endSession(CMStore store) {
        super(store);
    }

    public endSession(CMStore store, String searchPath, String passportId) {
        super(store);
        this.searchPath_ = searchPath;
        this.id_ = passportId;
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        this.searchPath_ = requestElement.getOptionalChildValueWithName("search");
        this.id_ = requestElement.getOptionalChildValueWithName("id");
        if (this.searchPath_ == null || this.searchPath_.length() < 1) {
            throw new CMException("cmRequestMissingAttr", new CMException.Parm("Request", "endSession"), new CMException.Parm("Attribute", "search"));
        }
        if (this.id_ == null || this.id_.length() < 1) {
            throw new CMException("cmRequestMissingAttr", new CMException.Parm("Request", "endSession"), new CMException.Parm("Attribute", "id"));
        }
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = false;
        if (!CMExecutionContext.get().executingStaticRequest()) {
            throw new CMException("cmStaticRequest", new CMException.Parm("Request", "endSession"));
        }
        XMLElement xmlEl = this.getRootElement();
        if (xmlEl.isRequestsChild()) {
            xmlEl = xmlEl.getSingleChildWithName("requests");
            ArrayList<XMLElement> queryList = xmlEl.getChildren();
            ListIterator iter = queryList.listIterator();
            while (iter.hasNext()) {
                XMLElement xmlElItem = (XMLElement)iter.next();
                this.getParams(xmlElItem);
                rc = this.doEndSession();
            }
        } else {
            this.getParams(xmlEl);
            rc = this.doEndSession();
        }
        this.out.print("\t<");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("endSessionResponse");
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\"/>\r\n");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doEndSession() throws CMException {
        block9: {
            if (CMIndicationGlobals.bSYS_Info_isEnabled) {
                CMIndications.CMTrace("cmEndSession", new CMException.Parm("Path", this.searchPath_), new CMException.Parm("ID", this.id_));
            }
            CMExecutionContext ctx = CMExecutionContext.get();
            ctx.setAccManPassportID(this.id_);
            int sessionObject = ctx.getCurrentUserSessionObjectID();
            if (sessionObject > 0) {
                try {
                    this.lockMgr_.releaseLocks();
                    CMStoreXPath userPath = null;
                    userPath = new CMStoreXPath(null, this.searchPath_ + '/' + "session[@defaultName='" + new HashUtil().hash(this.id_) + "']", false);
                    userPath.setLockManagerUsageFlag(15);
                    int[] sessionObjs = new int[]{sessionObject};
                    this.lockMgr_.requestLocksToObjects(sessionObjs, 15);
                    DeadlockContext context = new DeadlockContext();
                    context.sessionObjs = sessionObjs;
                    try {
                        CMWhileDeadlockExecutor.execute(this, context, Class.forName("com.cognos.cm.request.endSession").getDeclaredMethod("executeInDeadlockLoop", DeadlockContext.class, Integer.class));
                        break block9;
                    }
                    catch (CMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new CMException(t, "cmUnexpectedError");
                    }
                }
                finally {
                    CMExecutionContext.endUserSession(this.id_);
                    this.lockMgr_.releaseLocks();
                }
            }
            CMExecutionContext.endUserSession(this.id_);
        }
        if (CMIndicationGlobals.bSYS_Info_isEnabled) {
            CMIndications.CMTrace("cmEndSessionCount", new CMException.Parm("SessionCount", Integer.toString(CMExecutionContext.userSessionCacheSize())));
        }
        AAAProvider.Action.END_SESSION.sendNotification(this.id_);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDeadlockLoop(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        CMStoreQueryResults results = null;
        CMProperty[] props = new CMProperty[]{CMProperty.OBJECTCLASS};
        try {
            results = store.executeQuery(context.sessionObjs, props, null, 0, 512, null);
            while (results.next()) {
            }
            results.reset();
            while (results.next()) {
                String path = results.getSearchPath();
                delete2.deleteDescendants(store, path, 512, false);
                CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    private static class DeadlockContext {
        public int[] sessionObjs;

        private DeadlockContext() {
        }
    }
}

