/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.CAM.AAAException;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.cam.admin.AAANamespaceFormatURI;
import com.cognos.cm.cam.azn.AznUtil;
import com.cognos.cm.cmInfo;
import com.cognos.cm.dbstore.CMDbDataUpgradeStore;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.deployment.AncestorCache;
import com.cognos.cm.deployment.AuthenticatedNamespaces;
import com.cognos.cm.deployment.ContentFile;
import com.cognos.cm.deployment.DeploymentContent;
import com.cognos.cm.deployment.DeploymentContext;
import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.deployment.DeploymentExportArchive;
import com.cognos.cm.deployment.OptionsEncoder;
import com.cognos.cm.deployment.PackageDeploymentInfo;
import com.cognos.cm.deployment.ParametersEncoder;
import com.cognos.cm.deployment.exportTree.BatchSizeSelector;
import com.cognos.cm.deployment.exportTree.ExportEntry;
import com.cognos.cm.deployment.exportTree.ExportSet;
import com.cognos.cm.deployment.exportTree.ExportTree;
import com.cognos.cm.deployment.exportTree.HomeFolderExportTree;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMFaultDetailArray;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMPropertyValue;
import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePairArray;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPluginManager;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.XMLPolicyTransformer;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMSOAPWriter;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cm.util.DataEncryptionHelper;
import com.cognos.cm.util.io.CountingOutputStream;
import com.cognos.cmutils.collections.TraverseOrder;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.properties.Credentials;
import com.cognos.cmutils.properties.IDataEncryptionHelper;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;

public class export
extends Deployment {
    private static final String QS_CONTENT = "/content";
    private static final String QS_RECIPIENTS = "@objectClass='contact' or @objectClass='distributionList'";
    private static final String QS_NAMESPACE = "@objectClass='namespace' or @objectClass='role' or @objectClass='group'";
    private static final String QS_DATASOURCE_START = "CAMID(\":\")/*[@objectClass='dataSource' or @objectClass='dataSourceConnection' or @objectClass='dataSourceNameBinding' or @objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource'";
    private static final String QS_DATASOURCE = "CAMID(\":\")/*[@objectClass='dataSource' or @objectClass='dataSourceConnection' or @objectClass='dataSourceNameBinding' or @objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource']";
    private static final String QS_DATASOURCESIGNON = "CAMID(\":\")/*[@objectClass='dataSource' or @objectClass='dataSourceConnection' or @objectClass='dataSourceNameBinding' or @objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource' or @objectClass='dataSourceSignon']";
    private static final String QS_LAUNCHABLE = "/content/*[@objectClass='launchable']";
    private static final String QS_PACKAGES_FOLDERS = "/content/*[@objectClass='folder' or @objectClass='package']";
    private static HashMap<String, String> activePlugins;
    private boolean bOptionsPasswordInUnencryptedArchive_ = false;
    private DeploymentExportArchive exportArchive_;
    private BatchSizeSelector batchSizeSelector;
    private boolean useTreeExport = false;
    private CMProperty[] props_;
    private int nClassPos_ = 0;
    private int nSearchPathPos_ = 0;
    private int nHasChildrenPos_ = 0;
    private int nDefaultNamePos_ = 0;
    private CMPropertySet propSet_;
    private HomeFolderExportTree homeFoldersTree;
    private CMStorePath homeFolderPath;
    private ArrayList<String> userDocuments;
    private int dataFileCount_ = 0;

    public export(CMStore store) {
        super(store);
        this.isExport_ = true;
        this.homeFoldersTree = new HomeFolderExportTree(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        try {
            if (!this.parseForFirstDataElement()) {
                return;
            }
            this.getParams(this.didGetParmUsingXMLEl_);
            this.setDeploymentIPF(true);
            if (!this.entireContentStoreSelect_ && this.packageSelect_) {
                CMExecutionContext.get().setIPFObjectType(CMObjectClass.PACKAGE.getName().toUpperCase());
            }
        }
        catch (CMException ex) {
            DeploymentExecutionContext.clear();
            throw ex;
        }
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.runnableObjStorePath_ != null) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        XMLElement xmlElm = requestElement.getChildWithName("obj");
        this.runnableObjStorePath_ = this.getClassObjSearchPath(xmlElm);
        xmlElm = requestElement.getOptionalChildWithName("options");
        if (xmlElm != null) {
            this.getDeploymentOptions(xmlElm, true);
        } else {
            this.getDeploymentOptions(requestElement, true);
        }
    }

    private String makeFileName(String prefix, int number) {
        StringBuilder buf = new StringBuilder();
        buf.append(prefix).append(number).append(".xml");
        return buf.toString();
    }

    private void exportFolders(ContentFile content) throws CMException {
        int folderCount = 1;
        for (DeploymentContent record : content.folders) {
            record.filename = this.makeFileName("folder", folderCount++);
            String path = record.storeID != null ? CMStoreXPath.encodeStoreIdToPathString(record.storeID) : record.searchPath;
            this.exportToFile(DeploymentContext.Folder, record.filename, path, true);
        }
    }

    private void exportPackages(ContentFile content) throws CMException {
        int packCount = 1;
        for (DeploymentContent record : content.packages) {
            record.filename = this.makeFileName("package", packCount++);
            String path = record.storeID != null ? CMStoreXPath.encodeStoreIdToPathString(record.storeID) : record.searchPath;
            this.exportToFile(DeploymentContext.Package, record.filename, path, true);
            if (!this.deploymentOptionEnumPackage_) continue;
            record.searchPath = null;
        }
    }

    private void exportPersonalData(ContentFile content) throws CMException {
        int fileCount = 1;
        for (DeploymentContent record : content.accounts) {
            record.filename = this.makeFileName("accounts", fileCount++);
            PrintWriter printStream = this.openArchiveStream(record.filename, true);
            String exportQuery = record.searchPath;
            if (record.objClass != CMObjectClass.ACCOUNT) {
                StringBuilder buf = new StringBuilder(40);
                buf.append(record.searchPath).append("//account");
                exportQuery = buf.toString();
            }
            this.exportTree_exportAccounts(exportQuery, printStream);
            this.closeArchiveStream(printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryNamespaceFormatVersion(String namepaceSearchPath) throws CMException {
        CMStoreQueryResults results = null;
        int namespaceFormatVersion = -1;
        try {
            CMStoreXPath query2 = new CMStoreXPath(namepaceSearchPath);
            CMProperty[] props = new CMProperty[]{CMProperty.NAMESPACEFORMAT};
            results = this.store_.executeQuery(query2, props, null, 0, 8704, null);
            if (results.next()) {
                AAANamespaceFormatURI namespaceFormat = new AAANamespaceFormatURI(results.getValue(0).toString());
                namespaceFormatVersion = namespaceFormat.getVerionId();
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
        }
        return namespaceFormatVersion;
    }

    private void processPackageInfos(ContentFile content) throws CMException {
        for (int i = 0; i < this.packages_.size(); ++i) {
            PackageDeploymentInfo info = (PackageDeploymentInfo)this.packages_.get(i);
            String searchPath = "/content/*[@defaultName=" + CMStoreXPath.attributeQuoteString(info.sourceName_) + "]";
            DeploymentContent record = this.getContentRecordForPath(searchPath, null);
            if (record != null) {
                content.packages.add(record);
                record.name = info.sourceNames_;
                continue;
            }
            this.packages_.remove(i);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentContent getContentRecordForPath(String searchPath, AncestorCache ancestorCache) throws CMException {
        CMStoreQueryResults results;
        CMAncestors ancestors;
        DeploymentContent record;
        CMException error;
        boolean buildAncestors;
        block9: {
            buildAncestors = ancestorCache != null;
            CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH, CMProperty.NAME, CMProperty.OBJECTCLASS, CMProperty.STOREID, CMProperty.ANCESTORS};
            if (!buildAncestors) {
                props = Arrays.copyOf(props, 4);
            }
            error = null;
            record = null;
            ancestors = null;
            CMStoreXPath sp = new CMStoreXPath(searchPath);
            results = null;
            try {
                results = this.store_.executeQuery(sp, props, null, 9, 8193, null);
                if (!results.next()) {
                    throw new CMStoreObjectNotFound();
                }
                record = new DeploymentContent();
                record.searchPath = results.getValue(0).toString();
                record.name = (CMLocalizedStringArray)results.getValue(1);
                record.objClass = (CMObjectClass)results.getValue(2);
                record.storeID = results.getValue(3).toString();
                if (buildAncestors) {
                    ancestors = (CMAncestors)results.getValue(4);
                }
                if (!results.next()) break block9;
                CMException e = new CMException("cmBadObjectPathSingleObject");
                throw new CMException((Exception)e, "cmFailReadDeployOption", new CMException.Parm("Name", "export"));
            }
            catch (CMStoreObjectNotFound e) {
                try {
                    error = new CMException("cmExportObjectWithPathNotFound", new CMException.Parm("Path", searchPath));
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(results);
                    this.lockMgr_.releaseLocks();
                    throw throwable;
                }
                CMQueryUtils.safeQueryResultsRelease(results);
                this.lockMgr_.releaseLocks();
            }
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        this.lockMgr_.releaseLocks();
        if (error != null) {
            this.deploymentHistory.addRootError(error);
            return null;
        }
        if (buildAncestors && !record.isUserContent()) {
            record.ancestors = ancestorCache.convert(ancestors);
        }
        return record;
    }

    private void processExportSearchPaths(ContentFile content) throws CMException {
        AuthenticatedNamespaces authenticatedNSs = new AuthenticatedNamespaces();
        HashMap<String, Integer> nsFormatVersions = new HashMap<String, Integer>();
        AncestorCache ancestorCache = new AncestorCache(this.store_);
        ArrayList<String> newExportPaths = new ArrayList<String>();
        for (String searchPath : this.exportSearchPaths_) {
            DeploymentContent record = this.getContentRecordForPath(searchPath, ancestorCache);
            if (record == null) continue;
            if (record.isUserContent()) {
                if (this.archiveEncryptPassword_ == null) {
                    throw new CMException("cmExpectedArchiveEncryptPassword");
                }
                String nsID = CMCAMIDHelper.getNamespaceIDFromSearchPath(record.searchPath);
                if (!authenticatedNSs.containsNamespaceId(nsID)) continue;
                String nsSearchPath = CMCAMIDHelper.SelectFromCAMID(nsID);
                if (!nsFormatVersions.containsKey(nsID)) {
                    nsFormatVersions.put(nsID, this.queryNamespaceFormatVersion(nsSearchPath));
                }
                record.namespaceFormat = (Integer)nsFormatVersions.get(nsID);
                record.namespacePath = nsSearchPath;
                content.accounts.add(record);
            } else {
                content.packages.add(record);
            }
            record.searchPath = searchPath;
            newExportPaths.add(searchPath);
        }
        this.exportSearchPaths_ = newExportPaths;
        authenticatedNSs.writeMessages(this.deploymentHistory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUserContent(ContentFile content) throws CMException {
        AuthenticatedNamespaces authenticatedNSs = new AuthenticatedNamespaces();
        CMStoreQueryResults results = null;
        CMStoreXPath nsQuery = new CMStoreXPath("/directory/namespace");
        CMProperty[] nsProps = new CMProperty[]{CMProperty.SEARCHPATH, CMProperty.NAMESPACEFORMAT};
        try {
            results = this.store_.executeQuery(nsQuery, nsProps, null, 0, 8193, null);
            while (results.next()) {
                String searchPath = results.getValue(0).toString();
                String nsID = CMCAMIDHelper.getNamespaceIDFromSearchPath(searchPath);
                if (!authenticatedNSs.containsNamespaceId(nsID)) continue;
                DeploymentContent record = new DeploymentContent();
                String nsFormatURI = results.getValue(1).toString();
                AAANamespaceFormatURI nsFormat = new AAANamespaceFormatURI(nsFormatURI);
                record.searchPath = searchPath;
                record.namespacePath = searchPath;
                record.namespaceFormat = nsFormat.getVerionId();
                record.objClass = CMObjectClass.NAMESPACE;
                content.accounts.add(record);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
        }
        authenticatedNSs.writeMessages(this.deploymentHistory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPublicContent(ContentFile content) throws CMException {
        CMStoreQueryResults results = null;
        CMStoreXPath pkgQuery = new CMStoreXPath(QS_PACKAGES_FOLDERS);
        CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH, CMProperty.NAME, CMProperty.OBJECTCLASS, CMProperty.STOREID};
        try {
            results = this.store_.executeQuery(pkgQuery, props, null, 10, 8193, null);
            while (results.next()) {
                DeploymentContent record = new DeploymentContent();
                record.searchPath = results.getValue(0).toString();
                record.name = (CMLocalizedStringArray)results.getValue(1);
                record.objClass = (CMObjectClass)results.getValue(2);
                record.storeID = results.getValue(3).toString();
                if (record.objClass == CMObjectClass.PACKAGE) {
                    content.packages.add(record);
                    continue;
                }
                content.folders.add(record);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
        }
    }

    private synchronized HashMap<String, String> getActivePlugins() throws CMException {
        if (activePlugins != null) {
            return activePlugins;
        }
        HashMap<String, String> plugins = new HashMap<String, String>();
        CMPluginManager pluginMgr = CMPluginManager.getInstance();
        CMDbDataUpgradeStore dataUpgradeStore = new CMDbDataUpgradeStore();
        for (CMPluginDescriptor desc : pluginMgr.getPluginDescriptors()) {
            String pluginName;
            if (!desc.getPluginType().equalsIgnoreCase("Upgrade") || desc.getEditions() != null || plugins.containsKey(pluginName = desc.getPluginName())) continue;
            String version = dataUpgradeStore.get(pluginName);
            plugins.put(pluginName, version);
        }
        activePlugins = plugins;
        return plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doAction(XMLElement requestElement, String tabPrefix) throws CMException {
        this.assertRunning();
        boolean success = false;
        ContentFile content = new ContentFile();
        this.getParams(requestElement);
        this.addRunHistory();
        this.loadPlugin("com.cognos.xqe.util.datasets.DatasetUtil");
        if (!this.isSync_) {
            this.addHistoryDetailReqArgs(this.deploymentOptions_, null);
        }
        this.startDeploymentProgressThread();
        if ((this.dataSourceSignonSelect_ || this.entireContentStoreSelect_ || this.packageDatasetOutputs_) && this.archiveEncryptPassword_ == null) {
            throw new CMException("cmExpectedArchiveEncryptPassword");
        }
        this.batchSizeSelector = new BatchSizeSelector(this.store_.getObjectClasses());
        boolean bl = this.useTreeExport = this.batchSizeSelector.getBatchSize(null) > 0;
        if (!this.useTreeExport && CMIndicationGlobals.bDEP_Info_isEnabled) {
            CMIndications.CMTrace("cmDeployTreeBasedExportOff");
        }
        this.exportArchive_ = new DeploymentExportArchive(this.archive_, this.archiveEncryptPassword_, this.archiveOverwrite_);
        try {
            this.buildPropertyArray();
            this.addBuffer_ = new StringBuffer();
            if (this.entireContentStoreSelect_) {
                if (!this.userAccountsOnly_) {
                    this.exportToFile(DeploymentContext.Content, "contentObj.xml", QS_CONTENT, false, null, false);
                    this.exportToFile(DeploymentContext.Folder, "folders.xml", QS_LAUNCHABLE, true, null, true);
                    this.exportToFile(DeploymentContext.Configuration, "allConfiguration.xml", "/" + CMObjectClass.CONFIGURATION, false);
                    this.exportToFile(DeploymentContext.AdminFolder, "allAdminFolder.xml", "/" + CMObjectClass.ADMINFOLDER, false);
                    this.exportToFile(DeploymentContext.Capability, "allCapability.xml", "/" + CMObjectClass.CAPABILITY, false);
                    this.exportToFile(DeploymentContext.CognosNamespace, "allDirectoryCognos.xml", "CAMID(\":\")", false);
                    this.exportToFile(DeploymentContext.Tenants, "allDirectoryTenants.xml", allTenantsSearchPath_, false);
                    this.exportToFile(DeploymentContext.Portal, "allPortal.xml", "/" + CMObjectClass.PORTAL, false);
                    this.exportToFile(DeploymentContext.Transient, "allTransientStateFolder.xml", "/" + CMObjectClass.TRANSIENTSTATEFOLDER, true);
                    this.exportToFile(DeploymentContext.Catalog, "allCatalog.xml", allCatalogSearchPath_, true);
                    this.exportToFile(DeploymentContext.Resources, "allResources.xml", "/" + CMObjectClass.RESOURCEFOLDER, false);
                    this.getPublicContent(content);
                    this.exportFolders(content);
                    this.exportPackages(content);
                }
                if (this.personalDataSelect_) {
                    this.getUserContent(content);
                }
            } else {
                if (this.deploymentOptionEnumExport_) {
                    this.processExportSearchPaths(content);
                } else if (this.packageSelect_ && this.deploymentOptionEnumPackage_) {
                    this.processPackageInfos(content);
                }
                if (this.packageSelect_) {
                    this.exportPackages(content);
                }
                if (this.namespaceSelect_) {
                    this.exportToFile(DeploymentContext.CognosNamespace, "namespace.xml", QS_NAMESPACE, true, "CAMID(\":\")", false);
                }
                if (this.dataSourceSelect_) {
                    String strQuery = this.dataSourceSignonSelect_ ? QS_DATASOURCESIGNON : QS_DATASOURCE;
                    this.exportToFile(DeploymentContext.CognosNamespace, "dataSource.xml", strQuery, true, null, false);
                }
                if (this.recipientsSelect_) {
                    this.exportToFile(DeploymentContext.CognosNamespace, "recipients.xml", QS_RECIPIENTS, true, "CAMID(\":\")", false);
                }
            }
            if (this.personalDataSelect_) {
                this.homeFolderPath = this.getHomeFolderPath();
                this.exportPersonalData(content);
            }
            this.exportHomeFolders();
            this.assertRunning();
            content.plugins = this.getActivePlugins();
            this.createContentFile(content);
            this.createDeploymentRecord();
            this.assertRunning();
            this.generateRootLevelExportDetails();
            this.emitResponse(tabPrefix);
            success = true;
        }
        finally {
            if (this.exportArchive_ != null) {
                if (success) {
                    try {
                        this.exportArchive_.close();
                    }
                    catch (Exception exception) {}
                } else {
                    this.exportArchive_.delete();
                }
            }
            this.stopDeploymentProgressThread();
        }
        return success;
    }

    private void generateRootLevelExportDetails() {
        this.deploymentHistory.updateRunHistory(this.succeeded_);
        this.deploymentHistory.addRootDetail(this.objectsReportCount_, this.objectsFailed_);
        if (AdvancedSettings.TENANTS_DEPLOYMENT_UPDATE_TARGET && this.tenantsContentConflictResolution_ == 1 && DeploymentExecutionContext.get().isMultiTenantDeployment()) {
            this.deploymentHistory.addRootDetailObsoleteSetting();
        }
    }

    private void buildPropertyArray() {
        this.propSet_ = this.store_.getPropertySets().getPropertySet();
        ArrayList<CMProperty> propertiesList = new ArrayList<CMProperty>();
        propertiesList.add(CMProperty.CREATIONTIME);
        propertiesList.add(CMProperty.MODIFICATIONTIME);
        propertiesList.addAll(this.propSet_.getProperties(CMPropertyMeaning.DATASIZE));
        propertiesList.addAll(this.propSet_.getProperties(CMPropertyMeaning.DATATYPE));
        propertiesList.addAll(this.propSet_.getProperties(CMPropertyMeaning._DATAISCOMPRESSED));
        int iSpot = propertiesList.size();
        for (int idx = 0; idx < this.propSet_.size(); ++idx) {
            CMProperty prop = this.propSet_.getPropertyAt(idx);
            if (!prop.isUpdateable() && prop != CMProperty.SEARCHPATH && prop != CMProperty.HASCHILDREN && prop != CMProperty.DEFAULTNAME && prop != CMProperty.ANCESTORS && prop != CMProperty.OBJECTCLASS || prop.isDefaultMultilingualProperty() && prop != CMProperty.DEFAULTNAME || prop.isInternal()) continue;
            if (prop == CMProperty.SEARCHPATH) {
                this.nSearchPathPos_ = iSpot;
            } else if (prop == CMProperty.HASCHILDREN) {
                this.nHasChildrenPos_ = iSpot;
            } else if (prop == CMProperty.OBJECTCLASS) {
                this.nClassPos_ = iSpot;
            } else if (prop == CMProperty.DEFAULTNAME) {
                this.nDefaultNamePos_ = iSpot;
            }
            if ((prop == CMProperty.POLICIES || prop == CMProperty.USERCAPABILITYPOLICIES) && !this.objectPolicies_ || prop.hasMeaning(CMPropertyMeaning.DATATYPE) || prop.getName().equals("usageTrackingModel") || prop == CMProperty.TASKID || prop == CMProperty.EVENTID || prop == CMProperty.RUNOPTIONS || prop == CMProperty.DEPLOYMENTOPTIONS) continue;
            propertiesList.add(prop);
            ++iSpot;
        }
        propertiesList.add(this.ACCOUNT_FIRSTLOGONNAME);
        propertiesList.add(this.ACCOUNT_USERID);
        this.props_ = new CMProperty[propertiesList.size()];
        propertiesList.toArray(this.props_);
    }

    private static boolean isExternalProperty(CMProperty prop, CMStoreQueryResults results) {
        return prop.isExternal() && (results.getState() & 2) != 0 && results.hasExternalProperty(prop);
    }

    private static boolean isWriteableProperty(CMProperty prop) {
        return prop == CMProperty.CREATIONTIME || prop == CMProperty.MODIFICATIONTIME || prop.hasMeaning(CMPropertyMeaning.DATATYPE) || prop.hasMeaning(CMPropertyMeaning.DATASIZE) || prop.isUpdateable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportObject(ExportObject obj, PrintWriter packOut, CMStoreQueryResults results, CMProperty[] props) throws CMException {
        boolean isSysAdmin;
        String tab = "\t";
        String tabs2 = "\t\t";
        export.putElement(packOut, tab, "object", false, true);
        export.putElement(packOut, tabs2, "class", obj.objectClass.getName());
        export.putElement(packOut, tabs2, "name", XMLUtils.escape((String)obj.name, (boolean)false));
        if (obj.id != -1) {
            export.putElement(packOut, tabs2, "id", Integer.toString(obj.id));
        }
        export.putElement(packOut, tabs2, "parentId", Integer.toString(obj.parentId));
        boolean bl = isSysAdmin = obj.objectClass == CMObjectClass.ROLE && obj.path.indexOf("::System Administrators") > 0;
        if (isSysAdmin || obj.parentId == 0 && (obj.objectClass == CMObjectClass.ACCOUNT || obj.objectClass == CMObjectClass.CONTENT || obj.objectClass == CMObjectClass.CONFIGURATION || obj.objectClass == CMObjectClass.ADMINFOLDER || obj.objectClass == CMObjectClass.CAPABILITY || obj.objectClass == CMObjectClass.NAMESPACE || obj.objectClass == CMObjectClass.PORTAL || obj.objectClass == CMObjectClass.TRANSIENTSTATEFOLDER || obj.objectClass == CMObjectClass.RESOURCEFOLDER || obj.objectClass == CMObjectClass.CATALOG)) {
            export.putElement(packOut, tabs2, "path", XMLUtils.escape((String)obj.path, (boolean)false));
        }
        if (obj.parentId == -1 && obj.parentPath != null) {
            if (this.deploymentLogging_) {
                this.log_.logString("###Missing parentInfo for " + obj.path);
            }
            export.putElement(packOut, tabs2, "parentPath", XMLUtils.escape((String)obj.parentPath, (boolean)false));
        } else if (this.deploymentLogging_) {
            this.log_.logString("$$$Exporting " + obj.path);
        }
        if (obj.storeID != null) {
            export.putElement(packOut, tabs2, "storeID", XMLUtils.escape((String)obj.storeID, (boolean)false));
        }
        this.writeAccountGenericDocumentReferences(obj, packOut);
        export.putElement(packOut, tabs2, "props", false, true);
        HashMap<CMProperty, Object> deferredProps = null;
        boolean isDataSetOutput = false;
        boolean isSuccess = false;
        try {
            for (int idx = 0; idx < props.length; ++idx) {
                Object propValueObject;
                CMProperty prop = props[idx];
                if (!obj.objectClass.hasProperty(prop) || prop == CMProperty.DEFAULTNAME || (propValueObject = results.getValue(idx)) == null || results.wasAcquired() || !export.isWriteableProperty(prop) || export.isExternalProperty(prop, results)) continue;
                if (prop == CMProperty.FORMAT && obj.objectClass == CMObjectClass.OUTPUT) {
                    String formatValue;
                    if (propValueObject instanceof CMDbStoreString && (formatValue = ((CMDbStoreString)propValueObject).getValue()) != null && formatValue.equals("dataSet")) {
                        isDataSetOutput = true;
                    }
                } else {
                    if (prop.hasMeaning(CMPropertyMeaning.DATA) && obj.objectClass == CMObjectClass.OUTPUT) {
                        if (deferredProps == null) {
                            deferredProps = new HashMap<CMProperty, Object>();
                        }
                        deferredProps.put(prop, propValueObject);
                        continue;
                    }
                    if (prop.hasMeaning(CMPropertyMeaning._DATAISCOMPRESSED) && obj.objectClass == CMObjectClass.OUTPUT) {
                        if (deferredProps == null) {
                            deferredProps = new HashMap();
                        }
                        deferredProps.put(prop, propValueObject);
                    } else if (prop.hasMeaning(CMPropertyMeaning.GENERIC_REFERENCES)) {
                        this.homeFoldersTree.add((CMStringArray)propValueObject);
                    }
                }
                this.exportProperty(packOut, prop, propValueObject, null);
            }
            isSuccess = true;
        }
        finally {
            if (isSuccess && deferredProps != null) {
                try {
                    this.processDataSetOutput(packOut, deferredProps, isDataSetOutput);
                }
                catch (Exception ex) {
                    CMException cmex = new CMException(ex, "cmExportFailed");
                    this.deploymentHistory.saveDetail(obj.id, 7, cmex);
                }
            }
            export.putElement(packOut, tabs2, "props", true, true);
            export.putElement(packOut, tab, "object", true, true);
        }
    }

    private void writeAccountGenericDocumentReferences(ExportObject obj, PrintWriter packOut) {
        String tabs2 = "\t\t";
        if (obj.objectClass == CMObjectClass.ACCOUNT && this.userDocuments != null && !this.userDocuments.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String s : this.userDocuments) {
                buf.append(s).append(", ");
            }
            buf.setLength(buf.length() - 2);
            export.putElement(packOut, tabs2, "references", XMLUtils.escape((String)buf.toString(), (boolean)false));
        }
    }

    private void processDataSetOutput(PrintWriter packOut, HashMap<CMProperty, Object> deferredProps, boolean isDataSetOutput) throws CMException {
        CMProperty dataProp = this.propSet_.getProperty(CMPropertyMeaning.DATA, CMObjectClass.OUTPUT);
        Object dataPropValue = deferredProps.get(dataProp);
        if (dataPropValue != null) {
            String cValue;
            boolean isDataCompressed = false;
            CMProperty cProp = this.propSet_.getProperty(CMPropertyMeaning._DATAISCOMPRESSED, CMObjectClass.OUTPUT);
            Object cPropValue = deferredProps.get(cProp);
            if (cPropValue != null && cPropValue instanceof CMDbStoreString && (cValue = ((CMDbStoreString)cPropValue).getValue()) != null && cValue.equals("true")) {
                isDataCompressed = true;
            }
            this.exportProperty(packOut, dataProp, dataPropValue, new DataSetInfo(isDataSetOutput, isDataCompressed));
        }
    }

    private boolean hasReadAccess(CMStoreQueryResults results, CMObjectClass cls) {
        if (results.hasPermission("read")) {
            return true;
        }
        ++this.objectsFailed_;
        CMException cmex = new CMException("cmExportNoReadFail", new CMException.Parm("Class", cls.getLocalizedName()));
        cmex.ErrorLevel = 30000;
        this.deploymentHistory.saveDetail(results.getObjectID(), 7, cmex);
        return false;
    }

    private boolean accountExists(String path, int cmid) {
        try {
            CMCAMIDHelper.normalizeSecurityReference(this.store_, path, false, false, true, false);
            return true;
        }
        catch (CMException e) {
            ++this.objectsFailed_;
            CMException cmex = new CMException("cmAccountNotDefined", new CMException.Parm("Account", path));
            cmex.ErrorLevel = 30000;
            this.deploymentHistory.saveDetail(cmid, 7, cmex);
            return false;
        }
    }

    private void filterOutPublicContent(ExportTree tree) {
        for (ExportEntry e : tree.entries(TraverseOrder.postorder, null)) {
            if (e.getTenantID() != 0 || e.getChild() != null) continue;
            e.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTree_exportPath(String queryString, DeploymentContext context, PrintWriter packOut) throws CMException {
        CMStorePath path = CMStoreXPath.parse(queryString);
        try {
            ExportTree tree = this.buildExportTree(path);
            if (DeploymentExecutionContext.get().doExcludePublicObjects()) {
                this.filterOutPublicContent(tree);
            }
            this.exportTree(tree, packOut, 1, context);
        }
        finally {
            this.deploymentHistory.addSavedDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTree_exportAccounts(String queryString, PrintWriter packOut) throws CMException {
        ArrayList<CMStorePath> accountList = this.selectAccounts(queryString);
        if (accountList.size() == 0) {
            return;
        }
        int id = 1;
        for (CMStorePath account : accountList) {
            this.assertRunning();
            this.userDocuments = this.getUserGenericDocuments(account);
            this.homeFoldersTree.add(new CMDbStoreStringArray(this.userDocuments));
            if (this.deploymentLogging_) {
                this.log_.logString("Exporting account: " + account.toString());
            }
            try {
                ExportTree tree = this.buildExportTree(account);
                id = this.exportTree(tree, packOut, id, DeploymentContext.ExternalNamespace);
            }
            catch (CMException e) {
                RuntimeException err = new RuntimeException("Error encountered while exporting account " + account.toString(), e);
                CMIndications.logException(err);
            }
            finally {
                this.deploymentHistory.addSavedDetails();
                this.userDocuments = null;
            }
        }
        packOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CMStorePath> selectAccounts(String path) throws CMException {
        ArrayList<CMStorePath> list = new ArrayList<CMStorePath>();
        CMStoreQueryResults results = null;
        CMStoreXPath objectContext = new CMStoreXPath(path);
        try {
            try {
                CMProperty[] props = new CMProperty[]{CMProperty.OBJECTCLASS, CMProperty.SEARCHPATH, CMProperty.TENANTID};
                results = this.store_.executeQuery(objectContext, props, null, 10, 8193, null);
            }
            catch (CMStoreObjectNotFound props) {
                // empty catch block
            }
            if (results == null) {
                throw new CMException("cmExportObjectNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, objectContext)));
            }
            while (results.next()) {
                int tenantID;
                if (CMObjectClass.ACCOUNT != results.getValue(0) || (tenantID = results.getTenantID()) == 0 && DeploymentExecutionContext.get().doExcludePublicUserAccounts()) continue;
                String searchPath = results.getValue(1).toString();
                CMStoreXPath account = new CMStoreXPath(searchPath);
                int cmid = results.getObjectID();
                if (!this.accountExists(account.toString(), cmid) || !this.hasReadAccess(results, CMObjectClass.ACCOUNT)) continue;
                list.add(account);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
            this.deploymentHistory.addSavedDetails();
        }
        return list;
    }

    private int exportTree(ExportTree tree, PrintWriter packOut, int nextId, DeploymentContext context) throws CMException {
        CMProperty[] classProps = null;
        CMObjectClass prevClass = null;
        for (ExportSet set : tree.exportSets()) {
            int batchSize;
            CMObjectClass cls = set.getObjectClass();
            if (prevClass != cls) {
                classProps = this.getClassProperties(cls);
                prevClass = cls;
            }
            if ((batchSize = this.batchSizeSelector.getBatchSize(cls)) <= 0 || this.classProcessed(cls, context, null) == 0) {
                set.discard();
                continue;
            }
            set.setBatchSize(batchSize);
            nextId = this.exportSet(set, classProps, packOut, nextId, context);
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exportSet(ExportSet set, CMProperty[] props, PrintWriter writer, int nextId, DeploymentContext context) throws CMException {
        ExportObject obj = new ExportObject();
        obj.objectClass = set.getObjectClass();
        for (HashMap<InternalStoreId, ExportEntry> batch : set) {
            CMStoreQueryResults results = null;
            if (batch.isEmpty()) continue;
            try {
                this.store_.beginTransaction();
                this.lockMgr_.requestLocks(batch.keySet(), 10);
                results = this.store_.executeQuery(batch.keySet(), props, null, 10, 512, null);
                while (results.next()) {
                    int cmid = results.getObjectID();
                    ExportEntry entry = batch.get(this.store_.getInternalStoreId(cmid));
                    if (entry == null) continue;
                    ExportEntry parent = entry.getParent();
                    CMObjectClass parentCls = null;
                    if (parent != null) {
                        parentCls = parent.getObjectClass();
                    }
                    obj.parentId = entry.getParentID();
                    obj.id = nextId;
                    obj.path = results.getSearchPath();
                    obj.storeID = this.store_.getObjectStoreID(cmid);
                    obj.name = results.getName();
                    if (this.skipObject(obj, context, parentCls)) continue;
                    int statusDeploy = 6;
                    CMException errorOnObject = null;
                    try {
                        this.exportObject(obj, writer, results, props);
                        ++this.objectsReportCount_;
                        entry.setID(nextId);
                        ++nextId;
                    }
                    catch (CMException cmex) {
                        statusDeploy = 7;
                        errorOnObject = cmex;
                    }
                    catch (Exception ex) {
                        statusDeploy = 7;
                        errorOnObject = new CMException(ex, "cmExportDataWriteFail");
                    }
                    finally {
                        if (statusDeploy != 6) {
                            ++this.objectsFailed_;
                        }
                        if (statusDeploy == 6 && this.recordingLevel_ < 3) continue;
                        this.deploymentHistory.saveDetail(cmid, statusDeploy, errorOnObject);
                    }
                }
                this.store_.commitTransaction();
            }
            finally {
                if (results != null) {
                    results.release();
                }
                this.rollbackOpenTransaction();
                this.lockMgr_.releaseLocks();
                this.deploymentHistory.addSavedDetails();
            }
        }
        return nextId;
    }

    private boolean skipObject(ExportObject obj, DeploymentContext context, CMObjectClass parentCls) {
        return this.classProcessed(obj.objectClass, context, parentCls) == 0 || !export.deployObjectWithPath(obj.path) || obj.objectClass == CMObjectClass.RUNTIMESTATE && !obj.name.equals("onlineLearning");
    }

    private void rollbackOpenTransaction() {
        if (this.store_.inTransaction()) {
            try {
                this.store_.rollbackTransaction();
            }
            catch (CMException ex) {
                CMIndications.logException(ex);
            }
        }
    }

    private CMProperty[] getClassProperties(CMObjectClass cls) {
        ArrayList<CMProperty> result = new ArrayList<CMProperty>();
        for (CMProperty prop : this.props_) {
            if (!cls.hasProperty(prop)) continue;
            result.add(prop);
        }
        return result.toArray(new CMProperty[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportTree buildExportTree(CMStorePath root) throws CMException {
        ExportTree tree = new ExportTree(this.store_.getObjectClasses());
        CMStoreQueryResults results = null;
        int rootId = -1;
        CMStoreXPath path = new CMStoreXPath(root, "descendant-or-self::*", false);
        ArrayList<ExportEntry> unreadable = new ArrayList<ExportEntry>();
        try {
            CMProperty[] props = new CMProperty[]{CMProperty.OBJECTCLASS, CMProperty.STOREID, CMProperty.TENANTID};
            this.lockMgr_.requestLocks(path);
            results = this.store_.executeQuery(root, props, null, 10, 1, null);
            if (results.next()) {
                rootId = results.getObjectID();
            }
            results.release();
            results = null;
            results = this.store_.executeQuery(path, props, null, 10, 1, null);
            while (results.next()) {
                ExportEntry entry = this.createExportEntryFromResultSet(tree, results);
                if (this.hasReadAccess(results, entry.getObjectClass())) continue;
                unreadable.add(entry);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
            this.deploymentHistory.addSavedDetails();
        }
        tree.build(rootId);
        for (ExportEntry entry : unreadable) {
            if (entry.getParent() == null) continue;
            entry.delete();
        }
        return tree;
    }

    private ExportEntry createExportEntryFromResultSet(ExportTree tree, CMStoreQueryResults rs) {
        CMObjectClass cls = rs.getObjectClass();
        int tenantID = rs.getTenantID();
        int cmid = rs.getObjectID();
        int pcmid = rs.getParentObjectID();
        InternalStoreId storeid = this.store_.getInternalStoreId(cmid);
        return tree.add(cmid, pcmid, storeid, cls, tenantID);
    }

    private void exportToFile(DeploymentContext context, String filename, String queryString, boolean hasData) throws CMException {
        PrintWriter packOut = this.openArchiveStream(filename, hasData);
        this.exportTree_exportPath(queryString, context, packOut);
        this.closeArchiveStream(packOut);
    }

    private void exportToFile(DeploymentContext context, String filename, String queryString, boolean doRecursive, String securityNamepaceToQuery, boolean hasData) throws CMException {
        PrintWriter packOut = this.openArchiveStream(filename, hasData);
        this.exportToFile(context, packOut, queryString, doRecursive, securityNamepaceToQuery);
        this.closeArchiveStream(packOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportToFile(DeploymentContext context, PrintWriter packOut, String queryString, boolean doRecursive, String securityNamepaceToQuery) throws CMException {
        boolean doingSecurity;
        CMStoreQueryResults results = null;
        String queryStringPlusNamespaceFolder = null;
        String packageSearchPath = queryString;
        boolean bl = doingSecurity = securityNamepaceToQuery != null;
        if (doingSecurity) {
            queryStringPlusNamespaceFolder = "[" + queryString + " or @" + CMProperty.OBJECTCLASS.getName() + "=\"" + CMObjectClass.NAMESPACEFOLDER.getName() + "\"]";
            packageSearchPath = securityNamepaceToQuery + "/*" + queryStringPlusNamespaceFolder;
        }
        LinkedList<DeployObject> selectObjectsList = new LinkedList<DeployObject>();
        int id = 0;
        int cmid = -1;
        ExportObject obj = new ExportObject();
        selectObjectsList.add(new DeployObject(0, new CMStoreXPath(packageSearchPath)));
        while (!selectObjectsList.isEmpty()) {
            DeployObject deployObject = (DeployObject)selectObjectsList.removeFirst();
            CMStorePath objectContext = deployObject.objectContextPackage_;
            obj.parentId = deployObject.parentId_;
            try {
                try {
                    results = this.store_.executeQuery(objectContext, this.props_, null, 10, 8193, null);
                }
                catch (CMStoreObjectNotFound e) {
                    throw new CMException("cmExportObjectNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, objectContext)));
                }
                while (results.next()) {
                    CMException errorOnObject = null;
                    cmid = results.getObjectID();
                    obj.objectClass = (CMObjectClass)results.getValue(this.nClassPos_);
                    obj.name = results.getValue(this.nDefaultNamePos_).toString();
                    obj.path = results.getValue(this.nSearchPathPos_).toString();
                    obj.storeID = this.store_.getObjectStoreID(cmid);
                    CMObjectClass pCls = this.store_.getObjectClass(results.getParentObjectID());
                    if (this.deploymentLogging_) {
                        this.log_.logString("Exporting " + obj.path);
                    }
                    if (this.classProcessed(obj.objectClass, context, pCls) == 0 || !export.deployObjectWithPath(obj.path) || !this.hasReadAccess(results, obj.objectClass)) continue;
                    int statusDeploy = 6;
                    try {
                        obj.id = -1;
                        Object value = results.getValue(this.nHasChildrenPos_);
                        boolean bHasChildren = false;
                        if (value != null) {
                            bHasChildren = "true".equals(value.toString());
                        }
                        if (doRecursive && bHasChildren) {
                            String strAddPath = obj.path.length() > 1 ? obj.path + "/*" : "/*";
                            if (doingSecurity) {
                                strAddPath = strAddPath + queryStringPlusNamespaceFolder;
                            }
                            CMStorePath objectContextAdd = CMStoreXPath.parse(strAddPath);
                            selectObjectsList.add(new DeployObject(++id, objectContextAdd));
                            obj.id = id;
                        }
                        this.exportObject(obj, packOut, results, this.props_);
                        ++this.objectsReportCount_;
                    }
                    catch (CMException cmex) {
                        statusDeploy = 7;
                        errorOnObject = cmex;
                    }
                    catch (Exception ex) {
                        statusDeploy = 7;
                        errorOnObject = new CMException(ex, "cmExportDataWriteFail");
                    }
                    finally {
                        if (statusDeploy != 6) {
                            ++this.objectsFailed_;
                        }
                        if (statusDeploy == 6 && this.recordingLevel_ < 3) continue;
                        this.deploymentHistory.saveDetail(cmid, statusDeploy, errorOnObject);
                    }
                }
            }
            finally {
                if (results != null) {
                    results.release();
                }
                results = null;
                this.lockMgr_.releaseLocks();
                this.deploymentHistory.addSavedDetails();
            }
        }
        return true;
    }

    private void exportHomeFolders() throws CMException {
        this.homeFoldersTree.build();
        PrintWriter packOut = this.openArchiveStream("homeFolders.xml", true);
        this.exportTree(this.homeFoldersTree, packOut, 1, DeploymentContext.HomeFolders);
        this.closeArchiveStream(packOut);
        this.homeFoldersTree.writeIndex(this.exportArchive_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getUserGenericDocuments(CMStorePath userPath) throws CMException {
        ArrayList<String> documents = new ArrayList<String>();
        CMStoreQueryResults results = null;
        CMProperty[] props = new CMProperty[]{CMProperty.DOCUMENTID};
        for (CMStoreXPath path : this.getHomeFoldersOwnedByUser(userPath)) {
            CMStoreXPath docPath = new CMStoreXPath(path, "descendant::genericDocument", false);
            this.lockMgr_.requestLocks(docPath);
            try {
                results = this.store_.executeQuery(docPath, props, null, 10, 512, null);
                while (results.next()) {
                    CMDbStoreString docid = (CMDbStoreString)results.getValue(0);
                    if (docid == null) continue;
                    documents.add(docid.toString());
                }
            }
            finally {
                if (results != null) {
                    results.release();
                }
                this.lockMgr_.releaseLocks();
            }
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CMStoreXPath> getHomeFoldersOwnedByUser(CMStorePath userPath) throws CMException {
        CMStoreQueryResults results = null;
        CMStoreXPath homeFoldersPath = new CMStoreXPath(this.homeFolderPath, "*", false);
        ArrayList<CMStoreXPath> ownedFolders = new ArrayList<CMStoreXPath>();
        this.lockMgr_.requestLocks(Arrays.asList(userPath, this.homeFolderPath));
        try {
            int userId = this.store_.getUserAccountObjID(userPath.getCAMIDFromFirstStep());
            results = this.store_.executeQuery(homeFoldersPath, null, null, 10, 512, null);
            while (results.next()) {
                int cmid = results.getObjectID();
                if (userId != this.store_.getOwnerObjectID(cmid)) continue;
                ownedFolders.add(CMStoreXPath.fromStoreID(this.store_.getInternalStoreId(cmid).stringValue()));
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
        }
        return ownedFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMStoreXPath getHomeFolderPath() throws CMException {
        CMStoreQueryResults results = null;
        CMStoreXPath path = new CMStoreXPath("/folder[@name=\"home\"]");
        this.lockMgr_.requestLocks(path);
        try {
            results = this.store_.executeQuery(path, null, null, 10, 512, null);
            if (!results.next()) {
                throw new CMStoreObjectNotFound("/folder[@name=\"home\"]");
            }
            String storeId = this.store_.getObjectStoreID(results.getObjectID());
            CMStoreXPath cMStoreXPath = CMStoreXPath.fromStoreID(storeId);
            return cMStoreXPath;
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
        }
    }

    private PrintWriter openArchiveStream(String filename, boolean hasData) throws CMException {
        this.assertRunning();
        if (CMIndicationGlobals.bDEP_Info_isEnabled) {
            CMIndications.CMTrace("cmDeployExportFile", new CMException.Parm("file", filename));
        }
        PrintWriter packOut = this.exportArchive_.openXMLStream(filename, hasData);
        export.writeArchiveHeader(packOut);
        return packOut;
    }

    private void closeArchiveStream(PrintWriter packOut) {
        export.writeArchiveFooter(packOut);
        packOut.close();
    }

    private void createContentFile(ContentFile content) throws CMException {
        if (this.deploymentLogging_) {
            this.log_.logString("$$$Create the Deployment Content file");
        }
        PrintWriter packOut = this.exportArchive_.openXMLStream("content.xml", false);
        CMSOAPWriter wrt = new CMSOAPWriter(packOut);
        wrt.setIndent("\t", 0);
        content.writeTo(wrt);
        wrt.close();
        Exception ex = wrt.getError();
        if (ex != null) {
            throw new CMException(ex, "cmBadOutputFile", new CMException.Parm("Filename", "content.xml"));
        }
    }

    private void createDeploymentRecord() throws CMException {
        String xsdStr = CMPropertyTypes.XML_STRING.getName();
        String xsd = "xsd";
        if (this.deploymentLogging_) {
            this.log_.logString("$$$Create Deployment Record");
        }
        String optionsObjects = this.addBuffer_.toString();
        this.addBuffer_ = new StringBuffer();
        this.emit("<");
        this.emit("deploymentRecord");
        this.emit(" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"");
        this.emit(">\r\n");
        this.emit("\t");
        this.emitElement("cmBuildNumber", "xsd", xsdStr, cmInfo.getVersion());
        this.emit("\t");
        this.emitElement("edition", "xsd", xsdStr, CMServlet.getEdition().getName());
        this.emit("\t");
        this.emitElement("archiveVersion", "xsd", xsdStr, Integer.toString(7));
        this.emit("\t");
        this.emitElement("archive", "xsd", xsdStr, XMLUtils.escape((String)this.archive_, (boolean)false));
        this.emitDeploymentOptions("\t", "bus", false, false);
        this.emit("\t");
        this.emitArrayElement("deploymentObjects", "bus", "deploymentObject", this.objectsReportCount_);
        this.emit(optionsObjects);
        this.emit("\t");
        this.emitEndElement("deploymentObjects");
        this.emitEndElement("deploymentRecord");
        String deploymentRecord = this.addBuffer_.toString();
        this.addBuffer_ = null;
        try {
            PrintWriter packOut = this.exportArchive_.openXMLStream("exportRecord.xml", false);
            packOut.print(deploymentRecord);
            packOut.close();
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmBadOutputFile", new CMException.Parm("Filename", "exportRecord.xml"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportProperty(PrintWriter packOut, CMProperty prop, Object value, DataSetInfo dataSetInfo) throws CMException {
        block84: {
            String tabs3 = "\t\t\t";
            String tabs4 = "\t\t\t\t";
            String propName = prop.getName();
            boolean propNameTag = false;
            boolean attrValueTag = false;
            try {
                InputStream is;
                String propValueConverted = null;
                if (prop == CMProperty.POLICIES || prop == CMProperty.USERCAPABILITYPOLICIES) {
                    byte[] arrPolicy = (byte[])value;
                    if (arrPolicy.length > 0) {
                        try {
                            CMExecutionContext context = CMExecutionContext.get();
                            AznUtil azn = new AznUtil(CMServlet.AAA, context.getAccManPassportID(), context.getCAMAdditionalInfo());
                            propValueConverted = azn.describePolicy(prop.getName(), arrPolicy);
                            XMLPolicyTransformer trns = new XMLPolicyTransformer();
                            propValueConverted = trns.transformXML(propValueConverted);
                            propValueConverted = CMXMLUtils.removeContainerElements(propValueConverted, 2);
                        }
                        catch (AAAException ex) {
                            throw new CMException((Exception)((Object)ex), "cmNoReadPolicy");
                        }
                        catch (Exception ex) {
                            throw new CMException(ex, "cmNoReadPolicy");
                        }
                    }
                } else if (prop.getMeaning() == CMPropertyMeaning.CREDENTIALS) {
                    try {
                        EncryptingSession es = CMServlet.CAMFactory_.createEncryptingSession();
                        DataEncryptionHelper encryptionHelper = new DataEncryptionHelper(es);
                        String sEncodedEncryptedCredentials = RequestHandler.readAnyTypePropertyValueIntoString(value);
                        byte[] decryptedData = new Credentials((IDataEncryptionHelper)encryptionHelper).decryptCredentialsFromPropertyValue(sEncodedEncryptedCredentials);
                        propValueConverted = Base64.encode(decryptedData);
                    }
                    catch (Exception ex) {
                        throw new CMException(ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                    }
                } else if (prop.getType() == CMPropertyTypes.BIBUS_OPTIONARRAY) {
                    this.warnAboutSensitiveData(OptionsEncoder.encode(value));
                } else if (prop.getType() == CMPropertyTypes.BIBUS_PARAMETERVALUEARRAY) {
                    this.warnAboutSensitiveData(ParametersEncoder.encode(value));
                }
                boolean storeDataAsAttachment = prop.canBeAttachment() && value instanceof InputStream;
                export.putElement(packOut, tabs3, propName, false, true);
                propNameTag = true;
                if (prop == CMProperty.POLICIES || prop == CMProperty.USERCAPABILITYPOLICIES) {
                    if (propValueConverted != null) {
                        export.putArrayElement(packOut, tabs4, "value", "cm", "policy");
                        packOut.print("]\">");
                        packOut.print(propValueConverted);
                        attrValueTag = true;
                    }
                    return;
                }
                if (storeDataAsAttachment) {
                    is = (InputStream)value;
                    try {
                        this.exportValueAsAttachment(packOut, is, false, dataSetInfo);
                    }
                    catch (IOException ioe) {
                        throw new CMException((Exception)ioe, "cmPropReadFail", new CMException.Parm("Prop", propName));
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
                export.putElement(packOut, tabs4, "value", false, false);
                attrValueTag = true;
                if (prop.getMeaning() == CMPropertyMeaning.CREDENTIALS) {
                    if (propValueConverted != null) {
                        packOut.print(propValueConverted);
                    }
                    break block84;
                }
                if (prop.getType() == CMPropertyTypes.BIBUS_FAULTDETAILARRAY || prop.getType() == CMPropertyTypes.BIBUS_STRINGMAPENTRYARRAY) {
                    CMFaultDetailArray arrayValue = (CMFaultDetailArray)value;
                    packOut.print(arrayValue.getXMLContent(prop));
                    packOut.print("\r\n");
                    break block84;
                }
                if (value instanceof CMBasePropertyValue) {
                    CMBasePropertyValue aValue = (CMBasePropertyValue)value;
                    if (prop.getType().isArray()) {
                        CMArrayPropertyValue arrayValue = (CMArrayPropertyValue)aValue;
                        boolean hasDerivedTypes = arrayValue instanceof CMTypedNameValuePairArray;
                        for (int j = 0; j < arrayValue.getSize(); ++j) {
                            if (arrayValue.getItem(j) == null) continue;
                            packOut.print("<");
                            packOut.print("item");
                            if (hasDerivedTypes) {
                                CMTypedNameValuePair nvPair = (CMTypedNameValuePair)arrayValue.getItem(j);
                                packOut.print(" xsi:type=\"cm:");
                                packOut.print(nvPair.getTypeName());
                                packOut.print("\"");
                            }
                            packOut.print(">");
                            packOut.print(arrayValue.getXMLItemContent(j, prop, 0));
                            packOut.print("</");
                            packOut.print("item");
                            packOut.print(">\r\n");
                        }
                    } else {
                        CMPropertyValue propValue = (CMPropertyValue)aValue;
                        packOut.print(propValue.getXMLContent(prop));
                    }
                    break block84;
                }
                if (prop.getType() == CMPropertyTypes.XML_BASE64BINARY || prop.getType() == CMPropertyTypes.BIBUS_BASE64BINARYMIME) {
                    if (value instanceof InputStream) {
                        is = (InputStream)value;
                        try {
                            int numBytesRead;
                            byte[] inputData = new byte[16383];
                            while ((numBytesRead = is.read(inputData)) >= 0) {
                                if (numBytesRead == 0) continue;
                                Base64.encode(inputData, 0, numBytesRead, packOut);
                            }
                            break block84;
                        }
                        catch (IOException ex) {
                            throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    try {
                        byte[] bytes = (byte[])value;
                        Base64.encode(bytes, 0, bytes.length, packOut);
                        break block84;
                    }
                    catch (IOException ex) {
                        throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                    }
                }
                if (prop.getType() == CMPropertyTypes.XML_ANYTYPE || prop.getType() == CMPropertyTypes.BIBUS_ANYTYPEMIME || prop.getType() == CMPropertyTypes.BIBUS_DATASOURCECOMMANDBLOCK || prop.getType() == CMPropertyTypes.BIBUS_POWERPLAYDATABLOCKARRAY || prop.getType() == CMPropertyTypes.BIBUS_QUERYSPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_XMLENCODEDXML || prop.getType() == CMPropertyTypes.BIBUS_DATAINTEGRATIONSERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_PLANNINGTASKSERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_INDEXUPDATESERVICESERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_DATAMOVEMENTSERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_MIGRATIONSERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_REPORTDATASERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_XMLENCODEDXMLMIME || prop.getType() == CMPropertyTypes.BIBUS_PLANNINGADMINISTRATIONCONSOLESERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_POWERPLAYSERVICESPECIFICATION || prop.getType() == CMPropertyTypes.BIBUS_REPORTSERVICEDRILLTHROUGHSPECIFICATION) {
                    if (value instanceof String) {
                        packOut.print((String)value);
                        break block84;
                    }
                    Reader stream = null;
                    char[] buffer = new char[32768];
                    int numRead = 0;
                    CMTempOutputStream tempFileOutputStream = null;
                    if (value instanceof InputStream) {
                        if (prop == CMProperty.MODEL) {
                            tempFileOutputStream = new CMTempOutputStream();
                            try {
                                CMStreamUtils.copyStream((InputStream)((InputStream)value), (OutputStream)tempFileOutputStream);
                                tempFileOutputStream.close();
                                stream = new InputStreamReader((InputStream)new GZIPInputStream(tempFileOutputStream.getInputStream()), "UTF-8");
                            }
                            catch (IOException exTemp) {
                                try {
                                    tempFileOutputStream.delete();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                if (exTemp instanceof MalformedInputException) {
                                    throw new CMException((Exception)exTemp, "cmBadDataEncoding", new CMException.Parm("Prop", propName));
                                }
                                throw new CMException((Exception)exTemp, "cmPropReadFail", new CMException.Parm("Prop", propName));
                            }
                        }
                        try {
                            stream = new InputStreamReader((InputStream)new GZIPInputStream(new BufferedInputStream((InputStream)value, 32768)), "UTF-8");
                        }
                        catch (UnsupportedEncodingException ex) {
                            throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                        }
                        catch (IOException ex) {
                            throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                        }
                    }
                    stream = (Reader)value;
                    try {
                        while ((numRead = stream.read(buffer)) >= 0) {
                            if (numRead == 0) continue;
                            String outBuf = new String(buffer, 0, numRead);
                            if (prop.getType() == CMPropertyTypes.BIBUS_POWERPLAYDATABLOCKARRAY) {
                                packOut.print(CMXMLUtils.wrapInCDATASection(outBuf));
                                continue;
                            }
                            packOut.print(XMLUtils.escape((String)outBuf, (boolean)false));
                        }
                        break block84;
                    }
                    catch (IOException ex) {
                        throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                                stream = null;
                            }
                            catch (IOException iOException) {}
                        }
                        if (tempFileOutputStream != null) {
                            try {
                                tempFileOutputStream.delete();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                packOut.print(XMLUtils.escape((String)value.toString(), (boolean)false));
            }
            finally {
                if (attrValueTag) {
                    export.putElement(packOut, null, "value", true, true);
                }
                if (propNameTag) {
                    export.putElement(packOut, tabs3, propName, true, true);
                }
            }
        }
    }

    private void warnAboutSensitiveData(boolean hasSensitiveData) {
        if (!this.bOptionsPasswordInUnencryptedArchive_ && hasSensitiveData && this.archiveEncryptPassword_ == null) {
            CMException cmex = new CMException("cmOptionsPasswordsInUnencryptedArchive");
            cmex.ErrorLevel = 30000;
            this.deploymentHistory.saveDetail(CMObjectClass.ROOT.getID(), 6, cmex);
            this.bOptionsPasswordInUnencryptedArchive_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportValueAsAttachment(PrintWriter packOut, InputStream value, boolean compress, DataSetInfo dataSetInfo) throws IOException, CMException {
        String filename = this.dataFileCount_ + ".dat";
        ++this.dataFileCount_;
        OutputStream dataStream = this.exportArchive_.openDataStream(filename, compress);
        long dataSize = 0L;
        if (dataSetInfo != null && dataSetInfo.isDataSetOutput() && this.dataSetPlugin_ != null) {
            InputStream in = value;
            if (dataSetInfo.isDataCompressed) {
                in = new GZIPInputStream(value);
            }
            try (CountingOutputStream cout = new CountingOutputStream(dataStream);){
                this.dataSetPlugin_.decrypt(in, (OutputStream)cout);
                dataSize = cout.getBytesWritten();
            }
        }
        try {
            dataSize = CMStreamUtils.copyStream((InputStream)value, (OutputStream)dataStream);
        }
        finally {
            dataStream.close();
        }
        String tabs4 = "\t\t\t\t";
        packOut.write(tabs4);
        packOut.write("<value");
        packOut.write(" href=\"" + filename + "\" ");
        packOut.write("size=\"" + dataSize + "\"/>\r\n");
    }

    private static void writeArchiveHeader(PrintWriter writer) {
        writer.write("<");
        writer.write("archive");
        writer.write(" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"");
        writer.write(">\r\n<!-- CM Build=");
        writer.write(cmInfo.getVersion());
        writer.write(" -->\r\n  <");
        writer.write("objects");
        writer.write(">\r\n");
    }

    private static void writeArchiveFooter(PrintWriter writer) {
        writer.write("  </");
        writer.write("objects");
        writer.write(">\r\n</");
        writer.write("archive");
        writer.write(">\r\n");
    }

    public static void putElement(PrintWriter out, String tabs, String name, boolean isEnd, boolean doReturn) {
        if (tabs != null) {
            out.write(tabs);
        }
        out.write("<");
        if (isEnd) {
            out.write("/");
        }
        out.write(name);
        out.write(">");
        if (doReturn) {
            out.write("\r\n");
        }
    }

    public static void putElement(PrintWriter out, String tabs, String name, String value) {
        if (tabs != null) {
            out.write(tabs);
        }
        out.write("<");
        out.write(name);
        if (value == null || value.length() < 1) {
            out.write(" ");
            out.write("xsi");
            out.write(":");
            out.write("nil");
            out.write("=\"");
            out.write("true");
            out.write("\"/>");
        } else {
            out.write(">");
            out.write(value);
            out.write("</");
            out.write(name);
            out.write(">");
        }
        out.write("\r\n");
    }

    private static void putArrayElement(PrintWriter out, String tabs, String elementName, String arrayTypePrefix, String arrayType) {
        if (tabs != null) {
            out.write(tabs);
        }
        out.write("<");
        out.write(elementName);
        out.write(" ");
        out.write("xsi");
        out.write(":");
        out.write("type");
        out.write("=\"");
        out.write("SOAP-ENC");
        out.write(":");
        out.write("Array");
        out.write("\" ");
        out.write("SOAP-ENC");
        out.write(":");
        out.write("arrayType");
        out.write("=\"");
        out.write(arrayTypePrefix);
        out.write(":");
        out.write(arrayType);
        out.write("[");
    }

    @Override
    protected void setNamespace() {
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\">\r\n");
    }

    @Override
    protected void setResponseHeader() {
        this.out.write("\t<");
        this.out.write(this.getCMPrefixString());
        this.out.write(":");
        this.out.write("exportResponse");
    }

    @Override
    protected void setResponseTrailer() {
        this.out.write("\t</");
        this.out.write(this.getCMPrefixString());
        this.out.write(":");
        this.out.write("exportResponse");
        this.out.write(">");
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    public class DataSetInfo {
        private boolean isDataSetOutput = false;
        private boolean isDataCompressed = false;

        public DataSetInfo(boolean isDataSetOutput, boolean isDataCompressed) {
            this.isDataSetOutput = isDataSetOutput;
            this.isDataCompressed = isDataCompressed;
        }

        boolean isDataSetOutput() {
            return this.isDataSetOutput;
        }

        boolean isDataCompressed() {
            return this.isDataCompressed;
        }
    }

    private static final class DeployObject {
        int parentId_;
        CMStorePath objectContextPackage_;

        public DeployObject(int parentId, CMStorePath objectContextPackage) {
            this.parentId_ = parentId;
            this.objectContextPackage_ = objectContextPackage;
        }
    }

    private static final class ExportObject {
        int id;
        int parentId;
        CMObjectClass objectClass;
        String name;
        String path;
        String parentPath;
        String storeID;

        private ExportObject() {
        }
    }
}

