/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMBuildVersion;
import com.cognos.cm.util.CMDeploymentArchive;
import java.io.InputStream;

public class getDeploymentOptions
extends Deployment {
    String archive_;

    public getDeploymentOptions(CMStore store) {
        super(store);
        this.isGetDeploymentOptions_ = true;
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        this.setDeploymentIPF(false);
        CMExecutionContext.get().addLevel3Parm(new CMException.Parm("Options", this.archive_));
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.archive_ != null) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        this.archive_ = requestElement.getChildValueWithName("archive");
        XMLElement xmlElm = requestElement.getOptionalChildWithName("options");
        if (xmlElm != null) {
            this.getDeploymentOptions(xmlElm, false);
        } else {
            this.getDeploymentOptions(requestElement, false);
        }
    }

    @Override
    public boolean doAction(XMLElement requestElement, String tabPrefix) throws CMException {
        CMExecutionContext currContext = CMExecutionContext.get();
        if (!currContext.hasCapability("canUseContentStoreTool")) {
            throw new CMException("cmInsufficientPermissionsForRequest");
        }
        this.getParams(requestElement);
        try {
            CMDeploymentArchive deploymentArchive = new CMDeploymentArchive(this.archive_, this.archiveEncryptPassword_);
            String nameContent = "exportRecord.xml";
            InputStream inReader = deploymentArchive.getInputStream(nameContent);
            XMLDocParser parser = new XMLDocParser(true);
            XMLDoc xmlDoc = null;
            xmlDoc = parser.readXML(inReader);
            XMLElement rootEl = null;
            if (xmlDoc != null) {
                rootEl = xmlDoc.getRootXMLElement();
            }
            XMLElement optionsEL = null;
            if (rootEl != null) {
                optionsEL = rootEl.getOptionalChildWithName("options");
            }
            if (optionsEL == null) {
                throw new CMException("cmArchiveBad", new CMException.Parm("Archive", this.archive_));
            }
            inReader = deploymentArchive.getInputStream("content.xml");
            parser = new XMLDocParser(true);
            xmlDoc = parser.readXML(inReader);
            this.getDeploymentOptions(optionsEL, xmlDoc, false, this.archive_);
            CMBuildVersion archiveBuildVersion = new CMBuildVersion(0, 0, 0, 0);
            String cmBuildVersionStr = rootEl.getChildValueWithName("cmBuildNumber");
            try {
                archiveBuildVersion.setTo(cmBuildVersionStr);
            }
            catch (Exception e) {
                archiveBuildVersion.setTo(999999, 0, 0, 0);
            }
            boolean includeUpgradeClasses = false;
            if (archiveBuildVersion.compareTo("8.2.0.0") < 0) {
                includeUpgradeClasses = true;
            }
            boolean includePublicTenant = false;
            if (DeploymentExecutionContext.get().isMultiTenantDeployment() && archiveBuildVersion.getReleaseVersion().compareTo("10.2") == 0 && archiveBuildVersion.compareTo("10.2.5000.0") < 0) {
                includePublicTenant = true;
            }
            if (DeploymentExecutionContext.get().isIncludeReportOutputVersions() && archiveBuildVersion.compareTo("11.0.3.0") >= 0 && archiveBuildVersion.compareTo("11.0.4.0") < 0) {
                this.packageDatasetOutputs_ = true;
            }
            this.emitDeploymentOptions(tabPrefix, "cm", includeUpgradeClasses, includePublicTenant);
            deploymentArchive.close();
        }
        catch (CMException cmex) {
            throw cmex;
        }
        catch (Exception e) {
            throw new CMException("cmArchiveBad", new CMException.Parm("Archive", this.archive_));
        }
        return true;
    }

    @Override
    protected void setNamespace() {
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\">\r\n");
    }

    @Override
    protected void setResponseHeader() {
        this.out.print("\t<");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("getDeploymentOptionsResponse");
    }

    @Override
    protected void setResponseTrailer() {
        this.out.print("\t</");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("getDeploymentOptionsResponse");
        this.out.print(">");
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

