/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMIndentedPrintStream;

public class getTenancy
extends RequestHandler {
    public getTenancy(CMStore store) {
        super(store);
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
    }

    @Override
    public boolean handle(IConfiguration c, Request r) throws CMException {
        boolean rc = true;
        CMExecutionContext context = CMExecutionContext.get();
        boolean isAdmin = context.getCurrentUserIsAdministrator();
        if (!isAdmin) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "getTenancy"));
        }
        this.printResponse();
        return rc;
    }

    private void printResponse() {
        UserSessionCacheEntry user = CMExecutionContext.get().getContext().getCurrentUserSession();
        if (user == null) {
            throw new IllegalStateException("getTenancy request must be run as a user.");
        }
        CMIndentedPrintStream out = new CMIndentedPrintStream(this.oStream);
        out.indent();
        out.print("<");
        out.print(this.getCMPrefixString());
        out.print(":getTenantsResponse");
        out.print(" xmlns:cm=\"" + this.getBiBusNamespace() + "\"");
        out.print(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        out.print(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        out.println(" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        out.indent();
        out.println("<writeTenantID xsi:type=\"bus:stringProp\">");
        out.indent();
        out.print("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">");
        out.print(this.tenantRegistry.getTenantIdStringFromInt(user.getTenantId()));
        out.println("</value>");
        out.unindent();
        out.println("</writeTenantID>");
        int[] readTenantId = user.getReadTenantIds();
        out.print("<readTenantIDs xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"xsd:string[");
        if (readTenantId == null) {
            out.println("0]\" xsi:isNil=\"true\" />");
        } else {
            out.print(readTenantId.length);
            out.println("]\" >");
            out.indent();
            for (int tenantId : readTenantId) {
                out.print("<item xsi:type=\"xsd:string\" xml:space=\"preserve\">");
                out.print(this.tenantRegistry.getTenantIdStringFromInt(tenantId));
                out.println("</item>");
            }
            out.unindent();
            out.println("</readTenantIDs>");
        }
        out.unindent();
        out.print("</");
        out.print(this.getCMPrefixString());
        out.println(":getTenantsResponse>");
        out.unindent();
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

