/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.helper;

import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.helper.CMQueryResultFunction;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;

public class CMQueryResultUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProps(CMStorePath path, CMProperty[] props, CMQueryResultFunction funcs) throws IllegalArgumentException, CMException {
        CMStoreQueryResults results = null;
        CMStore store = CMExecutionContext.get().getStore();
        boolean bLockAcquiredHere = false;
        if (store == null) {
            throw new IllegalArgumentException("Function CMQueryResultUtils.getProps() can only be called after CMExecutionContext is initialized.");
        }
        if (!path.getLocksHaveBeenObtained()) {
            store.getLockManager().requestLocks(path);
            bLockAcquiredHere = true;
        }
        try {
            results = store.executeQuery(path, props, null, 0, 512, null);
            if (results != null && results.next()) {
                funcs.setHasResults(true);
                funcs.setResultObjClass(results.getObjectClass());
                if (props != null) {
                    for (int i = 0; i < props.length; ++i) {
                        funcs.addProperty(props[i], results.getValue(i));
                    }
                }
            }
            if (results.next()) {
                throw new CMException("cmMultipleParents");
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (bLockAcquiredHere) {
                store.getLockManager().releaseLocks();
                path.clearLocksHaveBeenObtained();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectIDWithPermissionRequired(CMStorePath path, int addPermissionRequired) throws IllegalArgumentException, CMException {
        CMStoreQueryResults results = null;
        CMStore store = CMExecutionContext.get().getStore();
        int objID = -1;
        boolean bLockAcquiredHere = false;
        if (store == null) {
            throw new IllegalArgumentException("Function CMQueryResultUtils.currentUserHasPermission() can only be called after CMExecutionContext is initialized.");
        }
        if (!path.getLocksHaveBeenObtained()) {
            store.getLockManager().requestLocks(path);
            bLockAcquiredHere = true;
        }
        try {
            results = store.executeQuery(path, null, null, 0, addPermissionRequired, null);
            if (results != null && results.next()) {
                objID = results.getObjectID();
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (bLockAcquiredHere) {
                store.getLockManager().releaseLocks();
                path.clearLocksHaveBeenObtained();
            }
        }
        return objID;
    }
}

