/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.accman.CMCAMNamespace;
import com.cognos.cm.cam.admin.AAANamespaceFormatURI;
import com.cognos.cm.cmInfo;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreAncestors;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.deployment.AuthenticatedNamespaces;
import com.cognos.cm.deployment.DeploymentAccount;
import com.cognos.cm.deployment.DeploymentContext;
import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.deployment.DeploymentImportRule;
import com.cognos.cm.deployment.HomeFolderIndex;
import com.cognos.cm.deployment.IncludeAllHomeFolderIndex;
import com.cognos.cm.deployment.OptionsDecoder;
import com.cognos.cm.deployment.PackageDeploymentInfo;
import com.cognos.cm.deployment.ParametersEncoder;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.AllInOneCounter;
import com.cognos.cm.diagnostics.BroadcastCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.RequestAttachment;
import com.cognos.cm.multipart.RequestImportAttachment;
import com.cognos.cm.multipart.RequestImportDataAttachment;
import com.cognos.cm.multipart.RequestImportDataSetAttachment;
import com.cognos.cm.notification.ArchivalNotificationParameters;
import com.cognos.cm.plugin.Interface.CMPlugin;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMPluginInfo;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.caspian.AddMissingTenantObjects;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMDescendantModifiedProperty;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.properties.MultilingualProperty;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.request.ImportParser;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.C8Edition;
import com.cognos.cm.server.CMDataUpgradeException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPluginManager;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.UpdateInitialContentNames;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.profileSettings.ProfilesManager;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.store.path.Lexer;
import com.cognos.cm.util.ArchivingUtil;
import com.cognos.cm.util.CMBuildVersion;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMDeploymentArchive;
import com.cognos.cm.util.CMInputStreamWithSize;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cm.util.io.CountingOutputStream;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xml.sax.InputSource;

public class importRequest
extends Deployment {
    private static final String PARENT_PATH = "parentPath";
    public static final Counter inUpgradePlugins = new AccumulatingCounter().makeThreadLocal();
    public static final Counter inUpgradePluginsTrace = new AllInOneCounter().makeThreadLocal();
    public static final Timer upgradeTimer = new Timer(new BroadcastCounter(inUpgradePlugins, inUpgradePluginsTrace));
    private static final String cmArchiveEntryNotFound = "cmArchiveEntryNotFound";
    private static final CMBuildVersion ARCHIVE_CUTOFF_VERSION = new CMBuildVersion(1, 1, 400, 0);
    private CMDeploymentArchive deploymentArchive_ = null;
    protected int archiveVersion;
    protected C8Edition archiveEdition;
    private XMLDoc xmlDocContent_ = null;
    private HashMap<Long, ParentInfo> parentMap_;
    private HashMap<Long, String> parentMapIgnored_;
    private HashMap<String, ParentInfo> missingParentObjs_;
    private CMTempOutputStream orphanObjStream_;
    private int orphanCount_;
    private ArrayList<AddDef> importUpdateList_ = null;
    private CMBaseClassArray bcaCurrentUser_ = null;
    private RequestHandler.ValidateOptions validateOpts_ = null;
    private CMTempOutputStream updateAddDefStream_ = null;
    private ArrayList<ValidateAfterObject> validateAfterList_ = null;
    private ImportParser importer_;
    private CMBuildVersion archiveBuildVersion_ = new CMBuildVersion(0, 0, 0, 0);
    private CMBuildVersion currCMBuildVersion = new CMBuildVersion(0, 0, 0, 0);
    private boolean doUpgrades_;
    private boolean upgradeInProgress_ = false;
    protected Map<String, List<CMPluginInfo>> upgradeClassMap_ = null;
    private List<UpgradeAfterObject> upgradeAfterList_ = null;
    private ArrayList<String> attachments_ = new ArrayList();
    private boolean replaceScheduleCredentials_ = false;
    private CMDbStoreBaseClassArray importUserCredentials_ = null;
    private boolean namespaceFormatsValidated = false;
    protected PackageDeploymentInfo currentPackageDeploymentInfo_;
    private Map<String, String> pluginsInArchive_ = null;
    private boolean isBalticArchive_ = false;
    private Set<String> tenantIdsPriorToImport;
    private HomeFolderIndex homeFolderIndex;
    private static final HashSet<String> licenseProps = new HashSet<String>(Arrays.asList("lastLogin", "_capabilities", "_license", "_userid"));
    private static final String reportVersionSearchPathSuffix_ = "@objectClass='" + CMObjectClass.REPORTVERSION.getName() + "'";
    private static final String reportRunHistorySearchPathSuffix_ = "@objectClass='" + CMObjectClass.HISTORY.getName() + "'";
    private static final String reportCacheSearchPathSuffix_ = "@objectClass='" + CMObjectClass.REPORTCACHE.getName() + "'";
    private static final String reportMetadataSearchPathSuffix_ = "@objectClass='" + CMObjectClass.REPORTMETADATA.getName() + "'";
    private static final String reportMetadataCacheSearchPathSuffix_ = "@objectClass='" + CMObjectClass.REPORTMETADATACACHE.getName() + "'";
    private static final String archiveHead_ = "<?xml version='1.0' encoding='UTF-8'?>\r\n<archive xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n<objects>\r\n";
    private static final String archiveFoot_ = "</objects>\r\n</archive>";
    private HashMap<String, ArrayList<ImportUpgrade>> perClassUpgrade_;

    public importRequest(CMStore store) {
        super(store);
        this.isImport_ = true;
        this.initRenamedRoles();
        this.tenantIdsPriorToImport = store.getTenantRegistry().getTenantIdStrings();
    }

    protected void initRenamedRoles() {
        CMDataUpgradeUtils.initRenamedRoles();
    }

    protected String getNamespace() {
        return "http://developer.cognos.com/schemas/bibus/3/";
    }

    @Override
    public void addRequestAttachment(String name, RequestAttachment attach) {
        this.attachments_.add(name);
        super.addRequestAttachment(name, attach);
    }

    public void addRequestAttachment(String name) {
        this.attachments_.add(name);
    }

    public void cleanupAttachments() {
        for (String attachment : this.attachments_) {
            this.deleteRequestAttachment(attachment);
        }
        this.attachments_.clear();
    }

    public void resetAttachments() {
        this.attachments_.clear();
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        try {
            if (!this.parseForFirstDataElement()) {
                return;
            }
            this.getParams(this.didGetParmUsingXMLEl_);
            this.setDeploymentIPF(true);
        }
        catch (CMException ex) {
            DeploymentExecutionContext.clear();
            throw ex;
        }
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.runnableObjStorePath_ != null) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        XMLElement xmlElm = requestElement.getChildWithName("obj");
        this.runnableObjStorePath_ = this.getClassObjSearchPath(xmlElm);
        xmlElm = requestElement.getOptionalChildWithName("options");
        if (xmlElm != null) {
            this.getDeploymentOptions(xmlElm, true);
        } else {
            this.getDeploymentOptions(requestElement, true);
        }
    }

    private void closeStreamQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private CMException badArchiveException(Throwable cause) {
        CMIndications.logException(cause);
        return new CMException(cause, "cmArchiveBad", new CMException.Parm("Archive", this.archive_));
    }

    private void importPackages() throws CMException {
        this.assertRunning();
        if (this.packages_ == null) {
            return;
        }
        ListIterator iter = this.packages_.listIterator();
        while (iter.hasNext()) {
            PackageDeploymentInfo packageInfo;
            this.currentPackageDeploymentInfo_ = packageInfo = (PackageDeploymentInfo)iter.next();
            if (packageInfo.sourceName_ == null) {
                throw new CMException("cmArchiveNoSource");
            }
            CMDbStoreLocalizedStringArray targetNames = packageInfo.targetNames_;
            if (targetNames == null) {
                targetNames = packageInfo.sourceNames_;
            }
            if (this.deploymentOptionEnumImport_) {
                this.doImport(DeploymentContext.Package, packageInfo.filename_, packageInfo.sourceName_, targetNames);
                continue;
            }
            String filename = this.lookupPackageByName(packageInfo.sourceName_);
            this.doImport(DeploymentContext.Package, filename, packageInfo.sourceName_, targetNames);
        }
        this.currentPackageDeploymentInfo_ = null;
    }

    private void importTopLevelPackagesFolders() throws CMException {
        this.assertRunning();
        if (this.xmlDocContent_ == null) {
            throw this.badArchiveException(null);
        }
        XMLElement contentRootEL = this.xmlDocContent_.getRootXMLElement();
        if (contentRootEL != null) {
            XMLElement foldersEL;
            XMLElement packagesEL = contentRootEL.getOptionalChildWithName("exportedPackages");
            if (packagesEL != null) {
                this.importPackagesOrFolders(packagesEL);
            }
            if ((foldersEL = contentRootEL.getOptionalChildWithName("exportedFolders")) != null) {
                this.importPackagesOrFolders(foldersEL);
            }
        }
    }

    private void importPackagesOrFolders(XMLElement contentEL) throws CMException {
        ArrayList<XMLElement> filesList = contentEL.getChildren();
        if (filesList != null) {
            for (XMLElement xmlElFile : filesList) {
                String fileName;
                PackageDeploymentInfo packageInfo = new PackageDeploymentInfo();
                XMLElement xmlElName = xmlElFile.getOptionalChildWithName("name");
                if (xmlElName != null) {
                    packageInfo.targetNames_ = packageInfo.sourceNames_ = MultilingualProperty.readTokenWithLocaleMapping(xmlElName);
                    packageInfo.fixNames();
                }
                if ((fileName = xmlElFile.getOptionalChildValueWithName("filename")) == null || packageInfo.sourceName_ == null) continue;
                this.doImport(DeploymentContext.Package, fileName, packageInfo.sourceName_, packageInfo.targetNames_);
            }
        }
    }

    private void importPersonalData(XMLElement xmlElContentRoot, boolean entireContentStore) throws CMException {
        AuthenticatedNamespaces authenticatedNSs = new AuthenticatedNamespaces();
        boolean skipUnauthenticatedNamespaces = AdvancedSettings.DEPLOYMENTSKIPUNAUTHENTICATEDNAMESPACES;
        if (entireContentStore) {
            this.importAllUserAccounts(xmlElContentRoot, skipUnauthenticatedNamespaces, authenticatedNSs);
        } else {
            this.importIndividualUserAccounts(skipUnauthenticatedNamespaces, authenticatedNSs);
        }
        authenticatedNSs.writeMessages(this.deploymentHistory, false);
    }

    private void importAllUserAccounts(XMLElement xmlElContentRoot, boolean skipUnauthenticatedNamespaces, AuthenticatedNamespaces authenticatedNSs) throws CMException {
        XMLElement xmlElExportedAccounts = xmlElContentRoot.getOptionalChildWithName("exportedAccounts");
        if (xmlElExportedAccounts == null || !xmlElExportedAccounts.hasChildren()) {
            return;
        }
        for (XMLElement xmlElAcc : xmlElExportedAccounts.getChildren()) {
            String namespace = xmlElAcc.getChildValueWithName("namespace");
            if (skipUnauthenticatedNamespaces && !authenticatedNSs.containsSearchPath(namespace)) continue;
            String fileName = xmlElAcc.getChildValueWithName("filename");
            this.importUserAccounts(fileName, namespace);
        }
    }

    private void importIndividualUserAccounts(boolean skipUnauthenticatedNamespaces, AuthenticatedNamespaces authenticatedNSs) throws CMException {
        if (this.accounts_ == null) {
            return;
        }
        for (DeploymentAccount account : this.accounts_) {
            String namespace = account.getNamespace();
            if (skipUnauthenticatedNamespaces && !authenticatedNSs.containsSearchPath(namespace)) continue;
            String fileName = account.getFileName();
            this.importUserAccounts(fileName, namespace);
        }
    }

    private void importUserAccounts(String fileName, String namespace) throws CMException {
        this.resetForNewImport();
        if (this.deploymentLogging_) {
            this.log_.logString("###Importing user accounts for " + namespace + " from " + fileName);
        }
        if (CMIndicationGlobals.bDEP_Info_isEnabled) {
            CMIndications.CMTrace("cmDeployImportFile", new CMException.Parm("file", fileName));
        }
        int iteration = 1;
        CMTempOutputStream tempStream = null;
        this.orphanCount_ = 0;
        try {
            int oldOrphanCount;
            do {
                InputStream pkgStream;
                oldOrphanCount = this.orphanCount_;
                this.orphanCount_ = 0;
                if (iteration == 1) {
                    pkgStream = this.deploymentArchive_.getInputStream(fileName);
                } else {
                    if (tempStream != null) {
                        tempStream.delete();
                    }
                    tempStream = this.orphanObjStream_;
                    this.closeTempObjectStream(tempStream);
                    pkgStream = tempStream.getInputStream();
                }
                this.orphanObjStream_ = this.createTempObjectStream();
                this.importer_.importPackage(pkgStream, null, DeploymentContext.ExternalNamespace);
                if (this.deploymentLogging_ && this.orphanCount_ != 0 && oldOrphanCount != this.orphanCount_) {
                    this.log_.logString("###Iteration: " + iteration + "  Objects left: " + this.orphanCount_);
                }
                ++iteration;
            } while (this.orphanCount_ != 0 && oldOrphanCount != this.orphanCount_);
        }
        catch (CMException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw this.badArchiveException(ex);
        }
        finally {
            try {
                if (tempStream != null) {
                    tempStream.delete();
                }
                if (this.orphanObjStream_ != null) {
                    this.orphanObjStream_.delete();
                    this.orphanObjStream_ = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    private void processImportRules() throws CMException {
        if (!this.deploymentOptionEnumImport_) {
            return;
        }
        ArrayList<XMLElement> contentList = this.getTheListOfContentFiles(this.xmlDocContent_);
        block0: for (int i = 0; i < this.importRules_.size(); ++i) {
            DeploymentImportRule importRule = (DeploymentImportRule)this.importRules_.get(i);
            String archiveSearchPath = importRule.getArchiveSearchPath();
            for (XMLElement xmlElContentFile : contentList) {
                String objClassString = null;
                String searchPathInContent = xmlElContentFile.getOptionalChildValueWithName("searchPath");
                if (searchPathInContent == null) {
                    XMLElement xmlElName = xmlElContentFile.getOptionalChildWithName("name");
                    if (xmlElName == null || !xmlElName.hasChildren()) continue;
                    for (XMLElement xmlElLocaleName : xmlElName.getChildren()) {
                        String pkgName = xmlElLocaleName.getOptionalChildValueWithName("value");
                        if (pkgName == null || !pkgName.equals(archiveSearchPath)) continue;
                        this.packages_.add(this.createDeploymentPackage(xmlElContentFile, objClassString, importRule));
                        continue block0;
                    }
                    continue;
                }
                if (!searchPathInContent.equals(archiveSearchPath)) continue;
                objClassString = xmlElContentFile.getOptionalChildValueWithName("objectClass");
                CMObjectClass objectClass = this.store_.getObjectClasses().getClassByName(objClassString);
                if (objectClass == CMObjectClass.NAMESPACE || objectClass == CMObjectClass.NAMESPACEFOLDER || objectClass == CMObjectClass.ACCOUNT) {
                    this.accounts_.add(this.createDeploymentAccount(xmlElContentFile, objectClass, searchPathInContent));
                    continue block0;
                }
                this.packages_.add(this.createDeploymentPackage(xmlElContentFile, objClassString, importRule));
                continue block0;
            }
        }
    }

    private DeploymentAccount createDeploymentAccount(XMLElement xmlElContentFile, CMObjectClass objectClass, String searchPath) throws CMException {
        DeploymentAccount account;
        try {
            CMDbStoreLocalizedStringArray name = this.readMLString(xmlElContentFile, "name", true, false);
            account = new DeploymentAccount(name, searchPath, objectClass);
            account.setNamespace(xmlElContentFile.getChildValueWithName("namespace"));
            account.setFileName(xmlElContentFile.getChildValueWithName("filename"));
        }
        catch (CMException ex) {
            throw this.badArchiveException(ex);
        }
        return account;
    }

    private PackageDeploymentInfo createDeploymentPackage(XMLElement xmlElContentFile, String objClass, DeploymentImportRule importRule) throws CMException {
        PackageDeploymentInfo pkgInfo;
        try {
            String fileName;
            CMDbStoreLocalizedStringArray name = this.readMLString(xmlElContentFile, "name", true, false);
            pkgInfo = new PackageDeploymentInfo();
            pkgInfo.objClass_ = objClass;
            pkgInfo.sourceNames_ = name;
            pkgInfo.targetNames_ = importRule.getTargetNames();
            pkgInfo.enabled_ = !importRule.isDisabled();
            pkgInfo.targetParent_ = importRule.getParent();
            pkgInfo.filename_ = fileName = xmlElContentFile.getChildValueWithName("filename");
            pkgInfo.fixNames();
        }
        catch (CMException ex) {
            throw this.badArchiveException(ex);
        }
        return pkgInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScheduleCredentialHandling() throws CMException {
        block10: {
            CMDbStoreObjectReference ref;
            if (this.packageSchedules_ || this.entireContentStoreSelect_) {
                this.replaceScheduleCredentials_ = AdvancedSettings.DEPLOYMENTUPDATESCHEDULECREDENTIAL;
                if (!this.takeOwnership_) {
                    this.replaceScheduleCredentials_ = false;
                }
            }
            if (!this.replaceScheduleCredentials_) break block10;
            CMStoreXPath credPath = new CMStoreXPath("~/credential");
            CMStoreQueryResults r = null;
            this.importUserCredentials_ = new CMDbStoreBaseClassArray();
            try {
                this.lockMgr_.requestLocks(credPath);
                if (this.store_ == null) {
                    this.store_ = CMExecutionContext.get().getStore();
                }
                r = this.store_.executeQuery(credPath, new CMProperty[]{CMProperty.SEARCHPATH}, null, 9, 0, null);
                while (r.next()) {
                    CMString v = (CMString)r.getValue(0);
                    ref = new CMDbStoreObjectReference(v.getValue());
                    this.importUserCredentials_.add(ref);
                }
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(r);
                this.lockMgr_.releaseLocks();
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(r);
            this.lockMgr_.releaseLocks();
            if (this.importUserCredentials_.getSize() == 0) {
                try {
                    String path = AccMan.generateTC();
                    ref = new CMDbStoreObjectReference(path);
                    this.importUserCredentials_.add(ref);
                }
                finally {
                    this.lockMgr_.releaseLocks();
                }
            }
        }
    }

    private void updateScheduleCredentials(AddDef addDef) {
        if (this.replaceScheduleCredentials_ && addDef.contains(CMProperty.CREDENTIAL)) {
            addDef.put(CMProperty.CREDENTIAL, this.importUserCredentials_);
        }
    }

    private boolean shallImportConfiguration() {
        return this.archiveEdition != C8Edition.MIDMARKET || CMServlet.getEdition() != C8Edition.ENTERPRISE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doAction(XMLElement requestElement, String tabPrefix) throws CMException {
        boolean configCapabModified = false;
        this.assertRunning();
        this.getParams(requestElement);
        this.setScheduleCredentialHandling();
        this.propSets_ = this.store_.getPropertySets();
        this.propSet_ = this.propSets_.getPropertySet();
        this.addRunHistory();
        this.loadPlugin("com.cognos.xqe.util.datasets.DatasetUtil");
        if (!this.isSync_) {
            this.addHistoryDetailReqArgs(this.deploymentOptions_, null);
        }
        this.startDeploymentProgressThread();
        CMExecutionContext.get().setApplyTenantIdVirtualInheritance(false);
        try {
            CMException e;
            this.deploymentArchive_ = new CMDeploymentArchive(this.archive_, this.archiveEncryptPassword_);
            this.deploymentArchive_.dump();
            XMLElement elemContentRoot = this.processArchiveContentFile();
            this.buildUpgradeClassMap();
            this.doUpgrades_ = this.createUpgradeList(this.archiveBuildVersion_);
            this.addBuffer_ = new StringBuffer();
            this.importer_ = new ImportParser(this.deploymentArchive_, this, this.store_);
            this.validateOpts_ = new RequestHandler.ValidateOptions();
            this.validateOpts_.failInvalidReferences = false;
            this.validateOpts_.remove3dPartyReferences = !this.namespaceThirdParty_;
            this.validateOpts_.postponeIdBasedReferences = true;
            this.validateOpts_.postponeSecurityReferences = true;
            this.validateOpts_.fromImport = true;
            this.validateOpts_.storeIDSubstitutes = new HashMap(512);
            this.importUpdateList_ = new ArrayList();
            this.initHomeFolderIndex();
            if (this.entireContentStoreSelect_) {
                if (!this.userAccountsOnly_) {
                    this.doImport(DeploymentContext.Tenants, "allDirectoryTenants.xml");
                    this.doImport(DeploymentContext.CognosNamespace, "allDirectoryCognos.xml");
                    this.updateSecurityReferences();
                    this.doImport(DeploymentContext.Content, "contentObj.xml");
                    this.doImport(DeploymentContext.Folder, "folders.xml");
                    this.importTopLevelPackagesFolders();
                    if (this.shallImportConfiguration()) {
                        if (this.doImport(DeploymentContext.Configuration, "allConfiguration.xml")) {
                            configCapabModified = true;
                        }
                        ProfilesManager.getInstance().updateSystemDefaultSettings(this.store_, false);
                    }
                    this.doImport(DeploymentContext.AdminFolder, "allAdminFolder.xml");
                    if (this.archiveBuildVersion_.compareTo("2.0.413.0") < 0) {
                        this.doImport(DeploymentContext.AdminFolder, "allImportDeploymentFolder.xml");
                        this.doImport(DeploymentContext.AdminFolder, "allExportDeploymentFolder.xml");
                    }
                    if (this.doImport(DeploymentContext.Capability, "allCapability.xml")) {
                        configCapabModified = true;
                    }
                    this.doImport(DeploymentContext.Portal, "allPortal.xml");
                    this.doImport(DeploymentContext.Transient, "allTransientStateFolder.xml");
                    this.doImport(DeploymentContext.Catalog, "allCatalog.xml");
                    this.doImport(DeploymentContext.Resources, "allResources.xml");
                }
                if (this.personalDataSelect_ && elemContentRoot != null) {
                    this.importPersonalData(elemContentRoot, true);
                }
            } else {
                this.processImportRules();
                if (this.namespaceSelect_) {
                    this.doImport(DeploymentContext.CognosNamespace, "namespace.xml");
                }
                if (this.recipientsSelect_) {
                    this.doImport(DeploymentContext.CognosNamespace, "recipients.xml");
                }
                if (this.dataSourceSelect_) {
                    this.doImport(DeploymentContext.CognosNamespace, "dataSource.xml");
                }
                this.updateSecurityReferences();
                if (this.personalDataSelect_ && elemContentRoot != null) {
                    this.importPersonalData(elemContentRoot, false);
                }
                if (this.packageSelect_) {
                    this.importPackages();
                }
            }
            if (this.archiveVersion >= 7) {
                this.doImport(DeploymentContext.HomeFolders, "homeFolders.xml");
            }
            if (this.updateAddDefStream_ != null) {
                try {
                    this.closeTempObjectStream(this.updateAddDefStream_);
                    this.validateOpts_.postponeIdBasedReferences = false;
                    CMInputStreamWithSize is = this.updateAddDefStream_.getInputStream();
                    this.importer_.updatePackage(is);
                }
                catch (Exception ex) {
                    throw new CMException(ex, "cmFailedToUpdateImportedObjects");
                }
                finally {
                    try {
                        this.updateAddDefStream_.delete();
                    }
                    catch (IOException iOException) {}
                    this.updateAddDefStream_ = null;
                }
            }
            this.ValidateAfter();
            this.upgradeAfter();
            this.handleMissingTenants();
            if (AdvancedSettings.UPDATEINITIALCONTENTNAMESAFTERIMPORT != null && (e = UpdateInitialContentNames.execute(this.store_, AdvancedSettings.UPDATEINITIALCONTENTNAMESAFTERIMPORT)) != null) {
                this.deploymentHistory.addRootError(e);
            }
            this.importer_ = null;
            this.currentPackageDeploymentInfo_ = null;
            this.addBuffer_ = null;
            this.assertRunning();
            this.deploymentHistory.updateRunHistory(this.succeeded_);
            this.deploymentHistory.addRootDetail(this.objectsReportCount_, this.objectsFailed_);
            this.emitResponse(tabPrefix);
            boolean bl = true;
            return bl;
        }
        finally {
            CMExecutionContext.get().setApplyTenantIdVirtualInheritance(true);
            if (this.deploymentArchive_ != null) {
                this.deploymentArchive_.close();
            }
            this.stopDeploymentProgressThread();
            if (configCapabModified) {
                CMDescendantModifiedProperty.set();
                configCapabModified = false;
            }
        }
    }

    private void initHomeFolderIndex() throws CMException {
        if (this.archiveVersion < 7) {
            this.homeFolderIndex = new IncludeAllHomeFolderIndex();
        } else {
            this.homeFolderIndex = new HomeFolderIndex();
            this.homeFolderIndex.loadFrom(this.deploymentArchive_);
        }
    }

    private void handleMissingTenants() {
        AddMissingTenantObjects adder = new AddMissingTenantObjects();
        if (adder.shouldRun(this.isBalticArchive_, this.pluginsInArchive_, this.entireContentStoreSelect_)) {
            try {
                CMUpgradeResult result = adder.addMissingTenants(this.tenantIdsPriorToImport);
                if (result.getMessages() != null) {
                    for (CMUpgradeMessage message : result.getMessages()) {
                        this.addUpgradeMessage("CM_internal_5.018", message);
                    }
                }
            }
            catch (CMException e) {
                CMIndications.logException(new CMException((Throwable)e, "cmDataUpgradeFail"));
                this.deploymentHistory.addRootError(new CMException(e, "cmDataUpgradeFail"));
            }
        }
    }

    private void addUpgradeMessage(String pluginId, CMUpgradeMessage message) {
        CMException messageException = new CMException("cmGeneralPluginMessage", new CMException.Parm("pluginId", pluginId), new CMException.Parm("message", message.getMessage()));
        messageException.ErrorLevel = CMDataUpgradeUtils.cmUpgradeSeverityToIpfSeverity(message.getSeverity());
        this.deploymentHistory.addErrorDetail("/", -1, messageException);
    }

    private boolean doImport(DeploymentContext ctx, String filename) throws CMException {
        try {
            this.doImport(ctx, filename, null);
        }
        catch (CMException e) {
            if (e.getCode() == cmArchiveEntryNotFound) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private String lookupPackageByName(String sourceName) {
        if (this.xmlDocContent_ == null) {
            return null;
        }
        XMLElement contentEL = this.xmlDocContent_.getRootXMLElement().getOptionalChildWithName("exportedPackages");
        if (contentEL == null || !contentEL.hasChildren()) {
            return null;
        }
        for (XMLElement xmlElFile : contentEL.getChildren()) {
            XMLElement xmlElName = xmlElFile.getOptionalChildWithName("name");
            if (xmlElName == null || !xmlElName.hasChildren()) continue;
            for (XMLElement xmlElLocaleName : xmlElName.getChildren()) {
                String strName = xmlElLocaleName.getOptionalChildValueWithName("value");
                if (strName == null || !strName.equals(sourceName)) continue;
                return xmlElFile.getOptionalChildValueWithName("filename");
            }
        }
        return null;
    }

    public void doImport(DeploymentContext ctx, String filename, String sourceName, CMDbStoreLocalizedStringArray targetNames) throws CMException {
        if (CMIndicationGlobals.bDEP_Info_isEnabled) {
            CMIndications.CMTrace("cmDeployImportFile", new CMException.Parm("file", filename));
        }
        try {
            this.doImport(ctx, filename, targetNames);
        }
        catch (CMException e) {
            if (e.getCode() == cmArchiveEntryNotFound) {
                throw new CMException((Exception)e.getCause(), "cmExportPackageMissing", new CMException.Parm("Archive", this.archive_), new CMException.Parm("Package", sourceName));
            }
            throw e;
        }
    }

    private void doImport(DeploymentContext ctx, String filename, CMDbStoreLocalizedStringArray targetNames) throws CMException {
        this.assertRunning();
        if (filename == null) {
            throw new CMException(cmArchiveEntryNotFound);
        }
        InputStream istream = null;
        try {
            istream = this.deploymentArchive_.getInputStream(filename);
        }
        catch (CMException cmex) {
            if (cmex.getCode() == "cmImportCryptoFailed") {
                throw cmex;
            }
            throw new CMException(cmex, cmArchiveEntryNotFound);
        }
        catch (Exception ex) {
            throw new CMException(ex, cmArchiveEntryNotFound);
        }
        try {
            this.resetForNewImport();
            this.importer_.importPackage(istream, targetNames, ctx);
        }
        catch (CMException ex) {
            this.closeStreamQuietly(istream);
            throw ex;
        }
        catch (Exception ex) {
            this.closeStreamQuietly(istream);
            throw this.badArchiveException(ex);
        }
    }

    private XMLElement processArchiveContentFile() throws CMException {
        String nameContent = "content.xml";
        InputSource inputSource = new InputSource(this.deploymentArchive_.getInputStream(nameContent));
        try {
            XMLDocParser parser = new XMLDocParser(true);
            this.xmlDocContent_ = parser.readXML(inputSource);
        }
        catch (Exception ex) {
            throw this.badArchiveException(ex);
        }
        XMLElement elemContentRoot = null;
        if (this.xmlDocContent_ != null && (elemContentRoot = this.xmlDocContent_.getRootXMLElement()) != null) {
            try {
                String archiveVersionStr = elemContentRoot.getChildValueWithName("archiveVersion");
                this.archiveVersion = Integer.parseInt(archiveVersionStr);
                if (this.archiveVersion != 7) {
                    if (this.archiveVersion > 7) {
                        throw new CMException("cmArchiveTooNew");
                    }
                    if (this.archiveVersion < 4) {
                        throw new CMException("cmArchiveTooOld", new CMException.Parm("Store", ARCHIVE_CUTOFF_VERSION.toString()));
                    }
                    if (this.archiveVersion < 5) {
                        this.isBalticArchive_ = true;
                    }
                }
                String cmBuildStr = elemContentRoot.getChildValueWithName("cmBuildNumber");
                try {
                    this.archiveBuildVersion_.setTo(cmBuildStr);
                }
                catch (Exception e) {
                    this.archiveBuildVersion_.setTo(999999, 0, 0, 0);
                }
                this.checkProductVersion(this.archiveBuildVersion_);
                String preserveStoreIDsCutoffVersion = "10.1.1.0";
                if (this.preserveStoreIDs_ && this.archiveBuildVersion_.compareTo(preserveStoreIDsCutoffVersion) < 0) {
                    CMException ex = new CMException("cmImportPreserveStoreIdsArchiveOld", new CMException.Parm("Version", preserveStoreIDsCutoffVersion));
                    this.deploymentHistory.addRootWarning(ex);
                    this.preserveStoreIDs_ = false;
                }
                String edition = elemContentRoot.getOptionalChildValueWithName("edition");
                this.archiveEdition = C8Edition.get(edition);
                if (this.archiveEdition == null) {
                    this.archiveEdition = C8Edition.ENTERPRISE;
                }
                XMLElement exportedAccounsEl = elemContentRoot.getOptionalChildWithName("exportedAccounts");
                this.validateNamespaces(exportedAccounsEl);
                XMLElement pluginsEL = elemContentRoot.getOptionalChildWithName("plugins");
                if (pluginsEL != null && pluginsEL.hasChildren()) {
                    for (XMLElement xmlElPlugin : pluginsEL.getChildren()) {
                        if (xmlElPlugin == null) continue;
                        XMLElement pluginNameEl = xmlElPlugin.getOptionalChildWithName("pluginName");
                        XMLElement pluginVersionEl = xmlElPlugin.getOptionalChildWithName("pluginVersion");
                        if (pluginNameEl == null || pluginNameEl.value_ == null || pluginVersionEl == null || pluginVersionEl.value_ == null) continue;
                        if (this.pluginsInArchive_ == null) {
                            this.pluginsInArchive_ = new HashMap<String, String>();
                        }
                        this.pluginsInArchive_.put(pluginNameEl.value_, pluginVersionEl.value_);
                    }
                }
            }
            catch (CMException exception) {
                throw exception;
            }
            catch (Exception ex) {
                throw this.badArchiveException(ex);
            }
        }
        return elemContentRoot;
    }

    private void checkProductVersion(CMBuildVersion archive) throws CMException {
        CMBuildVersion currentCM = new CMBuildVersion(this.getCurrCMVersion());
        currentCM.set(3, Integer.MAX_VALUE);
        if (archive.get(0) != 999999 && currentCM.get(0) != 999999 && currentCM.compareTo(archive) < 0) {
            throw new CMException("cmArchiveTooNew");
        }
    }

    private CMBuildVersion getCurrCMVersion() {
        try {
            String currVer = cmInfo.getVersion();
            this.currCMBuildVersion.setTo(currVer);
        }
        catch (Exception e) {
            this.currCMBuildVersion.setTo(999999, 0, 0, 0);
        }
        return this.currCMBuildVersion;
    }

    private boolean isPluginVersionInArchiveOlder(CMPluginDescriptor desc) {
        float pluginVersionInDesc;
        if (desc == null) {
            return false;
        }
        boolean isOlder = false;
        String pluginName = desc.getPluginName();
        float pluginVersionInArchive = Float.parseFloat(this.pluginsInArchive_.get(pluginName));
        if (pluginVersionInArchive < (pluginVersionInDesc = Float.parseFloat(desc.getVersion()))) {
            isOlder = true;
        }
        return isOlder;
    }

    private void addToUpgradeClassMap(CMPluginDescriptor desc, boolean isReportQueryPlugin, boolean setReportUpgradeFlag, boolean setPluginVersion) {
        if (desc == null) {
            return;
        }
        if (this.upgradeClassMap_ == null) {
            this.upgradeClassMap_ = new HashMap<String, List<CMPluginInfo>>();
        }
        for (String className : desc.getClassNamesForDeployment()) {
            List propList = desc.getProperties();
            String pluginID = desc.getPluginID();
            String pluginName = desc.getPluginName();
            String pluginVersionInArchive = null;
            if (isReportQueryPlugin && this.pluginsInArchive_ != null) {
                if (this.pluginsInArchive_.containsKey(pluginName)) {
                    pluginVersionInArchive = this.pluginsInArchive_.get(pluginName);
                } else if (this.archiveBuildVersion_.compareTo("2.0.0.0") > 0 && this.archiveBuildVersion_.compareTo("2.0.1124.0") < 0) {
                    pluginVersionInArchive = new Float(2.001).toString();
                }
            }
            CMPluginInfo pluginInfo = new CMPluginInfo(pluginID, pluginVersionInArchive, propList, desc.isPostImport(), isReportQueryPlugin, setReportUpgradeFlag, setPluginVersion);
            List<CMPluginInfo> pluginList = this.upgradeClassMap_.get(className);
            if (pluginList == null) {
                pluginList = new ArrayList<CMPluginInfo>();
                this.upgradeClassMap_.put(className, pluginList);
            }
            pluginList.add(pluginInfo);
        }
    }

    private boolean isClassnameInUpgradeList(CMPluginDescriptor desc) {
        if (this.upgradeClassList_ == null) {
            return false;
        }
        for (String className : desc.getClassNamesForDeployment()) {
            if (!this.upgradeClassList_.contains(className)) continue;
            return true;
        }
        return false;
    }

    private void buildUpgradeClassMap() {
        CMPluginManager pluginMgr = CMPluginManager.getInstance();
        if (!pluginMgr.hasPlugins()) {
            return;
        }
        List<CMPluginDescriptor> descs = pluginMgr.getPluginDescriptors();
        for (CMPluginDescriptor desc : descs) {
            if (!desc.getPluginType().equalsIgnoreCase("Upgrade")) continue;
            if (desc.getEditions() != null) {
                this.addEditionPlugin(desc);
                continue;
            }
            if (desc.isMandatory() && desc.forDeployment()) {
                this.addMandatoryPlugin(desc);
                continue;
            }
            this.addOptionalPlugin(desc);
        }
    }

    private boolean shouldRunPlugin(CMPluginDescriptor desc) {
        return this.isBalticArchive_ || this.pluginsInArchive_ == null || !this.pluginsInArchive_.containsKey(desc.getPluginName()) || this.isPluginVersionInArchiveOlder(desc);
    }

    private void addOptionalPlugin(CMPluginDescriptor desc) {
        boolean isReportQueryPlugin = false;
        List classList = desc.getClassNamesForDeployment();
        if (classList != null && (classList.contains(CMObjectClass.REPORT.getName()) || classList.contains(CMObjectClass.QUERY.getName()))) {
            isReportQueryPlugin = true;
        }
        boolean isInUpgradeList = this.isClassnameInUpgradeList(desc);
        if (isReportQueryPlugin) {
            boolean setReportUpgradeFlag = false;
            if (isInUpgradeList) {
                setReportUpgradeFlag = true;
            }
            boolean setPluginVersion = false;
            if (!this.isBalticArchive_ && this.pluginsInArchive_ != null) {
                if (!this.pluginsInArchive_.containsKey(desc.getPluginName())) {
                    setPluginVersion = true;
                } else if (this.isPluginVersionInArchiveOlder(desc)) {
                    setPluginVersion = true;
                }
            }
            if (setReportUpgradeFlag || setPluginVersion) {
                this.addToUpgradeClassMap(desc, true, setReportUpgradeFlag, setPluginVersion);
            }
        } else if (isInUpgradeList) {
            this.addToUpgradeClassMap(desc, false, false, false);
        }
    }

    private void addMandatoryPlugin(CMPluginDescriptor desc) {
        if (this.shouldRunPlugin(desc)) {
            this.addToUpgradeClassMap(desc, false, false, false);
        }
    }

    private void addEditionPlugin(CMPluginDescriptor desc) {
        if (CMServlet.getEdition() != C8Edition.ENTERPRISE || this.archiveEdition == C8Edition.ENTERPRISE) {
            return;
        }
        for (String edition : desc.getEditions()) {
            if (!this.archiveEdition.getName().equalsIgnoreCase(edition)) continue;
            this.addToUpgradeClassMap(desc, false, false, false);
            break;
        }
    }

    private void cleanLocales(CMDbStoreLocalizedStringArray sourceLocaleValues, CMDbStoreLocalizedStringArray targetValues) {
        if (targetValues == null || sourceLocaleValues == null) {
            return;
        }
        for (int i = 0; i < targetValues.getSize(); ++i) {
            CMLocalizedString localeStr = targetValues.get(i);
            if (sourceLocaleValues.get(localeStr.getLocale()) != null) continue;
            targetValues.removeItem(i);
            --i;
        }
    }

    private void resetForNewImport() {
        this.parentMap_ = null;
        this.parentMapIgnored_ = new HashMap();
        this.missingParentObjs_ = new HashMap();
    }

    protected void validateObjectProperties(AddDef addDef) throws CMException {
        if (!this.objectPolicies_) {
            addDef.remove(CMProperty.POLICIES);
            addDef.remove(CMProperty.USERCAPABILITYPOLICIES);
        }
        this.validateObjectProperties(addDef, this.validateOpts_);
    }

    @Override
    protected void validateParameters(AddDef addDef, AddDef.Entry entry, RequestHandler.ValidateOptions options) throws CMException {
        ParametersEncoder.decode(entry.getValue());
    }

    @Override
    protected void validateOptions(AddDef addDef, AddDef.Entry entry, RequestHandler.ValidateOptions options) throws CMException {
        XMLElement elValue = (XMLElement)entry.getValue();
        if (elValue == null) {
            return;
        }
        OptionsDecoder.decode(elValue, options.storeIDSubstitutes);
        super.validateOptions(addDef, entry, options);
    }

    private void restoreDefaultProperties(AddDef addDef) {
        CMProperty[] allProps = addDef.objectClass.getProperties();
        for (int i = 0; i < allProps.length; ++i) {
            CMProperty clProp = allProps[i];
            if (!clProp.isUpdateable() || clProp.isDisabled() || clProp == CMProperty.RETENTIONS || clProp == CMProperty.RUNOPTIONS || clProp == CMProperty.DEPLOYMENTOPTIONS || clProp == CMProperty.POLICIES || clProp == CMProperty.USERCAPABILITYPOLICIES || clProp == CMProperty.OWNER || clProp == CMProperty.CONTACT || clProp == CMProperty.CONTACTEMAIL || clProp == CMProperty.NAME || clProp == CMProperty.ROUTINGHINTS || addDef.objectClass == CMObjectClass.ACCOUNT && licenseProps.contains(clProp.getName()) || clProp.getType() == CMPropertyTypes.XML_BOOLEAN || clProp.isDefaultMultilingualProperty() || addDef.contains(clProp)) continue;
            if (clProp == CMProperty._ARCHIVESTATUS) {
                addDef.put(clProp, ArchivingUtil.getArchiveStatusForDatabaseDefault());
                continue;
            }
            if (addDef.objectClass == CMObjectClass.ROLE && clProp.getName().equals("profileRank") || clProp.getName().equals("usageTrackingModel") || addDef.updateAddDef != null && addDef.updateAddDef.contains(clProp)) continue;
            addDef.put(clProp, null);
        }
    }

    private void updateObjectOwner(AddDef addDef, boolean existingObj) throws CMException {
        if (existingObj && this.ownershipConflictResolution_ == 1) {
            addDef.remove(CMProperty.OWNER);
            if (addDef.updateAddDef != null) {
                addDef.updateAddDef.remove(CMProperty.OWNER);
            }
        } else {
            int inAddDef = 0;
            if (addDef.contains(CMProperty.OWNER)) {
                inAddDef = 1;
            } else if (addDef.updateAddDef != null && addDef.updateAddDef.contains(CMProperty.OWNER)) {
                inAddDef = 2;
            }
            if (inAddDef == 0) {
                addDef.put(CMProperty.OWNER, null);
            } else if (this.takeOwnership_) {
                if (this.bcaCurrentUser_ == null) {
                    this.bcaCurrentUser_ = new CMDbStoreBaseClassArray();
                    CMExecutionContext ctx = CMExecutionContext.get();
                    int objID = ctx.getCurrentUserAccountObjectID();
                    CMObjectClass objClass = ctx.getStore().getObjectClass(objID);
                    String searchPath = ctx.getCurrentUserSearchPath();
                    this.bcaCurrentUser_.add(new CMDbStoreObjectReference(objID, objClass, searchPath));
                }
                if (inAddDef == 1) {
                    addDef.put(CMProperty.OWNER, this.bcaCurrentUser_);
                } else {
                    addDef.updateAddDef.put(CMProperty.OWNER, this.bcaCurrentUser_);
                }
            }
        }
    }

    private String constructReportDescendantsSearchPath(String queryPath) {
        StringBuffer descSearchPathBuf = new StringBuffer(queryPath);
        descSearchPathBuf.append("/*[");
        descSearchPathBuf.append(reportCacheSearchPathSuffix_);
        descSearchPathBuf.append(" or ");
        descSearchPathBuf.append(reportMetadataSearchPathSuffix_);
        descSearchPathBuf.append(" or ");
        descSearchPathBuf.append(reportMetadataCacheSearchPathSuffix_);
        if (this.packageOutputs_ && this.packageOutputsConflictResolution_ == 2) {
            descSearchPathBuf.append(" or ");
            descSearchPathBuf.append(reportVersionSearchPathSuffix_);
        }
        if (this.packageHistories_ && this.packageHistoriesConflictResolution_ == 2) {
            descSearchPathBuf.append(" or ");
            descSearchPathBuf.append(reportRunHistorySearchPathSuffix_);
        }
        descSearchPathBuf.append("]");
        return descSearchPathBuf.toString();
    }

    private String constructUploadedFileDescendantsSearchPath(String queryPath) {
        StringBuilder descSearchPathBld = new StringBuilder(queryPath);
        int predicateCount = 0;
        descSearchPathBld.append("/*[");
        if (this.packageDatasetOutputs_ && this.packageDatasetOutputsConflictResolution_ == 2) {
            descSearchPathBld.append(reportVersionSearchPathSuffix_);
            ++predicateCount;
        }
        if (this.packageHistories_ && this.packageHistoriesConflictResolution_ == 2) {
            if (predicateCount > 0) {
                descSearchPathBld.append(" or ");
            }
            descSearchPathBld.append(reportRunHistorySearchPathSuffix_);
            ++predicateCount;
        }
        if (predicateCount > 0) {
            descSearchPathBld.append("]");
            return descSearchPathBld.toString();
        }
        return null;
    }

    private CMException verifyRequiredModelProperties(AddDef addDef, CMException errors) {
        if ((addDef.objectClass.subclassof(CMObjectClass.AUTHOREDREPORT) || addDef.objectClass.subclassof(CMObjectClass.AUTHOREDPOWERPLAY8REPORT) || addDef.objectClass.subclassof(CMObjectClass.REPORTVERSION) || addDef.objectClass.subclassof(CMObjectClass.BASEDATAINTEGRATIONTASK) || addDef.objectClass.subclassof(CMObjectClass.STOREDPROCEDURETASK)) && !addDef.contains(CMProperty.METADATAMODELPACKAGE) && !addDef.contains(CMProperty.METADATAMODEL)) {
            int prevLevel = -1;
            StringBuffer buf = new StringBuffer();
            buf.append(CMProperty.METADATAMODEL.getName());
            buf.append(", ");
            buf.append(CMProperty.METADATAMODELPACKAGE.getName());
            if (errors != null) {
                prevLevel = errors.ErrorLevel;
                errors = new CMException((Exception)errors, "cmWarningMissingRequiredProp", new CMException.Parm("Props", buf.toString()));
            } else {
                errors = new CMException("cmWarningMissingRequiredProp", new CMException.Parm("Props", buf.toString()));
            }
            errors.ErrorLevel = prevLevel > 30000 ? prevLevel : 30000;
        }
        return errors;
    }

    private void rollbackOpenTransaction() {
        if (this.store_.inTransaction()) {
            try {
                this.store_.rollbackTransaction();
            }
            catch (CMException ex) {
                CMIndications.logException(ex);
            }
        }
    }

    private void processDataSetOutput(AddDef addDef) throws CMException {
        if (this.dataSetPlugin_ == null) {
            return;
        }
        CMProperty dataProperty = this.findProperty(CMPropertyMeaning.DATA, CMObjectClass.OUTPUT);
        Object dataValue = addDef.get(dataProperty);
        if (dataValue != null && dataValue instanceof RequestImportDataAttachment) {
            RequestImportDataAttachment origAttach = (RequestImportDataAttachment)dataValue;
            InputStream in = origAttach.getTempInputStream();
            CountingOutputStream cout = new CountingOutputStream(new CMTempOutputStream());
            RequestImportDataSetAttachment encryptedAttach = null;
            try {
                this.dataSetPlugin_.encrypt(in, (OutputStream)cout);
                String attachFileName = CMDateUtils.getIsoDate();
                long dataSize = cout.getBytesWritten();
                encryptedAttach = new RequestImportDataSetAttachment(cout, attachFileName, dataSize);
                this.addRequestAttachment(attachFileName, encryptedAttach);
            }
            catch (Exception ex) {
                throw new CMException("cmGeneralPluginMessage", new CMException.Parm("pluginId", "com.cognos.xqe.util.datasets.DatasetUtil"), new CMException.Parm("message", ex.getMessage()));
            }
            finally {
                try {
                    cout.close();
                }
                catch (Exception ex1) {
                    CMIndications.logException(ex1);
                }
            }
            addDef.put(dataProperty, encryptedAttach);
            CMProperty extraProp = this.findProperty(CMPropertyMeaning._DATAISCOMPRESSED, CMObjectClass.OUTPUT);
            addDef.put(extraProp, new String("false"));
        }
    }

    /*
     * Exception decompiling
     */
    public void importObject(XMLElement xmlElm, CMDbStoreLocalizedStringArray packageTargetNames, DeploymentContext context) throws CMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 14[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addParentToLockedPaths(String parentPath) throws CMStoreParseException {
        this.lockedPaths_.add(new CMStoreXPath(parentPath, 11));
    }

    private void collectReferences(AddDef addDef) {
        for (CMProperty prop : addDef.names()) {
            if (!prop.hasMeaning(CMPropertyMeaning.GENERIC_REFERENCES)) continue;
            this.homeFolderIndex.addReferences((CMStringArray)addDef.get(prop));
        }
    }

    private void setTenantIDForUpdate(String searchPath, int existingTenantID, AddDef addDef) throws CMException {
        String archiveTenant = (String)addDef.get(CMProperty.TENANTID);
        int archiveTenantID = this.tenantRegistry.getTenantIdIntFromString(archiveTenant, false);
        if (archiveTenantID == 0 && !this.entireContentStoreSelect_) {
            if (existingTenantID != 0) {
                archiveTenantID = existingTenantID;
                String existingTenant = this.tenantRegistry.getTenantIdStringFromInt(existingTenantID);
                addDef.put(CMProperty.TENANTID, existingTenant);
            }
        } else if (existingTenantID != archiveTenantID) {
            String existingTenant = this.tenantRegistry.getTenantIdStringFromInt(existingTenantID);
            throw new CMException("cmImportTenantIDConflict", new CMException.Parm("searchPath", searchPath), new CMException.Parm("archiveTenantID", archiveTenant), new CMException.Parm("targetTenantID", existingTenant));
        }
    }

    private void setTenantIdForAdd(String searchPath, int parentTenantID, AddDef addDef) throws CMException {
        if (parentTenantID != 0) {
            this.setTenantIDForUpdate(searchPath, parentTenantID, addDef);
        }
    }

    private ParentInfo createParentInfo(CMDbStoreLocalizedStringArray packageTargetNames, DeploymentContext context) throws CMStoreParseException {
        this.parentMap_ = new HashMap();
        ParentInfo thisParentInfo = packageTargetNames == null && context == DeploymentContext.Tenants ? new ParentInfo("/" + CMObjectClass.DIRECTORY, CMObjectClass.DIRECTORY) : (packageTargetNames == null && context == DeploymentContext.Catalog ? new ParentInfo("/" + CMObjectClass.CATALOG, CMObjectClass.CATALOG) : (context == DeploymentContext.HomeFolders ? new ParentInfo("/folder[@name=\"home\"]", CMObjectClass.FOLDER) : (packageTargetNames == null && context != DeploymentContext.Folder ? new ParentInfo("CAMID(\":\")", CMObjectClass.NAMESPACE) : (this.deploymentOptionEnumImport_ ? this.createParentInfo(this.currentPackageDeploymentInfo_.targetParent_) : new ParentInfo(new String("/" + CMObjectClass.CONTENT.getName()), CMObjectClass.CONTENT)))));
        this.parentMap_.put(0L, thisParentInfo);
        return thisParentInfo;
    }

    private ParentInfo createParentInfo(String parentPath) throws CMStoreParseException {
        CMStoreXPath parentSP = new CMStoreXPath(parentPath);
        if (parentSP.size() == 1 && ":".equals(parentSP.getCAMIDFromFirstStep())) {
            return new ParentInfo(parentPath, CMObjectClass.NAMESPACE);
        }
        CMStoreXPathStep lastStep = (CMStoreXPathStep)parentSP.stepAt(parentSP.size() - 1);
        return new ParentInfo(parentPath, lastStep.classpredicate_);
    }

    private PathInfo createPathInfo(CMObjectClass objectClassThis, String objectPath, String objectName, String className, long parentId, String parentPath, CMDbStoreLocalizedStringArray packageTargetNames, boolean excludeNameFromPath, XMLElement xmlElmProps, DeploymentContext context) {
        String searchPath = null;
        String queryPath = null;
        StringBuffer queryPathBuf = null;
        if (objectPath == null) {
            StringBuffer searchPathBuf = new StringBuffer();
            searchPathBuf.append(parentPath);
            searchPathBuf.append("/");
            if (context == DeploymentContext.ExternalNamespace && objectClassThis == CMObjectClass.GROUP) {
                searchPathBuf.append("*");
            } else {
                searchPathBuf.append(className);
            }
            if (excludeNameFromPath) {
                queryPath = searchPathBuf.toString();
            }
            searchPathBuf.append("[");
            if (objectClassThis == CMObjectClass.PACKAGE && parentId == 0L) {
                queryPathBuf = new StringBuffer(searchPathBuf.toString());
                int size = 1;
                if (packageTargetNames != null) {
                    size = packageTargetNames.getSize();
                }
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        queryPathBuf.append(" or ");
                    }
                    queryPathBuf.append("@");
                    queryPathBuf.append(CMProperty.NAME.getName());
                    queryPathBuf.append("=");
                    if (packageTargetNames != null) {
                        CMLocalizedString lStr = packageTargetNames.get(i);
                        if (lStr != null) {
                            queryPathBuf.append(CMStoreXPath.attributeQuoteString(lStr.getValue()));
                            continue;
                        }
                        queryPathBuf.append(CMStoreXPath.attributeQuoteString(""));
                        continue;
                    }
                    queryPathBuf.append(CMStoreXPath.attributeQuoteString(objectName));
                }
                queryPathBuf.append("]");
            } else if (objectClassThis == CMObjectClass.TENANT) {
                queryPathBuf = new StringBuffer(searchPathBuf.toString());
                queryPathBuf.append("@");
                queryPathBuf.append(CMProperty.TENANTID.getName());
                queryPathBuf.append("=");
                String tenantID = this.getTenantIDFromPropList(xmlElmProps);
                queryPathBuf.append(CMStoreXPath.attributeQuoteString(tenantID));
                queryPathBuf.append("]");
            }
            searchPathBuf.append("@");
            searchPathBuf.append(CMProperty.NAME.getName());
            searchPathBuf.append("=");
            searchPathBuf.append(CMStoreXPath.attributeQuoteString(objectName));
            searchPathBuf.append("]");
            searchPath = searchPathBuf.toString();
        } else {
            if (excludeNameFromPath) {
                queryPath = objectPath;
            }
            if (context == DeploymentContext.ExternalNamespace && !objectPath.endsWith("]") && xmlElmProps.hasChildren()) {
                StringBuffer searchPathBuf = new StringBuffer();
                searchPathBuf.append(objectPath);
                searchPathBuf.append("[@");
                searchPathBuf.append(CMProperty.NAME.getName());
                searchPathBuf.append("=");
                searchPathBuf.append(CMStoreXPath.attributeQuoteString(objectName));
                searchPathBuf.append("]");
                objectPath = searchPathBuf.toString();
            }
            searchPath = objectPath;
        }
        if (queryPath == null) {
            queryPath = queryPathBuf != null ? queryPathBuf.toString() : searchPath;
        }
        return new PathInfo(searchPath, queryPath);
    }

    private String getTenantIDFromPropList(XMLElement xmlElmProps) {
        String tenantID = "";
        ArrayList<XMLElement> propList = xmlElmProps.getChildren();
        if (propList != null) {
            ListIterator iterProp = propList.listIterator();
            while (iterProp.hasNext()) {
                XMLElement xmlElValue;
                XMLElement xmlElProp = (XMLElement)iterProp.next();
                if (xmlElProp.isNil_ || !xmlElProp.name_.equals(CMProperty.TENANTID.getName()) || (xmlElValue = xmlElProp.getOptionalChildWithName("value")) == null) continue;
                tenantID = xmlElValue.value_;
            }
        }
        return tenantID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMException checkInvalidContainmentObject(int statusDeploy, String searchPath) {
        CMException warningOnObject = null;
        DeploymentExecutionContext dCtx = DeploymentExecutionContext.get();
        try {
            if (dCtx.hasInvalidContainmentObject() && statusDeploy != 7) {
                warningOnObject = new CMException("cmImportInvalidTenantContainmentOnObject", new CMException.Parm("searchPath", searchPath));
                warningOnObject.setErrorLevel(20000);
            }
        }
        finally {
            dCtx.setInvalidContainmentObject(false);
        }
        return warningOnObject;
    }

    protected CMStoreQueryResults addObject(CMStoreQueryResults parentQuery, CMObjectClass objectClassThis, AddDef addDef, CMBasePropertyValue objectNames) throws CMException {
        HashMap<String, Object> notificationParameters1 = this.createNotificationParameters();
        CMStoreQueryResults addResult = this.store_.addObject(parentQuery.getObjectID(), objectNames, objectClassThis, addDef.names(), addDef.values(), notificationParameters1);
        return addResult;
    }

    protected void updateObject(CMStoreQueryResults parentQuery, ArrayList<CMProperty> upProps, ArrayList<Object> upValues) throws CMException {
        HashMap<String, Object> notificationParameters = this.createNotificationParameters();
        this.store_.update(parentQuery, upProps, upValues, notificationParameters);
    }

    /*
     * Exception decompiling
     */
    public void importUserObject(XMLElement xmlElm) throws CMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[TRYBLOCK]], but top level block is 15[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateMaxOccurence(AddDef addDef, CMStoreQueryResults parentQuery, boolean deleteIt) throws CMException {
        CMObjectClass objectClass = addDef.objectClass;
        CMObjectClass parentClass = parentQuery.getObjectClass();
        int maxOccurs = parentClass.getMaxOccursFor(objectClass);
        if (maxOccurs < 1) {
            if (deleteIt) {
                delete.deleteDescendants(this.store_, addDef.searchPath, 10, true);
            }
            throw new CMException("cmInvalidChildClass", new CMException.Parm("Path", parentQuery.getPath()), new CMException.Parm("ChildClass", objectClass.getLocalizedName()), new CMException.Parm("ParentClass", parentClass.getLocalizedName()));
        }
        if (maxOccurs == CMObjectClass.MAX_OCCURS_UNLIMITED) {
            return;
        }
        String parPath = parentQuery.getSearchPath();
        int childCount = parentClass.isMaxOccursPerTenant(objectClass) ? CMQueryUtils.getChildCountForTenantId(this.store_, parPath, objectClass, addDef.tenantIDStr) : CMQueryUtils.getChildCount(this.store_, parPath, objectClass);
        if (deleteIt) {
            --childCount;
        }
        if (childCount >= maxOccurs) {
            if (deleteIt) {
                delete.deleteDescendants(this.store_, addDef.searchPath, 10, true);
            }
            throw new CMException("cmOverMaxChild", new CMException.Parm("Path", parentQuery.getPath()), new CMException.Parm("ChildClass", objectClass.getLocalizedName()), new CMException.Parm("ParentClass", parentClass.getLocalizedName()));
        }
    }

    private void processAccountGenericDocumentReferences(XMLElement xmlElm) {
        String references = xmlElm.getOptionalChildValueWithName("references");
        if (references == null) {
            return;
        }
        ArrayList<String> ids = CMStringUtils.split(references, ',', true);
        this.homeFolderIndex.addReferences(new CMDbStoreStringArray(ids));
    }

    private String reconstructSearchPath(String src) {
        try {
            boolean hadSlash = false;
            boolean skip = false;
            Lexer lex = new Lexer(src);
            lex.ignoreWhitespace(false);
            StringBuffer out = new StringBuffer(256);
            int token = 1;
            while (token != 0) {
                token = lex.yylex();
                String text = lex.getText();
                switch (token) {
                    case 2: {
                        text = CMStoreXPath.attributeQuoteString(text);
                        break;
                    }
                    case 17: {
                        if (hadSlash) break;
                        skip = true;
                        break;
                    }
                    case 18: {
                        if (!skip) break;
                        skip = false;
                        text = "";
                        break;
                    }
                    case 13: 
                    case 14: {
                        hadSlash = true;
                    }
                }
                if (skip) continue;
                out.append(text);
            }
            return out.toString();
        }
        catch (Exception e) {
            return src;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(XMLElement xmlElm) throws CMException {
        block12: {
            String strPath = null;
            int detailId = -1;
            CMStoreQueryResults existQuery = null;
            CMException errors = null;
            try {
                strPath = xmlElm.getOptionalChildValueWithName("path");
                detailId = xmlElm.getChildIntValueWithName("detailID");
                String className = xmlElm.getChildValueWithName("class");
                XMLElement elProps = xmlElm.getChildWithName("props");
                elProps.xsiType_ = className;
                AddDef addDef = this.getObjectIntoAddDef(elProps, 13, true, this.archiveBuildVersion_);
                String storeID = xmlElm.getChildValueWithName("storeID");
                this.resetLockedPaths();
                CMStoreXPath objPath = CMStoreXPath.fromStoreID(storeID);
                objPath.setLockManagerUsageFlag(13);
                this.lockedPaths_.add(objPath);
                if (addDef.objectClass == CMObjectClass.SCHEDULE) {
                    this.updateScheduleCredentials(addDef);
                }
                this.validateObjectProperties(addDef, this.validateOpts_);
                this.LockPaths();
                String strFailedRefs = this.resolveIDBasedReferences(addDef, false, true, null);
                this.store_.beginTransaction();
                existQuery = this.store_.executeQuery(objPath, null, null, 9, 2, null);
                if (!existQuery.next()) {
                    throw new CMException("cmImportObjMissing");
                }
                while (existQuery.next()) {
                }
                existQuery.reset();
                this.store_.update(existQuery, addDef.names(), addDef.values(), this.createNotificationParameters());
                existQuery.release();
                this.store_.commitTransaction();
                if (strFailedRefs != null) {
                    errors = new CMException("cmUnresolvedReferences1", new CMException.Parm("refs", strFailedRefs));
                    errors.ErrorLevel = 30000;
                }
                CMQueryUtils.safeQueryResultsRelease(existQuery);
                this.rollbackOpenTransaction();
            }
            catch (CMException ex) {
                if (ex instanceof CMStoreNotAvailable) {
                    throw new CMException((Exception)ex, "cmFailedToUpdateImportedObj", new CMException.Parm("path", strPath));
                }
                errors = new CMException((Exception)ex, "cmFailedToUpdateImportedObj", new CMException.Parm("path", strPath));
                break block12;
            }
            finally {
                CMQueryUtils.safeQueryResultsRelease(existQuery);
                this.rollbackOpenTransaction();
                this.lockMgr_.releaseLocks();
                if (errors != null) {
                    this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
                    this.lockMgr_.requestLocks(this.spRunHistoryStorePath_);
                    this.deploymentHistory.updateDetail(strPath, detailId, -1, errors);
                    this.lockMgr_.releaseLocks();
                }
            }
            this.lockMgr_.releaseLocks();
            if (errors != null) {
                this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
                this.lockMgr_.requestLocks(this.spRunHistoryStorePath_);
                this.deploymentHistory.updateDetail(strPath, detailId, -1, errors);
                this.lockMgr_.releaseLocks();
            }
        }
    }

    public HashMap<String, Object> createNotificationParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ArchivalNotificationParameters", new ArchivalNotificationParameters(true));
        return params;
    }

    private CMTempOutputStream createTempObjectStream() throws IOException {
        CMTempOutputStream stream = new CMTempOutputStream();
        stream.write(archiveHead_.getBytes("UTF-8"));
        return stream;
    }

    private void closeTempObjectStream(CMTempOutputStream stream) throws IOException {
        stream.write(archiveFoot_.getBytes("UTF-8"));
        stream.close();
    }

    private void serializeAddDef(AddDef addDef) throws CMException {
        if (addDef == null || addDef.updateAddDef == null || addDef.updateAddDef.storeID == null) {
            return;
        }
        AddDef updateAddDef = addDef.updateAddDef;
        try {
            if (this.updateAddDefStream_ == null) {
                this.updateAddDefStream_ = this.createTempObjectStream();
            }
            StringBuffer buf = new StringBuffer(512);
            buf.append("<").append("object").append(">");
            buf.append("<").append("class").append(">");
            buf.append(updateAddDef.objectClass.getName());
            buf.append("</").append("class").append(">");
            buf.append("<").append("storeID").append(">");
            buf.append(XMLUtils.escape((String)updateAddDef.storeID));
            buf.append("</").append("storeID").append(">");
            buf.append("<").append("path").append(">");
            buf.append(XMLUtils.escape((String)updateAddDef.searchPath.getOriginalPath()));
            buf.append("</").append("path").append(">");
            buf.append("<").append("detailID").append(">");
            buf.append(updateAddDef.detailId);
            buf.append("</").append("detailID").append(">");
            buf.append("<").append("props").append(">");
            String origModificationTime = (String)addDef.get(CMProperty.MODIFICATIONTIME);
            if (origModificationTime != null) {
                buf.append("<").append(CMProperty.MODIFICATIONTIME.getName()).append(">");
                buf.append("<").append("value").append(">");
                buf.append(origModificationTime);
                buf.append("</").append("value").append(">");
                buf.append("</").append(CMProperty.MODIFICATIONTIME.getName()).append(">");
            }
            for (AddDef.Entry entry = updateAddDef.firstEntry(); entry != null; entry = entry.next()) {
                Object value = entry.getValue();
                if (value == null) continue;
                if (!(value instanceof XMLElement)) {
                    throw new IllegalStateException("postponed property is already parsed");
                }
                XMLElement el = (XMLElement)value;
                String propName = entry.getProperty().getName();
                buf.append("<").append(propName).append(">");
                buf.append(el.makeXML("", true, false, false));
                buf.append("</").append(propName).append(">");
            }
            buf.append("</").append("props").append(">");
            buf.append("</").append("object").append(">");
            this.updateAddDefStream_.write(buf.toString().getBytes("UTF-8"));
        }
        catch (IOException ex) {
            throw new CMException(ex, "cmErrorWritingTempFile");
        }
    }

    private int checkIgnoredObject(String objectName, int classProcessing, long thisId, long parentId, DeploymentContext context) {
        if (context == DeploymentContext.HomeFolders && !this.homeFolderIndex.isReferenced((int)thisId)) {
            return 0;
        }
        if (classProcessing != 0 && this.parentMapIgnored_.size() != 0 && this.parentMapIgnored_.containsKey(parentId)) {
            classProcessing = 0;
        }
        if (classProcessing == 0 && thisId > 0L) {
            this.parentMapIgnored_.put(thisId, objectName);
        }
        return classProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteChildren(CMStorePath parent, CMObjectClass objClass, ArrayList<CMObjectClass> classesToRemove) throws CMException {
        String pathSuffix = "*";
        if (classesToRemove != null) {
            pathSuffix = pathSuffix.concat("[@objectClass='");
            for (int i = 0; i < classesToRemove.size(); ++i) {
                CMObjectClass className = classesToRemove.get(i);
                pathSuffix = pathSuffix.concat(className.toString());
                pathSuffix = i + 1 < classesToRemove.size() ? pathSuffix.concat("' or @objectClass='") : pathSuffix.concat("']//*");
            }
        }
        CMStoreXPath descendantQuery = new CMStoreXPath(parent, pathSuffix, false);
        CMStoreQueryResults descendantResults = null;
        int numDescendants = 0;
        int operation = 0;
        try {
            descendantResults = this.store_.executeQuery(descendantQuery, null, null, operation, 10, null);
            while (descendantResults.next()) {
                String searchPath = descendantResults.getSearchPath();
                if (objClass == CMObjectClass.NAMESPACE ? searchPath.equals("CAMID(\"::Anonymous\")") || searchPath.lastIndexOf("::System Administrators") > 0 || !importRequest.deployObjectWithPath(searchPath) : this.RunHistoryIDs_.contains(descendantResults.getObjectID())) continue;
                delete.deleteDescendants(this.store_, searchPath, 10, true);
            }
        }
        finally {
            if (descendantResults != null) {
                descendantResults.release();
            }
        }
        return numDescendants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecurityReferences() throws CMException {
        this.validateOpts_.postponeSecurityReferences = false;
        if (this.importUpdateList_.size() == 0) {
            return;
        }
        this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
        this.spRunHistoryStorePath_.setLockManagerUsageFlag(11);
        try {
            for (AddDef addDef : this.importUpdateList_) {
                String strPath;
                CMException errors = null;
                CMStoreQueryResults existQuery = null;
                try {
                    this.resetLockedPaths();
                    CMStoreXPath objPath = CMStoreXPath.fromStoreID(addDef.storeID);
                    objPath.setLockManagerUsageFlag(13);
                    this.lockedPaths_.add(objPath);
                    this.validateObjectProperties(addDef, this.validateOpts_);
                    this.LockPaths();
                    String strFailedRefs = this.resolveIDBasedReferences(addDef, false, true, null);
                    this.store_.beginTransaction();
                    int permissions = 18;
                    if (addDef.contains(CMProperty.POLICIES)) {
                        permissions |= 4;
                    }
                    if (!(existQuery = this.store_.executeQuery(objPath, null, null, 9, permissions, null)).next()) {
                        throw new CMException("cmImportObjMissing");
                    }
                    if (addDef.objectClass == CMObjectClass.ROLE && existQuery.getSearchPath().equals("CAMID(\"::System Administrators\")")) {
                        CMProperty[] props = new CMProperty[]{CMProperty.MEMBERS};
                        CMStoreQueryResults membersQuery = null;
                        try {
                            membersQuery = this.store_.executeQuery(objPath, props, null, 9, permissions, null);
                            membersQuery.next();
                            this.mergeMembersProperty(addDef, (CMBaseClassArray)membersQuery.getValue(0));
                        }
                        catch (Throwable throwable) {
                            CMQueryUtils.safeQueryResultsRelease(membersQuery);
                            throw throwable;
                        }
                        CMQueryUtils.safeQueryResultsRelease(membersQuery);
                    }
                    while (existQuery.next()) {
                    }
                    existQuery.reset();
                    this.store_.update(existQuery, addDef.names(), addDef.values());
                    existQuery.release();
                    this.store_.commitTransaction();
                    if (addDef.updateAddDef != null) {
                        addDef.updateAddDef.detailId = addDef.detailId;
                        addDef.updateAddDef.storeID = addDef.storeID;
                    }
                    if (strFailedRefs != null) {
                        errors = new CMException("cmUnresolvedReferences1", new CMException.Parm("refs", strFailedRefs));
                        errors.ErrorLevel = 30000;
                    }
                    CMQueryUtils.safeQueryResultsRelease(existQuery);
                    this.rollbackOpenTransaction();
                }
                catch (CMException ex) {
                    if (ex instanceof CMStoreNotAvailable) {
                        throw ex;
                    }
                    errors = new CMException(ex, "cmFailedToUpdateImportedObj");
                    continue;
                }
                finally {
                    CMQueryUtils.safeQueryResultsRelease(existQuery);
                    this.rollbackOpenTransaction();
                    this.lockMgr_.releaseLocks();
                    if (errors != null) {
                        this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
                        this.lockMgr_.requestLocks(this.spRunHistoryStorePath_);
                        strPath = addDef.searchPath.getOriginalPath();
                        this.deploymentHistory.updateDetail(strPath, addDef.detailId, -1, errors);
                        this.lockMgr_.releaseLocks();
                    }
                    this.serializeAddDef(addDef);
                    continue;
                }
                this.lockMgr_.releaseLocks();
                if (errors != null) {
                    this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
                    this.lockMgr_.requestLocks(this.spRunHistoryStorePath_);
                    strPath = addDef.searchPath.getOriginalPath();
                    this.deploymentHistory.updateDetail(strPath, addDef.detailId, -1, errors);
                    this.lockMgr_.releaseLocks();
                }
                this.serializeAddDef(addDef);
            }
        }
        finally {
            this.lockMgr_.releaseLocks();
            this.importUpdateList_ = null;
        }
    }

    private void mergeMembersProperty(AddDef addDef, CMBaseClassArray currentMembers) {
        CMBaseClassArray importedMembers = (CMBaseClassArray)addDef.get(CMProperty.MEMBERS);
        if (importedMembers == null) {
            addDef.remove(CMProperty.MEMBERS);
        } else if (currentMembers != null) {
            int curSize = currentMembers.getSize();
            for (int i = 0; i < curSize; ++i) {
                CMObjectReference curRef = currentMembers.getReference(i);
                if (curRef == null) continue;
                boolean bFound = false;
                for (int j = 0; j < importedMembers.getSize(); ++j) {
                    CMObjectReference impRef = importedMembers.getReference(j);
                    if (impRef == null || curRef.getObjectID() != impRef.getObjectID()) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                importedMembers.add(curRef);
            }
            addDef.put(CMProperty.MEMBERS, importedMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObjectStoreId(int objectId, String srcStoreId) {
        CMStoreQueryResults results = null;
        ArrayList<CMProperty> updateProps = new ArrayList<CMProperty>();
        ArrayList<Object> updateValues = new ArrayList<Object>();
        updateProps.add(CMProperty.STOREID);
        updateValues.add(srcStoreId.toLowerCase(Locale.ENGLISH));
        try {
            this.store_.beginTransaction();
            CMStoreXPath path = new CMStoreXPath(this.store_.getObjectSearchPath(objectId));
            results = this.store_.executeQuery(path, null, null, 7, 512, null);
            if (results.next()) {
                this.store_.update(results, updateProps, updateValues);
            }
            this.store_.commitTransaction();
        }
        catch (CMException cMException) {
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.rollbackOpenTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMException generateStoreIdNotPreservedWarning(int objectId, String srcStoreId, String dstStoreId) throws CMException {
        CMException firstEx = null;
        CMStoreQueryResults objQuery = null;
        try {
            CMStoreXPath path = CMStoreXPath.fromStoreID(srcStoreId);
            CMProperty[] props = new CMProperty[]{CMProperty.SEARCHPATH};
            this.lockMgr_.requestLocks(path);
            objQuery = this.store_.executeQuery(path, props, null, 9, 128, null);
            if (objQuery.next()) {
                String searchPath = objQuery.getValue(0).toString();
                firstEx = new CMException("cmImportStoreIdConflict", new CMException.Parm("SearchPath", searchPath));
            }
        }
        catch (CMException path) {
        }
        finally {
            if (objQuery != null) {
                objQuery.release();
            }
            this.lockMgr_.releaseLocks();
        }
        CMException secondEx = new CMException(firstEx, "cmImportStoreIdNotPreserved", new CMException.Parm("StoreId1", srcStoreId), new CMException.Parm("SearchPath", this.store_.getObjectSearchPath(objectId)), new CMException.Parm("StoreId2", dstStoreId));
        secondEx.ErrorLevel = 30000;
        return secondEx;
    }

    static CMUpgradeResult callUpgradePlugin(CMUpgradePlugin plugin, CMUpgradeData upgradeData) throws Exception {
        try {
            upgradeTimer.start();
            CMUpgradeResult cMUpgradeResult = plugin.upgrade(upgradeData);
            return cMUpgradeResult;
        }
        finally {
            upgradeTimer.stop(plugin.getClass().getName());
        }
    }

    private void upgradeAfter() {
        if (this.upgradeAfterList_ == null) {
            return;
        }
        for (UpgradeAfterObject upgradeAfterObj : this.upgradeAfterList_) {
            CMException ex;
            if (upgradeAfterObj == null || upgradeAfterObj.upgradeDataMap_ == null) continue;
            CMUpgradePlugin plugin = this.getUpgradePlugin(upgradeAfterObj.pluginInfo_);
            if (plugin == null) {
                CMException ex1 = new CMException("cmMissingPluginInfo");
                CMException ex2 = new CMException((Exception)ex1, "cmFailedToUpgradeObject", new CMException.Parm("Path", upgradeAfterObj.searchPath_));
                this.deploymentHistory.updateDetail(upgradeAfterObj.searchPath_, -1, -1, ex2);
                continue;
            }
            CMUpgradeData upgradeData = new CMUpgradeData();
            upgradeData.setData(upgradeAfterObj.upgradeDataMap_);
            CMUpgradeResult upgradeResult = null;
            try {
                String message;
                upgradeResult = importRequest.callUpgradePlugin(plugin, upgradeData);
                if (upgradeResult == null || (message = upgradeResult.getMessage()) == null || message.length() <= 0) continue;
                ex = new CMException("cmPluginMessage", new CMException.Parm("Path", upgradeAfterObj.searchPath_), new CMException.Parm("Message", message));
                this.deploymentHistory.updateDetail(upgradeAfterObj.searchPath_, -1, -1, ex);
            }
            catch (Exception e) {
                CMIndications.logException(new CMException((Throwable)e, "cmFailedToUpgradeObject", new CMException.Parm("Path", upgradeAfterObj.searchPath_)));
                ex = new CMException(e, "cmFailedToUpgradeObject", new CMException.Parm("Path", upgradeAfterObj.searchPath_));
                this.deploymentHistory.updateDetail(upgradeAfterObj.searchPath_, -1, -1, ex);
            }
        }
    }

    private void ValidateAfter() {
        if (this.validateAfterList_ == null) {
            return;
        }
        for (ValidateAfterObject valAftObj : this.validateAfterList_) {
            try {
                if (valAftObj.objectClass_ != CMObjectClass.SCHEDULE) continue;
                this.ValidateExistingSchedule(valAftObj.objectId_);
            }
            catch (CMException ex) {
                this.deploymentHistory.updateDetail(valAftObj.searchPath_, valAftObj.detailId_, -1, ex);
            }
        }
    }

    private void AddValidateAfterItem(int objectId, String searchPath, CMObjectClass objectClass, int detailId) {
        if (this.validateAfterList_ == null) {
            this.validateAfterList_ = new ArrayList();
        }
        this.validateAfterList_.add(new ValidateAfterObject(objectId, searchPath, objectClass, detailId));
    }

    private void validateNamespaces(XMLElement exportedAccounsEl) throws CMException {
        if (exportedAccounsEl == null) {
            return;
        }
        ArrayList<XMLElement> fileAccountsList = exportedAccounsEl.getChildren();
        if (fileAccountsList != null) {
            boolean namespaceMissing = false;
            HashMap<String, String> namespaceFormatMap = new HashMap<String, String>();
            ListIterator iter = fileAccountsList.listIterator();
            while (iter.hasNext()) {
                XMLElement fileAccountsEl = (XMLElement)iter.next();
                String namespace = fileAccountsEl.getOptionalChildValueWithName("namespace");
                String namespaceFormat = fileAccountsEl.getOptionalChildValueWithName("namespaceFormat");
                if (namespace != null && namespaceFormat != null) {
                    namespaceFormatMap.put(namespace, namespaceFormat);
                    continue;
                }
                namespaceMissing = true;
                break;
            }
            if (!namespaceMissing) {
                this.validateNamespaceFormats(namespaceFormatMap);
                this.namespaceFormatsValidated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateNamespaceFormats(HashMap<String, String> archiveNamespaceFormatMap) throws CMException {
        StringBuffer stringQuery = new StringBuffer();
        stringQuery.append("/");
        stringQuery.append(CMObjectClass.DIRECTORY.getName());
        stringQuery.append("/");
        stringQuery.append(CMObjectClass.NAMESPACE.getName());
        CMStoreXPath namespacesQuery = new CMStoreXPath(stringQuery.toString());
        CMStoreQueryResults results = null;
        try {
            CMProperty[] namespaceProps = new CMProperty[]{CMProperty.SEARCHPATH, CMProperty.NAMESPACEFORMAT};
            results = this.store_.executeQuery(namespacesQuery, namespaceProps, null, 0, 40961, null);
            while (results.next()) {
                Integer archiveNamespaceFormat;
                String namespaceSearchPath = results.getValue(0).toString();
                if (namespaceSearchPath.equalsIgnoreCase("CAMID(\":\")")) continue;
                String namespaceFormatURIString = results.getValue(1).toString();
                AAANamespaceFormatURI namespaceFormatURI = new AAANamespaceFormatURI(namespaceFormatURIString);
                String archiveNamespaceFormatString = archiveNamespaceFormatMap.get(namespaceSearchPath);
                if (archiveNamespaceFormatString == null || (archiveNamespaceFormat = new Integer(archiveNamespaceFormatString)).intValue() == namespaceFormatURI.getVerionId()) continue;
                CMCAMNamespace namespace = CMCAMIDHelper.getNamespaceFromCAMID(CMCAMIDHelper.CAMIDFromSearchPath(namespaceSearchPath));
                throw new CMException("cmIncompatibleNSFormat", new CMException.Parm("Name", namespace.getName()));
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.lockMgr_.releaseLocks();
        }
    }

    @Override
    protected void setNamespace() {
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\">\r\n");
    }

    @Override
    protected void setResponseHeader() {
        this.out.print("\t<");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("importResponse");
    }

    @Override
    protected void setResponseTrailer() {
        this.out.print("\t</");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("importResponse");
        this.out.print(">");
    }

    private boolean createUpgradeList(CMBuildVersion archiveVersion) throws CMException {
        this.perClassUpgrade_ = new HashMap();
        Class[] ctorTypes = new Class[]{importRequest.class};
        Object[] ctorParams = new Object[]{this};
        Class<?>[] declClasses = importRequest.class.getDeclaredClasses();
        for (int i = 0; i < declClasses.length; ++i) {
            if (declClasses[i].getSuperclass() != ImportUpgrade.class) continue;
            try {
                Constructor<?> ctor = declClasses[i].getConstructor(ctorTypes);
                ImportUpgrade upgrade = (ImportUpgrade)ctor.newInstance(ctorParams);
                if (upgrade.version_.compareTo(archiveVersion) < 0 || upgrade.classes_ == null) continue;
                for (int cn = 0; cn < upgrade.classes_.length; ++cn) {
                    String name = upgrade.classes_[cn];
                    ArrayList<ImportUpgrade> list = this.perClassUpgrade_.get(name);
                    if (list == null) {
                        list = new ArrayList();
                        this.perClassUpgrade_.put(name, list);
                    }
                    importRequest.addUpgradeToList(list, upgrade);
                }
                continue;
            }
            catch (Exception e) {
                throw new CMException(e, "cmUnexpectedError");
            }
        }
        if (this.perClassUpgrade_.size() == 0) {
            this.perClassUpgrade_ = null;
        }
        return this.perClassUpgrade_ != null;
    }

    private static void addUpgradeToList(List<ImportUpgrade> list, ImportUpgrade upgrade) {
        for (int i = 0; i < list.size(); ++i) {
            ImportUpgrade item = list.get(i);
            if (item.version_.compareTo(upgrade.version_) <= 0) continue;
            list.add(i, upgrade);
            return;
        }
        list.add(upgrade);
    }

    private boolean applyUpgrades(XMLElement elCls, XMLElement elObj) throws CMException {
        this.upgradeInProgress_ = true;
        if (this.perClassUpgrade_ != null) {
            boolean newName;
            block0: do {
                newName = false;
                ArrayList<ImportUpgrade> list = this.perClassUpgrade_.get(elCls.value_);
                if (list == null) continue;
                for (int i = 0; i < list.size(); ++i) {
                    newName = list.get(i).upgrade(elCls, elObj);
                    if (!newName) continue;
                    if (elCls.value_ != null) continue block0;
                    return false;
                }
            } while (newName);
        }
        this.upgradeInProgress_ = false;
        return true;
    }

    @Override
    protected String upgradeMigratedRoleNames(AddDef addDef, String searchPath) {
        if (!addDef.isImport || addDef.buildVersion == null || !this.buildInRange(new CMBuildVersion(2, 0, 753, 0), new CMBuildVersion(11, 4, 0, 0), addDef.buildVersion)) {
            return null;
        }
        if (!CMDataUpgradeUtils.isRoleRenamed(searchPath)) {
            return null;
        }
        return CMDataUpgradeUtils.getRenamedRole(searchPath, this.getLocalesForRoleRenaming(addDef));
    }

    private boolean buildInRange(CMBuildVersion start, CMBuildVersion end, CMBuildVersion test) {
        return test.compareTo(end) < 0 && test.compareTo(start) > 0;
    }

    private ArrayList<String> getLocalesForRoleRenaming(AddDef addDef) {
        ArrayList<String> locales = new ArrayList<String>();
        locales.add(CMExecutionContext.get().getCurrentUserContentLocale().toString());
        if (!locales.contains(ConfigurationFactory.getConfig().getServerLocale().toString())) {
            locales.add(ConfigurationFactory.getConfig().getServerLocale().toString());
        }
        CMLocalizedStringArray names = addDef.localizedName;
        for (int i = 0; i < names.getSize(); ++i) {
            String locale = names.get(i).getLocale().toString();
            if (locale == null || locales.contains(locale)) continue;
            locales.add(locale);
        }
        return locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParentInfo addDataSourceSchema(ParentInfo parentInfo, XMLElement elBaseModuleObj) throws CMException {
        CMStoreQueryResults addResult = null;
        CMStoreXPath objPath = new CMStoreXPath(parentInfo.path_);
        ParentInfo pInfo = null;
        try {
            String schemaValue;
            this.lockMgr_.releaseLocks();
            objPath.clearLocksHaveBeenObtained();
            objPath.setLockManagerUsageFlag(11);
            this.lockMgr_.requestLocks(objPath);
            ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
            ArrayList<Object> propValues = new ArrayList<Object>();
            if (this.store_ == null) {
                this.store_ = CMExecutionContext.get().getStore();
            }
            CMObjectClass cls = CMObjectClass.DATASOURCESCHEMA;
            String objName = elBaseModuleObj.getChildValueWithName("name");
            XMLElement elProps = elBaseModuleObj.getChildWithName("props");
            String catalogValue = elProps.getOptionalValueFromChildWithNameWithinChildWithName("catalog", "value");
            if (catalogValue != null) {
                propNames.add(this.store_.getProperty("catalog", cls));
                propValues.add(catalogValue);
            }
            if ((schemaValue = elProps.getOptionalValueFromChildWithNameWithinChildWithName("schema", "value")) != null) {
                propNames.add(this.store_.getProperty("schema", cls));
                propValues.add(schemaValue);
            }
            String oldStatus = elProps.getOptionalValueFromChildWithNameWithinChildWithName("status", "value");
            String newStatus = "";
            if (oldStatus != null) {
                if (oldStatus.equalsIgnoreCase("succeeded")) {
                    newStatus = "loaded";
                } else if (oldStatus.equalsIgnoreCase("executing")) {
                    newStatus = "loading";
                } else if (oldStatus.equalsIgnoreCase("failed")) {
                    newStatus = "error";
                }
            } else {
                XMLElement oldProp = elProps.getOptionalChildWithName("status");
                if (oldProp == null) {
                    oldProp = elProps.addChild(null, "status", null, null, null);
                    oldProp.addChild(null, "value", null, null, null);
                }
                XMLElement valueEl = new XMLElement().addChild(null, "value", null, null, null);
                valueEl.value_ = "succeeded";
                oldProp.replaceChild(valueEl);
                newStatus = "loaded";
            }
            propNames.add(this.store_.getProperty("status", cls));
            propValues.add(newStatus);
            propNames.add(this.store_.getProperty("schemaType", cls));
            propValues.add("user");
            propNames.add(this.store_.getProperty("specification", cls));
            propValues.add("{\"dataStatistics\":\"all\",\"excludedTables\":[],\"version\":\"1.0\",\"importPrimaryForeignKeys\":true,\"dataSamplingSize\":1000}");
            this.store_.beginTransaction();
            try {
                addResult = this.store_.addObject(parentInfo.objectId, (CMBasePropertyValue)new CMDbStoreString(objName), cls, propNames, propValues);
            }
            catch (CMStoreDuplicateObject e) {
                throw new CMException("cmDuplicateAdd", new CMException.Parm("Name", objPath.getOriginalPath()));
            }
            catch (CMStoreObjectNotFound e) {
                throw new CMException("cmDeployObjNotExist", new CMException.Parm("Name", objPath.getOriginalPath()));
            }
            addResult.next();
            pInfo = new ParentInfo(addResult.getSearchPath(), cls);
            pInfo.objectId = addResult.getObjectID();
            addResult.release();
            this.store_.commitTransaction();
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
        finally {
            if (addResult != null) {
                addResult.release();
            }
            if (this.store_.inTransaction()) {
                try {
                    this.store_.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            this.lockMgr_.releaseLocks();
            objPath.clearLocksHaveBeenObtained();
        }
        return pInfo;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    private void addVersionInformation(Map<String, String> upgradeDataMap) {
        String editionVersion = CMServlet.getEdition().getName();
        String archiveVersion = this.archiveEdition != null ? this.archiveEdition.getName() : editionVersion;
        upgradeDataMap.put("$VERSION_SOURCE", archiveVersion);
        upgradeDataMap.put("$VERSION_TARGET", editionVersion);
    }

    private CMUpgradePlugin getUpgradePlugin(CMPluginInfo pluginInfo) {
        CMPlugin plugin = CMPluginManager.getInstance().getPlugin(pluginInfo.getPluginID());
        if (plugin != null && plugin instanceof CMUpgradePlugin) {
            return (CMUpgradePlugin)plugin;
        }
        return null;
    }

    class UserInterfacesUpgrade
    extends ImportUpgrade {
        public UserInterfacesUpgrade() {
            this.version_ = new CMBuildVersion(2, 0, 965, 0);
            this.classes_ = new String[]{"package"};
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            XMLElement elUserInterfacesValue;
            XMLElement elProps = elObj.getChildWithName("props");
            XMLElement elUserInterfaces = elProps.getOptionalChildWithName("userInterfaces");
            if (elUserInterfaces != null) {
                elUserInterfacesValue = elUserInterfaces.getOptionalChildWithName("value");
                if (elUserInterfacesValue != null && elUserInterfacesValue.getChildren() != null) {
                    return false;
                }
                elProps.deleteChildWithName("userInterfaces");
                elUserInterfaces = null;
            }
            elUserInterfacesValue = elProps.addChild((CMSOAPConstants.XMLNamespace)null, "userInterfaces", null, null).addChild((CMSOAPConstants.XMLNamespace)null, "value", null, null);
            String[] userInterfaces = new String[]{"eventStudio", "queryStudio", "reportStudio"};
            for (int i = 0; i < userInterfaces.length; ++i) {
                elUserInterfacesValue.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "uiComponentEnum", userInterfaces[i]);
            }
            return false;
        }
    }

    class CanUseSDKCapabilityUpgrade
    extends ImportUpgrade {
        public CanUseSDKCapabilityUpgrade() {
            this.version_ = new CMBuildVersion(2, 0, 805, 0);
            this.classes_ = new String[]{"securedFunction"};
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            String[] path = new String[]{"props", "userCapability", "value"};
            XMLElement elCapability = elObj.getOptionalChildWithPath(path);
            if (elCapability != null && "canUseSDK".equals(elCapability.value_)) {
                elCls.value_ = null;
                return true;
            }
            return false;
        }
    }

    class ScheduleUpgrade
    extends ImportUpgrade {
        public ScheduleUpgrade() {
            this.version_ = new CMBuildVersion(2, 0, 445, 0);
            this.classes_ = new String[]{"schedule"};
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            XMLElement elProps = elObj.getChildWithName("props");
            XMLElement elScheReplStatus = elProps.getOptionalChildWithName("_scheduleReplicationStatus");
            if (elScheReplStatus != null) {
                elProps.deleteChildWithName("_scheduleReplicationStatus");
            }
            return false;
        }
    }

    class ContentAdministrationUpgrade
    extends ImportUpgrade {
        public ContentAdministrationUpgrade() {
            this.version_ = new CMBuildVersion(2, 0, 770, 0);
            this.classes_ = new String[]{"securedFeature"};
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            if (elCls == null || elObj == null) {
                return false;
            }
            XMLElement elProps = elObj.getOptionalChildWithName("props");
            if (elProps == null) {
                return false;
            }
            String userCapability = elProps.getOptionalValueFromChildWithNameWithinChildWithName("userCapability", "value");
            if (userCapability == null) {
                return false;
            }
            if (!userCapability.equalsIgnoreCase("canUseContentStoreTool")) {
                return false;
            }
            XMLElement elPolicies = elProps.getOptionalChildWithName("policies");
            if (elPolicies == null) {
                return false;
            }
            XMLElement elPolicyArray = elPolicies.getChildWithName("value");
            if (elPolicyArray == null || elPolicyArray.children_ == null) {
                return false;
            }
            boolean foundReportAdmin = false;
            boolean foundMetricsAdmin = false;
            boolean foundControllerAdmin = false;
            for (XMLElement policy : elPolicyArray.children_) {
                XMLElement elSecurityObj;
                String searchPath;
                if (policy == null || policy.children_ == null || (searchPath = (elSecurityObj = policy.getChildWithName("securityObject")).getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value")) == null) continue;
                if (searchPath.indexOf("Report Administrators") != -1) {
                    foundReportAdmin = true;
                    continue;
                }
                if (searchPath.indexOf("Metrics Administrators") != -1) {
                    foundMetricsAdmin = true;
                    continue;
                }
                if (searchPath.indexOf("Controller Administrators") == -1) continue;
                foundControllerAdmin = true;
            }
            String[] actions = new String[]{"traverse", "execute"};
            if (!foundReportAdmin) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Report Administrators\")", actions);
            }
            if (!foundMetricsAdmin) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Metrics Administrators\")", actions);
            }
            if (!foundControllerAdmin) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Controller Administrators\")", actions);
            }
            return false;
        }
    }

    class DeploymentDataUpgrade
    extends ImportUpgrade {
        public DeploymentDataUpgrade() {
            if (importRequest.this.upgradeClassMap_ == null || importRequest.this.upgradeClassMap_.isEmpty()) {
                this.version_ = new CMBuildVersion(0, 0, 0, 0);
                this.classes_ = new String[0];
            } else {
                this.classes_ = importRequest.this.upgradeClassMap_.keySet().toArray(new String[0]);
                this.version_ = new CMBuildVersion(999999, 0, 0, 0);
            }
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            if (elCls == null || elCls.value_ == null) {
                return false;
            }
            if (importRequest.this.upgradeClassMap_ == null || importRequest.this.upgradeClassMap_.isEmpty()) {
                return false;
            }
            String className = elCls.value_;
            if (!importRequest.this.upgradeClassMap_.containsKey(className)) {
                return false;
            }
            boolean skipObject = false;
            for (CMPluginInfo pluginInfo : importRequest.this.upgradeClassMap_.get(className)) {
                try {
                    skipObject = this.upgradeForOnePlugin(className, elObj, pluginInfo);
                    if (!skipObject) continue;
                    elCls.value_ = null;
                    return true;
                }
                catch (Exception ex) {
                    CMIndications.logException(ex, "Plugin ID: " + pluginInfo.getPluginID());
                    String objectName = elObj.getChildValueWithName("name");
                    CMDataUpgradeException error = new CMDataUpgradeException(ex, objectName);
                    String searchPath = this.buildSearchPath(className, elObj);
                    CMAncestors ancestors = this.getNameOnlyAncestors(searchPath);
                    importRequest.this.deploymentHistory.safeAddDetail(searchPath, 0, null, objectName, null, ancestors, 7, error, false);
                }
            }
            return false;
        }

        private CMAncestors getNameOnlyAncestors(String searchPath) {
            CMStoreXPath path;
            CMDbStoreAncestors ancestors = new CMDbStoreAncestors();
            if (searchPath == null) {
                return null;
            }
            try {
                path = new CMStoreXPath(searchPath);
            }
            catch (Exception ex) {
                return null;
            }
            for (int i = 0; i < path.size() - 1; ++i) {
                CMStoreXPathStep step = (CMStoreXPathStep)path.stepAt(i);
                String objName = step.getName();
                if (objName != null) {
                    ancestors.addChild(objName, "", "", "");
                    continue;
                }
                if (step.classpredicate_ != null && step.classpredicate_.getName() != null) {
                    ancestors.addChild(step.classpredicate_.getName(), "", "", "");
                    continue;
                }
                return null;
            }
            return ancestors;
        }

        private boolean upgradeForOnePlugin(String className, XMLElement elObj, CMPluginInfo pluginInfo) throws CMException {
            HashMap<String, String> upgradeDataMap = null;
            List upgradePropList = pluginInfo.getPropList();
            CMObjectClass objectClass = importRequest.this.store_.getObjectClasses().getClassByName(className);
            if (objectClass == null) {
                throw new CMException("cmBadClass", new CMException.Parm("Class", className));
            }
            XMLElement xmlElmProps = elObj.getChildWithName("props");
            xmlElmProps.xsiType_ = className;
            if (!xmlElmProps.hasChildren()) {
                return false;
            }
            CMProperty currentProperty = null;
            RequestAttachment attachFile = null;
            boolean requireSearchPath = false;
            String searchPath = this.buildSearchPath(className, elObj);
            for (String propName : upgradePropList) {
                XMLElement xmlElProp;
                if (propName == null || propName.length() == 0) continue;
                if (propName.equalsIgnoreCase("searchPath")) {
                    requireSearchPath = true;
                }
                if ((xmlElProp = xmlElmProps.getOptionalChildWithName(propName)) == null || xmlElProp.isNil_) {
                    if (!requireSearchPath || searchPath == null) continue;
                    if (upgradeDataMap == null) {
                        upgradeDataMap = new HashMap();
                    }
                    XMLElement searchPathEl = new XMLElement().addChild(null, "searchPath", CMSOAPConstants.NS_BIBUS, "stringProp");
                    XMLElement valueEl = searchPathEl.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_STRING.getName());
                    valueEl.value_ = searchPath;
                    upgradeDataMap.put("searchPath", searchPathEl.makeXML(null, true, false));
                    continue;
                }
                XMLElement xmlElValue = xmlElProp.getOptionalChildWithName("value");
                if (xmlElValue == null) continue;
                currentProperty = objectClass.getProperty(xmlElProp.name_);
                if (currentProperty == null) {
                    throw new CMException("cmBadProperty", new CMException.Parm("Property", xmlElProp.name_));
                }
                if (upgradeDataMap == null) {
                    upgradeDataMap = new HashMap();
                }
                if (CMDataUpgradeUtils.isSpecialPropForDataUpgrade(currentProperty.getName())) {
                    if (currentProperty == CMProperty.MODEL) {
                        try {
                            attachFile = this.getAttachmentFromPropValue(xmlElValue, currentProperty);
                            String modelValue = this.buildPropValueFromAttachment(attachFile, currentProperty);
                            if (modelValue == null || modelValue.length() == 0) continue;
                            upgradeDataMap.put(xmlElProp.name_, modelValue);
                            continue;
                        }
                        catch (CMException ex) {
                            throw new CMException((Exception)ex, "cmFailedToUpgradeProperty", new CMException.Parm("Property", currentProperty.getName()));
                        }
                    }
                    if (xmlElValue.value_ == null) continue;
                    upgradeDataMap.put(xmlElProp.name_, xmlElValue.value_);
                    continue;
                }
                String xmlString = xmlElValue.makeXML(null, true, false);
                if (xmlString == null || xmlString.length() == 0) continue;
                StringBuffer propStrBuf = new StringBuffer();
                propStrBuf.append("<");
                propStrBuf.append(currentProperty.getName());
                propStrBuf.append(" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"");
                propStrBuf.append(">");
                propStrBuf.append(xmlString);
                propStrBuf.append("</");
                propStrBuf.append(currentProperty.getName());
                propStrBuf.append(">");
                upgradeDataMap.put(xmlElProp.name_, propStrBuf.toString());
            }
            if (upgradeDataMap == null) {
                upgradeDataMap = new HashMap<String, String>();
            }
            upgradeDataMap.put("UPGRADE_FROM", "DEPLOYMENT");
            upgradeDataMap.put("objectClass", this.createObjectClassProperty(className));
            importRequest.this.addVersionInformation(upgradeDataMap);
            if (pluginInfo.isPostImport()) {
                if (importRequest.this.upgradeAfterList_ == null) {
                    importRequest.this.upgradeAfterList_ = new ArrayList();
                }
                UpgradeAfterObject upgradeAfterObj = new UpgradeAfterObject(pluginInfo, upgradeDataMap, searchPath);
                importRequest.this.upgradeAfterList_.add(upgradeAfterObj);
                return false;
            }
            CMUpgradePlugin plugin = importRequest.this.getUpgradePlugin(pluginInfo);
            if (plugin == null) {
                return false;
            }
            boolean setReportUpgradeFlag = false;
            boolean setPluginVersion = false;
            if (pluginInfo.isReportQueryPlugin()) {
                setReportUpgradeFlag = pluginInfo.getReportUpgradeFlag();
                setPluginVersion = pluginInfo.getPluginVersionFlag();
                if (setReportUpgradeFlag) {
                    upgradeDataMap.put("UPGRADE_REPORT", "");
                }
                if (setPluginVersion) {
                    upgradeDataMap.put("PLUGIN_VERSION", pluginInfo.getPluginVersion());
                }
            }
            CMUpgradeData upgradeData = new CMUpgradeData();
            upgradeData.setData(upgradeDataMap);
            CMUpgradeResult upgradeResult = null;
            try {
                upgradeResult = importRequest.callUpgradePlugin(plugin, upgradeData);
                if (upgradeResult != null) {
                    CMDataUpgradeException error;
                    int status = upgradeResult.getUpgradeStatus();
                    if (status == 1) {
                        Map dataMap = upgradeResult.getData();
                        if (dataMap == null || dataMap.isEmpty()) {
                            return false;
                        }
                        for (String propName : upgradePropList) {
                            XMLElement oldProp;
                            XMLElement xmlEl;
                            if (!dataMap.containsKey(propName)) continue;
                            currentProperty = objectClass.getProperty(propName);
                            if (currentProperty == null) {
                                throw new CMException("cmBadProperty", new CMException.Parm("Property", propName));
                            }
                            String xmlString = (String)dataMap.get(propName);
                            if (CMDataUpgradeUtils.isSpecialPropForDataUpgrade(currentProperty.getName())) {
                                if (currentProperty == CMProperty.MODEL) {
                                    this.setAttachmentFromPropValue(attachFile, xmlString, xmlElmProps, propName);
                                    continue;
                                }
                                XMLElement propEl = xmlElmProps.getChildWithName(propName);
                                propEl.deleteChildWithName("value");
                                propEl.addChild(null, "value", null, "string", xmlString);
                                continue;
                            }
                            Object valueEl = null;
                            XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(xmlString);
                            if (rootEl != null && (xmlEl = rootEl.getChild(0)) != null) {
                                valueEl = xmlEl.getOptionalChildWithName("value");
                            }
                            if (valueEl == null) {
                                valueEl = new XMLElement().addChild(null, "value", null, null, null);
                                ((XMLElement)valueEl).isNil_ = true;
                            }
                            if ((oldProp = xmlElmProps.getOptionalChildWithName(propName)) == null) {
                                oldProp = xmlElmProps.addChild(null, propName, null, null, null);
                                oldProp.addChild(null, "value", null, null, null);
                            }
                            oldProp.replaceChild((XMLElement)valueEl);
                            if (currentProperty != CMProperty.NAME) continue;
                            CMDbStoreLocalizedStringArray objectNames = MultilingualProperty.readTokenWithLocaleMapping((XMLElement)valueEl);
                            CMStringLocale currLocale = CMExecutionContext.get().getCurrentUserContentLocale();
                            String newName = objectNames.getDefault(currLocale);
                            XMLElement nameEl = elObj.getSingleChildWithName("name");
                            if (nameEl == null || newName == null) continue;
                            nameEl.value_ = newName;
                        }
                    }
                    List msgs = upgradeResult.getMessages();
                    String name = elObj.getChildValueWithName("name");
                    CMAncestors ancestors = this.getNameOnlyAncestors(searchPath);
                    if (msgs != null) {
                        int parentDetailId = -1;
                        for (CMUpgradeMessage msgObj : msgs) {
                            String errorMessagePath = searchPath;
                            if (errorMessagePath == null) {
                                errorMessagePath = name;
                            }
                            CMException ex = new CMException("cmPluginMessage", new CMException.Parm("Path", errorMessagePath), new CMException.Parm("Message", msgObj.getMessage()));
                            ex.ErrorLevel = msgObj.getSeverity();
                            String errCode = null;
                            errCode = status == 1 ? "cmDataUpgraded" : "cmDataNotUpgraded";
                            CMDataUpgradeException error2 = new CMDataUpgradeException((Exception)ex, searchPath, errCode);
                            error2.ErrorLevel = msgObj.getSeverity();
                            if (parentDetailId == -1) {
                                parentDetailId = 0;
                            }
                            parentDetailId = importRequest.this.deploymentHistory.safeAddDetail(searchPath, parentDetailId, null, name, null, ancestors, 7, error2, false);
                        }
                    } else if (status == 2) {
                        CMException ex = new CMException("cmPluginNoMessage", new CMException.Parm("Path", searchPath));
                        ex.ErrorLevel = 40000;
                        error = new CMDataUpgradeException(ex, searchPath);
                        error.ErrorLevel = 40000;
                        importRequest.this.deploymentHistory.safeAddDetail(searchPath, 0, null, name, null, ancestors, 7, error, false);
                    }
                    if (status == 3) {
                        CMException ex = new CMException("cmPluginSkipObject", new CMException.Parm("Path", searchPath), new CMException.Parm("PluginID", pluginInfo.getPluginID()));
                        ex.ErrorLevel = 20000;
                        error = new CMDataUpgradeException(ex, searchPath);
                        error.ErrorLevel = 20000;
                        importRequest.this.deploymentHistory.safeAddDetail(searchPath, 0, null, name, null, ancestors, 7, error, false);
                        return true;
                    }
                }
            }
            catch (Throwable ex) {
                CMIndications.logException(new CMException(ex, "cmFailedToUpgradeObject", new CMException.Parm("Path", searchPath)));
                throw new CMException(ex, "cmFailedToUpgradeObject", new CMException.Parm("Path", searchPath));
            }
            return false;
        }

        private String createObjectClassProperty(String clsName) {
            StringBuilder buf = new StringBuilder();
            buf.append("<objectClass xsi:type=\"bus:classEnumProp\"><value xsi:type=\"bus:classEnum\">");
            buf.append(clsName);
            buf.append("</value></objectClass>");
            return buf.toString();
        }

        private String buildSearchPath(String className, XMLElement elObj) throws CMException {
            String searchPath = null;
            String path = elObj.getOptionalChildValueWithName("path");
            if (path != null && path.length() > 0) {
                searchPath = path;
            } else if (importRequest.this.parentMap_ != null) {
                long parentId = elObj.getChildLongValueWithName("parentId");
                String objectName = elObj.getChildValueWithName("name");
                ParentInfo pInfo = (ParentInfo)importRequest.this.parentMap_.get(parentId);
                if (pInfo != null) {
                    StringBuffer searchPathBuf = new StringBuffer();
                    searchPathBuf.append(pInfo.path_);
                    searchPathBuf.append("/");
                    searchPathBuf.append(className);
                    searchPathBuf.append("[@");
                    searchPathBuf.append(CMProperty.NAME.getName());
                    searchPathBuf.append("=");
                    searchPathBuf.append(CMStoreXPath.attributeQuoteString(objectName));
                    searchPathBuf.append("]");
                    searchPath = searchPathBuf.toString();
                }
            }
            return searchPath;
        }

        private RequestAttachment getAttachmentFromPropValue(XMLElement xmlElValue, CMProperty currentProperty) throws CMException {
            String href = xmlElValue.getAttribute("href");
            if (href == null) {
                throw new CMException("cmPropMissingAttr", new CMException.Parm("Property", currentProperty.getName()), new CMException.Parm("Attribute", "href"));
            }
            if (href.substring(0, 4).compareToIgnoreCase("cid:") != 0) {
                throw new CMException("cmBadProp", new CMException.Parm("Value", currentProperty.getName()));
            }
            Object attach = importRequest.this.manager.getRequestAttachments(href = href.substring(4));
            if (attach == null) {
                throw new CMException("cmBadPropAttachment", new CMException.Parm("Property", currentProperty.getName()));
            }
            if (!(attach instanceof RequestImportAttachment) && !(attach instanceof RequestImportDataAttachment)) {
                throw new CMException("cmBadPropAttachment", new CMException.Parm("Property", currentProperty.getName()));
            }
            return (RequestAttachment)attach;
        }

        private String buildPropValueFromAttachment(RequestAttachment attachFile, CMProperty currentProperty) throws CMException {
            InputStream inputStream = null;
            String propValue = null;
            try {
                inputStream = attachFile.getTempInputStream();
                String xmlString = CMDataUpgradeUtils.getValueFromProp(currentProperty, inputStream);
                if (xmlString != null && xmlString.length() != 0) {
                    propValue = xmlString;
                }
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmBadPropAttachment", new CMException.Parm("Property", currentProperty.getName()));
            }
            finally {
                importRequest.this.closeStreamQuietly(inputStream);
            }
            return propValue;
        }

        private void setAttachmentFromPropValue(RequestAttachment attachFile, String xmlString, XMLElement xmlElmProps, String propName) throws CMException {
            if (attachFile != null) {
                attachFile.DeleteTheFileIfExists();
                attachFile = null;
            }
            try {
                String attachFileName = CMDateUtils.getIsoDate();
                long dataSize = new Long(xmlString.length());
                RequestImportAttachment attachment = new RequestImportAttachment(attachFileName, dataSize, false, true, false);
                String href = "cid:" + attachFileName;
                importRequest.this.addRequestAttachment(attachFileName, attachment);
                attachment.write(xmlString);
                attachment.finishWriting();
                XMLElement propEl = xmlElmProps.getChildWithName(propName);
                XMLElement valueEl = propEl.getChildWithName("value");
                valueEl.replaceAttribute("href", href);
                propEl.replaceChild(valueEl);
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmFailedToCreateAttachment", new CMException.Parm("Property", propName));
            }
        }
    }

    class RetentionsForHistoryUpgrade
    extends ImportUpgrade {
        public RetentionsForHistoryUpgrade() {
            this.version_ = new CMBuildVersion(2, 0, 442, 0);
            this.classes_ = new String[]{"query", "report", "reportView", "jobDefinition", "importDeployment", "exportDeployment"};
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            String[] path = new String[]{"props", "retentions", "value"};
            XMLElement elRetentions = elObj.getOptionalChildWithPath(path);
            if (elRetentions == null || elRetentions.getChildren() == null) {
                return false;
            }
            for (XMLElement el : elRetentions.getChildren()) {
                if ((el = el.getOptionalChildWithName("objectClass")) == null || el.value_ == null || !el.value_.equals("reportHistory") && !el.value_.equals("jobHistory") && !el.value_.equals("deploymentHistory")) continue;
                el.value_ = CMObjectClass.HISTORY.getName();
            }
            return false;
        }
    }

    class HistoryUpgrade
    extends ImportUpgrade {
        public HistoryUpgrade() {
            this.version_ = new CMBuildVersion(2, 0, 442, 0);
            this.classes_ = new String[]{"jobHistory", "reportHistory", "deploymentHistory"};
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            XMLElement elProps = elObj.getChildWithName("props");
            elProps.deleteChildWithName("executionDetails");
            if ("jobHistory".equals(elCls.value_)) {
                elProps.deleteChildWithName("related");
            } else if ("reportHistory".equals(elCls.value_)) {
                elProps.deleteChildWithName("output");
            }
            elCls.value_ = CMObjectClass.HISTORY.getName();
            return true;
        }
    }

    class ReportModelUpgrade
    extends ImportUpgrade {
        public ReportModelUpgrade() {
            this.version_ = AdvancedSettings.DEPLOYMENTREPORTMODELUPGRADE ? new CMBuildVersion(999999, 0, 0, 0) : new CMBuildVersion(2, 0, 428, 0);
            this.classes_ = new String[]{"query", "report", "reportVersion", "analysis"};
        }

        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            String packagePath = null;
            XMLElement elProps = elObj.getChildWithName("props");
            XMLElement elModel = elProps.getOptionalChildWithName("metadataModelPackage");
            if (elModel != null) {
                return false;
            }
            String[] path = new String[]{"metadataModel", "value", "item", "searchPath", "value"};
            elModel = elProps.getOptionalChildWithPath(path);
            if (elModel != null && (packagePath = elModel.value_) != null) {
                int index = packagePath.indexOf("/model[");
                packagePath = index != -1 ? packagePath.substring(0, index) : packagePath + "/..";
            }
            if (packagePath != null) {
                elProps.addChild((CMSOAPConstants.XMLNamespace)null, "metadataModelPackage", null, null).addChild((CMSOAPConstants.XMLNamespace)null, "value", null, null).addChild((CMSOAPConstants.XMLNamespace)null, "item", null, null).addChild(null, "searchPath", CMSOAPConstants.NS_BIBUS, "stringProp").addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "string", packagePath);
            }
            return false;
        }
    }

    class DeploymentFolderUpgrade
    extends ImportUpgrade {
        public DeploymentFolderUpgrade() {
            this.version_ = new CMBuildVersion(2, 0, 399, 0);
            this.classes_ = new String[]{"exportDeploymentFolder", "importDeploymentFolder"};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            elCls.value_ = CMObjectClass.ADMINFOLDER.getName();
            int parentId = elObj.getChildIntValueWithName("parentId");
            if (parentId == 0) {
                elObj.getChildValueWithName("name");
                String adminFolder = "/" + CMObjectClass.ADMINFOLDER;
                CMStoreQueryResults parentQuery = null;
                try {
                    CMStoreXPath parentPath = new CMStoreXPath(adminFolder);
                    importRequest.this.lockMgr_.requestLocks(parentPath);
                    parentQuery = importRequest.this.store_.executeQuery(parentPath, null, null, 9, 1, null);
                    if (parentQuery.next()) {
                        ParentInfo pInfo = new ParentInfo(parentQuery.getSearchPath(), CMObjectClass.ADMINFOLDER);
                        pInfo.objectId = parentQuery.getObjectID();
                        importRequest.this.parentMap_.put(0L, pInfo);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (parentQuery != null) {
                        parentQuery.release();
                    }
                    importRequest.this.lockMgr_.releaseLocks();
                }
                elObj.deleteChildWithName("path");
            }
            return true;
        }
    }

    class BaseModuleUpgrade
    extends ImportUpgrade {
        public BaseModuleUpgrade() {
            this.version_ = new CMBuildVersion(11, 0, 5, 21);
            this.classes_ = new String[]{"baseModule"};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean upgrade(XMLElement elCls, XMLElement elObj) throws CMException {
            long parentId = elObj.getChildIntValueWithName("parentId");
            ParentInfo pInfo = (ParentInfo)importRequest.this.parentMap_.get(parentId);
            if (pInfo == null) {
                return false;
            }
            CMObjectClass parentCls = pInfo.objectClass_;
            if (parentCls != CMObjectClass.DATASOURCECONNECTION) {
                return false;
            }
            String parentPath = pInfo.path_;
            String objName = elObj.getChildValueWithName("name");
            String dssPath = parentPath + "/dataSourceSchema[@name=\"" + objName + "\"]";
            if (importRequest.this.store_ == null) {
                importRequest.this.store_ = CMExecutionContext.get().getStore();
            }
            ParentInfo newParentInfo = null;
            CMStoreQueryResults queryResult = null;
            try {
                CMStoreXPath objXPath = new CMStoreXPath(dssPath);
                importRequest.this.lockMgr_.requestLocks(objXPath);
                queryResult = importRequest.this.store_.executeQuery(objXPath, null, null, 9, 1, null);
                if (queryResult.next()) {
                    newParentInfo = new ParentInfo(queryResult.getSearchPath(), CMObjectClass.DATASOURCESCHEMA);
                    newParentInfo.objectId = queryResult.getObjectID();
                }
            }
            catch (Exception e) {
                CMIndications.logException(e);
            }
            finally {
                if (queryResult != null) {
                    queryResult.release();
                }
                importRequest.this.lockMgr_.releaseLocks();
            }
            if (newParentInfo == null) {
                newParentInfo = importRequest.this.addDataSourceSchema(pInfo, elObj);
            }
            if (newParentInfo != null) {
                importRequest.this.parentMap_.put(Long.valueOf(newParentInfo.objectId), newParentInfo);
                elObj.setChildValueWithName("parentId", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_STRING.getName(), Integer.toString(newParentInfo.objectId));
                elObj.deleteChildWithName("path");
            }
            return false;
        }
    }

    abstract class ImportUpgrade {
        public CMBuildVersion version_;
        public String[] classes_;

        ImportUpgrade() {
        }

        public abstract boolean upgrade(XMLElement var1, XMLElement var2) throws CMException;
    }

    private static class PathInfo {
        String searchPath;
        String queryPath;

        PathInfo(String searchPath, String queryPath) {
            this.searchPath = searchPath;
            this.queryPath = queryPath;
        }
    }

    static class ParentInfo {
        public String path_;
        public CMObjectClass objectClass_;
        public int detailObjectId = 0;
        public int objectId = -1;

        ParentInfo(String path, CMObjectClass objectClass) {
            this.path_ = path;
            this.objectClass_ = objectClass;
        }
    }

    static class ValidateAfterObject {
        public int objectId_;
        public String searchPath_;
        public int detailId_;
        public CMObjectClass objectClass_;

        public ValidateAfterObject(int objectId, String searchPath, CMObjectClass objectClass, int detailId) {
            this.objectId_ = objectId;
            this.searchPath_ = searchPath;
            this.objectClass_ = objectClass;
            this.detailId_ = detailId;
        }
    }

    static class UpgradeAfterObject {
        public CMPluginInfo pluginInfo_;
        public Map<String, String> upgradeDataMap_;
        public String searchPath_;

        public UpgradeAfterObject(CMPluginInfo pluginInfo, Map<String, String> upgradeDataMap, String searchPath) {
            if (pluginInfo == null) {
                throw new IllegalArgumentException("cmMissingPluginInfo");
            }
            this.pluginInfo_ = pluginInfo;
            this.upgradeDataMap_ = upgradeDataMap;
            this.searchPath_ = searchPath;
        }
    }
}

