/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class listArchives
extends Deployment {
    public listArchives(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.setDeploymentIPF(false);
    }

    @Override
    public boolean doAction(XMLElement requestElement, String tabPrefix) throws CMException {
        CMExecutionContext currContext = CMExecutionContext.get();
        if (!currContext.hasCapability("canUseContentStoreTool")) {
            throw new CMException("cmInsufficientPermissionsForRequest");
        }
        File deploymentFolder = null;
        String[] fileList = null;
        try {
            deploymentFolder = listArchives.getDeploymentFolder();
            fileList = deploymentFolder.list();
        }
        catch (CMException cMException) {
            // empty catch block
        }
        int count = 0;
        String tabPrefix1 = tabPrefix + "\t";
        String stringPropPrefix = CMPropertyTypes.XML_STRING.getNamespacePrefix();
        String stringPropName = CMPropertyTypes.XML_STRING.getName();
        Object[] fileNames = null;
        if (fileList != null) {
            int extSize = ".zip".length();
            ArrayList<String> files = new ArrayList<String>();
            fileNames = new String[fileList.length];
            for (int i = 0; i < fileList.length; ++i) {
                String fileName = fileList[i];
                File theFile = new File(deploymentFolder, fileName);
                if (!theFile.getName().endsWith(".zip")) continue;
                fileName = fileName.substring(0, fileName.length() - extSize);
                files.add(fileName);
            }
            if (files.size() > 0) {
                fileNames = files.toArray();
                count = fileNames.length;
                Arrays.sort(fileNames);
            }
        }
        this.emit(tabPrefix);
        this.emitArrayElement(this.getArrayElementName(), stringPropPrefix, stringPropName, count);
        if (fileNames != null) {
            for (int i = 0; i < count; ++i) {
                this.emit(tabPrefix1);
                this.emitElement("item", stringPropPrefix, stringPropName, XMLUtils.encode((String)((String)fileNames[i])));
            }
        }
        this.emit(tabPrefix);
        this.emitEndElement(this.getArrayElementName());
        return true;
    }

    @Override
    protected void setNamespace() {
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\">\r\n");
    }

    @Override
    protected void setResponseHeader() {
        this.out.print("\t<");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("listArchivesResponse");
    }

    @Override
    protected void setResponseTrailer() {
        this.out.print("\t</");
        this.out.print(this.getCMPrefixString());
        this.out.print(":");
        this.out.print("listArchivesResponse");
        this.out.print(">");
    }

    public void lockArchive(String archive) throws CMException {
    }

    @Override
    protected String getArrayElementName() {
        return "archiveList";
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

