/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.backgroundTask.BackgroundTasksManager;
import com.cognos.cm.backgroundTask.IBackgroundTasksManager;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueStatus;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueStatusInfo;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMIndentedPrintStream;
import java.util.TreeSet;
import org.dom4j.Element;

public class manageBackgroundTasks
extends RequestHandler {
    private XMLElement manageTasksXML_;
    private boolean reloadConfiguration;
    private IBackgroundTasksManager taskManager = BackgroundTasksManager.getManager();
    private ICMQueueManager queueManager = CMQueueManager.getManager();

    public manageBackgroundTasks(CMStore store) {
        super(store);
    }

    protected String getResponseString() {
        return "manageBackgroundTasksResponse";
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!ctx.getCurrentUserIsAdministrator()) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "manageBackgroundTasks"));
        }
        boolean rc = false;
        CMIndentedPrintStream out = new CMIndentedPrintStream(this.oStream);
        out.indent();
        out.print(baLT);
        out.print(manageBackgroundTasks.s2ba(this.getCMPrefixString()));
        out.print(baColon);
        out.print(this.getResponseString());
        out.print(" xmlns:");
        out.print("cm");
        out.print("=\"");
        out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            out.print("\"");
            out.print(" xmlns:");
            out.print("cm1");
            out.print("=\"");
            out.print(this.getCMS_V1Namespace());
        }
        out.print("\">\r\n");
        out.println();
        out.indent();
        rc = this.doAction(out);
        out.unindent();
        out.print(baLT_Slash);
        out.print(manageBackgroundTasks.s2ba(this.getCMPrefixString()));
        out.print(baColon);
        out.print(this.getResponseString());
        out.print(baGT);
        out.unindent();
        out.flush();
        return rc;
    }

    private boolean doAction(CMIndentedPrintStream out) throws CMException {
        if (this.manageTasksXML_.name_.equalsIgnoreCase("startManager")) {
            this.startManager(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("stopManager")) {
            this.stopManager(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("startAllTasks")) {
            this.startAllTasks(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("stopAllTasks")) {
            this.stopAllTasks(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("startTask")) {
            this.startTask(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("stopTask")) {
            this.stopTask(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("taskRunningState")) {
            this.taskRunningState(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("waitForTaskCompletion")) {
            this.waitForTaskCompletion(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("startQueueManager")) {
            this.startQueueManager(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("stopQueueManager")) {
            this.stopQueueManager(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("getQueuesStatus")) {
            this.getQueuesStatus(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("getQueueStatus")) {
            this.getQueueStatus(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("cleanQueue")) {
            this.cleanQueue(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("getTasksInformation")) {
            this.getTasksInformation(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("getTaskInformation")) {
            this.getTaskInformation(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("startBlackoutPeriod")) {
            this.startBlackoutPeriod(out);
        } else if (this.manageTasksXML_.name_.equalsIgnoreCase("stopBlackoutPeriod")) {
            this.stopBlackoutPeriod(out);
        } else {
            throw new IllegalStateException("Missing command element");
        }
        return true;
    }

    private void cleanQueue(CMIndentedPrintStream out) throws CMException {
        String queueName = this.getRequiredAttribute(this.manageTasksXML_, "name");
        this.queueManager.cleanQueue(this.getStore(), queueName);
    }

    private void getQueueStatus(CMIndentedPrintStream out) throws CMException {
        String queueName = this.getRequiredAttribute(this.manageTasksXML_, "name");
        this.printOutQueueStatus(out, queueName);
    }

    private void stopBlackoutPeriod(CMIndentedPrintStream out) throws CMException {
        this.taskManager.stopBlackoutPeriod();
    }

    private void startBlackoutPeriod(CMIndentedPrintStream out) throws CMException {
        this.taskManager.startBlackoutPeriod();
    }

    private void waitForTaskCompletion(CMIndentedPrintStream out) throws CMException {
        String taskName = this.getRequiredAttribute(this.manageTasksXML_, "name");
        ((CMQueueManager)this.queueManager).stopBlockingQueues();
        ((BackgroundTasksManager)this.taskManager).waitForTaskCompletion(taskName);
    }

    private void taskRunningState(CMIndentedPrintStream out) throws CMException {
        String taskName = this.getRequiredAttribute(this.manageTasksXML_, "name");
        out.println("<taskInformation>");
        out.indent();
        out.print("<taskName>");
        out.print(taskName);
        out.println("</taskName>");
        out.print("<runningState>");
        out.print(this.getTaskRunningState(taskName));
        out.println("</runningState>");
        out.unindent();
        out.println("</taskInformation>");
    }

    private void stopTask(CMIndentedPrintStream out) throws CMException {
        String taskName = this.getRequiredAttribute(this.manageTasksXML_, "name");
        this.taskManager.stopTask(taskName);
    }

    private void startTask(CMIndentedPrintStream out) throws CMException {
        String taskName = this.getRequiredAttribute(this.manageTasksXML_, "name");
        this.taskManager.startTask(taskName, this.reloadConfiguration);
    }

    private void stopAllTasks(CMIndentedPrintStream out) throws CMException {
        this.taskManager.stopAllTasks();
    }

    private void startAllTasks(CMIndentedPrintStream out) throws CMException {
        this.taskManager.startAllTasks(this.reloadConfiguration);
    }

    private void stopManager(CMIndentedPrintStream out) throws CMException {
        block2: {
            try {
                this.taskManager.stop();
            }
            catch (CMException e) {
                if (e.getCode().equalsIgnoreCase("cmErrorTasksManagerNotStarted")) break block2;
                throw e;
            }
        }
    }

    private void startManager(CMIndentedPrintStream out) throws CMException {
        block2: {
            try {
                this.taskManager.start(true);
            }
            catch (CMException e) {
                if (e.getCode().equalsIgnoreCase("cmErrorTasksManagerAlreadyStarted")) break block2;
                throw e;
            }
        }
    }

    private void stopQueueManager(CMIndentedPrintStream out) throws CMException {
        this.queueManager.stop();
    }

    private void startQueueManager(CMIndentedPrintStream out) throws CMException {
        this.queueManager.start();
    }

    private void getQueuesStatus(CMIndentedPrintStream out) throws CMException {
        out.println("<queuesStatus>");
        out.indent();
        TreeSet<String> queueNames = new TreeSet<String>(this.queueManager.getQueueNames());
        for (String queueName : queueNames) {
            this.printOutQueueStatus(out, queueName);
        }
        out.unindent();
        out.println("</queuesStatus>");
    }

    private void printOutQueueStatus(CMIndentedPrintStream out, String queueName) throws CMException {
        ICMQueueStatus queueStatus = this.queueManager.getStatus(this.getStore(), queueName);
        out.println("<queueStatus>");
        out.indent();
        out.print("<queueName>");
        out.print(queueName);
        out.println("</queueName>");
        out.println("<status>");
        out.indent();
        for (ICMQueueStatusInfo statusInfo : queueStatus.getStatus(this.getStore())) {
            out.println("<statusInfo>");
            out.indent();
            out.print("<state>");
            out.print((Object)statusInfo.getState());
            out.println("</state>");
            out.print("<count>");
            out.print(statusInfo.getCount());
            out.println("</count>");
            out.unindent();
            out.println("</statusInfo>");
        }
        out.unindent();
        out.println("</status>");
        out.unindent();
        out.println("</queueStatus>");
    }

    private void getTasksInformation(CMIndentedPrintStream out) throws CMException {
        out.println("<tasksInformation>");
        out.indent();
        for (String taskName : this.taskManager.getConfiguredTaskNames()) {
            this.getTaskInformation(out, taskName);
        }
        out.unindent();
        out.println("</tasksInformation>");
    }

    private void getTaskInformation(CMIndentedPrintStream out) throws CMException {
        String taskName = this.getRequiredAttribute(this.manageTasksXML_, "name");
        this.getTaskInformation(out, taskName);
    }

    private void getTaskInformation(CMIndentedPrintStream out, String taskName) throws CMException {
        Element queueNameElement;
        out.println("<taskInformation>");
        out.indent();
        out.print("<taskName>");
        out.print(taskName);
        out.println("</taskName>");
        Element runOptions = this.taskManager.getTaskRunOptions(taskName);
        String queueName = "";
        if (runOptions != null && (queueNameElement = runOptions.element("queueName")) != null) {
            queueName = queueNameElement.getTextTrim();
        }
        out.print("<queueName>");
        out.print(queueName);
        out.println("</queueName>");
        String runningState = this.getTaskRunningState(taskName);
        out.print("<runningState>");
        out.print(runningState);
        out.println("</runningState>");
        out.unindent();
        out.println("</taskInformation>");
    }

    private String getTaskRunningState(String taskName) throws CMException {
        String runningState = "";
        if (this.taskManager.isTaskScheduled(taskName)) {
            runningState = "Scheduled";
        }
        if (this.taskManager.isTaskRunning(taskName)) {
            runningState = "Running";
        }
        return runningState;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        try {
            this.reloadConfiguration = false;
            if (requestElement.getChild(0).getAttribute("reloadConfiguration").equalsIgnoreCase("true")) {
                this.reloadConfiguration = true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.manageTasksXML_ = requestElement.getChild(0);
        }
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.getParams(this.getRootElement());
    }

    private String getRequiredAttribute(XMLElement element, String attributeName) throws CMException {
        String name = element.getAttribute(attributeName);
        if (name == null || name.length() <= 0) {
            throw new CMException("Missing required attribute " + attributeName);
        }
        return name;
    }
}

