/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.multitenancy.TenantIdCopyAction;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AuditContext;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandlerWithTarget;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class move
extends RequestHandlerWithTarget {
    public move(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        RequestInfo requestInfo = (RequestInfo)this.requestsInfo_.get(0);
        CMStoreXPath objectContext = null;
        if (requestInfo.objectsContexts_ != null && requestInfo.objectsContexts_.size() > 0 && (objectContext = (CMStoreXPath)requestInfo.objectsContexts_.get(0)) != null && objectContext.isUnion()) {
            throw new CMException("cmBadCompoundPathOp", new CMException.Parm("Path", objectContext.getOriginalPath()));
        }
    }

    protected XMLElement getTargetSearchPath(XMLElement requestElement) {
        return requestElement.getOptionalChildWithName("target");
    }

    protected String getMoveResultString() {
        return "moveResult";
    }

    protected XMLElement getNewNames(XMLElement requestElement) {
        return requestElement.getOptionalChildWithName("newName");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        ArrayList<XMLElement> aClassList;
        XMLElement optionsXmlElm;
        if (this.didGetParmUsingXMLEl_ == requestElement && this.requestsInfo_.size() > 0) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        if (this.lockedPaths_ == null) {
            this.lockedPaths_ = new ArrayList();
        }
        RequestInfo requestInfo = new RequestInfo();
        this.requestsInfo_.add(requestInfo);
        requestInfo.objectsContexts_ = new ArrayList<ICMStorePath>();
        requestInfo.targetContext_ = null;
        requestInfo.action_ = 2;
        XMLElement xmlElm = requestElement.getOptionalChildWithName("search");
        if (xmlElm != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
            CMStoreXPath objectContext = (CMStoreXPath)CMStoreXPath.parse(xmlElm.value_);
            CMObjectClass theClass = this.getObjectClassForIPF(objectContext);
            this.checkReadOnlyClass(theClass);
            objectContext.setLockManagerUsageFlag(18);
            this.addObjectContextToLockPaths(objectContext);
            requestInfo.objectsContexts_.add(objectContext);
        }
        if ((xmlElm = this.getTargetSearchPath(requestElement)) != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
            requestInfo.targetContext_ = this.parsePath(xmlElm.value_);
            this.validatePathForNonQueryCommand(requestInfo.targetContext_, "move");
            requestInfo.targetContext_.setLockManagerUsageFlag(19);
            this.addObjectContextToLockPaths(requestInfo.targetContext_);
        }
        if ((optionsXmlElm = requestElement.getOptionalChildWithName("options")) != null) {
            xmlElm = optionsXmlElm.getOptionalChildWithName("updateAction");
            if (xmlElm != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
                if (xmlElm.value_.equalsIgnoreCase("replace")) {
                    requestInfo.action_ = 1;
                } else if (xmlElm.value_.equalsIgnoreCase("fail")) {
                    requestInfo.action_ = 2;
                } else if (xmlElm.value_.equalsIgnoreCase("update")) {
                    requestInfo.action_ = 3;
                } else {
                    throw new CMException("cmBadAttrValue", new CMException.Parm("Value", xmlElm.value_), new CMException.Parm("Attribute", "updateAction"));
                }
            }
            if ((xmlElm = optionsXmlElm.getOptionalChildWithName("faultIfObjectReferenced")) != null && xmlElm.value_ != null && xmlElm.value_.length() > 0 && xmlElm.value_.equalsIgnoreCase("true")) {
                requestInfo.clearInvalidReferences_ = false;
            }
        }
        if ((xmlElm = this.getNewNames(requestElement)) != null) {
            requestInfo.newNames_ = new ArrayList<String>();
            if (xmlElm.isArray_) {
                if (xmlElm.hasChildren()) {
                    for (XMLElement xmlElName : xmlElm.getChildren()) {
                        String value = CMStringUtils.collapseWhitespace(xmlElName.value_);
                        move.validateName(value);
                        requestInfo.newNames_.add(value);
                    }
                }
            } else {
                String value = CMStringUtils.collapseWhitespace(xmlElm.value_);
                move.validateName(value);
                requestInfo.newNames_.add(value);
            }
        }
        if ((xmlElm = requestElement.getOptionalChildWithName("objects")) != null && (aClassList = xmlElm.getChildren()) != null) {
            ListIterator iterClass = aClassList.listIterator();
            while (iterClass.hasNext()) {
                XMLElement xmlElClass = (XMLElement)iterClass.next();
                this.checkReadOnlyClass(xmlElClass.xsiType_);
                CMStoreXPath objectContext = this.getClassObjSearchPath(xmlElClass);
                if (objectContext == null) continue;
                objectContext.setLockManagerUsageFlag(18);
                this.addObjectContextToLockPaths(objectContext);
                requestInfo.objectsContexts_.add(objectContext);
            }
        }
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = this.runCommands("moveResponse", "moveReply");
        return rc;
    }

    @Override
    protected void prepareLocks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doCommand(Object requestInfoObj, String tabPrefix) throws CMException {
        boolean noAccessCheckRequired = CMExecutionContext.get().getCurrentUserIsAdministrator();
        RequestInfo requestInfo = (RequestInfo)requestInfoObj;
        if (requestInfo.objectsContexts_.size() < 1) {
            throw new CMException("cmNoSelectPath");
        }
        if (requestInfo.targetContext_ == null) {
            throw new CMException("cmNoTargetPath");
        }
        CMStore store = CMExecutionContext.get().getStore();
        int objectTotalCount = 0;
        int objectCount = 0;
        this.out.print(tabPrefix);
        this.emitArrayElement(this.getMoveResultString(), "cm", "baseClass");
        this.addBuffer_ = new StringBuffer();
        ListIterator<ICMStorePath> iter = requestInfo.objectsContexts_.listIterator();
        ListIterator<String> iterNames = null;
        if (requestInfo.newNames_ != null) {
            iterNames = requestInfo.newNames_.listIterator();
        }
        ArrayList<String> permissions = null;
        int perm = 0;
        if (!noAccessCheckRequired) {
            permissions = new ArrayList<String>();
            permissions.add("read");
            perm = 1042;
        } else {
            perm = 512;
        }
        int groupCount = 0;
        while (iter.hasNext()) {
            CMStorePath objectContext = (CMStorePath)iter.next();
            String newName = null;
            if (iterNames != null) {
                newName = iterNames.next();
            }
            CMStoreQueryResults resultsSrc = null;
            try {
                this.handleTarget(requestInfo.targetContext_);
                try {
                    resultsSrc = store.executeQuery(objectContext, null, null, 4, perm, permissions);
                }
                catch (CMStoreObjectNotFound e) {
                    throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(store, objectContext)));
                }
                CMStoreQueryResults results = null;
                try {
                    objectCount = 0;
                    while (resultsSrc.next()) {
                        CMObjectClass objectClass = resultsSrc.getObjectClass();
                        String searchPath = resultsSrc.getSearchPath();
                        CMStoreXPath srcPath = new CMStoreXPath(searchPath);
                        int srcTenantId = resultsSrc.getTenantID();
                        String tenantId = this.tenantRegistry.getTenantIdStringFromInt(srcTenantId);
                        this.validateTenancy(srcTenantId);
                        this.assertIsValidChildClass(this.sTargetSearchPath_, this.targetClass_, objectClass);
                        this.validateMaxOccurs(this.sTargetSearchPath_, this.targetClass_, objectClass, tenantId);
                        if (srcPath.size() == 1) {
                            CMStoreXPathStep firstStep = (CMStoreXPathStep)srcPath.stepAt(0);
                            String camid = firstStep.getCAMIDLiteral();
                            if (camid == null) {
                                throw new CMException("cmBadMoveSelectionRoot", new CMException.Parm("Path", CMQueryUtils.getPath(store, srcPath)));
                            }
                            if (CMCAMIDHelper.isSpecialCAMID(camid)) {
                                throw new CMException("cmBadMoveSelectionSpecial", new CMException.Parm("Path", resultsSrc.getPath()));
                            }
                        }
                        if (store.isDescendantOrSelf(requestInfo.targetContext_, srcPath)) {
                            throw new CMException("cmBadTargetDescendantOfSearch", new CMException.Parm("Target", CMQueryUtils.getPath(store, requestInfo.targetContext_)), new CMException.Parm("Search", CMQueryUtils.getPath(store, srcPath)));
                        }
                        this.handleTargetOverwrite(store, resultsSrc, srcPath, newName);
                        if (objectClass == CMObjectClass.HISTORY) {
                            throw new CMException("cmInvalidMoveRunhistory", new CMException.Parm("Class", objectClass.getName()));
                        }
                        this.configurationModified(searchPath, objectClass);
                        ++objectCount;
                    }
                    resultsSrc.reset();
                    if (objectCount == 0) {
                        throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(store, objectContext)));
                    }
                    if (objectCount > 1 && newName != null) {
                        throw new CMException("cmBadNewName");
                    }
                    DeadlockContext context = new DeadlockContext();
                    context.requestInfo = requestInfo;
                    context.resultsSrc = resultsSrc;
                    context.results = results;
                    context.permissions = permissions;
                    context.perm = perm;
                    context.groupCount = groupCount;
                    context.objectContext = objectContext;
                    context.newName = newName;
                    try {
                        CMWhileDeadlockExecutor.execute(this, context, Class.forName("com.cognos.cm.request.move").getDeclaredMethod("executeInDeadlockLoop", DeadlockContext.class, Integer.class));
                    }
                    catch (CMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new CMException(t, "cmUnexpectedError");
                    }
                    groupCount = context.groupCount;
                    results = context.results;
                    objectCount = 0;
                    CMExecutionContext ctx = CMExecutionContext.get();
                    AuditContext auditContext = ctx.getAuditContext();
                    while (results.next()) {
                        ++objectCount;
                        CMObjectClass objectClass = results.getObjectClass();
                        String searchPath = results.getSearchPath();
                        int objectID = results.getObjectID();
                        String storeID = store.getObjectStoreID(objectID);
                        String defaultName = results.getName();
                        auditContext.add(objectID, objectClass);
                        this.configurationModified(searchPath, objectClass);
                        this.emitObject(tabPrefix, objectClass, defaultName, searchPath, storeID);
                    }
                    objectTotalCount += objectCount;
                    this.postSuccessfulOperation();
                }
                finally {
                    if (results != null) {
                        results.release();
                    }
                    if (resultsSrc == null) continue;
                    resultsSrc.release();
                }
            }
            catch (CMStoreDuplicateObject e) {
                String errorName = objectContext.getName();
                StringBuffer listofNames = new StringBuffer();
                String parentPath = null;
                try {
                    parentPath = this.getPath(requestInfo.targetContext_.toString());
                    if (newName == null) {
                        CMLocalizedStringArray names = (CMLocalizedStringArray)CMQueryUtils.getProp(store, objectContext, CMProperty.NAME);
                        for (int x = 0; x < names.getSize(); ++x) {
                            if (x > 0) {
                                listofNames.append(",");
                            }
                            listofNames.append(names.get(x).getValue());
                        }
                    } else {
                        listofNames.append(newName);
                    }
                }
                catch (CMException ex) {
                    throw new CMException((Exception)ex, "cmDuplicateNameFail", new CMException.Parm("Name", errorName));
                }
                throw new CMException("cmNameConflict", new CMException.Parm("Names", listofNames), new CMException.Parm("Root", parentPath));
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmMoveFailed");
            }
        }
        if (groupCount > 0) {
            DeadlockContext context = new DeadlockContext();
            context.groupCount = groupCount;
            try {
                CMWhileDeadlockExecutor.execute(this, context, Class.forName("com.cognos.cm.request.move").getDeclaredMethod("executeInDeadlockLoop2", DeadlockContext.class, Integer.class));
            }
            catch (CMException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new CMException(t, "cmUnexpectedError");
            }
        }
        this.out.print(Integer.toString(objectTotalCount));
        this.out.print("]\">\r\n");
        this.out.print(this.addBuffer_.toString());
        this.addBuffer_ = null;
        this.out.print(tabPrefix);
        this.out.print("</");
        this.out.print(this.getMoveResultString());
        this.out.print(">\r\n");
        return true;
    }

    private void validateTenancy(int srcTenantId) throws CMException, CMCacheException {
        if (!MultiTenancyUtils.isValidContainment(this.targetTenantId_, srcTenantId)) {
            String sourceTenantId = this.tenantRegistry.getTenantIdStringFromInt(srcTenantId);
            String targetTenantId = this.tenantRegistry.getTenantIdStringFromInt(this.targetTenantId_);
            throw new CMException("cmInvalidTenantContainment", new CMException.Parm("tenant", sourceTenantId), new CMException.Parm("path", this.sTargetSearchPath_), new CMException.Parm("parentTenant", targetTenantId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDeadlockLoop(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        CMStore store;
        if (context.sourceIds != null) {
            context.sourceIds.setSize(0);
        }
        if (context.targetIds != null) {
            context.targetIds.setSize(0);
        }
        if (context.correctOwnerIds != null) {
            context.correctOwnerIds.setSize(0);
        }
        if (context.results != null) {
            context.results.release();
            context.results = null;
        }
        if (context.requestInfo.action_ == 3 && deadlockRetryNumber != AdvancedSettings.DBDEADLOCKRETRYMAX) {
            store = CMExecutionContext.get().getStore();
            context.resultsSrc.release();
            context.resultsSrc = null;
            try {
                context.resultsSrc = store.executeQuery(context.objectContext, null, null, 3, context.perm, context.permissions);
            }
            catch (CMStoreObjectNotFound e) {
                throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(store, context.objectContext)));
            }
        } else if (deadlockRetryNumber != AdvancedSettings.DBDEADLOCKRETRYMAX) {
            context.resultsSrc.reset();
        }
        store = CMExecutionContext.get().getStore();
        try {
            block29: {
                store.beginTransaction();
                try {
                    if (context.requestInfo.action_ == 3) {
                        if (context.sourceIds == null) {
                            context.sourceIds = new CMIntList();
                        }
                        if (context.targetIds == null) {
                            context.targetIds = new CMIntList();
                        }
                        if (context.correctOwnerIds == null) {
                            context.correctOwnerIds = new CMIntList();
                        }
                        context.results = this.copy(context.resultsSrc, this.targetObjectID_, context.newName, true, context.requestInfo.clearInvalidReferences_, context.requestInfo.action_, context.perm, context.permissions, context.sourceIds, context.targetIds, context.correctOwnerIds, TenantIdCopyAction.keep());
                        store.copyReferencesInGroup(this, context.groupCount, context.sourceIds, context.targetIds, context.correctOwnerIds, null);
                        CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                        delete.deleteDescendants(store, context.objectContext, 10, context.requestInfo.clearInvalidReferences_);
                    } else {
                        context.results = store.move(context.resultsSrc, this.targetObjectID_, context.newName);
                        CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                    }
                }
                catch (CMStoreDuplicateObject e) {
                    if (context.requestInfo.action_ != 1 || this.sTargetSearchPath_ == null) {
                        throw e;
                    }
                    if (context.newName != null) {
                        this.deleteConflictingObjects(store, context.newName, context.resultsSrc.getSearchPath(), context.requestInfo.clearInvalidReferences_);
                    } else {
                        while (context.resultsSrc.next()) {
                            this.deleteConflictingObjects(store, context.resultsSrc.getName(), context.resultsSrc.getSearchPath(), context.requestInfo.clearInvalidReferences_);
                        }
                        context.resultsSrc.reset();
                    }
                    context.results = store.move(context.resultsSrc, this.targetObjectID_, context.newName);
                    CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                    if (context.results != null) break block29;
                    throw e;
                }
            }
            store.commitTransaction();
            ++context.groupCount;
        }
        finally {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            if (context.resultsSrc != null) {
                context.resultsSrc.release();
            }
        }
    }

    public void executeInDeadlockLoop2(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        try {
            store.beginTransaction();
            if (context.groupCount > 1) {
                store.updateReferencesBetweenGroups(this);
            }
            store.cleanReferenceGroups();
            store.commitTransaction();
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmCopyFailed");
        }
        finally {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected String getOperationName() {
        return "move";
    }

    private static class DeadlockContext {
        public CMIntList sourceIds;
        public CMIntList targetIds;
        public CMIntList correctOwnerIds;
        public CMStoreQueryResults resultsSrc;
        public CMStoreQueryResults results;
        public RequestInfo requestInfo;
        public List<String> permissions;
        public int perm = 0;
        public int groupCount = 0;
        public CMStorePath objectContext;
        public String newName;

        private DeadlockContext() {
        }
    }

    private class RequestInfo {
        public CMStoreXPath targetContext_ = null;
        public List<ICMStorePath> objectsContexts_;
        public List<String> newNames_;
        public int action_;
        public boolean clearInvalidReferences_ = true;

        private RequestInfo() {
        }
    }
}

