/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.CMDbStoreMetadataUtil;
import com.cognos.cm.dbstore.CMDbStoreSizeUtil;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.AbstractQuery;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreQuerySizeResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class querySize
extends AbstractQuery {
    private boolean bIncludeSize_;
    private boolean bRecreate_;
    private Map<String, Set<String>> objectClassesMap_;
    private boolean bAllClasses_;
    private boolean bSearchInEntireCS_;
    private CMProperty sizeInfoArrayProperty_;
    private ArrayList<CMDbStoreSizeUtil.OrderByColumn> orderByColumns_;
    private String sortForClass_;
    private int nMaxObjectsQuerySize_;
    private int nFirstObjectQuerySize_;

    public querySize(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.didGetParmUsingXMLEl_ = this.getRootElement();
        if (this.didGetParmUsingXMLEl_ == null) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
    }

    protected String getQueryResultString() {
        return "queryResult";
    }

    protected XMLElement getSearchPath(XMLElement requestElement) {
        return requestElement.getOptionalChildWithName("search");
    }

    protected XMLElement getQueryOptions(XMLElement requestElement) {
        return requestElement.getOptionalChildWithName("options");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        ArrayList<XMLElement> list;
        ListIterator iter;
        XMLElement optionsXmlElm;
        ArrayList<XMLElement> listClasses;
        if (this.didGetParmUsingXMLEl_ == requestElement && this.objectContext_ != null) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        if (this.lockedPaths_ == null) {
            this.lockedPaths_ = new ArrayList();
        }
        this.lockedPaths_.clear();
        this.objectContext_ = null;
        this.nMaxObjects_ = 0;
        this.nFirstObject_ = 0;
        this.propertiesList_ = null;
        this.permission_ = null;
        this.permissionFlags_ = 0;
        XMLElement xmlElm = requestElement.getOptionalChildWithName("search");
        if (xmlElm != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
            this.objectContext_ = this.parsePath(xmlElm.value_);
        }
        if (this.objectContext_ == null) {
            throw new CMException("cmNoSelection");
        }
        if (this.objectContext_.size() == 0) {
            this.bSearchInEntireCS_ = true;
        }
        if ((listClasses = (xmlElm = requestElement.getChildWithName("classes")).getChildren()) != null) {
            ListIterator iter2 = listClasses.listIterator();
            boolean bFirstClass = true;
            while (iter2.hasNext()) {
                XMLElement xmlEl = (XMLElement)iter2.next();
                boolean bParsed = this.parseClass(xmlEl);
                this.sortForClass_ = bFirstClass && bParsed ? xmlEl.value_ : null;
                bFirstClass = false;
            }
        }
        if ((optionsXmlElm = this.getQueryOptions(requestElement)) != null) {
            ArrayList<XMLElement> sizeInfoArrayList;
            xmlElm = optionsXmlElm.getOptionalChildWithName("sizeInfo");
            if (xmlElm != null && (sizeInfoArrayList = xmlElm.getChildren()) != null) {
                iter = sizeInfoArrayList.listIterator();
                while (iter.hasNext()) {
                    XMLElement xmlElSIZEINFO = (XMLElement)iter.next();
                    if (xmlElSIZEINFO.value_ == null || !xmlElSIZEINFO.value_.equals("size")) continue;
                    this.bIncludeSize_ = true;
                }
            }
            if ((xmlElm = optionsXmlElm.getOptionalChildWithName("recreate")) != null && xmlElm.value_ != null && xmlElm.value_.equals("true")) {
                this.bRecreate_ = true;
            }
        }
        if ((xmlElm = requestElement.getOptionalChildWithName("sortBy")) != null && (list = xmlElm.getChildren()) != null) {
            iter = list.listIterator();
            while (iter.hasNext()) {
                XMLElement xmlEl = (XMLElement)iter.next();
                this.parseSort(xmlEl);
            }
        }
        if ((xmlElm = optionsXmlElm.getOptionalChildWithName("maxObjects")) != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
            try {
                Integer intValue = new Integer(xmlElm.value_);
                this.nMaxObjectsQuerySize_ = intValue;
            }
            catch (NumberFormatException e) {
                throw new CMException("cmBadAttribute", new CMException.Parm("Name", "maxObjects"));
            }
        }
        if ((xmlElm = optionsXmlElm.getOptionalChildWithName("skipObjects")) != null && xmlElm.value_ != null && xmlElm.value_.length() > 0) {
            try {
                Integer intValue = new Integer(xmlElm.value_);
                this.nFirstObjectQuerySize_ = intValue;
            }
            catch (NumberFormatException e) {
                throw new CMException("cmBadAttribute", new CMException.Parm("Name", "skipObjects"));
            }
        }
        if (this.bAllClasses_) {
            this.bIncludeSize_ = false;
            this.sortForClass_ = null;
        }
        CMStore store = CMExecutionContext.get().getStore();
        this.sizeInfoArrayProperty_ = store.getObjectClasses().getClassByName("CMSystemProperties").getProperty("sizeInfoArray");
        if (this.propertiesList_ == null) {
            this.propertiesList_ = new ArrayList();
        }
        this.propertiesList_.add(CMProperty.STOREID);
        this.propertiesList_.add(CMProperty.SEARCHPATH);
        this.propertiesList_.add(CMProperty.OBJECTCLASS);
        this.propertiesList_.add(CMProperty.DEFAULTNAME);
        if (this.lockObjectContext_) {
            this.objectContext_.setLockManagerUsageFlag(10);
            this.addObjectContextToLockPaths(this.objectContext_);
        }
    }

    protected boolean parseClass(XMLElement xmlEl) throws CMException {
        boolean bSuccess = false;
        if (this.objectClassesMap_ == null) {
            this.objectClassesMap_ = new HashMap<String, Set<String>>();
        }
        CMStore store = CMExecutionContext.get().getStore();
        CMObjectClasses objectClasses = store.getObjectClasses();
        String className = xmlEl.value_;
        if (className != null) {
            Map<String, SortedSet<String>> metadataClassesMap = CMDbStoreMetadataUtil.getClassesMap();
            if (className.length() == 1 && className.charAt(0) == '*') {
                this.objectClassesMap_.putAll(metadataClassesMap);
                this.bAllClasses_ = true;
                bSuccess = true;
            } else {
                CMObjectClass objectClass = objectClasses.getClassByName(className);
                if (objectClass != null) {
                    int classId = objectClass.getID();
                    String classIdString = String.valueOf(classId);
                    Set metadataClassEntry = metadataClassesMap.get(classIdString);
                    this.objectClassesMap_.put(classIdString, metadataClassEntry);
                    bSuccess = true;
                }
            }
        }
        return bSuccess;
    }

    void parseSort(XMLElement xmlEl) throws CMException {
        boolean bDescend = false;
        String strOrderBy = xmlEl.getOptionalChildValueWithName("propName");
        String orderStr = xmlEl.getOptionalChildValueWithName("order");
        if (orderStr != null) {
            if (orderStr.equalsIgnoreCase("ascending")) {
                bDescend = false;
            } else if (orderStr.equalsIgnoreCase("descending")) {
                bDescend = true;
            } else {
                throw new CMException("cmInvalidOrder", new CMException.Parm("Value", "orderStr"));
            }
        }
        if (strOrderBy != null) {
            if (this.orderByColumns_ == null) {
                this.orderByColumns_ = new ArrayList();
            }
            CMDbStoreSizeUtil.OrderByColumn orderBy = new CMDbStoreSizeUtil.OrderByColumn(bDescend, strOrderBy);
            this.orderByColumns_.add(orderBy);
        }
    }

    private void emitReponseStart() {
        this.emitTabs(1);
        this.emit(baLT);
        this.emit(querySize.s2ba(this.getCMPrefixString()));
        this.emit(baColon);
        this.emit("querySizeResponse");
        this.emit(baPropNSDecl_Seg1);
        this.emit(CMSOAPConstants.baCM_PREFIX);
        this.emit(baEqualsQuote);
        this.emit(querySize.s2ba(this.getBiBusNamespace()));
        if (this.getCMS_V1Namespace() != null) {
            this.emit(baQuote);
            this.emit(baPropNSDecl_Seg1);
            this.emit(querySize.s2ba("cm1"));
            this.emit(baEqualsQuote);
            this.emit(querySize.s2ba(this.getCMS_V1Namespace()));
        }
        this.emit(baQuote_GT_EOL);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = false;
        CMExecutionContext ctx = CMExecutionContext.get();
        if (ctx.getCurrentUserIsAdministrator()) {
            this.emitReponseStart();
            rc = this.emitQueryResult();
            this.emitTabs(1);
            this.emit(baLT_Slash);
            this.emit(querySize.s2ba(this.getCMPrefixString()));
            this.emit(baColon);
            this.emit("querySizeResponse");
            this.emit(baGT);
        }
        return rc;
    }

    private boolean emitQueryResult() throws CMException {
        boolean rc = false;
        XMLElement xmlEl = this.getRootElement();
        XMLElement xmlRequests = xmlEl.getOptionalChildWithName("requests");
        if (xmlRequests != null) {
            this.emitTabs(2);
            this.emitArrayElement(CMSOAPConstants.baELEM_RETURNS, CMSOAPConstants.baCM_PREFIX, CMSOAPConstants.baELEM_QUERYSIZEREPLY);
            ArrayList<XMLElement> queryList = xmlRequests.getChildren();
            if (queryList == null) {
                this.out.print("0]\"/>\r\n");
            } else {
                this.emit(Integer.toString(queryList.size()));
                this.emit(baCloseSquare);
                this.emit(baQuote_GT_EOL);
                rc = this.emitQueryReplyElements(queryList, 3);
                this.emitTabs(2);
                this.emit(baLT_Slash);
                this.emit(CMSOAPConstants.baELEM_RETURNS);
                this.emit(baGT_EOL);
            }
        } else {
            rc = this.doQuerySize(xmlEl, 2);
        }
        return rc;
    }

    private boolean emitQueryReplyElements(List<XMLElement> elements, int indent) throws CMException {
        boolean rc = false;
        ListIterator<XMLElement> iter = elements.listIterator();
        while (iter.hasNext() && this.keepProcessingQueries_) {
            this.emitTabs(indent);
            this.emitElement(CMSOAPConstants.baELEM_SOAP_ITEM, CMSOAPConstants.baCM_PREFIX, CMSOAPConstants.baELEM_RSP_QUERYSIZEREPLY);
            XMLElement xmlElItem = iter.next();
            this.emit(baEOL);
            rc = this.doQuerySize(xmlElItem, indent + 1);
            this.emitTabs(indent);
            this.emit(baLT_Slash);
            this.emit(CMSOAPConstants.baELEM_SOAP_ITEM);
            this.emit(baGT_EOL);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doQuerySize(XMLElement requestElement, int nIndent) throws CMException {
        boolean rc = false;
        if (requestElement == null) {
            return rc;
        }
        this.getParams(requestElement);
        CMExecutionContext currContext = CMExecutionContext.get();
        CMStore store = currContext.getStore();
        CMStoreQueryResults results = null;
        CMStoreQuerySizeResults querySizeResults = null;
        try {
            this.propertiesList_.add(this.sizeInfoArrayProperty_);
            CMProperty[] props = new CMProperty[this.propertiesList_.size()];
            this.propertiesList_.toArray(props);
            this.permissionFlags_ = 32768;
            this.LockPaths();
            results = this.executeQueryWithResults(nIndent + 1, this.objectContext_);
            if (results == null) {
                store.release();
                boolean bl = false;
                return bl;
            }
            querySizeResults = new CMStoreQuerySizeResults(this, this.sizeInfoArrayProperty_);
            CMDbStoreSizeUtil.OrderByColumn[] orderBy = null;
            if (this.orderByColumns_ != null && this.sortForClass_ != null) {
                orderBy = new CMDbStoreSizeUtil.OrderByColumn[this.orderByColumns_.size()];
                this.orderByColumns_.toArray(orderBy);
            }
            querySizeResults.initialize(results, props, orderBy, this.bIncludeSize_, this.bSearchInEntireCS_ && this.bAllClasses_, this.objectClassesMap_);
            if (!querySizeResults.next()) {
                boolean bl = false;
                return bl;
            }
            rc = true;
            this.redirectToSecondaryStream(true);
            int i = 0;
            int displayPosition = 1;
            int nLastObject = this.nFirstObjectQuerySize_ + this.nMaxObjectsQuerySize_ - 1;
            if (this.nMaxObjectsQuerySize_ < 1) {
                nLastObject = Integer.MAX_VALUE;
            }
            do {
                if (i > nLastObject) {
                    break;
                }
                if (i >= this.nFirstObjectQuerySize_) {
                    ++this.queryCount_;
                    this.writeObject(querySizeResults, props, "item", nIndent, displayPosition);
                    if (this.bRecreate_) {
                        querySizeResults.saveInDatabase();
                    }
                    ++displayPosition;
                }
                ++i;
            } while (querySizeResults.next());
        }
        finally {
            if (querySizeResults != null) {
                querySizeResults.release();
            }
            this.lockMgr_.releaseLocks();
            this.resetLockedPaths();
            this.redirectToSecondaryStream(false);
        }
        this.emitTabs(nIndent);
        this.emitArrayElement(querySize.s2ba(this.getQueryResultString()), CMSOAPConstants.baCM_PREFIX, CMSOAPConstants.baTYPE_BASECLASS);
        this.emit(Integer.toString(this.queryCount_));
        this.emit(baCloseSquare);
        this.emit(baQuote_GT_EOL);
        this.writeOutSecondaryStream();
        this.emitTabs(nIndent);
        this.emit(baLT_Slash);
        this.emit(querySize.s2ba(this.getQueryResultString()));
        this.emit(baGT_EOL);
        this.clearSecondaryStream();
        return rc;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

