/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.indications.CMSessionLogging;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class recordSession
extends RequestHandler {
    private static final byte[] baRecordSession = recordSession.s2ba("recordSession");
    private static final byte[] baUsers = recordSession.s2ba("users");
    private static final byte[] baTraceUser = recordSession.s2ba("traceUser");
    private static final byte[] baItem = recordSession.s2ba("item");
    private static final byte[] baUser = recordSession.s2ba("user");
    private static final byte[] baTRQ = recordSession.s2ba("soap");
    private static final byte[] baSQL = recordSession.s2ba("sql");
    private static final byte[] baTYPE_BOOLEAN = recordSession.s2ba("boolean");
    private static final byte[] baTrue = recordSession.s2ba("true");
    private static final byte[] baFalse = recordSession.s2ba("false");
    private List<String> m_soapUsers;
    private List<String> m_sqlUsers;

    public recordSession(CMStore store) {
        super(store);
    }

    private void emitResponseStart() {
        this.emitTabs(1);
        this.emit(baLT);
        this.emit(recordSession.s2ba(this.getCMPrefixString()));
        this.emit(baColon);
        this.emit(baRecordSession);
        this.out.print(" xmlns:");
        this.out.print("cm");
        this.out.print("=\"");
        this.out.print(this.getBiBusNamespace());
        if (this.getCMS_V1Namespace() != null) {
            this.out.print("\"");
            this.out.print(" xmlns:");
            this.out.print("cm1");
            this.out.print("=\"");
            this.out.print(this.getCMS_V1Namespace());
        }
        this.out.print("\">\r\n");
    }

    private void emitResponseEnd() {
        this.emitTabs(1);
        this.emit(baLT_Slash);
        this.emit(recordSession.s2ba(this.getCMPrefixString()));
        this.emit(baColon);
        this.emit(baRecordSession);
        this.emit(baGT);
    }

    private void emitUsers(Map<String, boolean[]> users) {
        this.emitTabs(2);
        this.emitArrayElement(baUsers, CMSOAPConstants.baCM_PREFIX, baTraceUser, users.size());
        for (String user : users.keySet()) {
            this.emitTabs(3);
            this.emitElement(baItem, CMSOAPConstants.baCM_PREFIX, baTraceUser);
            this.emitTabs(4);
            this.emitElement(baUser, CMSOAPConstants.baXSD_PREFIX, CMSOAPConstants.baTYPE_STRING);
            this.emit(user.getBytes());
            this.emitEndElement(baUser);
            boolean[] flags = users.get(user);
            this.emitTabs(4);
            this.emitElement(baTRQ, CMSOAPConstants.baXSD_PREFIX, baTYPE_BOOLEAN);
            this.emit(flags[0] ? baTrue : baFalse);
            this.emitEndElement(baTRQ);
            this.emitTabs(4);
            this.emitElement(baSQL, CMSOAPConstants.baXSD_PREFIX, baTYPE_BOOLEAN);
            this.emit(flags[1] ? baTrue : baFalse);
            this.emitEndElement(baSQL);
            this.emitTabs(3);
            this.emitEndElement(baItem);
        }
        this.emitEndElement(baUsers);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (ctx.getCurrentUserIsAdministrator()) {
            int i;
            String[] sqlUsers;
            String[] soapUsers;
            if (null != this.m_soapUsers && null != this.m_sqlUsers) {
                soapUsers = this.m_soapUsers.toArray(new String[0]);
                sqlUsers = this.m_sqlUsers.toArray(new String[0]);
                CMSessionLogging.setUsers(soapUsers, sqlUsers);
            }
            soapUsers = CMSessionLogging.getSOAPUsers();
            sqlUsers = CMSessionLogging.getSQLUsers();
            HashMap<String, boolean[]> userList = new HashMap<String, boolean[]>();
            boolean[] SOAP = new boolean[]{true, false};
            boolean[] SQL = new boolean[]{false, true};
            boolean[] BOTH = new boolean[]{true, true};
            for (i = 0; i < soapUsers.length; ++i) {
                userList.put(soapUsers[i], SOAP);
            }
            for (i = 0; i < sqlUsers.length; ++i) {
                if (userList.containsKey(sqlUsers[i])) {
                    userList.put(sqlUsers[i], BOTH);
                    continue;
                }
                userList.put(sqlUsers[i], SQL);
            }
            this.emitResponseStart();
            this.emitUsers(userList);
            this.emitResponseEnd();
            return true;
        }
        return false;
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        XMLElement usersElem;
        XMLElement elem = this.getRootElement();
        if (null != elem && null != (usersElem = elem.getOptionalChildWithName("users"))) {
            this.m_soapUsers = new ArrayList<String>();
            this.m_sqlUsers = new ArrayList<String>();
            ArrayList<XMLElement> itemElems = usersElem.getChildrenAllShouldBe("item");
            if (null != itemElems) {
                for (int i = 0; i < itemElems.size(); ++i) {
                    XMLElement userElem;
                    XMLElement itemElem = (XMLElement)itemElems.get(i);
                    if (null == itemElem || null == (userElem = itemElem.getSingleChildWithName("user")) || 0 == userElem.value_.length()) continue;
                    XMLElement soapElem = itemElem.getSingleChildWithName("soap");
                    XMLElement sqlElem = itemElem.getSingleChildWithName("sql");
                    if (null != soapElem && Boolean.valueOf(soapElem.value_).booleanValue()) {
                        this.m_soapUsers.add(userElem.value_);
                    }
                    if (null == sqlElem || !Boolean.valueOf(sqlElem.value_).booleanValue()) continue;
                    this.m_sqlUsers.add(userElem.value_);
                }
            }
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

