/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMSessionStateRequestsAction;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.server.UserSessionsVisitor;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMIndentedPrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class sessionState
extends RequestHandler {
    public static final String ABOUT_ENUM_REQUESTS = "requests";
    public static final String ABOUT_ENUM_SESSIONS = "sessions";
    public static final String ABOUT_ENUM_SYSTEM = "system";
    public static final String TITLE_THREAD = "Thread";
    public static final String TITLE_REQUEST = "Request";
    public static final String TITLE_SIGNATURE = "Signature";
    public static final String TITLE_SESSION = "Session";
    public static final String TITLE_USERNAME = "User Name";
    public static final String TITLE_IPFPATH = "Ipf Path";
    public static final String TITLE_EXECUTIONTIME = "Execution Time";
    public static final String TITLE_CREATIONTIME = "Creation Time";
    public static final String TITLE_LASTAUTHENTICATETIME = "Last Autentication";
    public static final String TITLE_SAMPLETIME = "Sample Time";
    public static final String FILTERS = "filters";
    public static final String FILTER = "filter";
    public static final String FIELD = "field";
    public static final String OPERATOR = "operator";
    public static final String OPERAND = "operand";
    public static final String FILTER_OPERATION_EQUALS = "equals";
    public static final String FILTER_OPERATION_NOTEQUALS = "notEquals";
    public static final String FILTER_OPERATION_CONTAINS = "contains";
    public static final String FILTER_OPERATION_NOTCONTAINS = "notContains";
    public static final String FILTER_OPERATION_STARTSWITH = "startsWith";
    public static final String FILTER_OPERATION_NOTSTARTSWITH = "notStartsWith";
    public static final String FILTER_OPERATION_GREATERTHAN = "greaterThan";
    public static final String FILTER_OPERATION_GREATERTHANEQUAL = "greaterThanEqual";
    public static final String FILTER_OPERATION_LESSTHAN = "lessThan";
    public static final String FILTER_OPERATION_LESSTHANEQUAL = "lessThanEqual";
    public static List<String> FILTER_OPERATIONS = new ArrayList<String>(10);
    public static final String DATATYPE_STRING = "string";
    public static final String DATATYPE_LONG = "long";
    public static final String DATATYPE_DOUBLE = "double";
    public static final String DATATYPE_DATETIME = "dateTime";
    public static final String UNITS_MILLISECONDS = "milliseconds";
    private ArrayList<SchemaEntry> requestsSchema = new ArrayList(5);
    private ArrayList<SchemaEntry> sessionsSchema = new ArrayList(4);
    private RequestInfo requestInfo;
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS");
    private int filteredCount = 0;

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        super.prepareRequest(c, rq);
        this.getParamsAll();
    }

    public sessionState(CMStore store) {
        super(store);
        this.requestsSchema.add(new SchemaEntry(TITLE_SAMPLETIME, DATATYPE_DATETIME, null));
        this.requestsSchema.add(new SchemaEntry(TITLE_THREAD, DATATYPE_STRING, null));
        this.requestsSchema.add(new SchemaEntry(TITLE_REQUEST, DATATYPE_STRING, null));
        this.requestsSchema.add(new SchemaEntry(TITLE_SIGNATURE, DATATYPE_STRING, null));
        this.requestsSchema.add(new SchemaEntry(TITLE_SESSION, DATATYPE_STRING, null));
        this.requestsSchema.add(new SchemaEntry(TITLE_USERNAME, DATATYPE_STRING, null));
        this.requestsSchema.add(new SchemaEntry(TITLE_IPFPATH, DATATYPE_STRING, null));
        this.requestsSchema.add(new SchemaEntry(TITLE_EXECUTIONTIME, DATATYPE_LONG, null));
        this.sessionsSchema.add(new SchemaEntry(TITLE_SAMPLETIME, DATATYPE_DATETIME, null));
        this.sessionsSchema.add(new SchemaEntry(TITLE_SESSION, DATATYPE_STRING, null));
        this.sessionsSchema.add(new SchemaEntry(TITLE_USERNAME, DATATYPE_STRING, null));
        this.sessionsSchema.add(new SchemaEntry(TITLE_CREATIONTIME, DATATYPE_DATETIME, null));
        this.sessionsSchema.add(new SchemaEntry(TITLE_LASTAUTHENTICATETIME, DATATYPE_DATETIME, null));
    }

    public List<Map<String, Object>> filter(List<Map<String, Object>> rows) throws CMException {
        Filter[] filters = this.requestInfo.filters;
        if (filters == null || filters.length == 0) {
            return rows;
        }
        for (int i = rows.size() - 1; i >= 0; --i) {
            Map<String, Object> curRow = rows.get(i);
            boolean remove = false;
            for (int j = 0; j < filters.length && !remove; ++j) {
                Filter curFilter = filters[j];
                if (curFilter.correspondingSchemaEntry == null || curFilter.filter(curRow)) continue;
                remove = true;
            }
            if (!remove) continue;
            rows.remove(i);
            ++this.filteredCount;
        }
        return rows;
    }

    public SchemaEntry getSchemaEntry(List<SchemaEntry> schema, String name) {
        if (schema == null) {
            return null;
        }
        for (int i = 0; i < schema.size(); ++i) {
            SchemaEntry cur = schema.get(i);
            if (!cur.name.equals(name)) continue;
            return cur;
        }
        return null;
    }

    public List<SchemaEntry> getSchema(String subject) {
        if (subject.equals(ABOUT_ENUM_REQUESTS)) {
            return this.requestsSchema;
        }
        if (subject.equals(ABOUT_ENUM_SESSIONS)) {
            return this.sessionsSchema;
        }
        return null;
    }

    private void printResponse(List<SchemaEntry> schema, List<Map<String, Object>> rows) throws CMException {
        CMExecutionContext context = CMExecutionContext.get();
        boolean isAdmin = context.getCurrentUserIsAdministrator();
        if (!isAdmin) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "sessionState"));
        }
        CMIndentedPrintStream indentedOut = new CMIndentedPrintStream(this.oStream);
        indentedOut.indent();
        indentedOut.print(baLT);
        indentedOut.print(sessionState.s2ba(this.getCMPrefixString()));
        indentedOut.print(baColon);
        indentedOut.print("sessionStateResponse");
        indentedOut.print(" xmlns:");
        indentedOut.print("cm");
        indentedOut.print("=\"");
        indentedOut.print(this.getBiBusNamespace());
        indentedOut.print("\"");
        indentedOut.println(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        indentedOut.indent();
        indentedOut.println("<item xsi:type=\"cm:sessionStateTable\">");
        indentedOut.indent();
        indentedOut.print("<filteredCount>");
        indentedOut.print(this.filteredCount);
        indentedOut.println("</filteredCount>");
        indentedOut.print("<schema xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:sessionStateSchemaEntry[");
        indentedOut.print(schema.size());
        indentedOut.println("]\">");
        indentedOut.indent();
        for (int i = 0; i < schema.size(); ++i) {
            indentedOut.println("<item xsi:type=\"cm:sessionStateSchemaEntry\">");
            indentedOut.indent();
            indentedOut.print("<name xsi:type=\"xsd:string\">");
            indentedOut.print(schema.get((int)i).name);
            indentedOut.println("</name>");
            indentedOut.print("<dataType xsi:type=\"cm:sessionStateDataTypeEnum\">");
            indentedOut.print(schema.get((int)i).dataType);
            indentedOut.println("</dataType>");
            String units = schema.get((int)i).units;
            if (units != null) {
                indentedOut.print("<units xsi:type=\"xsd:string\">");
                indentedOut.print(units);
                indentedOut.print("</units>");
            }
            indentedOut.unindent();
            indentedOut.println("</item>");
        }
        indentedOut.unindent();
        indentedOut.println("</schema>");
        indentedOut.print("<rows xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:sessionStateRow[");
        indentedOut.print(rows.size());
        indentedOut.println("]\">");
        indentedOut.indent();
        for (Map<String, Object> curInfo : rows) {
            indentedOut.println("<item xsi:type=\"cm:sessionStateRow\">");
            indentedOut.indent();
            indentedOut.print("<entries xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"xsd:string[");
            indentedOut.print(schema.size());
            indentedOut.println("]\">");
            indentedOut.indent();
            for (int i = 0; i < schema.size(); ++i) {
                indentedOut.print("<item xsi:type=\"xsd:string\">");
                Object val = curInfo.get(schema.get((int)i).name);
                if (val != null) {
                    if (val instanceof Date) {
                        indentedOut.print(this.dateTimeFormat.format((Date)val));
                    } else {
                        indentedOut.print(val.toString());
                    }
                }
                indentedOut.println("</item>");
            }
            indentedOut.unindent();
            indentedOut.println("</entries>");
            indentedOut.unindent();
            indentedOut.println("</item>");
        }
        indentedOut.unindent();
        indentedOut.println("</rows>");
        indentedOut.unindent();
        indentedOut.println("</item>");
        indentedOut.unindent();
        indentedOut.print("</");
        indentedOut.print(sessionState.s2ba(this.getCMPrefixString()));
        indentedOut.print(baColon);
        indentedOut.print("sessionStateResponse");
        indentedOut.print(">");
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        boolean rc = true;
        final Date curTime = new Date();
        if (this.requestInfo.about_.equalsIgnoreCase(ABOUT_ENUM_REQUESTS)) {
            final ArrayList<Map<String, Object>> requestStates = new ArrayList<Map<String, Object>>();
            CMExecutionContext.iterateOverContexts(new CMSessionStateRequestsAction(){

                @Override
                public void doAction(CMExecutionContext context) {
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.put(sessionState.TITLE_REQUEST, context.getIPFOperation());
                    values.put(sessionState.TITLE_SESSION, context.getSessionContext());
                    values.put(sessionState.TITLE_SIGNATURE, context.getRequestContext());
                    values.put(sessionState.TITLE_THREAD, context.getName());
                    values.put(sessionState.TITLE_USERNAME, context.getCurrentUser());
                    values.put(sessionState.TITLE_IPFPATH, context.getIPFObjectPath());
                    values.put(sessionState.TITLE_EXECUTIONTIME, new Long(context.getExecutionTime()));
                    values.put(sessionState.TITLE_SAMPLETIME, curTime);
                    requestStates.add(values);
                }
            });
            this.filter(requestStates);
            this.printResponse(this.requestsSchema, requestStates);
        } else if (this.requestInfo.about_.equalsIgnoreCase(ABOUT_ENUM_SESSIONS)) {
            final ArrayList<Map<String, Object>> sessionStates = new ArrayList<Map<String, Object>>();
            CMExecutionContext.getSessionCache().iterateOverPassports(new UserSessionsVisitor(){

                @Override
                public void visit(String passportId, UserSessionCacheEntry entry) {
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.put(sessionState.TITLE_SESSION, entry.sessionContext_);
                    values.put(sessionState.TITLE_USERNAME, entry.currentUserDisplayName_);
                    values.put(sessionState.TITLE_CREATIONTIME, entry.creationTime_);
                    values.put(sessionState.TITLE_LASTAUTHENTICATETIME, new Date(entry.lastAuthenticateTimeMillis_));
                    values.put(sessionState.TITLE_SAMPLETIME, curTime);
                    sessionStates.add(values);
                }
            });
            this.filter(sessionStates);
            this.printResponse(this.sessionsSchema, sessionStates);
        } else if (this.requestInfo.about_.equalsIgnoreCase(ABOUT_ENUM_SYSTEM)) {
            // empty if block
        }
        return rc;
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        this.requestInfo = new RequestInfo();
        this.requestInfo.requestElement_ = requestElement;
        this.requestInfo.about_ = ABOUT_ENUM_REQUESTS;
        this.requestInfo.maxObjects_ = 0;
        XMLElement options = requestElement.getOptionalChildWithName("options");
        if (options != null) {
            ArrayList<XMLElement> filters;
            XMLElement filtersElement;
            XMLElement maxObjectsElement;
            XMLElement aboutElement = options.getOptionalChildWithName("about");
            if (aboutElement != null && aboutElement.value_ != null) {
                if (aboutElement.value_.equalsIgnoreCase(ABOUT_ENUM_REQUESTS)) {
                    this.requestInfo.about_ = ABOUT_ENUM_REQUESTS;
                } else if (aboutElement.value_.equalsIgnoreCase(ABOUT_ENUM_SESSIONS)) {
                    this.requestInfo.about_ = ABOUT_ENUM_SESSIONS;
                } else if (aboutElement.value_.equalsIgnoreCase(ABOUT_ENUM_SYSTEM)) {
                    this.requestInfo.about_ = ABOUT_ENUM_SYSTEM;
                } else {
                    throw new CMException("cmBadAttrValue", new CMException.Parm("Value", aboutElement.value_), new CMException.Parm("Attribute", "about"));
                }
            }
            if ((maxObjectsElement = options.getOptionalChildWithName("maxObjects")) != null && maxObjectsElement.value_ != null) {
                try {
                    Integer intValue = new Integer(maxObjectsElement.value_);
                    this.requestInfo.maxObjects_ = intValue;
                }
                catch (NumberFormatException e) {
                    throw new CMException("cmBadAttribute", new CMException.Parm("Name", "maxObjects"));
                }
            }
            if ((filtersElement = options.getOptionalChildWithName(FILTERS)) != null && (filters = filtersElement.getChildrenAllShouldBe(FILTER)) != null) {
                this.requestInfo.filters = new Filter[filters.size()];
                List<SchemaEntry> schema = this.getSchema(this.requestInfo.about_);
                for (int i = 0; i < filters.size(); ++i) {
                    XMLElement filterEle = (XMLElement)filters.get(i);
                    XMLElement fieldEle = filterEle.getChildWithName(FIELD);
                    XMLElement operatorEle = filterEle.getChildWithName(OPERATOR);
                    XMLElement operandEle = filterEle.getChildWithName(OPERAND);
                    SchemaEntry entry = this.getSchemaEntry(schema, fieldEle.value_);
                    if (entry == null) {
                        throw new CMException("cmBadAttrValue", new CMException.Parm("Value", fieldEle.value_), new CMException.Parm("Attribute", FIELD));
                    }
                    String operator = operatorEle.value_;
                    if (FILTER_OPERATIONS.indexOf(operator) == -1) {
                        throw new CMException("cmBadAttrValue", new CMException.Parm("Value", operatorEle.value_), new CMException.Parm("Attribute", OPERATOR));
                    }
                    this.requestInfo.filters[i] = new Filter(fieldEle.value_, operator, operandEle.value_, entry);
                }
            }
        }
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    static {
        FILTER_OPERATIONS.add(FILTER_OPERATION_EQUALS);
        FILTER_OPERATIONS.add(FILTER_OPERATION_NOTEQUALS);
        FILTER_OPERATIONS.add(FILTER_OPERATION_CONTAINS);
        FILTER_OPERATIONS.add(FILTER_OPERATION_NOTCONTAINS);
        FILTER_OPERATIONS.add(FILTER_OPERATION_STARTSWITH);
        FILTER_OPERATIONS.add(FILTER_OPERATION_NOTSTARTSWITH);
        FILTER_OPERATIONS.add(FILTER_OPERATION_GREATERTHAN);
        FILTER_OPERATIONS.add(FILTER_OPERATION_GREATERTHANEQUAL);
        FILTER_OPERATIONS.add(FILTER_OPERATION_LESSTHAN);
        FILTER_OPERATIONS.add(FILTER_OPERATION_LESSTHANEQUAL);
    }

    public class SchemaEntry {
        String name = null;
        String dataType = null;
        String units = null;

        SchemaEntry(String name, String dataType, String units) {
            this.name = name;
            this.dataType = dataType;
            this.units = units;
        }
    }

    public class Filter {
        public String field;
        public String operator;
        public String operand;
        public SchemaEntry correspondingSchemaEntry;

        public Filter(String field, String operator, String operand, SchemaEntry correspondingSchemaEntry) {
            this.field = field;
            this.operator = operator;
            this.operand = operand;
            this.correspondingSchemaEntry = correspondingSchemaEntry;
            if (this.operand == null && correspondingSchemaEntry != null && correspondingSchemaEntry.dataType.equals(sessionState.DATATYPE_STRING)) {
                this.operand = "";
            }
        }

        public boolean filter(Map<String, Object> row) throws CMException {
            if (this.correspondingSchemaEntry == null || this.operand == null) {
                return true;
            }
            String dataType = this.correspondingSchemaEntry.dataType;
            Object fieldVal = row.get(this.field);
            if (fieldVal == null && (fieldVal = this.getNullReplacement(dataType)) == null) {
                return false;
            }
            if (this.isStringBasedOperation(this.operator) || dataType.equals(sessionState.DATATYPE_STRING)) {
                String rowVal = fieldVal.toString();
                if (dataType.equals(sessionState.DATATYPE_DATETIME)) {
                    rowVal = sessionState.this.dateTimeFormat.format((Date)fieldVal);
                }
                return this.evaluateString(this.operator, rowVal, this.operand);
            }
            if (dataType.equals(sessionState.DATATYPE_DATETIME)) {
                try {
                    Date rowDate = (Date)fieldVal;
                    Date operandDate = sessionState.this.dateTimeFormat.parse(this.operand);
                    return this.evaluateDate(this.operator, rowDate, operandDate);
                }
                catch (ParseException e) {
                    throw new CMException("cmSessionStateFilterWrongDataType", new CMException.Parm("DataType", sessionState.DATATYPE_DATETIME), new CMException.Parm("FieldName", this.field), new CMException.Parm("Value", this.operand));
                }
            }
            if (dataType.equals(sessionState.DATATYPE_LONG)) {
                try {
                    long rowLong = (Long)fieldVal;
                    long operandLong = Long.parseLong(this.operand);
                    return this.evaluateLong(this.operator, rowLong, operandLong);
                }
                catch (NumberFormatException e) {
                    throw new CMException("cmSessionStateFilterWrongDataType", new CMException.Parm("DataType", sessionState.DATATYPE_LONG), new CMException.Parm("FieldName", this.field), new CMException.Parm("Value", this.operand));
                }
            }
            if (dataType.equals(sessionState.DATATYPE_DOUBLE)) {
                try {
                    double rowDouble = (Double)fieldVal;
                    double operandDouble = Double.parseDouble(this.operand);
                    return this.evaluateDouble(this.operator, rowDouble, operandDouble);
                }
                catch (NumberFormatException e) {
                    throw new CMException("cmSessionStateFilterWrongDataType", new CMException.Parm("DataType", sessionState.DATATYPE_DOUBLE), new CMException.Parm("FieldName", this.field), new CMException.Parm("Value", this.operand));
                }
            }
            return true;
        }

        private Object getNullReplacement(String dataType) {
            if (dataType.equals(sessionState.DATATYPE_STRING)) {
                return "";
            }
            if (dataType.equals(sessionState.DATATYPE_DOUBLE)) {
                return new Double(0.0);
            }
            if (dataType.equals(sessionState.DATATYPE_LONG)) {
                return new Long(0L);
            }
            if (dataType.equals(sessionState.DATATYPE_DATETIME)) {
                return null;
            }
            return null;
        }

        private boolean isStringBasedOperation(String operator) {
            return operator.equals(sessionState.FILTER_OPERATION_CONTAINS) || operator.equals(sessionState.FILTER_OPERATION_NOTCONTAINS) || operator.equals(sessionState.FILTER_OPERATION_STARTSWITH) || operator.equals(sessionState.FILTER_OPERATION_NOTSTARTSWITH);
        }

        private boolean evaluateString(String operator, String rowValue, String operand) {
            boolean result = true;
            result = sessionState.FILTER_OPERATION_EQUALS.equals(operator) ? rowValue.equals(operand) : (sessionState.FILTER_OPERATION_NOTEQUALS.equals(operator) ? !rowValue.equals(operand) : (sessionState.FILTER_OPERATION_CONTAINS.equals(operator) ? rowValue.indexOf(operand) != -1 : (sessionState.FILTER_OPERATION_NOTCONTAINS.equals(operator) ? rowValue.indexOf(operand) == -1 : (sessionState.FILTER_OPERATION_STARTSWITH.equals(operator) ? rowValue.startsWith(operand) : (sessionState.FILTER_OPERATION_NOTSTARTSWITH.equals(operator) ? !rowValue.startsWith(operand) : true)))));
            return result;
        }

        private boolean evaluateLong(String operator, long rowValue, long operand) {
            boolean result = true;
            result = sessionState.FILTER_OPERATION_EQUALS.equals(operator) ? rowValue == operand : (sessionState.FILTER_OPERATION_NOTEQUALS.equals(operator) ? rowValue != operand : (sessionState.FILTER_OPERATION_GREATERTHAN.equals(operator) ? rowValue > operand : (sessionState.FILTER_OPERATION_GREATERTHANEQUAL.equals(operator) ? rowValue >= operand : (sessionState.FILTER_OPERATION_LESSTHAN.equals(operator) ? rowValue < operand : (sessionState.FILTER_OPERATION_LESSTHANEQUAL.equals(operator) ? rowValue <= operand : true)))));
            return result;
        }

        private boolean evaluateDouble(String operator, double rowValue, double operand) {
            boolean result = true;
            result = sessionState.FILTER_OPERATION_EQUALS.equals(operator) ? rowValue == operand : (sessionState.FILTER_OPERATION_NOTEQUALS.equals(operator) ? rowValue != operand : (sessionState.FILTER_OPERATION_GREATERTHAN.equals(operator) ? rowValue > operand : (sessionState.FILTER_OPERATION_GREATERTHANEQUAL.equals(operator) ? rowValue >= operand : (sessionState.FILTER_OPERATION_LESSTHAN.equals(operator) ? rowValue < operand : (sessionState.FILTER_OPERATION_LESSTHANEQUAL.equals(operator) ? rowValue <= operand : true)))));
            return result;
        }

        private boolean evaluateDate(String operator, Date rowValue, Date operand) {
            boolean result = true;
            int r = rowValue.compareTo(operand);
            result = sessionState.FILTER_OPERATION_EQUALS.equals(operator) ? r == 0 : (sessionState.FILTER_OPERATION_NOTEQUALS.equals(operator) ? r != 0 : (sessionState.FILTER_OPERATION_GREATERTHAN.equals(operator) ? r > 0 : (sessionState.FILTER_OPERATION_GREATERTHANEQUAL.equals(operator) ? r >= 0 : (sessionState.FILTER_OPERATION_LESSTHAN.equals(operator) ? r < 0 : (sessionState.FILTER_OPERATION_LESSTHANEQUAL.equals(operator) ? r <= 0 : true)))));
            return result;
        }
    }

    public class RequestInfo {
        public XMLElement requestElement_;
        public int maxObjects_;
        public String about_;
        public Filter[] filters;
    }
}

