/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.UserSessionCache;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.trustedServices.trustedService;
import java.util.ArrayList;
import java.util.List;

public class setIdentity
extends RequestHandler {
    private static final String ACCOUNT = "account";
    private static final String WRITE_TENANT_ID = "writeTenantID";
    private static final String READ_TENANT_IDS = "readTenantIDs";
    private static final String ELEM_IDENTITY = "identity";
    private String passportId;
    private String writeTenantName;
    private List<String> readTenantNames;
    private CMExecutionContext ctx;

    public setIdentity(CMStore store) {
        super(store);
    }

    public setIdentity(CMStore store, CMExecutionContext ctx) {
        this(store);
        this.ctx = ctx;
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.ctx == null) {
            this.ctx = CMExecutionContext.get();
        }
        if (!this.isRequestTrusted(this.ctx) && !this.ctx.executingStaticRequest()) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "setIdentity"));
        }
        XMLElement passportElement = requestElement.getChildWithName("CAMPassport");
        this.passportId = passportElement.getChildValueWithName("id");
        XMLElement queryResultElement = requestElement.getChildWithName(ELEM_IDENTITY);
        XMLElement itemElement = this.getItemWithType(queryResultElement, ACCOUNT);
        this.writeTenantName = this.extractWriteTenantID(itemElement);
        this.readTenantNames = this.extractReadTenantID(itemElement);
    }

    private String extractWriteTenantID(XMLElement itemElement) throws CMException {
        XMLElement writeTenantIDElement = itemElement.getOptionalChildWithName(WRITE_TENANT_ID);
        if (writeTenantIDElement != null) {
            try {
                String writeTenantID = writeTenantIDElement.getChildValueWithName("value");
                return writeTenantID == null ? "" : writeTenantID;
            }
            catch (CMException cMException) {
                // empty catch block
            }
        }
        return this.extractDefaultTenantID(itemElement);
    }

    private String extractDefaultTenantID(XMLElement itemElement) throws CMException {
        String tenantId = null;
        XMLElement tenantIDElement = itemElement.getOptionalChildWithName("tenantID");
        if (tenantIDElement != null) {
            tenantId = tenantIDElement.getChildValueWithName("value");
        }
        if (tenantId == null) {
            tenantId = "";
        }
        return tenantId;
    }

    private List<String> extractReadTenantID(XMLElement itemElement) {
        List<String> readTenantNames = null;
        XMLElement readTenantIDsElement = itemElement.getOptionalChildWithName(READ_TENANT_IDS);
        if (readTenantIDsElement != null && readTenantIDsElement.hasChildren()) {
            readTenantNames = this.getItemValues(readTenantIDsElement);
        }
        return readTenantNames;
    }

    private XMLElement getItemWithType(XMLElement element, String name) throws CMException {
        ArrayList<XMLElement> itemElements = element.getChildren();
        for (XMLElement itemElement : itemElements) {
            if (!name.equals(itemElement.xsiType_)) continue;
            return itemElement;
        }
        throw new CMException("cmExpectedElementAttrMissing", new CMException.Parm("Name", "item"), new CMException.Parm("Attribute", "type"), new CMException.Parm("Value", name));
    }

    private List<String> getItemValues(XMLElement element) {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<XMLElement> itemElements = element.getChildren();
        if (itemElements != null) {
            for (XMLElement itemElement : itemElements) {
                values.add(itemElement.value_ != null ? itemElement.value_ : "");
            }
        }
        return values;
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        this.getParamsAll();
    }

    @Override
    public boolean handle(IConfiguration config_, Request r) throws CMException {
        int[] readTenantIDs;
        UserSessionCache sessionCache = CMExecutionContext.getSessionCache();
        UserSessionCacheEntry userSessionCacheEntry = sessionCache.lookupPassport(this.passportId);
        if (userSessionCacheEntry == null) {
            throw new CMException("cmUnknownPassportId");
        }
        int writeTenantID = this.tenantRegistry.getTenantIdIntFromString(this.writeTenantName, false);
        userSessionCacheEntry.setTenantId(writeTenantID);
        if (this.readTenantNames != null) {
            if (!this.readTenantNames.contains("")) {
                this.readTenantNames.add("");
            }
            readTenantIDs = this.tenantRegistry.getTenantIdsAsIntArray(this.readTenantNames, false);
        } else {
            readTenantIDs = userSessionCacheEntry.getBoundedTenantIds();
        }
        userSessionCacheEntry.setReadTenantIds(readTenantIDs);
        this.writeResponse();
        return true;
    }

    private boolean isRequestTrusted(CMExecutionContext ctx) {
        trustedService trustedServiceObj = ctx.getTrustedService();
        if (trustedServiceObj != null) {
            return trustedServiceObj.getId().equalsIgnoreCase("CAMSASVC");
        }
        return false;
    }

    private void writeResponse() {
        this.emitTabs(1);
        this.emit("<" + this.getMethodNamespace().getPrefix() + ":" + "setIdentityResponse");
        this.emit(" xmlns:" + this.getMethodNamespace().getPrefix() + "=\"" + this.getMethodNamespace().getUri() + "\"");
        this.emit(" />");
    }

    protected CMSOAPConstants.XMLNamespace getMethodNamespace() {
        return CMSOAPConstants.NS_CM;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }
}

