/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cmutils.xml.XMLUtils;
import java.lang.reflect.Method;

public class stackTrace
extends RequestHandler {
    private static Object objThreadMXBean = null;
    private static Method methodGetAllThreadIds = null;
    private static Method methodGetThreadInfo = null;
    private static Method methodGetThreadName = null;
    private static Method methodGetStackTrace = null;

    public stackTrace(CMStore store) {
        super(store);
    }

    private static void outputThreadDumps(CMIndentedPrintStream out) {
        if (objThreadMXBean == null) {
            return;
        }
        try {
            long[] ids = (long[])methodGetAllThreadIds.invoke(objThreadMXBean, new Object[0]);
            if (ids == null) {
                return;
            }
            Object objThreadInfo = null;
            Object[] stackTraceElements = null;
            String sThreadName = "";
            int nIds = ids.length;
            for (int i = 0; i < nIds; ++i) {
                objThreadInfo = methodGetThreadInfo.invoke(objThreadMXBean, new Long(ids[i]), new Integer(Integer.MAX_VALUE));
                if (objThreadInfo == null) continue;
                sThreadName = (String)methodGetThreadName.invoke(objThreadInfo, new Object[0]);
                stackTraceElements = (Object[])methodGetStackTrace.invoke(objThreadInfo, new Object[0]);
                if (sThreadName == null || sThreadName.length() == 0 || stackTraceElements == null || stackTraceElements.length == 0) continue;
                out.println("<Thread>");
                out.indent();
                out.print("<Name>");
                out.print(XMLUtils.encode((String)sThreadName));
                out.println("</Name>");
                out.println("<StackTrace>");
                out.indent();
                for (int j = 0; j < stackTraceElements.length; ++j) {
                    out.print("<StackTraceElement>");
                    out.print(XMLUtils.encode((String)stackTraceElements[j].toString()));
                    out.println("</StackTraceElement>");
                }
                out.unindent();
                out.println("</StackTrace>");
                out.unindent();
                out.println("</Thread>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printResponse() {
        CMIndentedPrintStream out = new CMIndentedPrintStream(this.oStream);
        out.indent();
        out.print("<");
        out.print(this.getCMPrefixString());
        out.print(":");
        out.print("stackTraceResponse");
        out.print(" xmlns:");
        out.print("cm");
        out.print("=\"");
        out.print(this.getBiBusNamespace());
        out.print("\"");
        out.println(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        out.indent();
        stackTrace.outputThreadDumps(out);
        out.unindent();
        out.print("</");
        out.print(this.getCMPrefixString());
        out.print(":");
        out.print("stackTraceResponse");
        out.print(">");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
    }

    @Override
    public boolean handle(IConfiguration c, Request r) throws CMException {
        boolean rc = true;
        CMExecutionContext context = CMExecutionContext.get();
        boolean isAdmin = context.getCurrentUserIsAdministrator();
        if (!isAdmin) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", "stackTrace"));
        }
        this.printResponse();
        return rc;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    static {
        try {
            Method methodGetThreadMXBean;
            Class<?> classManagementFactory = Class.forName("java.lang.management.ManagementFactory");
            if (classManagementFactory != null && (methodGetThreadMXBean = classManagementFactory.getMethod("getThreadMXBean", new Class[0])) != null) {
                Class<?> classThreadInfo;
                objThreadMXBean = methodGetThreadMXBean.invoke(null, new Object[0]);
                Class<?> classThreadMXBean = Class.forName("java.lang.management.ThreadMXBean");
                if (classThreadMXBean != null) {
                    methodGetAllThreadIds = classThreadMXBean.getMethod("getAllThreadIds", new Class[0]);
                    methodGetThreadInfo = classThreadMXBean.getMethod("getThreadInfo", Long.TYPE, Integer.TYPE);
                }
                if ((classThreadInfo = Class.forName("java.lang.management.ThreadInfo")) != null) {
                    methodGetThreadName = classThreadInfo.getMethod("getThreadName", new Class[0]);
                    methodGetStackTrace = classThreadInfo.getMethod("getStackTrace", new Class[0]);
                }
            }
            if (methodGetAllThreadIds == null || methodGetThreadInfo == null || methodGetThreadName == null || methodGetStackTrace == null) {
                objThreadMXBean = null;
            }
        }
        catch (Exception e) {
            objThreadMXBean = null;
        }
    }
}

