/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.externalRepository.CMPluginResourceLoader;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnectionProperties;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.IRepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.IRepositoryPluginManager;
import com.cognos.cm.repositoryPluginFramework.RepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.cognos.cm.util.DataEncryptionHelper;
import com.cognos.cmutils.properties.Credentials;
import com.cognos.cmutils.properties.IDataEncryptionHelper;
import java.util.Properties;

public class testDataSourceConnection
extends RequestHandler {
    private String _connectionString;
    private String _user;
    private String _password;

    public testDataSourceConnection(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        CMExecutionContext currentContext = CMExecutionContext.get();
        currentContext.setIPFCategory("Audit.Admin.CM");
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        XMLElement connectionStringXmlElm = requestElement.getChildWithName("connectionString");
        XMLElement credentialsXmlElm = requestElement.getChildWithName("credentials");
        this.setConnectionString(connectionStringXmlElm);
        this.setCredentials(credentialsXmlElm);
    }

    private void setCredentials(XMLElement credentialsXmlElm) throws CMException {
        this._user = null;
        this._password = null;
        try {
            String encoddedCredentials;
            if (credentialsXmlElm != null && (encoddedCredentials = credentialsXmlElm.value_) != null) {
                String[] decriptedCredentials = this.decriptCredentials(encoddedCredentials);
                this._user = decriptedCredentials[0];
                this._password = decriptedCredentials[1];
            }
        }
        catch (Exception e) {
            throw new CMException(e.getMessage());
        }
    }

    protected String[] decriptCredentials(String encoddedCredentials) throws Exception {
        EncryptingSession es = CMServlet.CAMFactory_.createEncryptingSession();
        DataEncryptionHelper encryptionHelper = new DataEncryptionHelper(es);
        Credentials cred = new Credentials((IDataEncryptionHelper)encryptionHelper);
        String[] decriptedCredentials = cred.createCredentialsPropertiesFromPropertyValue(encoddedCredentials);
        return decriptedCredentials;
    }

    private void setConnectionString(XMLElement connectionStringXmlElm) {
        this._connectionString = connectionStringXmlElm.value_;
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        this.hasCanUseDataSourcesToolCapability();
        CMIndentedPrintStream out = this.getCMIndentedPrintStream();
        RepositoryConnection connection = null;
        IRepositoryConnectionString connectionString = this.getRepositoryConnectionString();
        IPluginResourceLoader repositoryServiceResourceLoader = this.createResourceLoader();
        Properties connectionProperties = new Properties();
        if (this._user != null) {
            connectionProperties.put("user", this._user);
        }
        if (this._password != null) {
            connectionProperties.put("password", this._password);
        }
        connectionProperties.put("CONSUMER_NAME", "CM");
        connectionProperties.put(RepositoryConnectionProperties.TEST_REPOSITORY_CONNECTION, "true");
        try {
            IRepositoryPluginManager manager = this.getRepositoryManager();
            connection = manager.getConnection(connectionString, connectionProperties, repositoryServiceResourceLoader);
        }
        catch (RepositoryException e) {
            throw new CMException((Exception)((Object)e), "cmFaiedToConnectToRepository", new CMException.Parm("Connection", this._connectionString));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        out.indent();
        out.print(baLT);
        out.print(testDataSourceConnection.s2ba(this.getCMPrefixString()));
        out.print(baColon);
        out.print("testDataSourceConnectionResponse");
        out.print(" xmlns:");
        out.print("cm");
        out.print("=\"");
        out.print(this.getBiBusNamespace());
        out.print("\">\r\n");
        out.println();
        out.indent();
        out.unindent();
        out.print(baLT_Slash);
        out.print(testDataSourceConnection.s2ba(this.getCMPrefixString()));
        out.print(baColon);
        out.print("testDataSourceConnectionResponse");
        out.print(baGT);
        out.unindent();
        out.flush();
        return true;
    }

    protected CMIndentedPrintStream getCMIndentedPrintStream() {
        CMIndentedPrintStream out = new CMIndentedPrintStream(this.oStream);
        return out;
    }

    protected IRepositoryConnectionString getRepositoryConnectionString() throws CMException {
        RepositoryConnectionString connectionString = null;
        try {
            connectionString = new RepositoryConnectionString(this._connectionString);
        }
        catch (RepositoryException e1) {
            throw new CMException("cmFaiedToProcessRepositoryConnectionString", new CMException.Parm("Connection", this._connectionString));
        }
        return connectionString;
    }

    protected IPluginResourceLoader createResourceLoader() {
        return new CMPluginResourceLoader();
    }

    protected IRepositoryPluginManager getRepositoryManager() throws RepositoryException {
        return RepositoryPluginManager.getManager();
    }

    private void hasCanUseDataSourcesToolCapability() throws CMException {
        CMExecutionContext currContext = this.getContext();
        if (!currContext.hasCapability("canUseDataSourcesTool")) {
            throw new CMException("cmNoRequiredCapability", new CMException.Parm("Capability", "canUseDataSourcesTool"));
        }
    }

    protected CMExecutionContext getContext() {
        CMExecutionContext currContext = CMExecutionContext.get();
        return currContext;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    public String getConnectionString() {
        return this._connectionString;
    }

    public String getUserName() {
        return this._user;
    }

    public String getPassword() {
        return this._password;
    }
}

