/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request;

import com.cognos.cm.connectors.SDSConnector.SDSConnector;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.PortalOptionEnum;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantIdUpdateValidator;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMRetentionRuleArray;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.request.AbstractQuery;
import com.cognos.cm.request.ModifyingQuery;
import com.cognos.cm.request.UpdateRequestTransactionManager;
import com.cognos.cm.server.AccountTemplates;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AuditContext;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreDeadlock;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMAAAObjectPropertiesDoc;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMQueryUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;

public class update
extends ModifyingQuery {
    private AccountTemplates accountTemplates = null;

    public update(CMStore store) {
        super(store);
    }

    @Override
    public void prepareRequest(IConfiguration c, Request rq) throws CMException {
        if (!this.parseForFirstDataElement()) {
            return;
        }
        this.getParams(this.didGetParmUsingXMLEl_);
        ModifyingQuery.RequestInfo requestInfo = (ModifyingQuery.RequestInfo)this.requestsInfo_.get(0);
        CMStoreXPath objectContext = null;
        if (requestInfo.addDefs_ != null && requestInfo.addDefs_.size() > 0) {
            AddDef addDef = requestInfo.addDefs_.get(0);
            objectContext = addDef.searchPath;
            if (objectContext != null && objectContext.isUnion()) {
                throw new CMException("cmBadCompoundPathOp", new CMException.Parm("Path", objectContext.getOriginalPath()));
            }
        }
    }

    protected String getUpdateResultString() {
        return "updateResult";
    }

    @Override
    public void getParams(XMLElement requestElement) throws CMException {
        if (this.didGetParmUsingXMLEl_ == requestElement && this.requestsInfo_.size() > 0) {
            this.didGetParmUsingXMLEl_ = null;
            return;
        }
        if (this.lockedPaths_ == null) {
            this.lockedPaths_ = new ArrayList();
        }
        ModifyingQuery.RequestInfo requestInfo = new ModifyingQuery.RequestInfo();
        requestInfo.requestElement_ = requestElement;
        this.requestsInfo_.add(requestInfo);
        XMLElement xmlElm = requestElement.getOptionalChildWithName("updates");
        if (xmlElm == null) {
            xmlElm = requestElement.getChildWithName("objects");
        }
        ArrayList<XMLElement> aClassList = xmlElm.getChildren();
        requestInfo.addDefs_ = this.getObjectsIntoAddDefs(aClassList, 13);
        for (AddDef addDef : requestInfo.addDefs_) {
            CMStoreXPath storePath = addDef.searchPath;
            this.validatePathForNonQueryCommand(storePath, "update");
        }
        this.parseOptions(requestElement, requestInfo);
        this.parseResponseDelay(requestElement);
    }

    private void parseResponseDelay(XMLElement requestElement) throws CMException {
        long responseDelay = requestElement.getOptionalChildLongValueWithName("responseDelay", -1L);
        if (responseDelay > 0L) {
            this.setResponseDelay(responseDelay);
        }
    }

    private void parseOptions(XMLElement requestElement, ModifyingQuery.RequestInfo requestInfo) throws CMException {
        boolean ignoreInvalidObjectRefs;
        XMLElement optionsXmlElm = requestElement.getOptionalChildWithName("options");
        if (optionsXmlElm == null) {
            return;
        }
        XMLElement returnPropsEle = optionsXmlElm.getOptionalChildWithName("returnProperties");
        if (returnPropsEle != null && returnPropsEle.hasChildren()) {
            CMPropertySet propSet = this.getPropertySet();
            if (this.propertiesList_ == null) {
                this.propertiesList_ = new ArrayList();
            }
            for (XMLElement item : returnPropsEle.getChildren()) {
                this.addProperty(item.value_, this.propertiesList_, propSet);
            }
        }
        if (ignoreInvalidObjectRefs = optionsXmlElm.getOptionalChildBooleanValueWithName("ignoreInvalidObjectReference", false)) {
            requestInfo.failInvalidReferences_ = false;
        }
        requestInfo.updateTenantIDRecursive = optionsXmlElm.getOptionalChildBooleanValueWithName("updateTenantIDRecursive", false);
        requestInfo.forceTenantIdUpdateOnDescendants = optionsXmlElm.getOptionalChildBooleanValueWithName("forceTenantIDUpdateOnDescendants", false);
        requestInfo.faultOnEmptySelection = optionsXmlElm.getOptionalChildBooleanValueWithName("faultOnEmptySelection", true);
    }

    @Override
    public boolean handle(IConfiguration c, Request rq) throws CMException {
        return this.runCommands("updateResponse", "updateReply");
    }

    @Override
    public boolean doCommand(Object requestInfoObj, String tabPrefix) throws CMException {
        ModifyingQuery.RequestInfo requestInfo = (ModifyingQuery.RequestInfo)requestInfoObj;
        if (requestInfo.addDefs_ == null || requestInfo.addDefs_.size() < 1) {
            throw new CMException("cmNoSelection");
        }
        String tabPrefix1 = tabPrefix + "\t";
        CMIntList affectedObjects = new CMIntList();
        this.addBuffer_ = new StringBuffer();
        DeadlockContext context = new DeadlockContext();
        context.requestInfo = requestInfo;
        context.affectedObjects = affectedObjects;
        context.committed = false;
        try {
            try {
                Class[] args = new Class[]{DeadlockContext.class, Integer.class};
                String methodName = "executeInDeadlockLoop";
                Method method = update.class.getDeclaredMethod("executeInDeadlockLoop", args);
                CMWhileDeadlockExecutor.execute(this, context, method);
            }
            catch (CMException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new CMException(t, "cmUnexpectedError");
            }
        }
        catch (CMException e1) {
            if (e1.getCode() == "cmEmptySelection") {
                throw e1;
            }
            if (CMError.isServerFault(e1)) {
                throw e1;
            }
            if (e1.getCode() == "cmDuplicateObject") {
                throw e1;
            }
            String path = context.currentPath == null ? "(null)" : context.currentPath.toString();
            throw new CMException((Exception)e1, "cmUpdateFailed1", new CMException.Parm("path", path));
        }
        if (context.committed) {
            this.postSuccessfulOperation();
            this.writeObjects(tabPrefix1, affectedObjects);
        }
        if (this.accountTemplates != null) {
            this.accountTemplates.update(CMExecutionContext.get().getCurrentUserContentLocale());
        }
        String objects = this.addBuffer_.toString();
        this.addBuffer_ = null;
        this.emit(tabPrefix);
        this.emitArrayElement(this.getUpdateResultString(), "cm", "baseClass", affectedObjects.size());
        this.emit(objects);
        this.emit(tabPrefix);
        this.emitEndElement(this.getUpdateResultString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareLocks() throws CMException {
        this.lockMgr_.releaseLocks();
        if (CMExecutionContext.get().getAuthenticateCreateSession()) {
            this.store_.createSessionStorage();
        }
        for (int iR = 0; iR < this.requestsInfo_.size(); ++iR) {
            ModifyingQuery.RequestInfo requestInfo = (ModifyingQuery.RequestInfo)this.requestsInfo_.get(iR);
            for (AddDef addDef : requestInfo.addDefs_) {
                this.validateObjectProperties(addDef, requestInfo.failInvalidReferences_);
                this.prepareTriggerDefs(addDef, addDef.searchPath, null);
                CMObjectClass objCls = addDef.objectClass;
                if (objCls != CMObjectClass.ACCOUNT && objCls != CMObjectClass.NAMESPACEFOLDER && objCls != CMObjectClass.GROUP && objCls != CMObjectClass.ROLE) continue;
                if (addDef.searchPath == null) {
                    throw new CMException("cmNoSelection");
                }
                addDef.searchPath.ResolveCurrentUserSteps(false);
                int permissions = 8704;
                CMStoreQueryResults results = this.store_.executeQuery(addDef.searchPath, null, null, 0, permissions, null);
                try {
                    String secObjSearchPath = null;
                    int numSecObjs = 0;
                    while (results.next()) {
                        secObjSearchPath = results.getSearchPath();
                        CMObjectClass objClass = results.getObjectClass();
                        if (objClass == CMObjectClass.ACCOUNT || objClass == CMObjectClass.GROUP || objClass == CMObjectClass.NAMESPACEFOLDER || objClass == CMObjectClass.ROLE) {
                            this.store_.createSecurityProxyObject(CMCAMIDHelper.CAMIDFromSearchPath(secObjSearchPath), null, objClass);
                        }
                        ++numSecObjs;
                    }
                    if (numSecObjs != true) continue;
                    addDef.searchPath = this.createXPath(secObjSearchPath);
                    addDef.searchPath.setLockManagerUsageFlag(14);
                    this.addObjectContextToLockPaths(addDef.searchPath);
                }
                finally {
                    results.release();
                    this.lockMgr_.releaseLocks();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDeadlockLoop(DeadlockContext context, Integer deadlockRetryNumber) throws CMException {
        if (this.addBuffer_ != null) {
            this.addBuffer_.setLength(0);
        }
        context.affectedObjects.setSize(0);
        ArrayList<AddDef> addDefs = context.requestInfo.addDefs_;
        UpdateDef[] updateDefs = new UpdateDef[addDefs.size()];
        for (int i = 0; i < addDefs.size(); ++i) {
            AddDef addDef = addDefs.get(i);
            updateDefs[i] = new UpdateDef(addDef);
        }
        try {
            this.executeTransactions(context, deadlockRetryNumber, updateDefs);
        }
        finally {
            try {
                this.store_.rollbackOpenTransaction();
            }
            catch (Exception exception) {}
            for (UpdateDef updateDef : updateDefs) {
                updateDef.release();
            }
        }
    }

    protected void executeTransactions(DeadlockContext context, Integer deadlockRetryNumber, UpdateDef[] updateDefs) throws CMException {
        UpdateRequestTransactionManager transactionManager = new UpdateRequestTransactionManager(this.store_);
        this.setTransactionManager(transactionManager);
        transactionManager.beginUpdateRequest();
        transactionManager.beginUpdatingStore();
        try {
            this.queryTargetObjects(updateDefs, context);
        }
        catch (CMException e) {
            if (e.getCode().equalsIgnoreCase("cmEmptySelection") && !context.requestInfo.faultOnEmptySelection) {
                return;
            }
            throw e;
        }
        this.preLockTargetObjects(updateDefs, context);
        Arrays.sort(updateDefs);
        this.updateTargetObjects(updateDefs, deadlockRetryNumber, context);
        transactionManager.commitUpdatingStore();
        this.doActionsIfRetentionRulesUpdatedCommit(updateDefs);
        transactionManager.commitUpdateRequest();
        context.committed = true;
        context.currentPath = null;
    }

    private void validateUpdateDef(UpdateDef updateDef) throws CMException {
        AddDef addDef = updateDef.addDef;
        this.validateName(addDef);
        if (addDef.objectClass == CMObjectClass.SCHEDULE) {
            this.validateScheduleObject(addDef, true);
            this.validateCredentialAccess(addDef);
        } else if (addDef.objectClass == CMObjectClass.ARCHIVELOCATION) {
            this.validateArchiveLocation(addDef);
        }
        if (addDef.name != null && addDef.localizedName == null) {
            addDef.put(CMProperty.DEFAULTNAME, addDef.name);
        }
        if (addDef.localizedName != null) {
            addDef.put(CMProperty.NAME, addDef.localizedName);
        }
        if (addDef.size() == 0) {
            updateDef.doTheUpdateAction = false;
        }
        if (addDef.contains(CMProperty.RETENTIONS)) {
            this.setDefaultRetentionRules(addDef);
            updateDef.rules = (CMRetentionRuleArray)addDef.get(CMProperty.RETENTIONS);
            this.validateRetentionRules(updateDef.rules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryTargetObjects(UpdateDef[] updateDefs, DeadlockContext context) throws CMException {
        TenantIdUpdateValidator tenantIdUpdateValidator = null;
        for (UpdateDef updateDef : updateDefs) {
            CMDbStoreTypedNameValuePairArray optionArray;
            updateDef.doTheUpdateAction = true;
            AddDef addDef = updateDef.addDef;
            CMProperty[] queryProps = null;
            ArrayList<CMProperty> externalPropList = null;
            boolean bUpdatePolicy = false;
            boolean requiresWriteAccess = false;
            boolean updatingSessionVarsOnly = true;
            context.currentPath = addDef.searchPath;
            boolean isValidTenantIdUpdate = this.isValidTenantIdUpdate(context.requestInfo, addDef);
            if (addDef.searchPath == null) {
                throw new CMException("cmNoSelectPath");
            }
            this.resolveIDBasedReferences(addDef, context.requestInfo.failInvalidReferences_, false, null);
            this.validateUpdateDef(updateDef);
            for (CMProperty prop : addDef.names()) {
                if (prop.isExternal()) {
                    if (externalPropList == null) {
                        externalPropList = new ArrayList<CMProperty>();
                    }
                    externalPropList.add(prop);
                }
                if (addDef.objectClass == CMObjectClass.ACCOUNT && !this.isSessionVarProperty(prop)) {
                    updatingSessionVarsOnly = false;
                }
                if (!prop.requiresWriteAccess()) continue;
                requiresWriteAccess = true;
            }
            if (addDef.objectClass == CMObjectClass.ACCOUNT && updatingSessionVarsOnly && addDef.contains(CMProperty.OPTIONS) && (optionArray = (CMDbStoreTypedNameValuePairArray)addDef.get(CMProperty.OPTIONS)) != null) {
                for (int j = 0; j < optionArray.getSize(); ++j) {
                    String typeName;
                    CMTypedNameValuePair item = optionArray.getPair(j);
                    String name = item.getName();
                    PortalOptionEnum option = PortalOptionEnum.find(name, typeName = item.getTypeName());
                    if (option != null && option.getMappedUserPreference() != null) continue;
                    updatingSessionVarsOnly = false;
                    break;
                }
            }
            if (addDef.contains(CMProperty.POLICIES) || addDef.contains(CMProperty.OWNER)) {
                bUpdatePolicy = true;
            }
            boolean membersPropertyIsEmpty = false;
            boolean isUpdatingTenantIDForRole = false;
            if (addDef.objectClass == CMObjectClass.ROLE) {
                if (addDef.contains(CMProperty.MEMBERS) && addDef.get(CMProperty.MEMBERS) == null) {
                    membersPropertyIsEmpty = true;
                }
                if (addDef.contains(CMProperty.TENANTID)) {
                    isUpdatingTenantIDForRole = true;
                }
            }
            boolean settingRunAsOwner = this.mustVerifyOwnerCredential(addDef, null);
            if (addDef.objectClass.isExternal() && externalPropList != null || membersPropertyIsEmpty || isUpdatingTenantIDForRole) {
                queryProps = new CMProperty[]{CMProperty.ID};
            } else if (settingRunAsOwner) {
                queryProps = new CMProperty[]{CMProperty.OWNER};
            }
            CMStoreXPath objectContext = addDef.searchPath;
            if (addDef.version != null) {
                StringBuilder pathBuf = new StringBuilder(objectContext.getOriginalPath());
                pathBuf.append("[@version=\"").append(addDef.version).append("\"]");
                objectContext = new CMStoreXPath(pathBuf.toString());
            }
            updateDef.qPermissions |= this.calculateQueryPermissions(updateDef, bUpdatePolicy, requiresWriteAccess, updatingSessionVarsOnly);
            CMStoreQueryResults results = null;
            try {
                results = this.store_.executeQuery(objectContext, queryProps, null, 7, updateDef.qPermissions, null);
                if (!results.next()) {
                    this.handleEmptySelection(updateDef);
                }
                updateDef.targetResults = results;
                CMProperty[] externalProps = null;
                if (externalPropList != null && externalPropList.size() > 0) {
                    externalProps = externalPropList.toArray(new CMProperty[externalPropList.size()]);
                }
                CMExecutionContext ctx = CMExecutionContext.get();
                AuditContext auditContext = ctx.getAuditContext();
                do {
                    Object id;
                    boolean isObjectExternal;
                    CMObjectClass objectClass = results.getObjectClass();
                    boolean bl = isObjectExternal = (results.getState() & 2) != 0;
                    if (objectClass != addDef.objectClass) {
                        throw new CMException("cmClassMismatch2", new CMException.Parm("ClassSource", addDef.objectClass.getName()), new CMException.Parm("ClassTarget", objectClass.getName()));
                    }
                    if (isObjectExternal || objectClass == CMObjectClass.NAMESPACE) {
                        if (addDef.name != null) {
                            if (objectClass == CMObjectClass.NAMESPACE) {
                                throw new CMException("cmPropNotUpdateableNamespace", new CMException.Parm("Property", CMProperty.DEFAULTNAME.getName()), new CMException.Parm("Namespace", results.getName()));
                            }
                            throw new CMException("cmPropNotUpdateable1", new CMException.Parm("prop", CMProperty.DEFAULTNAME.getName()));
                        }
                        if (addDef.contains(CMProperty.TENANTID) && objectClass != CMObjectClass.ACCOUNT) {
                            addDef.remove(CMProperty.TENANTID);
                            isValidTenantIdUpdate = false;
                        }
                    }
                    if (isObjectExternal && externalProps != null) {
                        String externalID = results.getValue(0).toString();
                        this.assertExternalPropertiesUpdatable(externalProps, objectClass, externalID);
                    }
                    if ((membersPropertyIsEmpty || isUpdatingTenantIDForRole) && (id = results.getValue(0)) != null && id.toString().equalsIgnoreCase("::System Administrators")) {
                        if (membersPropertyIsEmpty) {
                            throw new CMException("cmEmptySysAdmin");
                        }
                        if (isUpdatingTenantIDForRole) {
                            throw new CMException("cmCantChangeSysAdminTenantID");
                        }
                    }
                    if (objectClass == CMObjectClass.ACCOUNT && results.getSearchPath().equals(CMExecutionContext.get().getCurrentUserSearchPath()) && this.updateSession(addDef)) {
                        updateDef.doTheUpdateAction = false;
                    }
                    if (settingRunAsOwner) {
                        this.assertCredentialAccess((CMBaseClassArray)results.getValue(0));
                    }
                    if (objectClass == CMObjectClass.SCHEDULE && !SDSConnector.currentRequestIsFromSDS()) {
                        addDef.remove(CMProperty.TASKID);
                    }
                    if (objectClass == CMObjectClass.HISTORY) {
                        addDef.remove(CMProperty.DEFAULTNAME);
                    }
                    if (updateDef.doTheUpdateAction) {
                        this.configurationModified(results.getSearchPath(), results.getObjectClass());
                    }
                    int cmid = results.getObjectID();
                    context.affectedObjects.add(cmid);
                    if (cmid < updateDef.minCMID) {
                        updateDef.minCMID = cmid;
                    }
                    auditContext.add(cmid, objectClass);
                    if (!isValidTenantIdUpdate) continue;
                    String tenantIdString = (String)addDef.get(CMProperty.TENANTID);
                    int tenantIdInt = this.tenantRegistry.getTenantIdIntFromString(tenantIdString, false);
                    if (tenantIdUpdateValidator == null) {
                        tenantIdUpdateValidator = this.createTenantIdUpdateValidator();
                    }
                    tenantIdUpdateValidator.addTenantIdUpdateNodeAndValidate(cmid, tenantIdInt);
                } while (results.next());
                if (addDef.updateAllDescendantNames != null || isValidTenantIdUpdate) {
                    results.reset();
                    this.queryDescendants(results, context, updateDef, isValidTenantIdUpdate);
                }
                updateDef.targetResults = results;
                results = null;
                if (addDef.objectClass == CMObjectClass.ACCOUNT && addDef.contains(CMProperty.CONTENTLOCALE) && AdvancedSettings.LIMIT_ACCOUNT_TEMPLATE_NAMES) {
                    if (this.accountTemplates == null) {
                        this.accountTemplates = new AccountTemplates();
                    }
                    this.accountTemplates.addAccountSearchPath(updateDef.addDef.searchPath);
                }
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(results);
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(results);
        }
    }

    private void assertExternalPropertiesUpdatable(CMProperty[] externalProps, CMObjectClass objectClass, String externalID) throws CMException {
        CMAAAObjectPropertiesDoc docCheckforExternalProps = new CMAAAObjectPropertiesDoc(objectClass, externalID, externalProps);
        for (int i = 0; i < externalProps.length; ++i) {
            if (externalProps[i] != CMProperty.MEMBERS && docCheckforExternalProps.getValue(i) == null) continue;
            throw new CMException("cmPropNotUpdateable1", new CMException.Parm("prop", externalProps[i].getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryDescendants(CMStoreQueryResults parentResults, DeadlockContext context, UpdateDef updateDef, boolean isValidTenantIdUpdate) throws CMException {
        AddDef addDef = updateDef.addDef;
        String suffix = "";
        int targetTenantId = 0;
        if (isValidTenantIdUpdate) {
            String tenantId = (String)addDef.get(CMProperty.TENANTID);
            targetTenantId = this.tenantRegistry.getTenantIdIntFromString(tenantId, false);
        } else {
            suffix = this.buildHasPropertyDescendentsQuerySuffix(addDef);
        }
        while (parentResults.next()) {
            CMStoreQueryResults results;
            block7: {
                int parentTenantId = parentResults.getTenantID();
                String searchPath = parentResults.getSearchPath();
                String query2 = searchPath + "/descendant::*" + suffix;
                results = null;
                try {
                    boolean haveDescendants = false;
                    results = this.store_.executeQuery(this.createXPath(query2), null, null, 7, updateDef.qPermissions, null);
                    while (results.next()) {
                        haveDescendants = true;
                        if (isValidTenantIdUpdate && !context.requestInfo.forceTenantIdUpdateOnDescendants && !this.isValidToUpdateDescendantTo(results.getTenantID(), targetTenantId, parentTenantId)) {
                            String path = CMQueryUtils.getPath(this.store_, results.getSearchPath());
                            throw new CMException("cmInvalidTenantUpdateDescendants", new CMException.Parm("path", path));
                        }
                        context.affectedObjects.add(results.getObjectID());
                    }
                    if (!haveDescendants) break block7;
                    updateDef.descendantResults.add(results);
                    results = null;
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(results);
                    throw throwable;
                }
            }
            CMQueryUtils.safeQueryResultsRelease(results);
        }
    }

    private int calculateQueryPermissions(UpdateDef updateDef, boolean updatePolicy, boolean requiresWriteAccess, boolean updatingSessionVarsOnly) throws CMException {
        boolean noAccessCheckRequired;
        int result = 0;
        CMExecutionContext exCtx = CMExecutionContext.get();
        boolean bCurrentUser = false;
        CMStoreXPath searchPath = updateDef.addDef.searchPath;
        if (updateDef.addDef.objectClass == CMObjectClass.ACCOUNT && searchPath.toString().equals(exCtx.getCurrentUserSearchPath())) {
            bCurrentUser = true;
        }
        if (noAccessCheckRequired = exCtx.getCurrentUserIsAdministrator()) {
            requiresWriteAccess = false;
            updatePolicy = false;
            result |= 0x200;
        }
        if (AbstractQuery.grantSDSTraverse(searchPath)) {
            result |= 0x4000;
        }
        if (bCurrentUser && (updatingSessionVarsOnly || !exCtx.getCurrentUserIsSharedAnonymous())) {
            requiresWriteAccess = false;
            result |= 0x200;
        }
        if (requiresWriteAccess) {
            result |= 2;
        }
        if (updatePolicy) {
            result |= 4;
        }
        return result;
    }

    private boolean isSessionVarProperty(CMProperty prop) {
        return prop == CMProperty.CONTENTLOCALE || prop == CMProperty.PRODUCTLOCALE || prop == CMProperty.TIMEZONEID || prop == CMProperty.FORMAT || prop == CMProperty.PORTALPREFERENCES || prop == CMProperty.OPTIONS || prop == CMProperty.USEACCESSIBILITYFEATURES;
    }

    private void handleEmptySelection(UpdateDef updateDef) throws CMException {
        CMStoreXPath objectContext = updateDef.addDef.searchPath;
        this.assertObjectVersionMatches(objectContext, updateDef.qPermissions, updateDef.addDef.version);
        throw new CMException("cmEmptySelection", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, objectContext)));
    }

    protected TenantIdUpdateValidator createTenantIdUpdateValidator() {
        return new TenantIdUpdateValidator(this.store_.getCache(), this.tenantRegistry);
    }

    private boolean isValidToUpdateDescendantTo(int currentTenantId, int tenantIdUpdatingTo, int updateTargetTenantId) {
        if (updateTargetTenantId == 0) {
            if (tenantIdUpdatingTo != 0) {
                return currentTenantId == 0 || currentTenantId == tenantIdUpdatingTo;
            }
            return currentTenantId == 0;
        }
        return currentTenantId == updateTargetTenantId;
    }

    protected CMStoreXPath createXPath(String query2) throws CMStoreParseException {
        return new CMStoreXPath(query2);
    }

    private String buildHasPropertyDescendentsQuerySuffix(AddDef addDef) {
        StringBuilder suffixBuilder = new StringBuilder();
        ListIterator<CMProperty> iter = addDef.updateAllDescendantNames.listIterator();
        suffixBuilder.append("[");
        while (iter.hasNext()) {
            CMProperty prop = iter.next();
            suffixBuilder.append("hasProperty('");
            suffixBuilder.append(prop.getName());
            suffixBuilder.append("')");
            if (!iter.hasNext()) continue;
            suffixBuilder.append(" or ");
        }
        suffixBuilder.append("]");
        return suffixBuilder.toString();
    }

    protected void updateTargetObjects(UpdateDef[] updateDefs, Integer deadlockRetryNumber, DeadlockContext context) throws CMException {
        for (int i = 0; i < updateDefs.length; ++i) {
            UpdateDef updateDef = updateDefs[i];
            if (!updateDef.doTheUpdateAction) continue;
            CMStoreQueryResults results = updateDef.targetResults;
            AddDef addDef = updateDef.addDef;
            try {
                this.trimResults(results);
                this.store_.update(results, addDef.names(), addDef.values());
                CMWhileDeadlockExecutor.checkSimulateDeadlock(deadlockRetryNumber);
                if (addDef.updateAllDescendantNames != null || this.isValidTenantIdUpdate(context.requestInfo, addDef)) {
                    this.updateDescendants(updateDef, context);
                }
                if (addDef.triggerDefs == null) continue;
                this.executeTriggerDefs(addDef.triggerDefs);
                continue;
            }
            catch (CMStoreDuplicateObject e) {
                String parentPath = results.getParentSearchPath();
                if (parentPath != null && addDef.localizedName != null) {
                    StringBuilder listofNames = new StringBuilder();
                    CMLocalizedStringArray names = addDef.localizedName;
                    for (int x = 0; x < names.getSize(); ++x) {
                        listofNames.append(names.get(x).getValue());
                        listofNames.append(",");
                    }
                    throw new CMException("cmNameConflict", new CMException.Parm("Names", listofNames), new CMException.Parm("Root", parentPath));
                }
                throw new CMException("cmDuplicateObject");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doActionsIfRetentionRulesUpdatedCommit(UpdateDef[] updateDefs) {
        for (int i = 0; i < updateDefs.length; ++i) {
            UpdateDef updateDef = updateDefs[i];
            if (!updateDef.doTheUpdateAction) continue;
            try {
                CMStoreQueryResults results = updateDef.targetResults;
                CMRetentionRuleArray rules = updateDef.rules;
                if (rules == null) continue;
                this.doActionsOnRetentionRulesChanged(results, rules);
                continue;
            }
            catch (CMException retEx) {
                if (!AdvancedSettings.LOGRETENTIONRULEERRORS) continue;
                CMIndications.logException(retEx);
                continue;
            }
            finally {
                try {
                    this.store_.rollbackOpenTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void preLockTargetObjects(UpdateDef[] updateDefs, DeadlockContext context) throws CMException {
        if (updateDefs.length > 1 && AdvancedSettings.ENABLEPRELOCKOBJECTS) {
            int[] objectIds = context.affectedObjects.toArray();
            this.store_.lockObjectsInDatabase(objectIds);
        }
    }

    protected void trimResults(CMStoreQueryResults results) {
        results.reset();
    }

    protected void doActionsOnRetentionRulesChanged(CMStoreQueryResults results, CMRetentionRuleArray rules) throws CMException {
        this.doRetentionRules(results, rules);
        this.doExpirationTime(results, rules);
    }

    protected void doRetentionRules(CMStoreQueryResults results, CMRetentionRuleArray rules) throws CMException {
        int ruleCount = rules.getSize();
        for (int ruleIdx = 0; ruleIdx != ruleCount; ++ruleIdx) {
            CMRetentionRule rule = rules.getRule(ruleIdx);
            this.trimResults(results);
            while (results.next()) {
                try {
                    this.executeRetentionRule(this.store_, rule, results.getSearchPath(), -1);
                }
                catch (CMStoreDeadlock retEx) {
                    CMIndications.logException(retEx);
                }
                catch (CMException ex) {
                    throw new CMException(ex, "cmRetentionFailed");
                }
            }
        }
    }

    protected void doExpirationTime(CMStoreQueryResults results, CMRetentionRuleArray rules) throws CMException {
        int ruleCount = rules.getSize();
        for (int ruleIdx = 0; ruleIdx != ruleCount; ++ruleIdx) {
            CMRetentionRule rule = rules.getRule(ruleIdx);
            this.trimResults(results);
            while (results.next()) {
                try {
                    this.updateExpirationTimeInTransaction(this.store_, rule, results.getSearchPath(), true);
                }
                catch (CMException ex) {
                    throw new CMException(ex, "cmRetentionFailed");
                }
            }
        }
    }

    protected void updateDescendants(UpdateDef updateDef, DeadlockContext context) throws CMException {
        AddDef addDef = updateDef.addDef;
        for (CMStoreQueryResults resultsDesc : updateDef.descendantResults) {
            ArrayList<CMProperty> properties = new ArrayList<CMProperty>();
            ArrayList<Object> values = new ArrayList<Object>();
            if (this.isValidTenantIdUpdate(context.requestInfo, addDef)) {
                properties.add(CMProperty.TENANTID);
                values.add(addDef.get(CMProperty.TENANTID));
            }
            if (addDef.updateAllDescendantNames != null) {
                properties.addAll(addDef.updateAllDescendantNames);
            }
            int fillWithNulls = properties.size() - values.size();
            for (int i = 0; i < fillWithNulls; ++i) {
                values.add(null);
            }
            this.store_.update(resultsDesc, properties, values);
        }
    }

    private boolean isValidTenantIdUpdate(ModifyingQuery.RequestInfo info, AddDef addDef) {
        return info.updateTenantIDRecursive && addDef.contains(CMProperty.TENANTID) && CMExecutionContext.get().isAbleToEditTenantId();
    }

    @Override
    protected void validateAddDef(AddDef addDef, ModifyingQuery.RequestInfo info) throws CMException {
        super.validateAddDef(addDef, info);
        if (addDef.contains(CMProperty.TENANTID) && (addDef.objectClass == CMObjectClass.TENANTS || addDef.objectClass == CMObjectClass.TENANT)) {
            throw new CMException("cmReadOnlyProperty", new CMException.Parm("property", CMProperty.TENANTID.getName()), new CMException.Parm("class", addDef.objectClass.getName()));
        }
        if (addDef.contains(CMProperty.TENANTID) && !info.updateTenantIDRecursive) {
            throw new CMException("cmUpdateTenantIDRecursive");
        }
    }

    protected static class UpdateDef
    implements Comparable<UpdateDef> {
        boolean doTheUpdateAction = true;
        int minCMID = Integer.MAX_VALUE;
        AddDef addDef;
        int qPermissions = 0;
        CMStoreQueryResults targetResults;
        ArrayList<CMStoreQueryResults> descendantResults = new ArrayList();
        CMRetentionRuleArray rules = null;

        UpdateDef(AddDef addDef) {
            this.addDef = addDef;
        }

        void release() {
            CMQueryUtils.safeQueryResultsRelease(this.targetResults);
            for (CMStoreQueryResults results : this.descendantResults) {
                CMQueryUtils.safeQueryResultsRelease(results);
            }
        }

        @Override
        public int compareTo(UpdateDef o) {
            return this.minCMID - o.minCMID;
        }
    }

    protected static class DeadlockContext {
        public ModifyingQuery.RequestInfo requestInfo;
        public CMIntList affectedObjects;
        public boolean committed = false;
        public CMStoreXPath currentPath;

        protected DeadlockContext() {
        }
    }
}

