/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator;

import com.cognos.cm.request.validator.ICacheValidatorCalculator;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfMonitor;
import java.io.InputStream;

public class CacheValidatorCounters
implements ICacheValidatorCalculator {
    private ICacheValidatorCalculator calculator;
    private static final PerfCounter PERF_COUNTER_PREQUERY_HITS = PerfMonitor.getCounter((String)"com.cognos.cm.request.cacheValidator.preQueryHits", (String)"The number of times that the validator prevented running the query", (int)6);
    private static final PerfCounter PERF_COUNTER_PREQUERY_MISSES = PerfMonitor.getCounter((String)"com.cognos.cm.request.cacheValidator.preQueryMisses", (String)"The number of times that the validator did not prevent running the query", (int)6);
    private static final PerfCounter PERF_COUNTER_SUPPORTED_HITS = PerfMonitor.getCounter((String)"com.cognos.cm.request.cacheValidator.supportedHits", (String)"The number of cache validator queries that contained supported classes", (int)6);
    private static final PerfCounter PERF_COUNTER_SUPPORTED_MISSES = PerfMonitor.getCounter((String)"com.cognos.cm.request.cacheValidator.supportedMisses", (String)"The number of cache validator queries that did not contain at least one supported class", (int)6);

    public CacheValidatorCounters(ICacheValidatorCalculator calculator) {
        this.calculator = calculator;
    }

    @Override
    public String calculateNewValidator(InputStream response) {
        String newVal = this.calculator.calculateNewValidator(response);
        if (newVal.equals("NOT_SUPPORTED")) {
            PERF_COUNTER_SUPPORTED_MISSES.incr();
        } else {
            PERF_COUNTER_SUPPORTED_HITS.incr();
        }
        return newVal;
    }

    @Override
    public boolean validatorMatches() {
        if (this.calculator.validatorMatches()) {
            PERF_COUNTER_PREQUERY_HITS.incr();
            PERF_COUNTER_SUPPORTED_HITS.incr();
            return true;
        }
        PERF_COUNTER_PREQUERY_MISSES.incr();
        return false;
    }

    @Override
    public boolean canCheck() {
        return this.calculator.canCheck();
    }

    @Override
    public boolean canFetchModifiedDate() {
        return this.calculator.canFetchModifiedDate();
    }

    @Override
    public Long getModifiedDate() {
        return this.calculator.getModifiedDate();
    }

    PerfCounter getValidatorHits_test() {
        return PERF_COUNTER_PREQUERY_HITS;
    }

    PerfCounter getValidatorMisses_test() {
        return PERF_COUNTER_PREQUERY_MISSES;
    }

    PerfCounter getValidatorSupported_test() {
        return PERF_COUNTER_SUPPORTED_HITS;
    }

    PerfCounter getValidatorNotSupported_test() {
        return PERF_COUNTER_SUPPORTED_MISSES;
    }

    @Override
    public boolean responseValidated() {
        return this.calculator.responseValidated();
    }
}

