/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.request.validator.CacheValidatorCounters;
import com.cognos.cm.request.validator.CompositeCacheValidator;
import com.cognos.cm.request.validator.DefaultCacheValidator;
import com.cognos.cm.request.validator.ICacheValidator;
import com.cognos.cm.request.validator.ICacheValidatorCalculator;
import com.cognos.cm.request.validator.ICacheValidatorUpdater;
import com.cognos.cm.request.validator.ValidatorLookupCache;
import com.cognos.cm.request.validator.VersionBasedValidator;
import com.cognos.cm.request.validator.responseActions.NoResponseValidation;
import com.cognos.cm.request.validator.responseActions.ResponseValidator;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CacheValidatorFactory {
    private static final String FILE_NAME = "/WEB-INF/cm/Validator.xml";
    private static boolean initialized;
    private static Map<String, Class<? extends ICacheValidator>> objectClassMap;
    private static List<PathMatcher> matchers;
    private static List<String> defaultClasses;
    private static ValidatorLookupCache lookupCache;
    private CMResourceLoader loader = CMResourceUtils.getResourceLoader();
    private static Map<String, Class<? extends ResponseValidator>> responseActions;

    public ICacheValidatorCalculator getValidatorCalculator(List<String> paths, String validator, String responseAction) {
        return this.getValidatorCalculator(paths, validator, responseAction, true);
    }

    public ICacheValidatorCalculator getValidatorCalculator(List<String> paths, String validator, String responseAction, boolean includeCounterProxy) {
        this.lazyInitialize();
        ICacheValidatorCalculator calculator = null;
        calculator = VersionBasedValidator.instance.getCalculator(paths, validator, responseAction, lookupCache);
        if (calculator == null) {
            ICacheValidator matchedValidator = this.getMatchedValidator(paths);
            calculator = matchedValidator.getCalculator(paths, validator, responseAction, lookupCache);
        }
        if (includeCounterProxy) {
            return new CacheValidatorCounters(calculator);
        }
        return calculator;
    }

    public ICacheValidatorUpdater getValidatorUpdater(Notification notification) {
        this.lazyInitialize();
        String cls = notification.getObjectClass().getName();
        ICacheValidator val = this.getValidator(cls);
        return val.getUpdater();
    }

    private ICacheValidator getValidator(String cls) {
        Class<? extends ICacheValidator> clazz = this.getValidatorClassFromObjectClass(cls);
        if (clazz == null) {
            return new DefaultCacheValidator();
        }
        return this.buildValidator(clazz);
    }

    private Class<? extends ICacheValidator> getValidatorClassFromObjectClass(String cls) {
        return objectClassMap.get(cls);
    }

    private ICacheValidator getMatchedValidator(List<String> paths) {
        HashMap<Class<? extends ICacheValidator>, List<String>> classMap = this.getClassMap(paths);
        ICacheValidator val = null;
        if (classMap.size() > 1) {
            val = new CompositeCacheValidator();
            this.addValidatorToComposite(classMap, (CompositeCacheValidator)val);
        } else {
            Iterator<Class<? extends ICacheValidator>> iter = classMap.keySet().iterator();
            Class<? extends ICacheValidator> clazz = iter.next();
            val = this.buildValidator(clazz);
        }
        return val;
    }

    private void addValidatorToComposite(HashMap<Class<? extends ICacheValidator>, List<String>> classMap, CompositeCacheValidator val) {
        for (Class<? extends ICacheValidator> clazz : classMap.keySet()) {
            List<String> innerPaths = classMap.get(clazz);
            ICacheValidator innerVal = this.buildValidator(clazz);
            val.addValidator(innerVal, innerPaths);
        }
    }

    private ICacheValidator buildValidator(Class<? extends ICacheValidator> clazz) {
        try {
            ICacheValidator val = clazz.newInstance();
            return val;
        }
        catch (InstantiationException e) {
            CMIndications.logException(e);
        }
        catch (IllegalAccessException e) {
            CMIndications.logException(e);
        }
        return null;
    }

    private HashMap<Class<? extends ICacheValidator>, List<String>> getClassMap(List<String> paths) {
        HashMap<Class<? extends ICacheValidator>, List<String>> classMap = new HashMap<Class<? extends ICacheValidator>, List<String>>();
        Class<? extends ICacheValidator> clazz = null;
        for (String path : paths) {
            clazz = this.getClassFromPathMatcher(path);
            if (classMap.containsKey(clazz)) {
                classMap.get(clazz).add(path);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(path);
            classMap.put(clazz, list);
        }
        return classMap;
    }

    private Class<? extends ICacheValidator> getClassFromPathMatcher(String path) {
        for (PathMatcher matcher : matchers) {
            if (!matcher.regexMatcher(path)) continue;
            return matcher.getValidatorClass();
        }
        return DefaultCacheValidator.class;
    }

    private synchronized void lazyInitialize() {
        if (!initialized) {
            this.initialize();
            initialized = true;
        }
    }

    private void initialize() {
        this.parseValidatorDescriptor(this.loader);
    }

    private void parseValidatorDescriptor(CMResourceLoader _loader) {
        InputStream descriptorStream = this.getResourceStream(_loader);
        Element rootElement = this.getRootElement(descriptorStream);
        Element validators = rootElement.element("validators");
        this.parseValidators(validators);
        this.parseDefaultClasses(rootElement);
    }

    private void parseDefaultClasses(Element rootElement) {
        Element defaultClassesEl = rootElement.element("defaultClasses");
        if (defaultClassesEl != null) {
            List objectClasses = defaultClassesEl.elements("objectClass");
            for (Element objectClass : objectClasses) {
                String className = objectClass.getStringValue();
                defaultClasses.add(className);
            }
        }
    }

    private void parseValidators(Element validators) {
        if (validators != null) {
            List validatorList = validators.elements("validator");
            for (Element validator : validatorList) {
                this.parseValidator(validator);
            }
        }
    }

    private void parseValidator(Element validator) {
        Element updateClasses = validator.element("updateClasses");
        List<String> objectClasses = this.getUpdateClasses(updateClasses);
        String searchPathMatcher = validator.elementText("searchPathMatcher");
        String validatorClass = validator.elementText("class");
        Class<? extends ICacheValidator> clazz = this.getValidatorClass(validatorClass);
        matchers.add(new PathMatcher(searchPathMatcher, clazz));
        for (String objectClass : objectClasses) {
            objectClassMap.put(objectClass, clazz);
        }
    }

    private Class<? extends ICacheValidator> getValidatorClass(String validatorClass) {
        try {
            return Class.forName(validatorClass);
        }
        catch (ClassNotFoundException e) {
            throw new CMRuntimeException(new CMException((Exception)e, "cmBadConfigFile", new CMException.Parm("File", FILE_NAME)));
        }
    }

    private List<String> getUpdateClasses(Element updateClasses) {
        List classes = updateClasses.elements("objectClass");
        ArrayList<String> objectClasses = new ArrayList<String>();
        for (Element objectClass : classes) {
            objectClasses.add(objectClass.getStringValue());
        }
        return objectClasses;
    }

    private Element getRootElement(InputStream descriptorStream) {
        Element rootElement = null;
        try {
            SAXReader reader = new SAXReader();
            Document descDoc = reader.read(descriptorStream);
            descriptorStream.close();
            rootElement = descDoc.getRootElement();
        }
        catch (Exception ex) {
            throw new CMRuntimeException(new CMException(ex, "cmBadConfigFile", new CMException.Parm("File", FILE_NAME)));
        }
        return rootElement;
    }

    private InputStream getResourceStream(CMResourceLoader _loader) {
        InputStream descriptorStream = _loader.getResourceInputStream(FILE_NAME);
        if (descriptorStream == null) {
            throw new CMRuntimeException(new CMException("cmNoConfigFile", new CMException.Parm("File", FILE_NAME)));
        }
        return descriptorStream;
    }

    protected void setResourceLoader_test(CMResourceLoader loader2) {
        this.loader = loader2;
    }

    protected void reset_test() {
        initialized = false;
        defaultClasses = new ArrayList<String>();
        objectClassMap = new ConcurrentHashMap<String, Class<? extends ICacheValidator>>();
        matchers = new ArrayList<PathMatcher>();
    }

    public boolean isDefaultSupportedClass(String name) {
        this.lazyInitialize();
        return defaultClasses.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseValidator getResponseAction(String responseAction) {
        if (responseAction == null) {
            return new NoResponseValidation();
        }
        if (responseActions.containsKey(responseAction)) {
            return this.getLoadedResponseAction(responseAction);
        }
        Map<String, Class<? extends ResponseValidator>> map = responseActions;
        synchronized (map) {
            this.loadNewResponseAction(responseAction);
        }
        return this.getLoadedResponseAction(responseAction);
    }

    private ResponseValidator getLoadedResponseAction(String responseAction) {
        Class<? extends ResponseValidator> actionClass = responseActions.get(responseAction);
        if (actionClass != null) {
            try {
                return actionClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new CMRuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new CMRuntimeException(e);
            }
        }
        return null;
    }

    private void loadNewResponseAction(String responseAction) {
        Class<? extends ResponseValidator> clazz = this.getResponseActionClass(responseAction);
        responseActions.put(responseAction, clazz);
    }

    private Class<? extends ResponseValidator> getResponseActionClass(String responseAction) {
        String fullClass = "com.cognos.cm.request.validator.responseActions." + responseAction;
        try {
            return Class.forName(fullClass);
        }
        catch (ClassNotFoundException e) {
            throw new CMRuntimeException(e);
        }
    }

    static {
        objectClassMap = new ConcurrentHashMap<String, Class<? extends ICacheValidator>>();
        matchers = new ArrayList<PathMatcher>();
        defaultClasses = new ArrayList<String>();
        lookupCache = new ValidatorLookupCache(AdvancedSettings.VALIDATORCACHESIZE);
        responseActions = new ConcurrentHashMap<String, Class<? extends ResponseValidator>>();
    }

    private class PathMatcher {
        private Class<? extends ICacheValidator> valClass;
        private Pattern pattern;

        public PathMatcher(String strPattern, Class<? extends ICacheValidator> class1) {
            this.pattern = Pattern.compile(strPattern, 34);
            this.valClass = class1;
        }

        public boolean regexMatcher(String path) {
            Matcher m = this.pattern.matcher(path);
            return m.find();
        }

        public Class<? extends ICacheValidator> getValidatorClass() {
            return this.valClass;
        }
    }
}

