/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator;

import com.cognos.cm.request.validator.CacheValidatorFactory;
import com.cognos.cm.request.validator.ICacheValidator;
import com.cognos.cm.request.validator.ICacheValidatorCalculator;
import com.cognos.cm.request.validator.ICacheValidatorUpdater;
import com.cognos.cm.request.validator.IValidator;
import com.cognos.cm.request.validator.ValidatorLookupCache;
import com.cognos.cm.request.validator.responseActions.ResponseValidator;
import com.cognos.cm.server.CMExecutionContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CompositeCacheValidator
implements ICacheValidator {
    private List<ValidatorContainer> validators;
    private ValidatorLookupCache cache;

    @Override
    public ICacheValidatorCalculator getCalculator(List<String> paths, String requestValidator, String unsupportedAction, ValidatorLookupCache cache) {
        this.cache = cache;
        return new CompositeCacheValidatorCalculator(this.validators, requestValidator, unsupportedAction, paths);
    }

    @Override
    public ICacheValidatorUpdater getUpdater() {
        throw new IllegalStateException("The composite validator should never be called for updates");
    }

    public void addValidator(ICacheValidator innerVal, List<String> innerPaths) {
        if (this.validators == null) {
            this.validators = new ArrayList<ValidatorContainer>();
        }
        this.validators.add(new ValidatorContainer(innerVal, innerPaths));
    }

    public class CompositeCacheValidatorCalculator
    implements ICacheValidatorCalculator {
        private List<ICacheValidatorCalculator> calculators = new ArrayList<ICacheValidatorCalculator>();
        private List<String> paths;
        private IValidator validator;
        private String responseAction;
        private ResponseValidator postAction;

        public CompositeCacheValidatorCalculator(List<ValidatorContainer> validators, String requestValidator, String unsupportedAction, List<String> paths) {
            this.paths = paths;
            this.validator = CompositeCacheValidator.this.cache.get(requestValidator);
            this.responseAction = unsupportedAction;
            if (validators != null) {
                for (ValidatorContainer container : validators) {
                    ICacheValidator validator = container.validator;
                    this.calculators.add(validator.getCalculator(container.paths, requestValidator, unsupportedAction, CompositeCacheValidator.this.cache));
                }
            }
        }

        @Override
        public String calculateNewValidator(InputStream response) {
            Long modifiedDate = this.getModifiedDate();
            IValidator newValidator = null;
            if (modifiedDate == null) {
                this.postAction = new CacheValidatorFactory().getResponseAction(this.responseAction);
                return this.postAction.getNewValidator(CMExecutionContext.get().getAccManPassportID(), CompositeCacheValidator.this.cache, this.validator, response);
            }
            newValidator = CompositeCacheValidator.this.cache.buildValidator(modifiedDate, this.paths);
            return CompositeCacheValidator.this.cache.cacheNewValidator(newValidator);
        }

        @Override
        public Long getModifiedDate() {
            Long mostRecent = new Long(0L);
            for (ICacheValidatorCalculator calculator : this.calculators) {
                if (!calculator.canFetchModifiedDate()) {
                    return null;
                }
                Long modTime = calculator.getModifiedDate();
                if (modTime <= mostRecent) continue;
                mostRecent = modTime;
            }
            return mostRecent;
        }

        @Override
        public boolean canFetchModifiedDate() {
            return false;
        }

        @Override
        public boolean validatorMatches() {
            Long mostRecent = new Long(0L);
            for (ICacheValidatorCalculator calculator : this.calculators) {
                if (calculator.canCheck()) {
                    Long modTime = calculator.getModifiedDate();
                    if (modTime <= mostRecent) continue;
                    mostRecent = modTime;
                    continue;
                }
                return false;
            }
            return this.validator != null && this.validator.equals(CompositeCacheValidator.this.cache.buildValidator(mostRecent, this.paths));
        }

        @Override
        public boolean canCheck() {
            return false;
        }

        @Override
        public boolean responseValidated() {
            return this.postAction != null && this.postAction.validated();
        }
    }

    private class ValidatorContainer {
        private ICacheValidator validator;
        private List<String> paths;

        public ValidatorContainer(ICacheValidator validator, List<String> paths) {
            this.validator = validator;
            this.paths = paths;
        }
    }
}

