/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator;

import com.cognos.cm.notification.Notification;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.request.validator.ICacheValidator;
import com.cognos.cm.request.validator.ICacheValidatorCalculator;
import com.cognos.cm.request.validator.ICacheValidatorUpdater;
import com.cognos.cm.request.validator.IValidator;
import com.cognos.cm.request.validator.ValidatorLookupCache;
import java.io.InputStream;
import java.util.List;

public class DataSourceSignonCacheValidator
implements ICacheValidator {
    private static Long dataSourceTime = new Long(0L);
    private ValidatorLookupCache cache;

    @Override
    public ICacheValidatorCalculator getCalculator(List<String> paths, String requestValidator, String unsupportedAction, ValidatorLookupCache cache) {
        this.cache = cache;
        return new DataSourceSignonCalculator(paths, cache.get(requestValidator));
    }

    @Override
    public ICacheValidatorUpdater getUpdater() {
        return new DataSourceSignonUpdater();
    }

    public class DataSourceSignonCalculator
    implements ICacheValidatorCalculator {
        private List<String> paths;
        private IValidator validator;

        public DataSourceSignonCalculator(List<String> paths, IValidator validator) {
            this.paths = paths;
            this.validator = validator;
        }

        @Override
        public String calculateNewValidator(InputStream response) {
            return DataSourceSignonCacheValidator.this.cache.cacheNewValidator(DataSourceSignonCacheValidator.this.cache.buildValidator(this.getModifiedDate(), this.paths));
        }

        @Override
        public boolean canCheck() {
            return true;
        }

        @Override
        public Long getModifiedDate() {
            return dataSourceTime;
        }

        @Override
        public boolean validatorMatches() {
            return this.validator != null && this.validator.equals(DataSourceSignonCacheValidator.this.cache.buildValidator(dataSourceTime, this.paths));
        }

        @Override
        public boolean canFetchModifiedDate() {
            return true;
        }

        @Override
        public boolean responseValidated() {
            return false;
        }
    }

    public class DataSourceSignonUpdater
    implements ICacheValidatorUpdater {
        @Override
        public void objectUpdated(Notification notification) {
            CMObjectClass cls = notification.getObjectClass();
            if (this.isSupportedCls(cls)) {
                dataSourceTime = System.nanoTime();
            }
        }

        private boolean isSupportedCls(CMObjectClass cls) {
            String name = cls.getName();
            return name.contains("dataSource");
        }

        @Override
        public void objectsUpdated(List<Notification> notifications) {
            for (Notification notification : notifications) {
                this.objectUpdated(notification);
            }
        }
    }
}

