/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.validator.CacheValidatorFactory;
import com.cognos.cm.request.validator.ICacheValidator;
import com.cognos.cm.request.validator.ICacheValidatorCalculator;
import com.cognos.cm.request.validator.ICacheValidatorUpdater;
import com.cognos.cm.request.validator.IValidator;
import com.cognos.cm.request.validator.NotSupportedValidator;
import com.cognos.cm.request.validator.ValidatorLookupCache;
import com.cognos.cm.request.validator.responseActions.ResponseValidator;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMSynchronizedLRRCache;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DefaultCacheValidator
implements ICacheValidator {
    protected static String contentStoreID_ = null;
    protected static CMSynchronizedLRRCache modTimesCache_ = new CMSynchronizedLRRCache(AdvancedSettings.VALIDATORCACHEKEYSSIZE, "ModifiedTimes");
    private static CacheValidatorFactory factory = new CacheValidatorFactory();
    protected ValidatorLookupCache cache;

    @Override
    public ICacheValidatorUpdater getUpdater() {
        return new CacheValidatorUpdater();
    }

    @Override
    public ICacheValidatorCalculator getCalculator(List<String> paths, String requestValidator, String responseAction, ValidatorLookupCache cache) {
        this.cache = cache;
        return new CacheValidatorCalculator(paths, responseAction, cache.get(requestValidator), requestValidator);
    }

    public class CacheValidatorCalculator
    implements ICacheValidatorCalculator {
        private IValidator calculatedValidator;
        private IValidator requestValidator;
        protected HashMap<String, Object> storeIDs_;
        private List<String> paths_;
        private String responseAction;
        private ResponseValidator postAction;

        public CacheValidatorCalculator(List<String> paths, String responseAction, IValidator validator, String val) {
            this.paths_ = paths;
            this.getStoreIds(paths);
            this.requestValidator = validator;
            this.responseAction = responseAction;
            if (this.requestValidator instanceof NotSupportedValidator) {
                return;
            }
            this.calculatedValidator = DefaultCacheValidator.this.cache.buildValidator(this.getModifiedDate(), this.paths_);
        }

        private boolean addStoreIDToWatchList(String storeID, CMObjectClass objClass) {
            if (objClass != null && factory.isDefaultSupportedClass(objClass.getName())) {
                modTimesCache_.add(storeID, System.nanoTime());
                return true;
            }
            return false;
        }

        private void setContentStoreID(String storeID) {
            if (factory.isDefaultSupportedClass(CMObjectClass.CONTENT.getName())) {
                contentStoreID_ = storeID;
            }
        }

        protected void setContentStoreID_test(String storeID) {
            this.setContentStoreID(storeID);
        }

        protected boolean addStoreIDToWatchList_test(String storeID, CMObjectClass objClass) {
            return this.addStoreIDToWatchList(storeID, objClass);
        }

        private String getContentStoreID() {
            return contentStoreID_;
        }

        private boolean isTrackable(CMObjectClass objClass) {
            if (objClass == null) {
                return false;
            }
            return factory.isDefaultSupportedClass(objClass.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryAddStoreIDToWatchList(String storeID, CMObjectClass objectClass) {
            CMSynchronizedLRRCache cMSynchronizedLRRCache = modTimesCache_;
            synchronized (cMSynchronizedLRRCache) {
                if (!modTimesCache_.contains(storeID) && !this.addStoreIDToWatchList(storeID, objectClass)) {
                    return false;
                }
            }
            return true;
        }

        private Long getModTime(String storeID) {
            return (Long)modTimesCache_.get(storeID);
        }

        private boolean isBeingTracked(String storeID) {
            return modTimesCache_.contains(storeID);
        }

        @Override
        public boolean validatorMatches() {
            if (!this.canCheck()) {
                return false;
            }
            return this.requestValidator != null && this.calculatedValidator.equals(this.requestValidator);
        }

        @Override
        public String calculateNewValidator(InputStream response) {
            if (this.calculatedValidator == null && this.addStoreIDsToWatch()) {
                this.calculatedValidator = DefaultCacheValidator.this.cache.buildValidator(this.getModifiedDate(), this.paths_);
            }
            if (this.calculatedValidator == null) {
                this.postAction = factory.getResponseAction(this.responseAction);
                return this.postAction.getNewValidator(CMExecutionContext.get().getAccManPassportID(), DefaultCacheValidator.this.cache, this.requestValidator, response);
            }
            return DefaultCacheValidator.this.cache.cacheNewValidator(this.calculatedValidator);
        }

        @Override
        public Long getModifiedDate() {
            Long mostRecent = null;
            if (this.storeIDs_ != null && this.storeIDs_.keySet() != null) {
                for (String storeID : this.storeIDs_.keySet()) {
                    Long modTime = this.getModTime(storeID);
                    if (modTime == null) {
                        return null;
                    }
                    if (mostRecent == null) {
                        mostRecent = new Long(0L);
                    }
                    if (mostRecent >= modTime) continue;
                    mostRecent = modTime;
                }
            }
            return mostRecent;
        }

        protected boolean addStoreIDsToWatch() {
            if (this.storeIDs_ == null || this.storeIDs_.keySet() == null) {
                return false;
            }
            Iterator<String> iter = this.storeIDs_.keySet().iterator();
            if (!iter.hasNext()) {
                return false;
            }
            while (iter.hasNext()) {
                String sID = iter.next();
                Object objectClass = this.storeIDs_.get(sID);
                if (!(objectClass instanceof CMObjectClass)) {
                    return false;
                }
                if (this.tryAddStoreIDToWatchList(sID, (CMObjectClass)objectClass)) continue;
                return false;
            }
            return true;
        }

        protected boolean addCheatedStoreIDs(String searchPath, CMStoreXPath path) {
            if (searchPath == null) {
                return false;
            }
            if (this.isPathCheatable(path)) {
                if (searchPath.startsWith("/content")) {
                    String contentStoreID = this.getContentStoreID();
                    if (contentStoreID != null) {
                        if (this.storeIDs_ == null) {
                            this.storeIDs_ = new HashMap();
                        }
                        this.storeIDs_.put(contentStoreID, CMObjectClass.CONTENT);
                        return true;
                    }
                } else {
                    String storeID = this.getStoreID(path);
                    if (InternalStoreId.validate(storeID) && (this.isBeingTracked(storeID) || this.checkCheatedStoreID(storeID))) {
                        if (this.storeIDs_ == null) {
                            this.storeIDs_ = new HashMap();
                        }
                        if (!this.storeIDs_.containsKey(storeID)) {
                            this.storeIDs_.put(storeID, "_valid");
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean checkCheatedStoreID(String storeID) {
            if (this.storeIDs_ == null) {
                return false;
            }
            Object objClass = this.storeIDs_.get(storeID);
            if (objClass != null && objClass instanceof CMObjectClass) {
                return this.isTrackable((CMObjectClass)objClass);
            }
            return false;
        }

        private String getStoreID(CMStoreXPath path) {
            if (path.stepAt(path.size() - 1).getNodeSetFunction() == CMConstants.FUNC_STOREID_DEF) {
                return this.resolveStoreID(path.stepAt(path.size() - 1));
            }
            return this.resolveStoreID(path.stepAt(path.size() - 2));
        }

        private String resolveStoreID(CMStorePathStep step) {
            CMStorePathPredicateFunction fxn = (CMStorePathPredicateFunction)step.Predicates.get(0);
            CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)fxn.args.get(0);
            String storeID = arg.toString();
            if (storeID.length() == 35) {
                storeID = CMStringUtils.removeQuotes(storeID);
            }
            return storeID;
        }

        private boolean isPathCheatable(CMStoreXPath path) {
            if (path == null || path.size() == 0) {
                return false;
            }
            if (path.stepAt(0).toString().equals("/content")) {
                if (path.size() == 1) {
                    return true;
                }
                return path.size() == 2 && path.stepAt(1).toString().startsWith("/*");
            }
            if (path.stepAt(path.size() - 1).getNodeSetFunction() == CMConstants.FUNC_STOREID_DEF) {
                return true;
            }
            if (this.lastStepIsSlashStar(path)) {
                return this.secondLastStepIsStoreID(path);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void getStoreIds(List<String> paths) {
            if (paths == null) {
                return;
            }
            Iterator<String> iter = paths.iterator();
            while (iter.hasNext()) {
                try {
                    String searchPath = iter.next();
                    CMStoreXPath path = new CMStoreXPath(searchPath);
                    if (this.addCheatedStoreIDs(searchPath, path)) continue;
                    CMStoreQueryResults rs = null;
                    try {
                        path = this.normalizePath(path);
                        rs = CMExecutionContext.get().getStore().executeQuery(path, new CMProperty[]{CMProperty.STOREID, CMProperty.OBJECTCLASS}, null, 0, 512, null);
                        if (rs == null || !rs.next()) continue;
                        if (this.storeIDs_ == null) {
                            this.storeIDs_ = new HashMap();
                        }
                        if (rs.getValue(0) == null) continue;
                        String storeID = rs.getValue(0).toString();
                        this.storeIDs_.put(storeID, rs.getObjectClass());
                        if (!searchPath.equals("/content")) continue;
                        this.setContentStoreID(storeID);
                    }
                    catch (Exception e) {
                        this.storeIDs_ = null;
                        return;
                    }
                    finally {
                        if (rs == null) continue;
                        rs.release();
                    }
                }
                catch (Exception e) {
                    this.storeIDs_ = null;
                    return;
                }
            }
        }

        private CMStoreXPath normalizePath(CMStoreXPath path) throws CMStoreParseException {
            CMStoreXPath _path = path;
            if (this.lastStepIsSlashStar(path) && this.secondLastStepIsStoreID(path)) {
                _path = new CMStoreXPath(path.stepAt(path.size() - 2).toString());
            }
            return _path;
        }

        private boolean secondLastStepIsStoreID(CMStoreXPath path) {
            return path.stepAt(path.size() - 2).getNodeSetFunction() == CMConstants.FUNC_STOREID_DEF;
        }

        private boolean lastStepIsSlashStar(CMStoreXPath path) {
            if (path.size() > 1) {
                CMStorePathStep step = path.stepAt(path.size() - 1);
                return step.getAxis() == 1;
            }
            return false;
        }

        @Override
        public boolean canCheck() {
            return this.calculatedValidator != null;
        }

        @Override
        public boolean canFetchModifiedDate() {
            if (this.calculatedValidator != null) {
                return true;
            }
            return this.addStoreIDsToWatch();
        }

        @Override
        public boolean responseValidated() {
            return this.postAction != null && this.postAction.validated();
        }
    }

    public static class CacheValidatorUpdater
    implements ICacheValidatorUpdater {
        private void updateModTime(String storeID) {
            if (modTimesCache_.contains(storeID)) {
                Long time = System.nanoTime();
                modTimesCache_.add(storeID, time);
            }
        }

        @Override
        public void objectUpdated(Notification notification) {
            if (notification.getOperation().equals("delete")) {
                this.objectDeleted(notification);
            } else {
                this.updateModTime(notification.getStoreID());
                this.updateModTime(notification.getParentStoreID());
            }
        }

        @Override
        public void objectsUpdated(List<Notification> notifications) {
            if (notifications != null && notifications.size() != 0) {
                for (Notification notification : notifications) {
                    this.objectUpdated(notification);
                }
            }
        }

        private void objectDeleted(Notification notification) {
            if (!notification.isParent()) {
                modTimesCache_.remove(notification.getStoreID());
            } else {
                this.updateModTime(notification.getStoreID());
            }
            this.updateModTime(notification.getParentStoreID());
        }
    }
}

