/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator;

import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.request.validator.AbstractValidator;
import com.cognos.cm.request.validator.IValidator;
import com.cognos.cm.request.validator.StringBasedValidator;
import com.cognos.cm.request.validator.Validator;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.util.CMUUID;
import com.cognos.cm.util.LRUMap;
import com.cognos.cmutils.hash.HashProviders;
import com.cognos.cmutils.hash.HashUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ValidatorLookupCache {
    private Map<String, IValidator> guidToVal = null;
    private Map<String, String> valToGuid = null;
    public static final Counter hits = new AccumulatingCounter().makeThreadLocal();
    public static final Counter miss = new AccumulatingCounter().makeThreadLocal();

    public ValidatorLookupCache(int size) {
        if (size > 0) {
            this.guidToVal = Collections.synchronizedMap(new LRUMap(size, LRUMap.LRU_Ordering.ACCESS));
            this.valToGuid = Collections.synchronizedMap(new LRUMap(size, LRUMap.LRU_Ordering.ACCESS));
        }
    }

    public String cacheNewValidator(IValidator validator) {
        if (this.guidToVal != null) {
            return this.getGuid(validator);
        }
        return validator.toString();
    }

    private String getGuid(IValidator validator) {
        String existingGuid = this.valToGuid.get(validator.toString());
        if (existingGuid != null) {
            return existingGuid;
        }
        return this.createNewGuid(validator);
    }

    private String createNewGuid(IValidator validator) {
        String safeValidator = new CMUUID().toString();
        this.guidToVal.put(safeValidator, validator);
        validator.setKey(safeValidator);
        this.valToGuid.put(validator.toString(), safeValidator);
        return safeValidator;
    }

    public IValidator get(String key) {
        if (key == null) {
            return null;
        }
        if (this.guidToVal == null) {
            return new StringBasedValidator(key);
        }
        IValidator validator = this.guidToVal.get(key);
        this.updateCounters(key, validator);
        return validator;
    }

    private void updateCounters(String key, IValidator validator) {
        if (validator != null) {
            hits.increment(0L);
        } else if (!key.equals("?")) {
            miss.increment(0L);
        }
    }

    public IValidator buildValidator(Long modifiedTime, List<String> paths) {
        if (modifiedTime == null) {
            return null;
        }
        CMExecutionContext exContext = CMExecutionContext.get();
        String preferencesProfile = this.getPreferencesProfile(exContext);
        AbstractValidator val = this.guidToVal != null ? new Validator(paths, modifiedTime, preferencesProfile, exContext.getAccManPassportID()) : new StringBasedValidator(paths, modifiedTime, preferencesProfile, exContext.getAccManPassportID());
        return val;
    }

    protected String getPreferencesProfile(CMExecutionContext exContext) {
        StringBuilder preferencesProfile = new StringBuilder();
        List<CMPreference> prefs = CMPreference.getAllPreferences();
        for (CMPreference pref : prefs) {
            preferencesProfile.append(exContext.getPreference(pref));
        }
        return new HashUtil(HashProviders.MD5).hash(preferencesProfile.toString());
    }
}

