/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator;

import com.cognos.cm.cache.CMCacheJavaImpl;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.validator.ICacheValidator;
import com.cognos.cm.request.validator.ICacheValidatorCalculator;
import com.cognos.cm.request.validator.ICacheValidatorUpdater;
import com.cognos.cm.request.validator.ValidatorLookupCache;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMLocalePreference;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePredicateAttribute;
import com.cognos.cm.store.path.CMStorePredicateComparison;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class VersionBasedValidator
implements ICacheValidator {
    public static final VersionBasedValidator instance = new VersionBasedValidator();
    private static final ICacheValidatorUpdater DUMMY_UPDATER = new ICacheValidatorUpdater(){

        @Override
        public void objectUpdated(Notification notification) {
        }

        @Override
        public void objectsUpdated(List<Notification> notifications) {
        }
    };

    @Override
    public ICacheValidatorUpdater getUpdater() {
        return DUMMY_UPDATER;
    }

    @Override
    public ICacheValidatorCalculator getCalculator(List<String> paths, String requestValidator, String responseAction, ValidatorLookupCache cache) {
        if (paths.size() != 1 || responseAction != null) {
            return null;
        }
        try {
            PathAnalyzer analyzer = new PathAnalyzer(paths.get(0));
            if (!analyzer.analyze()) {
                return null;
            }
            return new ETAGCalculator(analyzer, requestValidator);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class PathAnalyzer {
        CMExecutionContext ctx;
        String searchPath;
        CMCacheJavaImpl cache;
        CMStoreXPath path;
        int stepNum;
        String storeId;
        boolean childrenQuery = false;
        int classFilter = -1;

        PathAnalyzer(String searchPath) {
            this.searchPath = searchPath;
        }

        public boolean analyze() throws CMException {
            this.ctx = CMExecutionContext.get();
            this.cache = (CMCacheJavaImpl)this.ctx.getStore().getCache();
            this.path = new CMStoreXPath(this.searchPath);
            if (this.path.isUnion() || this.path.size() == 0 || this.path.size() > 3 || this.path.hasDescendantSteps()) {
                return false;
            }
            this.stepNum = 0;
            this.storeId = this.getPathRoot();
            if (this.storeId == null) {
                return false;
            }
            ++this.stepNum;
            if (this.path.size() == this.stepNum + 1) {
                this.childrenQuery = true;
                this.classFilter = PathAnalyzer.getClassFilter(this.currentStep());
            } else if (this.path.size() > this.stepNum + 1) {
                return false;
            }
            return true;
        }

        public String getStoreId() {
            return this.storeId;
        }

        public boolean isChildrenQuery() {
            return this.childrenQuery;
        }

        public int getClassFilter() {
            return this.classFilter;
        }

        private CMStoreXPathStep currentStep() {
            return (CMStoreXPathStep)this.path.stepAt(this.stepNum);
        }

        private String getPathRoot() throws CMException {
            CMStoreXPathStep step = this.currentStep();
            if (step.bCurrentUser_) {
                return this.getIdFromUserPath(step);
            }
            CMConstants.FunctionDef nodeSetFn = step.getNodeSetFunction();
            if (nodeSetFn != null) {
                return this.getIdForNodeSetFunction(nodeSetFn, step);
            }
            return this.getRootObjectId(step);
        }

        private String getRootObjectId(CMStoreXPathStep step) {
            int clsId = PathAnalyzer.getClassFilter(step);
            if (clsId == -1) {
                return null;
            }
            InternalStoreId storeId = this.cache.getChild(0, clsId);
            if (storeId != null) {
                return storeId.stringValue();
            }
            return null;
        }

        private String getIdForNodeSetFunction(CMConstants.FunctionDef nodeSetFn, CMStoreXPathStep step) {
            if (nodeSetFn == CMConstants.FUNC_STOREID_DEF) {
                CMStorePathPredicateFunction fn = (CMStorePathPredicateFunction)step.Predicates.get(0);
                return fn.getStringArgument(0);
            }
            return null;
        }

        private String getIdFromUserPath(CMStoreXPathStep step) throws CMException {
            if (step.bCurrentSession_ || this.path.size() > 3) {
                return null;
            }
            int id = CMExecutionContext.get().getCurrentUserAccountObjectID();
            if (id <= 0) {
                return null;
            }
            if (this.path.size() == 1) {
                return this.cache.CMCacheGetStoreId(id, true);
            }
            ++this.stepNum;
            step = this.currentStep();
            int clsId = PathAnalyzer.getClassFilter(step);
            if (clsId == -1) {
                return null;
            }
            InternalStoreId storeId = this.cache.getChild(id, clsId);
            if (storeId != null) {
                return storeId.stringValue();
            }
            return null;
        }

        private static int getClassFilter(CMStoreXPathStep step) {
            if (step.hasPredicates()) {
                for (CMStorePredicateElement pred : step.Predicates) {
                    String objClass;
                    List<CMStorePredicateElement> predicates;
                    if (!(pred instanceof CMStorePathPredicate) || (predicates = ((CMStorePathPredicate)pred).PredicateExpressions).size() != 3 || !PathAnalyzer.isEqulsPredicate(predicates.get(1)) || (objClass = PathAnalyzer.getClassFilter(predicates.get(0), predicates.get(2))) == null) continue;
                    return PathAnalyzer.getClassId(objClass);
                }
            }
            return -1;
        }

        private static boolean isEqulsPredicate(CMStorePredicateElement el) {
            return el instanceof CMStorePredicateComparison && ((CMStorePredicateComparison)el).comparison == 2;
        }

        private static String getClassFilter(CMStorePredicateElement left, CMStorePredicateElement right) {
            if (left instanceof CMStorePredicateAttribute && ((CMStorePredicateAttribute)left).property == CMProperty.OBJECTCLASS && right instanceof CMStorePredicateStringLiteral) {
                return ((CMStorePredicateStringLiteral)right).literal;
            }
            return null;
        }

        private static int getClassId(String name) {
            CMObjectClass cls = CMDbStoreFactory.objectClasses_.getClassByName(name);
            return cls.getID();
        }
    }

    private static class ETAGCalculator
    implements ICacheValidatorCalculator {
        private String etag;
        private boolean matched;

        public ETAGCalculator(PathAnalyzer analizer, String etag) throws CMException {
            CMExecutionContext ctx = CMExecutionContext.get();
            String s = this.getContentETAG(analizer, ctx);
            if (s == null) {
                this.etag = etag != null && etag.startsWith("42-") ? "410" : "NOT_SUPPORTED";
                this.matched = false;
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("42-").append(this.getUserETAG(ctx)).append('-').append(s);
                this.etag = buf.toString();
                this.matched = this.etag.equals(etag);
            }
        }

        private String getContentETAG(PathAnalyzer analizer, CMExecutionContext ctx) throws CMException {
            CMCacheJavaImpl cache = (CMCacheJavaImpl)ctx.getStore().getCache();
            return analizer.isChildrenQuery() ? cache.getContentEtag(analizer.getStoreId(), analizer.getClassFilter()) : cache.getEtag(analizer.getStoreId());
        }

        private String getUserETAG(CMExecutionContext ctx) throws CMStoreNotAvailable, CMStoreUnexpected {
            StringBuilder buf = new StringBuilder();
            CMLocalePreference contentlocale = ctx.getRequestLocale("contentLocale");
            buf.append(contentlocale.toString());
            String showHidden = ctx.getPreference(CMPreference.SHOWHIDDENOBJECTS);
            buf.append(showHidden == null ? (char)'f' : showHidden.charAt(0));
            buf.append(ctx.getCurrentUserIdentity());
            ArrayList<String> strTenantIDs = new ArrayList<String>();
            int[] intTenantIDs = ctx.getReadTenantIds();
            CMStore store = ctx.getStore();
            TenantRegistry tenantRegistry = store.getTenantRegistry();
            if (intTenantIDs != null && intTenantIDs.length > 0) {
                for (int tenantID : intTenantIDs) {
                    strTenantIDs.add(tenantRegistry.getTenantIdStringFromInt(tenantID));
                }
                buf.append(((Object)strTenantIDs).toString());
            }
            return Integer.toHexString(buf.toString().hashCode());
        }

        @Override
        public boolean validatorMatches() {
            return this.matched;
        }

        @Override
        public boolean canCheck() {
            return false;
        }

        @Override
        public String calculateNewValidator(InputStream inputStream) {
            return this.etag;
        }

        @Override
        public Long getModifiedDate() {
            return 0L;
        }

        @Override
        public boolean canFetchModifiedDate() {
            return false;
        }

        @Override
        public boolean responseValidated() {
            return false;
        }
    }
}

