/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.request.validator.responseActions;

import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.request.validator.IValidator;
import com.cognos.cm.request.validator.NotSupportedValidator;
import com.cognos.cm.request.validator.QueryResponse;
import com.cognos.cm.request.validator.ValidatorLookupCache;
import com.cognos.cm.request.validator.responseActions.ResponseValidator;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AdvancedSettingsObserver;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMGZIPOutputStream;
import com.cognos.cm.util.LRUMap;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class responseCompare
implements ResponseValidator {
    private boolean responseMatched = false;
    private String passportID;
    private static Double salt = null;
    public static final Counter hits = new AccumulatingCounter().makeThreadLocal();
    public static final Counter miss = new AccumulatingCounter().makeThreadLocal();
    public static LRUMap<String, QueryResponse> responses = new LRUMap(AdvancedSettings.VALIDATOR_RESPONSE_COMPARE_CACHE_SIZE, LRUMap.LRU_Ordering.ACCESS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setResponseCacheSize(int size) {
        LRUMap<String, QueryResponse> lRUMap = responses;
        synchronized (lRUMap) {
            responses.setMaxSize(size);
        }
    }

    @Override
    public String getNewValidator(String passportID, ValidatorLookupCache cache, IValidator validator, InputStream response) {
        this.passportID = passportID;
        QueryResponse queryResponse = this.getQueryResponse(response);
        if (validator != null) {
            String key = validator.toString();
            this.responseMatched = this.responsesMatch(key, queryResponse);
            if (this.responseMatched) {
                return validator.getKey();
            }
        }
        NotSupportedValidator newValidator = new NotSupportedValidator(queryResponse, this);
        return cache.cacheNewValidator(newValidator);
    }

    public boolean responsesMatch(String key, QueryResponse response) {
        QueryResponse myResponse = this.getResponse(key);
        if (myResponse == null) {
            return false;
        }
        return myResponse.equals(response);
    }

    @Override
    public boolean validated() {
        return this.responseMatched;
    }

    private QueryResponse getQueryResponse(InputStream response) {
        ByteArrayOutputStream byteResponseOutStream = new ByteArrayOutputStream(1024);
        CMGZIPOutputStream zipoutputStream = this.getZipOutputStream(response, byteResponseOutStream);
        long responseCRC = this.getCheckSum(zipoutputStream);
        byte[] zippedResponseBytes = byteResponseOutStream.toByteArray();
        QueryResponse newResponse = new QueryResponse(zippedResponseBytes, responseCRC);
        return newResponse;
    }

    private CMGZIPOutputStream getZipOutputStream(InputStream responseStream, ByteArrayOutputStream byteResponseOutStream) {
        CMGZIPOutputStream zipoutputStream = null;
        try {
            zipoutputStream = new CMGZIPOutputStream(byteResponseOutStream);
            byte[] buf = new byte[2048];
            int nBytesRead = responseStream.read(buf);
            while (nBytesRead > 0) {
                zipoutputStream.write(buf, 0, nBytesRead);
                nBytesRead = responseStream.read(buf);
            }
            zipoutputStream.close();
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmValidatorErrorReadingResponse"));
            return null;
        }
        return zipoutputStream;
    }

    private long getCheckSum(CMGZIPOutputStream zipoutputStream) {
        if (zipoutputStream == null) {
            return 0L;
        }
        return zipoutputStream.getCRC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(String key, QueryResponse queryResponse) {
        LRUMap<String, QueryResponse> lRUMap = responses;
        synchronized (lRUMap) {
            responses.put(key, queryResponse);
        }
    }

    public String getResponseKey(QueryResponse response) {
        return this.passportID + response.toString() + this.getSalt();
    }

    private Double getSalt() {
        if (salt == null) {
            salt = Math.random();
        }
        return salt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResponse getResponse(String key) {
        LRUMap<String, QueryResponse> lRUMap = responses;
        synchronized (lRUMap) {
            QueryResponse resp = (QueryResponse)responses.get(key);
            if (resp != null) {
                hits.increment(0L);
            } else if (key != null && !key.equals("?")) {
                miss.increment(0L);
            }
            return resp;
        }
    }

    static {
        AdvancedSettings.addObserver(new SizeObserver());
    }

    private static class SizeObserver
    implements AdvancedSettingsObserver {
        private SizeObserver() {
        }

        @Override
        public void updateSettings() {
            if (AdvancedSettings.VALIDATOR_RESPONSE_COMPARE_CACHE_SIZE != responses.getMaxSize()) {
                responseCompare.setResponseCacheSize(AdvancedSettings.VALIDATOR_RESPONSE_COMPARE_CACHE_SIZE);
            }
        }
    }
}

