/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.rest.CMStoreQueryHelper;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.ResultProperty;
import com.cognos.cm.rest.ResultRow;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CMQueryHelperImpl
implements CMStoreQueryHelper {
    private static final Pattern STOREID_PATTERN = Pattern.compile("^i[0-9a-fA-F]{32}$");
    private static final Pattern BASE_PATTERN = Pattern.compile("^[a-zA-Z]+$");
    private final CMExecutionContext ctx;
    private OrderByField[] orderBy;

    public CMQueryHelperImpl(CMExecutionContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public CMStorePath getPath(String searchPath) throws CMStoreParseException {
        Matcher storeIDmatcher = STOREID_PATTERN.matcher(searchPath);
        Matcher baseMatcher = BASE_PATTERN.matcher(searchPath);
        CMStoreXPath path = null;
        if ("root".equals(searchPath)) {
            path = new CMStoreXPath("/");
        } else if ("~".equals(searchPath) || "~~".equals(searchPath)) {
            path = new CMStoreXPath(searchPath);
        } else if (storeIDmatcher.matches()) {
            path = CMStoreXPath.fromStoreID(searchPath);
        } else if (baseMatcher.matches()) {
            path = new CMStoreXPath("/" + searchPath);
        } else {
            throw new CMStoreParseException("cmInvalidSearchPath", new CMException.Parm("Path", searchPath));
        }
        return path;
    }

    @Override
    public CMStorePath parsePath(String searchPath) throws CMStoreParseException {
        return CMStoreXPath.parse(searchPath);
    }

    @Override
    public boolean validStoreID(String storeId) {
        return InternalStoreId.validate(storeId);
    }

    @Override
    public CMStorePath getChildPath(String storeId, String childStep) throws CMStoreParseException {
        CMStorePath path = this.getPath(storeId);
        return new CMStoreXPath(path, childStep, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object queryOneProperty(CMStorePath path, CMProperty prop) throws CMException, HTTPException {
        Object result = null;
        CMStoreQueryResults queryResults = null;
        CMDbStore store = (CMDbStore)this.ctx.getStore();
        CMProperty[] props = new CMProperty[]{prop};
        int flags = 8224;
        try {
            queryResults = store.executeQuery(path, props, null, 0, flags, null);
            if (!queryResults.next()) {
                throw new HTTPException(404);
            }
            result = queryResults.getValue(0);
            if (queryResults.next()) {
                throw new HTTPException(400, "More than one object selected");
            }
            Object object = result;
            this.release(queryResults);
            return object;
        }
        catch (Throwable throwable) {
            this.release(queryResults);
            throw throwable;
        }
    }

    @Override
    public List<ResultRow> executeQuery(CMStorePath path, CMProperty ... props) throws CMException {
        return this.executeQuery(path, this.orderBy, 256, props);
    }

    @Override
    public List<ResultRow> executeAdminQuery(CMStorePath path, CMProperty ... props) throws CMException {
        return this.executeQuery(path, this.orderBy, 512, props);
    }

    @Override
    public List<ResultRow> executeOrderedQuery(CMStorePath path, CMProperty ... props) throws CMException {
        OrderByField orderBy = new OrderByField(true, CMProperty.CREATIONTIME);
        OrderByField[] orderByFields = new OrderByField[]{orderBy};
        return this.executeQuery(path, orderByFields, 256, props);
    }

    @Override
    public void release(CMStoreQueryResults results) {
        CMQueryUtils.safeQueryResultsRelease(results);
        CMQueryUtils.safeReleaseLocks(this.ctx);
    }

    @Override
    public void setOrderBy(OrderByField[] orderBy) {
        this.orderBy = orderBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultRow> executeQuery(CMStorePath path, OrderByField[] orderBy, int permission, CMProperty ... props) throws CMException {
        CMStoreQueryResults results = null;
        try {
            CMDbStore store = (CMDbStore)this.ctx.getStore();
            int flags = 0x2020 | permission;
            results = store.executeQuery(path, props, orderBy, 0, flags, null);
            List<ResultRow> list = this.processResults(results, props);
            this.release(results);
            return list;
        }
        catch (Throwable throwable) {
            this.release(results);
            throw throwable;
        }
    }

    private List<ResultRow> processResults(CMStoreQueryResults cmResults, CMProperty ... props) throws CMException {
        ArrayList<ResultRow> results = new ArrayList<ResultRow>();
        while (cmResults.next()) {
            ResultRow row = new ResultRow();
            int propIdx = 0;
            for (CMProperty prop : props) {
                this.addPropertyToResult(cmResults, row, propIdx++, prop);
            }
            results.add(row);
        }
        return results;
    }

    private void addPropertyToResult(CMStoreQueryResults cmResults, ResultRow row, int propIdx, CMProperty prop) throws CMException {
        String name = prop.getName();
        Object value = cmResults.getValue(propIdx);
        ResultProperty property = new ResultProperty(name, value);
        row.add(property);
    }
}

