/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest;

import com.cognos.accman.jcam.crypto.BATrustedRequestSession;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieFactory;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.diagnostics.DiagnosticsContext;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.rest.Access;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.Handler;
import com.cognos.cm.rest.HttpMethods;
import com.cognos.cm.rest.PropertyHandlerFactoryImpl;
import com.cognos.cm.rest.handlers.BulkVersionCheck;
import com.cognos.cm.rest.handlers.ContentObjects;
import com.cognos.cm.rest.handlers.EtagValidatorHandler;
import com.cognos.cm.rest.handlers.FunctionsHandler;
import com.cognos.cm.rest.handlers.IdQueryHandler;
import com.cognos.cm.rest.handlers.LicenseDefinitionsHandler;
import com.cognos.cm.rest.handlers.LicensesHandler;
import com.cognos.cm.rest.handlers.ObjectsHandler;
import com.cognos.cm.rest.handlers.UpsDescriptionsHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.UserPreferences;
import com.cognos.cm.util.CMStringUtils;
import com.ibm.cognos.pogo.zipi.ZipiWrappedServlet;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class Objects
extends ZipiWrappedServlet {
    public static String INVALID_PASSPORT = "The passport ID is invalid";
    public static String MUST_BE_TRUSTED = "Operation requires trust access";
    public static final String CAM_PASSPORT_NAME = "cam_passport";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String LOCATION = "Location";
    public static final boolean IS_PASSPORT_URL_ENABLED = true;
    private static HashMap<String, Class<? extends Handler>> handlers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ZipiStorage.setCurrentService((String)"contentManagerService");
        try {
            Class<? extends Handler> cls = this.getHandlerClass(request);
            if (cls == null) {
                response.sendError(400);
            } else if (!this.methodSupported(cls, request.getMethod().toUpperCase())) {
                response.sendError(405);
            } else if (CMServlet.CMRunningMode_ == 1) {
                this.handleCMRunning(cls, request, response);
            } else if (CMServlet.CMRunningMode_ == 2) {
                this.handleCMStandby(request, response);
            } else {
                response.sendError(503);
            }
        }
        finally {
            ZipiStorage.clearCurrentService();
        }
    }

    private boolean processTrustToken(CMExecutionContext ctx, HttpServletRequest request) throws HTTPException {
        String trustToken = request.getHeader("X-CA-Authorization");
        if (trustToken == null) {
            return false;
        }
        try {
            BATrustedRequestSession baSes = CMServlet.CAMFactory_.createBATrustedSession();
            String serviceId = baSes.getServiceIDAndVerifyToken(trustToken);
            ctx.setServiceId(serviceId);
        }
        catch (CAMCryptoException e) {
            throw new HTTPException(401, e.getMessage());
        }
        return true;
    }

    private void initDiagnostics(CMExecutionContext ctx) {
        ContentManager.diagnosticsManager.reset();
        DiagnosticsContext diagCtx = DiagnosticsContext.get();
        diagCtx.setCommand("rest");
        diagCtx.setUser(ctx.getCurrentUser());
    }

    private void sendError(HttpServletResponse response, int code, Throwable t) {
        try {
            response.sendError(code, t.getLocalizedMessage());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCMRunning(Class<? extends Handler> handlerCls, HttpServletRequest request, HttpServletResponse response) {
        CMExecutionContext ctx = null;
        try {
            ContentManager.inCMTimer.start();
            ctx = this.setupExecutionContext();
            this.initDiagnostics(ctx);
            this.authenticateRequest(handlerCls, request);
            this.setRequestPreferences(ctx, request);
            Handler handler = this.createHandler(handlerCls, ctx);
            handler.handleRequest(request, response);
        }
        catch (CMException ce) {
            int status = CMError.isServerFault(ce) ? 500 : 400;
            this.sendError(response, status, ce);
        }
        catch (HTTPException he) {
            he.sendError(response);
        }
        catch (Exception e) {
            CMIndications.logException(e);
            this.sendError(response, 500, e);
        }
        finally {
            if (ctx != null) {
                CMExecutionContext.tearDown();
            }
            ContentManager.inCMTimer.stop();
            ContentManager.diagnosticsManager.update();
        }
    }

    private void authenticateRequest(Class<? extends Handler> handlerCls, HttpServletRequest request) throws HTTPException {
        CMExecutionContext ctx = CMExecutionContext.get();
        boolean requiresPassport = true;
        boolean mustBeTrusted = false;
        Access access = this.getAnnotation(handlerCls, Access.class);
        if (access != null) {
            requiresPassport = access.value().equals("AUTHENTICATED");
            mustBeTrusted = access.value().equals("TRUSTED");
        }
        String passport = this.getPassportID(request);
        ctx.setAccManPassportID(passport);
        boolean isTrusted = this.processTrustToken(ctx, request);
        if (requiresPassport && !this.isAuthenticated(ctx)) {
            throw new HTTPException(401, INVALID_PASSPORT);
        }
        if (mustBeTrusted && !isTrusted) {
            throw new HTTPException(401, MUST_BE_TRUSTED);
        }
    }

    private void setRequestPreferences(CMExecutionContext ctx, HttpServletRequest request) {
        UserPreferences sessionVars = ctx.getCurrentUserSessionVars();
        UserPreferences prefs = sessionVars == null ? new UserPreferences() : new UserPreferences(sessionVars);
        String crn = this.getCookie(request, "CRN");
        if (crn != null) {
            this.decodePreferenceCookie(crn, prefs);
        }
        ctx.getContext().setRequestPreferences(prefs);
    }

    private void decodePreferenceCookie(String cookie, UserPreferences prefs) {
        try {
            String v = URLDecoder.decode(cookie, "utf-8");
            for (String s : CMStringUtils.split(v, '&')) {
                int eq = s.indexOf(61);
                if (eq == -1) continue;
                String name = s.substring(0, eq);
                String value = s.substring(eq + 1);
                CMPreference pref = CMPreference.find(URLDecoder.decode(name, "utf-8"));
                if (pref == null) continue;
                prefs.set(pref, URLDecoder.decode(value, "utf-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleCMStandby(HttpServletRequest request, HttpServletResponse response) {
        CMExecutionContext ctx = this.setupExecutionContext();
        String activeCM = this.getActiveCM(ctx);
        CMExecutionContext.tearDown();
        if (!StringUtils.isBlank((String)activeCM)) {
            this.sentRedirect(request, response, activeCM);
        } else {
            response.setStatus(503);
        }
    }

    private String getActiveCM(CMExecutionContext ctx) {
        try {
            return ctx.getStore().getRunningContentStoreName();
        }
        catch (CMException e) {
            CMIndications.logException(e);
            return null;
        }
    }

    private void sentRedirect(HttpServletRequest request, HttpServletResponse response, String location) {
        String urlWithoutP2pd = location.substring(0, location.indexOf("/p2pd"));
        String redirectURL = urlWithoutP2pd + request.getRequestURI();
        redirectURL = response.encodeRedirectURL(redirectURL);
        response.setStatus(301);
        response.setHeader(LOCATION, redirectURL);
    }

    private String getPassportID(HttpServletRequest request) {
        String passportId = request.getHeader("X-Cognos-CAM-passportID");
        if (passportId != null) {
            return passportId;
        }
        passportId = this.getPassportIDFromCookie(request);
        if (passportId == null) {
            passportId = request.getParameter(CAM_PASSPORT_NAME);
        }
        return passportId;
    }

    private String getPassportIDFromCookie(HttpServletRequest request) {
        String encryptedPassportId = this.getCookie(request, CAM_PASSPORT_NAME);
        if (encryptedPassportId != null) {
            CAMCookie aCookie = CAMCookieFactory.createCAMCookie((String)encryptedPassportId);
            return aCookie.getPassportID();
        }
        return null;
    }

    private String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected CMExecutionContext setupExecutionContext() {
        CMExecutionContext.setUp();
        CMExecutionContext.mapCurrentThreadContext();
        return CMExecutionContext.get();
    }

    private boolean isAuthenticated(CMExecutionContext ctx) {
        String passport = ctx.getAccManPassportID();
        boolean isPassportMissing = passport == null;
        return !isPassportMissing && CMServlet.AAA.validate(passport);
    }

    private Class<? extends Handler> getHandlerClass(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        StringTokenizer toker = new StringTokenizer(pathInfo, "/");
        if (toker.hasMoreTokens()) {
            return handlers.get(toker.nextToken());
        }
        return null;
    }

    private Handler createHandler(Class<? extends Handler> clazz, CMExecutionContext ctx) {
        Handler handler = null;
        try {
            handler = clazz.newInstance();
            handler.setContext(ctx);
            PropertyHandlerFactoryImpl factory = new PropertyHandlerFactoryImpl(ctx);
            handler.setPropertyHandlerFactory(factory);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        finally {
            ctx.release();
        }
        return handler;
    }

    private boolean methodSupported(Class cls, String method) {
        HttpMethods m = this.getAnnotation(cls, HttpMethods.class);
        if (m != null) {
            for (String s : m.value()) {
                if (!s.equals(method)) continue;
                return true;
            }
            return false;
        }
        return method.equals("GET");
    }

    private <T> T getAnnotation(Class cls, Class<T> annotation) {
        while (cls != null) {
            T m = cls.getDeclaredAnnotation(annotation);
            if (m != null) {
                return m;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    static {
        handlers.put("objects", ObjectsHandler.class);
        handlers.put("functions", FunctionsHandler.class);
        handlers.put("tags", EtagValidatorHandler.class);
        handlers.put("ups_descriptions", UpsDescriptionsHandler.class);
        handlers.put("licenses", LicensesHandler.class);
        handlers.put("license_definitions", LicenseDefinitionsHandler.class);
        handlers.put("accessible_objects", IdQueryHandler.class);
        handlers.put("versions", BulkVersionCheck.class);
        handlers.put("content_objects", ContentObjects.class);
    }
}

