/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest;

import com.cognos.cm.rest.PropertyHandler;
import com.cognos.cm.rest.PropertyHandlerFactory;
import com.cognos.cm.rest.handlers.AliasedPropertyHandler;
import com.cognos.cm.server.CMExecutionContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PropertyHandlerFactoryImpl
implements PropertyHandlerFactory {
    private static Map<String, PropertyHandler> handlers = new HashMap<String, PropertyHandler>();
    private CMExecutionContext ctx;

    public PropertyHandlerFactoryImpl(CMExecutionContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean isSupportedProperty(String property) {
        return handlers.containsKey(property);
    }

    @Override
    public PropertyHandler getHandler(String property) {
        PropertyHandler handler = handlers.get(property);
        if (handler == null) {
            throw new RuntimeException("Unknown property handler: " + property);
        }
        handler = handler instanceof AliasedPropertyHandler ? this.newAliasedHandler(handler) : PropertyHandlerFactoryImpl.newHandler(handler.getClass());
        return handler;
    }

    private PropertyHandler newAliasedHandler(PropertyHandler handler) {
        AliasedPropertyHandler aliasedPropHandler = (AliasedPropertyHandler)handler;
        try {
            handler = (PropertyHandler)aliasedPropHandler.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return handler;
    }

    private static void loadStandardProps() {
        String[] standardProps;
        for (String prop : standardProps = new String[]{"data", "storeID", "userCapabilities", "identity", "tenantID", "permissions", "children", "outputs", "defaultOutput", "userProfileSettings", "searchPath"}) {
            PropertyHandlerFactoryImpl.loadPropHandler(prop);
        }
    }

    private static void loadPDCProps() {
        PropertyHandlerFactoryImpl.loadPropHandler("ccPages", "com.cognos.cm.rest.ccPagesPropertyHandler");
    }

    private static void loadAliasedProps() {
        AliasedPropertyHandler handler = new AliasedPropertyHandler();
        handler.addAlias("output", handlers.get("data"));
        handlers.put("_content", handler);
    }

    private static void loadPropHandler(String propName) {
        PropertyHandlerFactoryImpl.loadPropHandler(propName, PropertyHandlerFactoryImpl.getPropertyHandlerClass(propName));
    }

    private static void loadPropHandler(String propName, String className) {
        Class<? extends PropertyHandler> clazz = PropertyHandlerFactoryImpl.classForName(className);
        if (clazz != null) {
            PropertyHandlerFactoryImpl.loadPropHandler(propName, clazz);
        }
    }

    private static void loadPropHandler(String propName, Class<? extends PropertyHandler> clazz) {
        handlers.put(propName, PropertyHandlerFactoryImpl.newHandler(clazz));
    }

    private static PropertyHandler newHandler(Class<? extends PropertyHandler> clazz) {
        try {
            Constructor<? extends PropertyHandler> cst = clazz.getDeclaredConstructor(new Class[0]);
            return cst.newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends PropertyHandler> getPropertyHandlerClass(String property) {
        if (handlers.containsKey(property)) {
            return handlers.get(property).getClass();
        }
        String path = PropertyHandlerFactoryImpl.getHandlerClassName(property);
        Class<? extends PropertyHandler> clazz = PropertyHandlerFactoryImpl.classForName(path);
        if (clazz != null) {
            handlers.put(property, PropertyHandlerFactoryImpl.newHandler(clazz));
        }
        return clazz;
    }

    private static Class<? extends PropertyHandler> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String getHandlerClassName(String propName) {
        char[] propNameChars = propName.toCharArray();
        propNameChars[0] = Character.toUpperCase(propNameChars[0]);
        String className = new String(propNameChars);
        return "com.cognos.cm.rest.handlers.properties." + className + "PropertyHandler";
    }

    protected Set<String> getSupportedProps() {
        return handlers.keySet();
    }

    static {
        PropertyHandlerFactoryImpl.loadStandardProps();
        PropertyHandlerFactoryImpl.loadPDCProps();
        PropertyHandlerFactoryImpl.loadAliasedProps();
    }
}

