/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.BasePropertyHandler;
import com.cognos.cm.rest.handlers.ContentProperty;
import com.cognos.cm.rest.handlers.ContentPropertyFactory;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.ContentDispositionBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public abstract class BaseContentPropertyHandler
extends BasePropertyHandler {
    private static final int BUFFER_SIZE = 32768;

    public abstract boolean isSupported(CMObjectClass var1);

    public abstract ContentPropertyFactory getContentPropertyFactory(CMObjectClass var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, String encodedStoreId, String passport) throws CMException, IOException, HTTPException {
        CMObjectClass objectClass;
        int cmid;
        CMCache cmCache;
        int versionNumber;
        String contentName;
        ContentProperty content;
        CMCacheQueryInstance cacheQuery;
        ICMLockManager lockManager;
        CMDbStore store;
        block9: {
            store = (CMDbStore)this.ctx.getStore();
            CMStorePath path = this.queryHelper.getPath(encodedStoreId);
            lockManager = store.getLockManager();
            ArrayList<String> appPerms = new ArrayList<String>();
            appPerms.add("read");
            cacheQuery = null;
            content = null;
            contentName = null;
            versionNumber = 0;
            try {
                lockManager.requestLocks(path);
                cmCache = store.getCache();
                ICacheAccessMan accMan = cmCache.newAccessMan(passport);
                accMan.setPermissions(appPerms);
                cacheQuery = cmCache.executeQuery(path, 0, accMan);
                int[] cmids = cacheQuery.resultObjects();
                if (cmids.length == 0) {
                    throw new HTTPException(404);
                }
                if (cmids.length > 1) {
                    throw new HTTPException(400, "More than one object selected");
                }
                cmid = cmids[0];
                String storeId = cmCache.CMCacheGetStoreId(cmid, true);
                versionNumber = cmCache.getVersionNumber(storeId);
                objectClass = store.getObjectClass(cmid);
                if (!this.isSupported(objectClass)) {
                    throw new HTTPException(404);
                }
                if (this.isModified(request, versionNumber)) break block9;
                response.setStatus(304);
            }
            catch (Throwable throwable) {
                this.releaseCacheQuery(cacheQuery);
                this.releaseLocks(lockManager);
                throw throwable;
            }
            this.releaseCacheQuery(cacheQuery);
            this.releaseLocks(lockManager);
            return;
        }
        contentName = this.getOutputName(cmCache, cmid);
        content = this.queryContent(store, cmid, objectClass);
        this.releaseCacheQuery(cacheQuery);
        this.releaseLocks(lockManager);
        try {
            this.writeContent(request, response, content, contentName, versionNumber);
        }
        finally {
            IOUtils.closeQuietly((Closeable)content);
        }
    }

    private boolean isModified(HttpServletRequest request, int versionNumber) {
        int incomingVersion;
        boolean isModified = true;
        if (versionNumber != -1 && this.hasIfNoneMatchHeader(request) && (incomingVersion = this.getVersionFromETag(request)) == versionNumber) {
            isModified = false;
        }
        return isModified;
    }

    private boolean hasIfNoneMatchHeader(HttpServletRequest request) {
        return request.getHeader("If-None-Match") != null;
    }

    private int getVersionFromETag(HttpServletRequest request) {
        String eTag = request.getHeader("If-None-Match");
        String incomingVersion = eTag.substring(eTag.indexOf(61) + 1);
        return Integer.valueOf(incomingVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentProperty queryContent(CMDbStore store, int cmid, CMObjectClass objectClass) throws CMException, HTTPException {
        CMStoreQueryResults results = null;
        ContentProperty contentProp = null;
        try {
            ContentPropertyFactory factory = this.getContentPropertyFactory(objectClass);
            results = store.executeQuery(new int[]{cmid}, factory.getPropertyArray(), null, 0, 1, null);
            if (!results.next()) {
                throw new HTTPException(404);
            }
            contentProp = factory.create(results);
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(results);
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        return contentProp;
    }

    private String getOutputName(CMCache cache, int cmids) throws CMException {
        CMAncestors ancestors = cache.getAncestors(cmids);
        String outputName = cache.CMCacheGetName(cmids, CMDbStoreCacheUtil.getCacheSearchLocales());
        String name = ancestors.getName(ancestors.getSize() - 2) + " " + outputName;
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(HttpServletRequest request, HttpServletResponse response, ContentProperty contentProp, String name, int version) throws IOException {
        if (version != -1) {
            response.setHeader("ETag", "version=" + version);
        }
        String userAgent = request.getHeader("User-Agent");
        String contentType = contentProp.getContentType();
        String disposition = ContentDispositionBuilder.buildContentDisposition(name, contentType, userAgent);
        response.addHeader("Content-Disposition", disposition);
        response.setContentType(contentType);
        response.setStatus(200);
        String reqAcceptEncoding = request.getHeader("Accept-Encoding");
        boolean isGzipEncodingRequested = this.acceptsGzipEncoding(reqAcceptEncoding);
        boolean alreadyGzipped = contentProp.isCompressed() && isGzipEncodingRequested;
        ServletOutputStream out = response.getOutputStream();
        long contentLength = -1L;
        InputStream in = null;
        try {
            if (alreadyGzipped) {
                response.addHeader("Content-Encoding", "gzip");
                response.addHeader("Content-Transfer-Encoding", "8bit");
                contentLength = contentProp.getContentLength();
                in = contentProp.getInputStream();
            } else if (contentProp.isCompressed()) {
                contentLength = contentProp.getUncompressedContentLength();
                if (contentProp.hasContent()) {
                    in = new GZIPInputStream(contentProp.getInputStream(), 32768);
                }
            } else {
                contentLength = contentProp.getContentLength();
                in = contentProp.getInputStream();
            }
            this.addContentLengthHeader(response, contentLength);
            if (in != null) {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    protected boolean acceptsGzipEncoding(String reqAcceptEncoding) {
        return reqAcceptEncoding != null && reqAcceptEncoding.toLowerCase().contains("gzip");
    }

    private void addContentLengthHeader(HttpServletResponse response, long contentLength) {
        if (contentLength != -1L) {
            response.addHeader("Content-Length", Long.toString(contentLength));
        }
    }
}

