/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.rest.CMPropertyJSONSerializer;
import com.cognos.cm.rest.CMQueryHelperImpl;
import com.cognos.cm.rest.CMStoreQueryHelper;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.PropertyHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.path.CMStorePath;
import com.ibm.json.java.JSONArray;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

public abstract class BasePropertyHandler
implements PropertyHandler {
    protected CMExecutionContext ctx;
    protected CMStoreQueryHelper queryHelper;

    public BasePropertyHandler() {
        this.initialize();
    }

    protected void initialize() {
        this.ctx = CMExecutionContext.get();
        this.queryHelper = new CMQueryHelperImpl(this.ctx);
    }

    public BasePropertyHandler(CMExecutionContext ctx) {
        this.ctx = ctx;
    }

    protected void setContext(CMExecutionContext ctx) {
        this.ctx = ctx;
    }

    public void setQueryHelper(CMStoreQueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    protected void releaseCacheQuery(CMCacheQueryInstance cacheQuery) {
        if (cacheQuery != null) {
            try {
                cacheQuery.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void releaseLocks(ICMLockManager lockMgr) {
        try {
            lockMgr.releaseLocks();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void handlePropertyQuery(HttpServletResponse response, String storeIdLiteral, CMProperty property, CMPropertyJSONSerializer propSerializer) throws IOException, CMException, HTTPException {
        JSONArray objArray = new JSONArray();
        CMStorePath path = this.queryHelper.getPath(storeIdLiteral);
        Object value = this.queryHelper.queryOneProperty(path, property);
        propSerializer.serialize(objArray, value);
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(200);
        objArray.serialize((OutputStream)response.getOutputStream());
    }
}

