/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.rest.Access;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.HttpMethods;
import com.cognos.cm.rest.handlers.AbstractHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.CMStringUtils;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.Charsets;

@HttpMethods(value={"GET", "POST"})
@Access(value="TRUSTED")
public class BulkVersionCheck
extends AbstractHandler {
    static final String CONTENT_TYPE = "Content-Type";
    static final String STOREIDS = "storeIDs";
    static final String MIME_TYPE_JSON = "application/json";
    static final String QP_IDS = "storeIDs";

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, CMException, HTTPException {
        JSONObject result;
        InternalStoreId[] objectsToCheck = this.getObjectsToCheck(request);
        if (objectsToCheck.length != 0) {
            CMCache cache = CMExecutionContext.get().getStore().getCache();
            int[] versions = cache.getVersionNumbers(objectsToCheck);
            result = this.buildResult(objectsToCheck, versions);
        } else {
            result = new JSONObject();
        }
        this.writeRespose(response, result);
    }

    private void writeRespose(HttpServletResponse response, JSONObject result) throws IOException {
        ServletOutputStream os = response.getOutputStream();
        response.setContentType(MIME_TYPE_JSON);
        response.setStatus(200);
        result.serialize((OutputStream)os);
    }

    private InternalStoreId[] getObjectsToCheck(HttpServletRequest request) throws HTTPException, IOException {
        return this.convertStoreIds(request.getMethod().equals("GET") ? this.getObjectListFromQueryParameters(request) : this.getObjectListFromRequestBody(request));
    }

    private List<String> getObjectListFromRequestBody(HttpServletRequest request) throws HTTPException, IOException {
        this.assertJsonContentType(request);
        JSONObject obj = this.parseRequestBody(request);
        Object value = obj.get((Object)"storeIDs");
        if (value == null) {
            return Collections.emptyList();
        }
        if (!(value instanceof List)) {
            throw new HTTPException(400, "Invalid payload");
        }
        return (List)value;
    }

    private JSONObject parseRequestBody(HttpServletRequest request) throws IOException, HTTPException {
        ServletInputStream is = request.getInputStream();
        try {
            return JSONObject.parse((Reader)new InputStreamReader((InputStream)is, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new HTTPException(400, "Invalid payload: " + e.getMessage());
        }
    }

    private void assertJsonContentType(HttpServletRequest request) throws HTTPException {
        String s = request.getHeader(CONTENT_TYPE);
        if (s == null) {
            s = request.getContentType();
        }
        if (s == null) {
            throw new HTTPException(415);
        }
        ArrayList<String> parts = CMStringUtils.split(s, ';', true);
        if (!MIME_TYPE_JSON.equals(parts.get(0))) {
            throw new HTTPException(415);
        }
    }

    private List<String> getObjectListFromQueryParameters(HttpServletRequest request) {
        String s = request.getParameter("storeIDs");
        return s == null ? Collections.emptyList() : CMStringUtils.split(s, ',');
    }

    private InternalStoreId[] convertStoreIds(List<String> ids) throws HTTPException {
        InternalStoreId[] result = new InternalStoreId[ids.size()];
        int i = 0;
        for (String s : ids) {
            InternalStoreId id = InternalStoreId.fromString(s);
            if (id == null) {
                throw new HTTPException(400, "invalid id:" + s);
            }
            result[i++] = id;
        }
        return result;
    }

    private JSONObject buildResult(InternalStoreId[] objectsToCheck, int[] versions) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < objectsToCheck.length; ++i) {
            result.put((Object)objectsToCheck[i].toString(), (Object)versions[i]);
        }
        return result;
    }
}

