/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.rest.NameValuePair;
import com.cognos.cm.rest.ResultProperty;
import com.cognos.cm.rest.ResultRow;
import com.cognos.cm.rest.handlers.BasePropertyHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class ChildPagedPropertyHandler
extends BasePropertyHandler {
    public static final String MAX_OBJECTS = "maxObjects";
    public static final String SKIP_OBJECTS = "skipObjects";

    public ChildPagedPropertyHandler() {
    }

    public ChildPagedPropertyHandler(CMExecutionContext ctx) {
        super(ctx);
    }

    protected JSONArray getChildrenAsJSONArray(CMStorePath path, CMProperty[] props, int skipObjects, int maxObjects) throws CMException {
        int start;
        JSONArray objArray = new JSONArray();
        List<ResultRow> results = this.queryHelper.executeOrderedQuery(path, props);
        int resultCount = results.size();
        int n = start = skipObjects >= 0 ? skipObjects : 0;
        if (start < resultCount) {
            int end = maxObjects == Integer.MAX_VALUE ? Integer.MAX_VALUE : start + maxObjects;
            end = end < resultCount ? end : resultCount;
            List<ResultRow> toReturn = results.subList(start, end);
            for (ResultRow row : toReturn) {
                JSONObject jsonObj = this.createJSONObject(row);
                objArray.add((Object)jsonObj);
            }
        }
        return objArray;
    }

    protected int getParameterIntValue(HttpServletRequest request, String paramName, int defaultValue) {
        String value = request.getParameter(paramName);
        int intValue = defaultValue;
        try {
            if (value != null) {
                intValue = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    protected CMStorePath getChildrenSearchPath(String encodedStoreId, NameValuePair param) throws CMException {
        String childStep = "*";
        String paramName = param.getName();
        Object paramValue = param.getValue();
        if (paramName != null && paramValue != null) {
            childStep = "*[@" + paramName + "='" + CMStoreXPath.attributeEncodeString(paramValue.toString()) + "']";
        }
        return this.queryHelper.getChildPath(encodedStoreId, childStep);
    }

    private JSONObject createJSONObject(ResultRow row) {
        JSONObject jsonObj = new JSONObject();
        for (ResultProperty property : row) {
            Object value = property.getValue();
            if (value == null) continue;
            jsonObj.put(property.getKey(), (Object)value.toString());
        }
        return jsonObj;
    }
}

