/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.rest.Access;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.AbstractHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.CMStringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Access(value="TRUSTED")
public class ContentObjects
extends AbstractHandler {
    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, CMException, HTTPException {
        InternalStoreId[] ids = ContentObjects.convertStoreIds(ContentObjects.getIds(request));
        CMCache cache = CMExecutionContext.get().getStore().getCache();
        response.setStatus(cache.assertContentObjects(ids) ? 204 : 404);
    }

    private static List<String> getIds(HttpServletRequest request) throws HTTPException {
        StringTokenizer st = new StringTokenizer(request.getPathInfo(), "/");
        st.nextToken();
        String id = null;
        if (st.hasMoreTokens()) {
            id = st.nextToken();
            if (st.hasMoreTokens()) {
                throw new HTTPException(400, "Invalid URL");
            }
        }
        if (id != null) {
            return Collections.singletonList(id);
        }
        String s = request.getParameter("ids");
        if (s != null) {
            return CMStringUtils.split(s, ',');
        }
        throw new HTTPException(400, "required parameters are missing");
    }

    private static InternalStoreId[] convertStoreIds(List<String> ids) throws HTTPException {
        InternalStoreId[] result = new InternalStoreId[ids.size()];
        int i = 0;
        for (String s : ids) {
            InternalStoreId id = InternalStoreId.fromString(s);
            if (id == null) {
                throw new HTTPException(400, "invalid id:" + s);
            }
            result[i++] = id;
        }
        return result;
    }
}

