/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.rest.CMQueryHelperImpl;
import com.cognos.cm.rest.CMStoreQueryHelper;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.FunctionHandler;
import com.cognos.cm.rest.handlers.FunctionHandlerFactory;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMQueryUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class DataSourceFunctionsHandler
implements FunctionHandlerFactory<DataSourceFunctionsHandler>,
FunctionHandler {
    private CMExecutionContext ctx;
    private CMStoreQueryHelper queryHelper;

    public DataSourceFunctionsHandler() {
        this(null);
    }

    public DataSourceFunctionsHandler(CMExecutionContext ctx) {
        this.ctx = ctx;
        this.queryHelper = new CMQueryHelperImpl(this.ctx);
    }

    @Override
    public DataSourceFunctionsHandler getFunctionHandler(CMExecutionContext ctx) {
        return new DataSourceFunctionsHandler(ctx);
    }

    @Override
    public void execute(HttpServletResponse response, String functionName, Map<String, String[]> params) throws CMException, IOException, HTTPException {
        String dataSourceName = this.getDataSourceName(params);
        CMStoreXPath path = this.getFunctionSearchPath(functionName, dataSourceName);
        CMProperty[] properties = this.getRequestedProperties(params);
        JSONArray result = this.executeFunction(path, properties);
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(200);
        result.serialize((OutputStream)response.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray executeFunction(CMStoreXPath path, CMProperty[] properties) throws CMException {
        JSONArray result = new JSONArray();
        CMDbStore store = (CMDbStore)this.ctx.getStore();
        ICMLockManager lockMgr = store.getLockManager();
        CMStoreQueryResults queryResults = null;
        lockMgr.requestLocks(path);
        try {
            int flags = 32;
            queryResults = store.executeQuery(path, properties, null, 0, flags, null);
            while (queryResults.next()) {
                OrderedJSONObject obj = new OrderedJSONObject();
                for (int i = 0; i < properties.length; ++i) {
                    CMProperty prop = properties[i];
                    try {
                        obj.put((Object)prop.getName(), this.getValue(queryResults, i));
                        continue;
                    }
                    catch (IOException ie) {
                        throw new CMException((Exception)ie, "cmPropReadFail", new CMException.Parm("Prop", prop.getName()));
                    }
                }
                result.add((Object)obj);
            }
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(queryResults);
            try {
                lockMgr.releaseLocks();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(queryResults);
        try {
            lockMgr.releaseLocks();
        }
        catch (Exception exception) {}
        return result;
    }

    private String getDataSourceName(Map<String, String[]> params) throws CMException, HTTPException {
        String[] idParams = params.get("id");
        if (idParams != null) {
            CMStoreXPath storeIdPath = CMStoreXPath.fromStoreID(idParams[0]);
            return this.queryHelper.queryOneProperty(storeIdPath, CMProperty.DEFAULTNAME).toString();
        }
        String[] nameParams = params.get("name");
        if (nameParams != null && nameParams.length == 1) {
            return nameParams[0];
        }
        throw new HTTPException(400);
    }

    private CMStoreXPath getFunctionSearchPath(String functionName, String dataSourceName) throws CMStoreParseException {
        CMStoreXPath path = new CMStoreXPath(functionName + "('" + CMStoreXPath.attributeEncodeString(dataSourceName) + "')");
        return path;
    }

    private CMProperty[] getRequestedProperties(Map<String, String[]> params) {
        String[] propLists;
        ArrayList<CMProperty> properties = new ArrayList<CMProperty>();
        String[] propNames = params.get("property");
        if (propNames != null) {
            for (int i = 0; i < propNames.length; ++i) {
                String propName = propNames[i];
                properties.add(this.getPropertyByName(propName));
            }
        }
        if ((propLists = params.get("properties")) != null) {
            for (int i = 0; i < propLists.length; ++i) {
                String propsList = propLists[i];
                StringTokenizer toker = new StringTokenizer(propsList, ",");
                while (toker.hasMoreTokens()) {
                    properties.add(this.getPropertyByName(toker.nextToken()));
                }
            }
        }
        return properties.toArray(new CMProperty[properties.size()]);
    }

    private CMProperty getPropertyByName(String propName) {
        List<CMProperty> props = this.ctx.getPropertySet().getProperties(propName);
        return props.get(0);
    }

    private Object getValue(CMStoreQueryResults results, int i) throws CMException, IOException {
        Object value = results.getValue(i);
        if (value == null) {
            return null;
        }
        if (value instanceof StringReader) {
            StringReader reader = (StringReader)value;
            value = IOUtils.toString((Reader)reader);
        } else {
            value = value.toString();
        }
        return value;
    }
}

