/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.request.validator.CacheValidatorFactory;
import com.cognos.cm.request.validator.ICacheValidatorCalculator;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.AbstractHandler;
import com.cognos.cm.server.CMException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EtagValidatorHandler
extends AbstractHandler {
    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, CMException, HTTPException {
        String etag = this.getRequestEtag(request);
        String path = this.getPathFromUrl(request.getPathInfo());
        List<String> paths = Collections.singletonList(path);
        CacheValidatorFactory cf = new CacheValidatorFactory();
        ICacheValidatorCalculator validator = cf.getValidatorCalculator(paths, etag, null);
        int status = 205;
        if (validator != null) {
            if (validator.validatorMatches()) {
                status = 304;
            } else {
                etag = validator.calculateNewValidator(new ByteArrayInputStream(new byte[0]));
                if (etag.equals("410")) {
                    status = 410;
                }
            }
        } else {
            status = 400;
        }
        response.setStatus(status);
    }

    private String getPathFromUrl(String url) {
        if (url == null || url.length() < 2) {
            return null;
        }
        int n = url.substring(1).indexOf(47);
        if (n == -1) {
            return null;
        }
        return url.substring(n + 2);
    }

    private String getRequestEtag(HttpServletRequest request) throws HTTPException {
        String eTag = request.getHeader("If-None-Match");
        if (eTag == null) {
            throw new HTTPException(400);
        }
        if (eTag.length() > 2 && eTag.charAt(0) == '\"') {
            eTag = eTag.substring(1, eTag.length() - 1);
        }
        if (!eTag.startsWith("42-")) {
            throw new HTTPException(400);
        }
        return eTag;
    }
}

