/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.AbstractHandler;
import com.cognos.cm.rest.handlers.DataSourceFunctionsHandler;
import com.cognos.cm.rest.handlers.FunctionHandlerFactory;
import com.cognos.cm.rest.handlers.RepositoryDataSourceLookup;
import com.cognos.cm.server.CMException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FunctionsHandler
extends AbstractHandler {
    private static HashMap<String, FunctionHandlerFactory> functions = new HashMap();

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, CMException, HTTPException {
        StringTokenizer st = new StringTokenizer(request.getPathInfo(), "/");
        st.nextToken();
        String functionName = st.nextToken();
        Map params = request.getParameterMap();
        this.runRequest(response, functionName, params);
    }

    private void runRequest(HttpServletResponse response, String functionName, Map<String, String[]> params) throws CMException, IOException, HTTPException {
        FunctionHandlerFactory factoryInstance = functions.get(functionName);
        if (factoryInstance == null) {
            throw new HTTPException(400, "In this implementation, the url must be of the form /cm/1.0/functions/<function>?arg=value");
        }
        Object functionHandler = factoryInstance.getFunctionHandler(this.ctx);
        functionHandler.execute(response, functionName, params);
    }

    static {
        functions.put("dataSourceSignon", new DataSourceFunctionsHandler());
        functions.put("defaultRepositoryConnection", new DataSourceFunctionsHandler());
        functions.put("repositoryDataSourceLookup", new RepositoryDataSourceLookup());
    }
}

