/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.properties.CMDbStorePermissions;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.AbstractHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IdQueryHandler
extends AbstractHandler {
    private CMDbStore store;

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, CMException, HTTPException {
        List<String> toCheck = this.getIDs(request);
        this.setupCMInterface();
        String toReturn = this.queryObjects(toCheck);
        this.buildSuccessResponse(response, toReturn);
    }

    private void setupCMInterface() throws CMStoreNotAvailable, CMStoreUnexpected {
        this.store = (CMDbStore)this.ctx.getStore();
    }

    private List<String> getIDs(HttpServletRequest request) {
        String s = request.getParameter("ids");
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> toCheck = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            toCheck.add(st.nextToken());
        }
        return toCheck;
    }

    private void buildSuccessResponse(HttpServletResponse response, String s) throws IOException {
        response.setStatus(200);
        response.setContentType("text/plain");
        ServletOutputStream os = response.getOutputStream();
        os.write(s.getBytes("utf-8"));
        os.close();
    }

    private String queryObjects(List<String> toCheck) throws CMException {
        String validObjs = "";
        ArrayList<InternalStoreId> storeIds = new ArrayList<InternalStoreId>();
        ArrayList<String> exStoreIds = new ArrayList<String>();
        for (String s : toCheck) {
            if (s.startsWith("i")) {
                storeIds.add(new InternalStoreId(s));
                continue;
            }
            exStoreIds.add(s);
        }
        if (!storeIds.isEmpty()) {
            validObjs = this.internalSearch(storeIds);
        }
        if (!exStoreIds.isEmpty()) {
            validObjs = validObjs.concat(this.externalSearch(exStoreIds));
        }
        if (!validObjs.isEmpty()) {
            validObjs = this.removeTrailingComma(validObjs);
        }
        return validObjs;
    }

    private String getViewable(CMStoreQueryResults results) throws CMException {
        StringBuilder sb = new StringBuilder();
        while (results.next()) {
            CMDbStoreString storeId = (CMDbStoreString)results.getValue(CMProperty.STOREID);
            CMDbStorePermissions value = (CMDbStorePermissions)results.getValue(CMProperty.PERMISSIONS);
            if (value.getSize() <= 0) continue;
            sb.append(storeId.getValue()).append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalSearch(List<InternalStoreId> storeIds) throws CMException {
        String string;
        int perms = 33024;
        CMProperty[] props = new CMProperty[]{CMProperty.STOREID, CMProperty.PERMISSIONS};
        ICMLockManager lockManager = this.store.getLockManager();
        CMStoreQueryResults results = null;
        try {
            lockManager.requestLocks(storeIds, 10);
            results = this.store.executeQuery(storeIds, props, null, 0, perms, null);
            string = this.getViewable(results);
            this.releaseResults(results);
        }
        catch (Throwable throwable) {
            this.releaseResults(results);
            lockManager.releaseLocks();
            throw throwable;
        }
        lockManager.releaseLocks();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String externalSearch(List<String> storeIds) throws CMException {
        String string;
        String path = this.createCompoundPath(storeIds);
        int perms = 33024;
        CMProperty[] props = new CMProperty[]{CMProperty.STOREID, CMProperty.PERMISSIONS};
        ICMLockManager lockManager = this.store.getLockManager();
        CMStoreXPath searchPath = new CMStoreXPath(path);
        CMStoreQueryResults results = null;
        try {
            lockManager.requestLocks(searchPath);
            results = this.store.executeQuery(searchPath, props, null, 0, perms, null);
            string = this.getViewable(results);
            this.releaseResults(results);
        }
        catch (Throwable throwable) {
            this.releaseResults(results);
            lockManager.releaseLocks();
            throw throwable;
        }
        lockManager.releaseLocks();
        return string;
    }

    private String createCompoundPath(List<String> storeIds) {
        StringBuilder sb = new StringBuilder();
        for (String s : storeIds) {
            String camId = CMCAMIDHelper.storeID2CAMID(s);
            String ns = CMCAMIDHelper.getNamespaceIDFromCAMID(camId);
            if (!this.ctx.isUserAuthenticatedIntoNamespace(ns)) continue;
            sb.append("CAMID(" + SearchPathEncoder.quoteString((String)camId) + ")|");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String removeTrailingComma(String s) {
        return s.substring(0, s.length() - 1);
    }

    private void releaseResults(CMStoreQueryResults results) {
        if (!results.equals(null)) {
            results.release();
        }
    }
}

