/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.AbstractHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.LicenseManager;
import com.cognos.cm.server.LicenseReport;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.JsonWriter;
import com.cognos.cm.util.csv.CSVReader;
import com.cognos.cm.util.csv.CSVRecord;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class LicensesHandler
extends AbstractHandler {
    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, CMException, HTTPException {
        if (!this.ctx.hasCapability("canUseCapabilitiesTool")) {
            throw new HTTPException(403);
        }
        boolean summary = false;
        StringTokenizer st = new StringTokenizer(request.getPathInfo(), "/");
        st.nextToken();
        if (st.hasMoreTokens()) {
            if ("summary".equals(st.nextToken())) {
                summary = true;
            } else {
                response.setStatus(400);
                return;
            }
        }
        int level = LicensesHandler.getIntParameter(request, "level");
        boolean refresh = LicensesHandler.getBooleanParameter(request, "refresh");
        String tenant = request.getParameter("tenant");
        String etag = LicensesHandler.getRequestEtag(request);
        LicenseReport report = LicenseManager.getInstance().getReport(tenant, refresh);
        if (report == null) {
            response.setStatus(500);
            return;
        }
        if (!refresh && LicensesHandler.verifyETag(report, etag)) {
            response.setStatus(304);
            return;
        }
        response.setHeader("ETag", LicensesHandler.getETag(report));
        response.setHeader("Cache-control", "private, must-revalidate");
        if (summary) {
            this.writeSummary(response, report);
        } else {
            ServletOutputStream os = response.getOutputStream();
            if (level == -1) {
                this.writeFullReport(response, (OutputStream)os, report);
            } else if (level > LicenseManager.getInstance().getMaxLicenseLevel()) {
                response.setStatus(400);
            } else {
                this.writeReport(level, response, (OutputStream)os, report);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFullReport(HttpServletResponse response, OutputStream os, LicenseReport report) throws IOException {
        response.setContentType("text/csv");
        StringBuilder buf = new StringBuilder();
        buf.append("attachment; filename=licenses-").append(report.getCreationTime()).append(".csv");
        response.setHeader("Content-Disposition", buf.toString());
        response.setStatus(200);
        InputStream is = report.getDetailedReport();
        if (is != null) {
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
                os.flush();
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReport(int level, HttpServletResponse response, OutputStream os, LicenseReport report) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(200);
        InputStream is = report.getDetailedReport();
        try {
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os, 8096), StandardCharsets.UTF_8);
            JsonWriter jw = new JsonWriter(ow);
            ow.write("{\n \"level\": ");
            ow.write(String.valueOf(level));
            ow.write(",\n \"name\": ");
            jw.write(LicenseManager.getInstance().getLicenseName(level), false);
            ow.write(",\n \"asOfTime\": \"");
            ow.write(report.getCreationTime());
            ow.write("\",\n \"users\": [\n");
            CSVReader reader = new CSVReader(is);
            JsonRecord jr = new JsonRecord(reader);
            String separator = "   ";
            for (CSVRecord record : reader) {
                int l = record.getInt(0);
                if (l != level) continue;
                ow.write(separator);
                separator = ",   \n";
                jr.wrap(record);
                jw.write(jr, false);
            }
            ow.write("]\n}");
            ow.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private void writeSummary(HttpServletResponse response, LicenseReport report) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(200);
        String data = report.getSummary();
        response.setContentLength(data.length());
        IOUtils.write((String)data, (OutputStream)response.getOutputStream(), (String)"utf-8");
    }

    private static String getETag(LicenseReport report) {
        return '\"' + report.getETag() + '\"';
    }

    private static boolean verifyETag(LicenseReport report, String etag) {
        if (etag == null) {
            return false;
        }
        return etag.equals(report.getETag());
    }

    private static boolean getBooleanParameter(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        if (value == null) {
            return false;
        }
        return value.length() == 0 || "true".equals(value);
    }

    private static int getIntParameter(HttpServletRequest request, String name) throws HTTPException {
        String value = request.getParameter(name);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new HTTPException(400);
        }
    }

    private static String getRequestEtag(HttpServletRequest request) {
        String eTag = request.getHeader("If-None-Match");
        if (eTag == null) {
            return null;
        }
        return CMStringUtils.removeQuotes(eTag);
    }

    static class JsonRecord
    extends AbstractMap<String, Object> {
        private ArrayList<Map.Entry<String, Object>> set = new ArrayList();
        private CSVRecord record;

        public JsonRecord(CSVReader reader) throws IOException {
            List headers = reader.readHeaders();
            for (int idx = 0; idx < headers.size(); ++idx) {
                String name = (String)headers.get(idx);
                if ("level".equals(name)) continue;
                this.set.add(new MapEntry(name, idx));
            }
        }

        public void wrap(CSVRecord record) {
            this.record = record;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return set.iterator();
                }

                @Override
                public int size() {
                    return set.size();
                }
            };
        }

        private class MapEntry
        extends AbstractMap.SimpleEntry<String, Object> {
            private int idx;

            public MapEntry(String name, int idx) {
                super(name, null);
                this.idx = idx;
            }

            @Override
            public Object getValue() {
                return JsonRecord.this.record.get(this.idx);
            }
        }
    }
}

