/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers;

import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.IRepositoryRules;
import com.cognos.cm.properties.RepositoryRules;
import com.cognos.cm.rest.CMQueryHelperImpl;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.FunctionHandler;
import com.cognos.cm.rest.handlers.FunctionHandlerFactory;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.ibm.json.java.JSONArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class RepositoryDataSourceLookup
implements FunctionHandler,
FunctionHandlerFactory<RepositoryDataSourceLookup> {
    private static final String CONTENT_MANAGER_SID = "cm";
    private CMExecutionContext execContext;
    private IRepositoryRules repositoryRules;

    public RepositoryDataSourceLookup(CMExecutionContext ctx) {
        this(ctx, new RepositoryRules());
    }

    RepositoryDataSourceLookup(CMExecutionContext ctx, IRepositoryRules rRules) {
        this.execContext = ctx;
        this.repositoryRules = rRules;
    }

    public RepositoryDataSourceLookup() {
        this(null);
    }

    @Override
    public RepositoryDataSourceLookup getFunctionHandler(CMExecutionContext ctx) {
        return new RepositoryDataSourceLookup(ctx);
    }

    @Override
    public void execute(HttpServletResponse response, String functionName, Map<String, String[]> params) throws CMException, IOException, HTTPException {
        String dsStoreID;
        String[] idParams = params.get("id");
        if (idParams == null) {
            throw new HTTPException(400);
        }
        JSONArray objArray = new JSONArray();
        String reportStoreID = idParams[0];
        String dataSourceName = this.getDataSourceName(reportStoreID);
        objArray.add((Object)CONTENT_MANAGER_SID);
        if (dataSourceName != null && dataSourceName.length() > 0 && (dsStoreID = this.getDataSourceStoreID(dataSourceName)) != null) {
            objArray.add((Object)dsStoreID);
        }
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(200);
        objArray.serialize((OutputStream)response.getOutputStream());
    }

    private String getDataSourceStoreID(String dataSourceName) throws CMException, HTTPException {
        CMQueryHelperImpl queryHelper = new CMQueryHelperImpl(this.execContext);
        CMStorePath path = this.getDataSourceSearchPath(dataSourceName);
        try {
            return queryHelper.queryOneProperty(path, CMProperty.STOREID).toString();
        }
        catch (HTTPException he) {
            if (he.getErrorCode() == 404) {
                return null;
            }
            throw he;
        }
    }

    private String getDataSourceName(String reportStoreID) throws CMException {
        CMStoreXPath searchStorePath = CMStoreXPath.fromStoreID(reportStoreID);
        CMStore store = this.execContext.getStore();
        return this.queryDataSourceName(searchStorePath, store);
    }

    private CMStorePath getDataSourceSearchPath(String dataSourceName) throws CMStoreParseException {
        return new CMStoreXPath("CAMID(\":\")/dataSource[@name=\"" + dataSourceName + "\"]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryDataSourceName(CMStorePath reportSearchPath, CMStore store) throws CMException {
        String dataSourceName = null;
        ICMLockManager lockManager = store.getLockManager();
        try {
            lockManager.requestLocks(reportSearchPath);
            store.beginTransaction();
            dataSourceName = this.repositoryRules.getRepositoryDataSourceName(reportSearchPath, CMObjectClass.REPORTVERSION);
            store.commitTransaction();
        }
        finally {
            try {
                if (store.inTransaction()) {
                    store.rollbackTransaction();
                }
            }
            finally {
                lockManager.releaseLocks();
            }
        }
        return dataSourceName;
    }
}

