/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers.properties;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.rest.HTTPException;
import com.cognos.cm.rest.handlers.BasePropertyHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.path.CMStorePath;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CachedPropertyHandler
extends BasePropertyHandler {
    protected abstract String fetchPropertyValue(CMCache var1, int var2) throws CMException;

    public CachedPropertyHandler() {
    }

    public CachedPropertyHandler(CMExecutionContext ctx) {
        super(ctx);
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, String encodedStoreId, String passport) throws CMException, IOException, HTTPException {
        String value = this.queryProperty(encodedStoreId);
        response.setContentType("text/plain; charset=utf-8");
        response.setStatus(200);
        ServletOutputStream os = response.getOutputStream();
        os.write(value.getBytes("utf-8"));
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryProperty(String encodedStoreId) throws CMException, HTTPException {
        String string;
        CMDbStore store = (CMDbStore)this.ctx.getStore();
        CMStorePath path = this.queryHelper.getPath(encodedStoreId);
        ICMLockManager lockManager = store.getLockManager();
        lockManager.requestLocks(path);
        CMCacheQueryInstance cacheQuery = null;
        try {
            CMCache cache = store.getCache();
            cacheQuery = cache.executeQuery(path, 0);
            int[] cmids = cacheQuery.resultObjects();
            if (cmids.length == 0) {
                throw new HTTPException(404);
            }
            if (cmids.length > 1) {
                throw new HTTPException(400, "More than one object selected");
            }
            string = this.fetchPropertyValue(cache, cmids[0]);
        }
        catch (Throwable throwable) {
            this.releaseCacheQuery(cacheQuery);
            this.releaseLocks(lockManager);
            throw throwable;
        }
        this.releaseCacheQuery(cacheQuery);
        this.releaseLocks(lockManager);
        return string;
    }
}

