/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers.properties;

import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.DataPropertyHelper;
import com.cognos.cm.rest.handlers.ContentProperty;
import com.cognos.cm.rest.handlers.ContentPropertyFactory;
import com.cognos.cm.rest.handlers.properties.DataProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.util.CMXMLUtils;
import java.io.InputStream;

public class DataPropertyFactory
implements ContentPropertyFactory {
    private final CMObjectClass objectClass;
    private final CMProperty[] propertyArray;
    public static final int DATA_COLUMN = 0;
    public static final int CONTENT_TYPE_COLUMN = 1;
    public static final int IS_COMPRESSED_COLUMN = 2;
    public static final int DATA_SIZE_COLUMN = 3;
    public static final int TOTAL_COLUMNS = 4;

    public DataPropertyFactory(CMObjectClass objectClass) {
        this.objectClass = objectClass;
        this.propertyArray = new CMProperty[4];
        this.propertyArray[0] = this.getProperty(CMPropertyMeaning.DATA);
        this.propertyArray[1] = this.getProperty(CMPropertyMeaning.DATATYPE);
        this.propertyArray[2] = this.getProperty(CMPropertyMeaning._DATAISCOMPRESSED);
        this.propertyArray[3] = this.getProperty(CMPropertyMeaning.DATASIZE);
    }

    @Override
    public String getPropertyName() {
        return CMPropertyMeaning.DATA.getName();
    }

    private CMProperty getProperty(CMPropertyMeaning propMeaning) {
        return this.objectClass.getProperty(propMeaning);
    }

    @Override
    public CMProperty[] getPropertyArray() {
        return this.propertyArray;
    }

    @Override
    public ContentProperty create(CMStoreQueryResults results) throws CMException {
        return new DataProperty(this.fetchValues(results));
    }

    private DataPropertyHelper fetchValues(CMStoreQueryResults results) throws CMException {
        InputStream data = (InputStream)results.getValue(0);
        String contentType = this.getStringValue(results, 1);
        boolean isCompressed = this.getBooleanValue(results, 2);
        long uncompressedDataSize = this.getLongValue(results, 3);
        if (data == null) {
            uncompressedDataSize = 0L;
        }
        DataPropertyHelper dataPropertyHelper = this.createDataPropertyHelper(results, data, contentType, isCompressed);
        dataPropertyHelper.setUncompressedDataSize(uncompressedDataSize);
        return dataPropertyHelper;
    }

    protected DataPropertyHelper createDataPropertyHelper(CMStoreQueryResults results, InputStream data, String contentType, boolean isCompressed) throws CMException {
        return new DataPropertyHelper(CMDbStoreFactory.tempfileCache_, results, this.propertyArray[0], data, contentType, isCompressed);
    }

    private String getStringValue(CMStoreQueryResults results, int idx) throws CMException {
        Object value = results.getValue(idx);
        return value == null ? null : value.toString();
    }

    private boolean getBooleanValue(CMStoreQueryResults results, int idx) throws CMException {
        Object value = results.getValue(idx);
        return value == null ? false : CMXMLUtils.parseBooleanAttribute(value.toString());
    }

    private long getLongValue(CMStoreQueryResults results, int idx) throws CMException {
        Object value = results.getValue(idx);
        return value == null ? -1L : Long.parseLong(value.toString());
    }
}

