/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers.properties;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.rest.NameValuePair;
import com.cognos.cm.rest.handlers.ChildPagedPropertyHandler;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.path.CMStorePath;
import com.ibm.json.java.JSONArray;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OutputsPropertyHandler
extends ChildPagedPropertyHandler {
    public OutputsPropertyHandler() {
    }

    public OutputsPropertyHandler(CMExecutionContext ctx) {
        super(ctx);
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, String encodedStoreId, String passport) throws CMException, IOException {
        CMStorePath path = this.getOutputsSearchPath(request, encodedStoreId);
        JSONArray objArray = this.retrieveOutputs(request, path);
        this.respond(response, objArray);
    }

    CMStorePath getOutputsSearchPath(HttpServletRequest request, String encodedStoreId) throws CMException {
        NameValuePair queryParam = new NameValuePair(CMProperty.OBJECTCLASS.getName(), CMObjectClass.OUTPUT.getName());
        CMStorePath path = this.getChildrenSearchPath(encodedStoreId, queryParam);
        return path;
    }

    private JSONArray retrieveOutputs(HttpServletRequest request, CMStorePath path) throws CMException {
        int skipObjects = this.getParameterIntValue(request, "skipObjects", 0);
        int maxObjects = this.getParameterIntValue(request, "maxObjects", Integer.MAX_VALUE);
        CMProperty dataPathInfo = CMObjectClass.OUTPUT.getProperty(CMPropertyMeaning.DATAPATHINFO);
        CMProperty dataType = CMObjectClass.OUTPUT.getProperty(CMPropertyMeaning.DATATYPE);
        CMProperty[] props = new CMProperty[]{CMProperty.CREATIONTIME, CMProperty.STOREID, CMProperty.DEFAULTNAME, dataPathInfo, dataType, CMProperty.LOCALE, CMProperty.BURSTKEY, CMProperty.FORMAT};
        JSONArray objArray = this.getChildrenAsJSONArray(path, props, skipObjects, maxObjects);
        return objArray;
    }

    private void respond(HttpServletResponse response, JSONArray objArray) throws IOException {
        response.setStatus(200);
        response.setContentType("application/json; charset=utf-8");
        objArray.serialize((OutputStream)response.getOutputStream());
    }
}

