/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.rest.handlers.properties;

import com.cognos.cm.rest.handlers.ContentProperty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.ReaderInputStream;

public class SingleColumnContentProperty
implements ContentProperty {
    private Object content;
    private String contentType;
    private boolean isCompressed;
    public static final int CONTENT_COLUMN = 0;
    public static final int TOTAL_COLUMNS = 1;

    public SingleColumnContentProperty(Object content, String contentType, boolean isCompressed) {
        this.content = content;
        this.contentType = contentType;
        this.isCompressed = isCompressed;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getUncompressedContentLength() {
        return -1L;
    }

    @Override
    public boolean hasContent() {
        return this.content != null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = null;
        if (this.content instanceof InputStream) {
            in = (InputStream)this.content;
        } else if (this.content instanceof Reader) {
            in = new ReaderInputStream((Reader)this.content, Charsets.UTF_8);
        } else if (this.content instanceof String) {
            in = new ByteArrayInputStream(this.content.toString().getBytes(Charsets.UTF_8));
        } else {
            String type = this.content == null ? "null" : this.content.getClass().toString();
            throw new IOException("Unknown content type " + type);
        }
        return in;
    }
}

